/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentSetMutualIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MCIndexSegmentSetMutualIntersector
implements SegmentSetMutualIntersector {
    private STRtree index = new STRtree();

    public MCIndexSegmentSetMutualIntersector(Collection baseSegStrings) {
        this.initBaseSegments(baseSegStrings);
    }

    public SpatialIndex getIndex() {
        return this.index;
    }

    private void initBaseSegments(Collection segStrings) {
        Iterator i = segStrings.iterator();
        while (i.hasNext()) {
            this.addToIndex((SegmentString)i.next());
        }
        this.index.build();
    }

    private void addToIndex(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            this.index.insert(mc.getEnvelope(), (Object)mc);
        }
    }

    public void process(Collection segStrings, SegmentIntersector segInt) {
        ArrayList monoChains = new ArrayList();
        Iterator i = segStrings.iterator();
        while (i.hasNext()) {
            this.addToMonoChains((SegmentString)i.next(), monoChains);
        }
        this.intersectChains(monoChains, segInt);
    }

    private void addToMonoChains(SegmentString segStr, List monoChains) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            monoChains.add(mc);
        }
    }

    private void intersectChains(List monoChains, SegmentIntersector segInt) {
        SegmentOverlapAction overlapAction = new SegmentOverlapAction(segInt);
        for (MonotoneChain queryChain : monoChains) {
            List overlapChains = this.index.query(queryChain.getEnvelope());
            for (MonotoneChain testChain : overlapChains) {
                queryChain.computeOverlaps(testChain, overlapAction);
                if (!segInt.isDone()) continue;
                return;
            }
        }
    }

    public class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        private SegmentIntersector si = null;

        public SegmentOverlapAction(SegmentIntersector si) {
            this.si = si;
        }

        public void overlap(MonotoneChain mc1, int start1, MonotoneChain mc2, int start2) {
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            this.si.processIntersections(ss1, start1, ss2, start2);
        }
    }
}

