/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel;

import java.io.Reader;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.XDOMGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.IWikiParser;

public abstract class AbstractWikiModelParser
implements Parser,
WikiModelStreamParser {
    @Inject
    @Named(value="plain/1.0")
    protected PrintRendererFactory plainRendererFactory;

    public abstract IWikiParser createWikiModelParser() throws ParseException;

    public abstract ResourceReferenceParser getLinkReferenceParser();

    public abstract ResourceReferenceParser getImageReferenceParser();

    protected StreamParser getLinkLabelParser() {
        return this;
    }

    public XDOM parse(Reader source) throws ParseException {
        IdGenerator idGenerator = new IdGenerator();
        XDOMGeneratorListener listener = new XDOMGeneratorListener();
        this.parse(source, (Listener)listener, idGenerator);
        XDOM xdom = listener.getXDOM();
        xdom.setIdGenerator(idGenerator);
        return xdom;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        IdGenerator idGenerator = new IdGenerator();
        this.parse(source, listener, idGenerator);
    }

    @Override
    public XWikiGeneratorListener createXWikiGeneratorListener(Listener listener, IdGenerator idGenerator) {
        return new DefaultXWikiGeneratorListener(this.getLinkLabelParser(), listener, this.getLinkReferenceParser(), this.getImageReferenceParser(), this.plainRendererFactory, idGenerator, this.getSyntax());
    }

    protected void parse(Reader source, Listener listener, IdGenerator idGenerator) throws ParseException {
        IWikiParser parser = this.createWikiModelParser();
        try {
            parser.parse(source, (IWemListener)this.createXWikiGeneratorListener(listener, idGenerator));
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse input source", (Throwable)e);
        }
    }
}

