/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.egl.EGL;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDummyUpstreamSurfaceHook;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGLnDynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLSurface;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    protected static final boolean DEBUG = GLDrawableFactoryImpl.DEBUG;
    private static final boolean DEBUG_SHAREDCTX = DEBUG || GLContext.DEBUG;
    static final boolean QUERY_EGL_ES_NATIVE_TK;
    private static boolean eglDynamicLookupHelperInit;
    private static GLDynamicLookupHelper eglES1DynamicLookupHelper;
    private static GLDynamicLookupHelper eglES2DynamicLookupHelper;
    private static GLDynamicLookupHelper eglGLnDynamicLookupHelper;
    static final String eglInitializeFuncName = "eglInitialize";
    private boolean isANGLE = false;
    private boolean hasX11 = false;
    private EGLGraphicsDevice defaultDevice = null;
    private EGLFeatures defaultDeviceEGLFeatures;
    private SharedResourceRunner sharedResourceRunner;
    private HashMap<String, SharedResourceRunner.Resource> sharedMap;

    private static final boolean isANGLE(GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (Platform.OSType.WINDOWS == PlatformPropsImpl.OS_TYPE) {
            return gLDynamicLookupHelper.isFunctionAvailable("eglQuerySurfacePointerANGLE") || gLDynamicLookupHelper.isFunctionAvailable("glBlitFramebufferANGLE") || gLDynamicLookupHelper.isFunctionAvailable("glRenderbufferStorageMultisampleANGLE");
        }
        return false;
    }

    private static final boolean includesES1(GLDynamicLookupHelper gLDynamicLookupHelper) {
        return gLDynamicLookupHelper.isFunctionAvailable("glLoadIdentity") && gLDynamicLookupHelper.isFunctionAvailable("glEnableClientState") && gLDynamicLookupHelper.isFunctionAvailable("glColorPointer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EGLDrawableFactory() {
        Class<EGLDrawableFactory> clazz = EGLDrawableFactory.class;
        synchronized (EGLDrawableFactory.class) {
            GLDynamicLookupHelper gLDynamicLookupHelper;
            long l;
            boolean bl;
            block48: {
                if (eglDynamicLookupHelperInit) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                eglDynamicLookupHelperInit = true;
                if (NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true)) {
                    this.hasX11 = true;
                    try {
                        ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = false;
                l = 0L;
                gLDynamicLookupHelper = null;
                try {
                    gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
                }
                catch (GLException gLException) {
                    if (!DEBUG) break block48;
                    gLException.printStackTrace();
                }
            }
            if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete() && (bl = EGLAcc.resetProcAddressTable((DynamicLookupHelper)gLDynamicLookupHelper))) {
                boolean bl2;
                l = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                eglES2DynamicLookupHelper = gLDynamicLookupHelper;
                boolean bl3 = bl2 = null == eglES1DynamicLookupHelper && EGLDrawableFactory.includesES1(eglES2DynamicLookupHelper);
                if (bl2) {
                    eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                }
                boolean bl4 = EGLDrawableFactory.isANGLE(eglES2DynamicLookupHelper);
                this.isANGLE |= bl4;
                if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES2 - OK (includesES1 " + bl2 + ", isANGLE: " + bl4 + ", eglInitialize 0x" + Long.toHexString(l) + ")");
                    if (bl2) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK (ES2 lib)");
                    }
                }
            } else if (DEBUG || GLProfile.DEBUG) {
                System.err.println("Info: EGLDrawableFactory: EGL ES2 - NOPE");
            }
            if (null == eglES1DynamicLookupHelper) {
                block49: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block49;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    boolean bl5;
                    long l2;
                    if (!bl) {
                        bl = EGLAcc.resetProcAddressTable((DynamicLookupHelper)gLDynamicLookupHelper);
                        if (bl) {
                            l = l2 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                            bl5 = true;
                        } else {
                            l2 = 0L;
                            bl5 = false;
                        }
                    } else {
                        l2 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                        boolean bl6 = bl5 = l2 == l;
                    }
                    if (bl5) {
                        eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                        boolean bl7 = EGLDrawableFactory.isANGLE(eglES1DynamicLookupHelper);
                        this.isANGLE |= bl7;
                        if (DEBUG || GLProfile.DEBUG) {
                            System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK (isANGLE: " + bl7 + ", eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l2) + ")");
                        }
                    } else if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE (ES1 proc, eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l2) + ")");
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE (ES1 lib)");
                }
            }
            if (null == eglGLnDynamicLookupHelper) {
                block50: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLGLnDynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block50;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    boolean bl8;
                    long l3;
                    if (!bl) {
                        bl = EGLAcc.resetProcAddressTable((DynamicLookupHelper)gLDynamicLookupHelper);
                        if (bl) {
                            l = l3 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                            bl8 = true;
                        } else {
                            l3 = 0L;
                            bl8 = false;
                        }
                    } else {
                        l3 = gLDynamicLookupHelper.dynamicLookupFunction(eglInitializeFuncName);
                        boolean bl9 = bl8 = l3 == l;
                    }
                    if (bl8) {
                        eglGLnDynamicLookupHelper = gLDynamicLookupHelper;
                        if (DEBUG || GLProfile.DEBUG) {
                            System.err.println("Info: EGLDrawableFactory: EGL GLn - OK (eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l3) + ")");
                        }
                    } else if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL GLn - NOPE (GLn proc, eglTableReset " + bl + ", eglInitialize 0x" + Long.toHexString(l3) + ")");
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL GLn - NOPE (GLn lib)");
                }
            }
            if (null != eglES2DynamicLookupHelper || null != eglES1DynamicLookupHelper || null != eglGLnDynamicLookupHelper) {
                if (this.isANGLE && !GLProfile.enableANGLE) {
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE disabled");
                    }
                } else {
                    if (this.isANGLE && (DEBUG || GLProfile.DEBUG)) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE enabled");
                    }
                    EGLGraphicsConfigurationFactory.registerFactory();
                    this.sharedMap = new HashMap();
                    this.defaultDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(0L, "decon", 0);
                    this.sharedResourceRunner = new SharedResourceRunner(new SharedResourceImplementation());
                    this.sharedResourceRunner.start();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != this.sharedMap;
    }

    @Override
    protected final void shutdownImpl() {
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.shutdown");
        }
        if (null != this.sharedResourceRunner) {
            this.sharedResourceRunner.stop();
            this.sharedResourceRunner = null;
        }
        if (null != this.sharedMap) {
            this.sharedMap.clear();
            this.sharedMap = null;
        }
        if (null != this.defaultDevice) {
            this.defaultDevice.close();
            this.defaultDevice = null;
        }
        if (null != eglES1DynamicLookupHelper) {
            eglES1DynamicLookupHelper = null;
        }
        if (null != eglES2DynamicLookupHelper) {
            eglES2DynamicLookupHelper = null;
        }
        if (null != eglGLnDynamicLookupHelper) {
            eglGLnDynamicLookupHelper = null;
        }
        EGLGraphicsConfigurationFactory.unregisterFactory();
        EGLDisplayUtil.shutdown(DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMap() {
        HashMap<String, SharedResourceRunner.Resource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            System.err.println("EGLDrawableFactory.map " + this.sharedMap.size());
            int n = 0;
            Set<String> set = this.sharedMap.keySet();
            for (String string : set) {
                SharedResource sharedResource = (SharedResource)this.sharedMap.get(string);
                System.err.println("EGLDrawableFactory.map[" + n + "] " + string + " -> " + sharedResource.getDevice() + ", avail " + sharedResource.isAvailable + "gln   [quirks " + sharedResource.rendererQuirksGLn + ", ctp " + EGLContext.getGLVersion(3, 0, sharedResource.ctpGLn, null) + "], " + "es1   [quirks " + sharedResource.rendererQuirksES1 + ", ctp " + EGLContext.getGLVersion(1, 0, sharedResource.ctpES1, null) + "], " + "es2/3 [quirks " + sharedResource.rendererQuirksES3ES2 + ", ctp " + EGLContext.getGLVersion(2, 0, sharedResource.ctpES3ES2, null) + "]");
                ++n;
            }
        }
    }

    public final boolean hasDefaultDeviceKHRCreateContext() {
        return this.defaultDeviceEGLFeatures.hasKHRCreateContext;
    }

    public final boolean hasOpenGLAPISupport() {
        return this.defaultDeviceEGLFeatures.hasGLAPI;
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != this.sharedMap;
    }

    private static List<GLCapabilitiesImmutable> getAvailableEGLConfigs(EGLGraphicsDevice eGLGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(eGLGraphicsDevice.getHandle(), null, 0, intBuffer)) {
            throw new GLException("EGLDrawableFactory.getAvailableEGLConfigs: Get maxConfigs (eglGetConfigs) call failed, error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (0 < intBuffer.get(0)) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
            IntBuffer intBuffer2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
            int n = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
            if (EGL.eglChooseConfig(eGLGraphicsDevice.getHandle(), intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer) && intBuffer.get(0) > 0) {
                return EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), pointerBuffer, intBuffer.get(0), n, false, false);
            }
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    static void dumpEGLInfo(String string, long l) {
        String string2 = EGL.eglQueryString(l, 12371);
        String string3 = EGL.eglQueryString(l, 12429);
        String string4 = EGL.eglQueryString(0L, 12372);
        String string5 = EGL.eglQueryString(l, 12372);
        System.err.println(string + "EGL vendor " + string2 + ", version [client " + string4 + ", server " + string5 + "], clientAPIs " + string3);
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return this.sharedResourceRunner.start();
    }

    public final boolean isANGLE() {
        return this.isANGLE;
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(String string) {
        GLDynamicLookupHelper gLDynamicLookupHelper = "GLES2" == string || "GLES3" == string ? eglES2DynamicLookupHelper : ("GLES1" == string ? eglES1DynamicLookupHelper : eglGLnDynamicLookupHelper);
        if (null == gLDynamicLookupHelper) {
            throw new GLException("No lookup for esProfile " + string);
        }
        return gLDynamicLookupHelper;
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == this.sharedMap) {
            return new ArrayList<GLCapabilitiesImmutable>();
        }
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLDrawable(this, EGLSurface.get(nativeSurface));
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Non pbuffer not yet implemented");
        }
        return new EGLDrawable(this, EGLSurface.get(nativeSurface));
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        return true;
    }

    private final EGLGraphicsConfiguration evalConfig(boolean[] blArray, AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        EGLGraphicsDevice eGLGraphicsDevice;
        if (bl || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            long l = abstractGraphicsDevice instanceof EGLGraphicsDevice ? ((EGLGraphicsDevice)abstractGraphicsDevice).getNativeDisplayID() : abstractGraphicsDevice.getHandle();
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(l, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
            eGLGraphicsDevice.open();
            blArray[0] = true;
        } else {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            blArray[0] = false;
        }
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return eGLGraphicsConfiguration;
    }

    @Override
    protected final ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        boolean[] blArray = new boolean[]{false};
        EGLGraphicsConfiguration eGLGraphicsConfiguration = this.evalConfig(blArray, abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
        return EGLSurface.createWrapped(eGLGraphicsConfiguration, 0L, upstreamSurfaceHook, blArray[0]);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new EGLDummyUpstreamSurfaceHook(n, n2));
    }

    @Override
    public final ProxySurface createSurfacelessImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        boolean[] blArray = new boolean[]{false};
        EGLGraphicsConfiguration eGLGraphicsConfiguration = this.evalConfig(blArray, abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
        return EGLSurface.createSurfaceless(eGLGraphicsConfiguration, new GenericUpstreamSurfacelessHook(n, n2), blArray[0]);
    }

    protected static MutableSurface createPBufferSurfaceImpl(MutableSurface mutableSurface, boolean bl) {
        return null;
    }

    protected static long createPBufferSurfaceImpl(EGLGraphicsConfiguration eGLGraphicsConfiguration, int n, int n2, boolean bl) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities();
        int n3 = bl ? (gLCapabilitiesImmutable.getAlphaBits() > 0 ? 12382 : 12381) : 12380;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + eGLGraphicsConfiguration);
        }
        IntBuffer intBuffer = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(n, n2, n3);
        long l = EGL.eglCreatePbufferSurface(eGLGraphicsDevice.getHandle(), eGLGraphicsConfiguration.getNativeConfig(), intBuffer);
        if (0L == l) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + n + "x" + n2 + ", " + eGLGraphicsDevice + ", " + eGLGraphicsConfiguration + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("PBuffer setSurface result: eglSurface 0x" + Long.toHexString(l));
        }
        return l;
    }

    @Override
    protected ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(eGLGraphicsDevice.getNativeDisplayID(), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        eGLGraphicsDevice2.open();
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice2, n);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        return EGLSurface.createWrapped(eGLGraphicsConfiguration, l, upstreamSurfaceHook, true);
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(NativeWindowFactory.TYPE_EGL);
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    static {
        Debug.initSingleton();
        QUERY_EGL_ES_NATIVE_TK = PropertyAccess.isPropertyDefined((String)"jogl.debug.EGLDrawableFactory.QueryNativeTK", (boolean)true);
        eglDynamicLookupHelperInit = false;
        eglES1DynamicLookupHelper = null;
        eglES2DynamicLookupHelper = null;
        eglGLnDynamicLookupHelper = null;
    }

    class SharedResourceImplementation
    implements SharedResourceRunner.Implementation {
        SharedResourceImplementation() {
        }

        @Override
        public void clear() {
            EGLDrawableFactory.this.sharedMap.clear();
        }

        @Override
        public SharedResourceRunner.Resource mapPut(AbstractGraphicsDevice abstractGraphicsDevice, SharedResourceRunner.Resource resource) {
            return EGLDrawableFactory.this.sharedMap.put(abstractGraphicsDevice.getConnection(), resource);
        }

        @Override
        public SharedResourceRunner.Resource mapGet(AbstractGraphicsDevice abstractGraphicsDevice) {
            return (SharedResourceRunner.Resource)EGLDrawableFactory.this.sharedMap.get(abstractGraphicsDevice.getConnection());
        }

        @Override
        public Collection<SharedResourceRunner.Resource> mapValues() {
            return EGLDrawableFactory.this.sharedMap.values();
        }

        @Override
        public boolean isDeviceSupported(AbstractGraphicsDevice abstractGraphicsDevice) {
            return null != EGLDrawableFactory.this.sharedMap;
        }

        @Override
        public SharedResourceRunner.Resource createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
            abstractGraphicsDevice.lock();
            try {
                SharedResource sharedResource = this.createEGLSharedResourceImpl(abstractGraphicsDevice);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("EGLGLXDrawableFactory - Could not initialize shared resources for " + abstractGraphicsDevice, throwable);
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }

        private SharedResource createEGLSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
            int[] nArray;
            Object object;
            GLRendererQuirks[] gLRendererQuirksArray = new GLRendererQuirks[]{null};
            GLRendererQuirks[] gLRendererQuirksArray2 = new GLRendererQuirks[]{null};
            GLRendererQuirks[] gLRendererQuirksArray3 = new GLRendererQuirks[]{null};
            int[] nArray2 = new int[]{8};
            int[] nArray3 = new int[]{8};
            int[] nArray4 = new int[]{4};
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLDrawableFactory.createShared(): device " + abstractGraphicsDevice);
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (null != eglGLnDynamicLookupHelper) {
                object = new int[]{3};
                nArray = new int[]{1};
                bl4 = this.mapAvailableEGLESConfig(abstractGraphicsDevice, (int[])object, nArray, nArray4, gLRendererQuirksArray3) && 0 != object[0];
            } else {
                bl4 = false;
            }
            EGLContext.setAvailableGLVersionsSet(abstractGraphicsDevice, true);
            if (null != eglES1DynamicLookupHelper) {
                object = new int[]{1};
                nArray = new int[]{0};
                bl = this.mapAvailableEGLESConfig(abstractGraphicsDevice, (int[])object, nArray, nArray2, gLRendererQuirksArray) && 1 == object[0];
            } else {
                bl = false;
            }
            if (null != eglES2DynamicLookupHelper) {
                object = new int[]{3};
                nArray = new int[]{0};
                boolean bl5 = bl3 = this.mapAvailableEGLESConfig(abstractGraphicsDevice, (int[])object, nArray, nArray3, gLRendererQuirksArray2) && 3 == object[0];
                if (!bl3) {
                    object[0] = 2;
                    if (this.mapAvailableEGLESConfig(abstractGraphicsDevice, (int[])object, nArray, nArray3, gLRendererQuirksArray2)) {
                        switch (object[0]) {
                            case 2: {
                                bl2 = true;
                                break;
                            }
                            case 3: {
                                bl3 = true;
                                break;
                            }
                            default: {
                                throw new InternalError("XXXX Got " + object[0]);
                            }
                        }
                    }
                }
            }
            if (EGLDrawableFactory.this.hasX11) {
                this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray[0]);
                this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray2[0]);
            }
            object = new SharedResource(EGLDrawableFactory.this.defaultDevice, bl4 || bl || bl2 || bl3, gLRendererQuirksArray3[0], nArray4[0], gLRendererQuirksArray[0], nArray2[0], gLRendererQuirksArray2[0], nArray3[0]);
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLDrawableFactory.createShared: devices: queried nativeTK " + QUERY_EGL_ES_NATIVE_TK + ", adevice " + abstractGraphicsDevice + ", defaultDevice " + EGLDrawableFactory.this.defaultDevice);
                System.err.println("EGLDrawableFactory.createShared: context GLn: " + bl4 + ", quirks " + gLRendererQuirksArray3[0]);
                System.err.println("EGLDrawableFactory.createShared: context ES1: " + bl + ", quirks " + gLRendererQuirksArray[0]);
                System.err.println("EGLDrawableFactory.createShared: context ES2: " + bl2 + ", quirks " + gLRendererQuirksArray2[0]);
                System.err.println("EGLDrawableFactory.createShared: context ES3: " + bl3 + ", quirks " + gLRendererQuirksArray2[0]);
                EGLDrawableFactory.this.dumpMap();
            }
            return object;
        }

        private void handleDontCloseX11DisplayQuirk(GLRendererQuirks gLRendererQuirks) {
            if (null != gLRendererQuirks && gLRendererQuirks.exist(8)) {
                X11Util.markAllDisplaysUnclosable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean mapAvailableEGLESConfig(AbstractGraphicsDevice abstractGraphicsDevice, int[] nArray, int[] nArray2, int[] nArray3, GLRendererQuirks[] gLRendererQuirksArray) {
            boolean bl2;
            String string = EGLContext.getGLProfile(nArray[0], nArray2[0], nArray3[0]);
            if (!GLProfile.isAvailable(abstractGraphicsDevice, string)) {
                if (!DEBUG_SHAREDCTX) return false;
                System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: " + string + " n/a on " + abstractGraphicsDevice);
                return false;
            }
            GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
            GLDrawableFactoryImpl gLDrawableFactoryImpl = (GLDrawableFactoryImpl)GLDrawableFactory.getDesktopFactory();
            boolean bl3 = 0L == EGLDrawableFactory.this.defaultDevice.getHandle();
            boolean bl = bl2 = !QUERY_EGL_ES_NATIVE_TK || bl3 || null == gLDrawableFactoryImpl;
            if (DEBUG_SHAREDCTX) {
                System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: " + string + " ( " + nArray[0] + " ), " + "mapsADeviceToDefaultDevice " + bl2 + " (QUERY_EGL_ES_NATIVE_TK " + QUERY_EGL_ES_NATIVE_TK + ", initDefaultDevice " + bl3 + ", hasDesktopFactory " + (null != gLDrawableFactoryImpl) + ", isEGLGraphicsDevice " + (abstractGraphicsDevice instanceof EGLGraphicsDevice) + ")");
            }
            EGLGraphicsDevice eGLGraphicsDevice = null;
            EGLFeatures eGLFeatures = null;
            ProxySurface proxySurface = null;
            ProxySurface proxySurface2 = null;
            ProxySurface proxySurface3 = null;
            boolean bl4 = false;
            try {
                EGLDrawable eGLDrawable;
                Object object2;
                block50: {
                    Object object3;
                    Object object;
                    block54: {
                        GLCapabilities gLCapabilities;
                        block52: {
                            boolean bl5;
                            block53: {
                                gLCapabilities = new GLCapabilities(gLProfile);
                                gLCapabilities.setRedBits(5);
                                gLCapabilities.setGreenBits(5);
                                gLCapabilities.setBlueBits(5);
                                gLCapabilities.setAlphaBits(0);
                                gLCapabilities.setDoubleBuffered(false);
                                if (!bl2) break block52;
                                if (bl3) {
                                    EGLDrawableFactory.this.defaultDevice.open();
                                    EGLDrawableFactory.this.defaultDeviceEGLFeatures = new EGLFeatures(EGLDrawableFactory.this.defaultDevice);
                                    long l = EGL.eglGetDisplay(0L);
                                    if (0L == l) {
                                        GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, 16);
                                        EGLDisplayUtil.setSingletonEGLDisplayOnly(true);
                                        if (DEBUG_SHAREDCTX) {
                                            System.err.println("Quirk: " + GLRendererQuirks.toString(16) + ": cause: Second eglGetDisplay(EGL_DEFAULT_DISPLAY) failed");
                                        }
                                    }
                                }
                                eGLGraphicsDevice = EGLDrawableFactory.this.defaultDevice;
                                eGLFeatures = EGLDrawableFactory.this.defaultDeviceEGLFeatures;
                                if (DEBUG_SHAREDCTX) {
                                    System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig.0: " + eGLFeatures);
                                }
                                if (gLProfile.isGLES() || eGLFeatures.hasGLAPI) break block53;
                                if (DEBUG_SHAREDCTX) {
                                    System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig() OpenGL API not supported (1)");
                                }
                                break block54;
                            }
                            GLCapabilitiesImmutable gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilities);
                            object2 = EGLDrawableFactory.getAvailableEGLConfigs(eGLGraphicsDevice, gLCapabilitiesImmutable);
                            boolean bl6 = bl5 = object2.size() > 0;
                            if (bl5) {
                                proxySurface3 = EGLDrawableFactory.this.createDummySurfaceImpl(eGLGraphicsDevice, false, gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, 64, 64);
                                if (null != proxySurface3) {
                                    proxySurface3.createNotify();
                                    proxySurface = proxySurface3;
                                }
                                break block54;
                            } else {
                                object = EGLDrawableFactory.getAvailableEGLConfigs(eGLGraphicsDevice, gLCapabilities);
                                if (object.size() > 0) {
                                    object3 = (GLCapabilitiesImmutable)object.get(0);
                                    EGLContext.mapStaticGLESVersion(eGLGraphicsDevice, (GLCapabilitiesImmutable)object3);
                                    bl4 = true;
                                }
                                if (DEBUG_SHAREDCTX) {
                                    System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig() no pbuffer config available, detected !pbuffer config: " + bl4);
                                    EGLGraphicsConfigurationFactory.printCaps("!PBufferCaps", (List<GLCapabilitiesImmutable>)object, System.err);
                                }
                            }
                            break block54;
                        }
                        proxySurface2 = gLDrawableFactoryImpl.createDummySurface(abstractGraphicsDevice, gLCapabilities, null, 64, 64);
                        if (null != proxySurface2) {
                            proxySurface2.createNotify();
                            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(proxySurface2);
                            eGLGraphicsDevice.open();
                            eGLFeatures = new EGLFeatures(eGLGraphicsDevice);
                            if (DEBUG_SHAREDCTX) {
                                System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig.1: " + eGLFeatures);
                            }
                            if (!gLProfile.isGLES() && !eGLFeatures.hasGLAPI) {
                                if (DEBUG_SHAREDCTX) {
                                    System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig() OpenGL API not supported (2)");
                                }
                            } else {
                                boolean bl7 = true;
                                proxySurface = proxySurface2;
                            }
                        }
                    }
                    if (null == proxySurface) return bl4;
                    eGLDrawable = null;
                    object2 = null;
                    object = null;
                    try {
                        eGLDrawable = (EGLDrawable)EGLDrawableFactory.this.createOnscreenDrawableImpl(proxySurface);
                        eGLDrawable.setRealized(true);
                        object = (EGLContext)eGLDrawable.createContext(null);
                        if (null == object) {
                            throw new GLException("Couldn't create shared context for drawable: " + eGLDrawable);
                        }
                        if (0 != ((GLContextImpl)object).makeCurrent()) {
                            object3 = ((GLContextImpl)object).getGL().glGetString(7938);
                            if (null != object3) {
                                ((EGLContext)object).mapCurrentAvailableGLESVersion(eGLGraphicsDevice);
                                if (eGLGraphicsDevice != abstractGraphicsDevice) {
                                    ((EGLContext)object).mapCurrentAvailableGLESVersion(abstractGraphicsDevice);
                                }
                                if (eGLFeatures.hasKHRSurfaceless && (((GLContext)object).isGLES() || ((GLContext)object).getGLVersionNumber().compareTo(GLContext.Version3_0) >= 0)) {
                                    if (EGLDrawableFactory.this.probeSurfacelessCtx((GLContext)object, false)) {
                                        object2 = ((GLContextImpl)object).getGLDrawable();
                                    }
                                } else {
                                    EGLDrawableFactory.this.setNoSurfacelessCtxQuirk((GLContext)object);
                                }
                                gLRendererQuirksArray[0] = ((GLContext)object).getRendererQuirks();
                                nArray3[0] = ((EGLContext)object).getContextOptions();
                                nArray[0] = ((GLContext)object).getGLVersionNumber().getMajor();
                                nArray2[0] = ((GLContext)object).getGLVersionNumber().getMinor();
                                bl4 = true;
                            } else if (DEBUG_SHAREDCTX) {
                                System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: " + eGLGraphicsDevice + ", " + ((GLContext)object).getGLVersion() + " - VERSION is null, dropping availability!");
                            }
                        }
                        if (null == object) break block50;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!DEBUG_SHAREDCTX) return bl4;
                            System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: INFO: context create/makeCurrent failed");
                            throwable.printStackTrace();
                            return bl4;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            block51: {
                                if (null != object) {
                                    try {
                                        ((GLContextImpl)object).destroy();
                                    }
                                    catch (GLException gLException) {
                                        if (!DEBUG_SHAREDCTX) break block51;
                                        System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: INFO: destroy caught exception:");
                                        gLException.printStackTrace();
                                    }
                                }
                            }
                            if (null != object2) {
                                object2.setRealized(false);
                            }
                            if (null != eGLDrawable) {
                                eGLDrawable.setRealized(false);
                            }
                        }
                    }
                    try {
                        ((GLContextImpl)object).destroy();
                    }
                    catch (GLException gLException) {
                        if (!DEBUG_SHAREDCTX) break block50;
                        System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: INFO: destroy caught exception:");
                        gLException.printStackTrace();
                    }
                }
                if (null != object2) {
                    object2.setRealized(false);
                }
                if (null == eGLDrawable) return bl4;
                eGLDrawable.setRealized(false);
                return bl4;
            }
            catch (Throwable throwable) {
                if (DEBUG_SHAREDCTX) {
                    System.err.println("Caught exception on thread " + EGLDrawableFactory.getThreadName());
                    throwable.printStackTrace();
                }
                bl4 = false;
                return bl4;
            }
            finally {
                if (null != proxySurface3) {
                    proxySurface3.destroyNotify();
                }
                if (EGLDrawableFactory.this.defaultDevice != eGLGraphicsDevice && null != eGLGraphicsDevice) {
                    eGLGraphicsDevice.close();
                }
                if (null != proxySurface2) {
                    proxySurface2.destroyNotify();
                }
            }
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG_SHAREDCTX) {
                System.err.println("Shutdown Shared:");
                System.err.println("Device  : " + sharedResource.device);
                ExceptionUtils.dumpStack((PrintStream)System.err);
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private EGLGraphicsDevice device;
        final boolean isAvailable;
        final GLRendererQuirks rendererQuirksGLn;
        final GLRendererQuirks rendererQuirksES1;
        final GLRendererQuirks rendererQuirksES3ES2;
        final int ctpGLn;
        final int ctpES1;
        final int ctpES3ES2;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice, boolean bl, GLRendererQuirks gLRendererQuirks, int n, GLRendererQuirks gLRendererQuirks2, int n2, GLRendererQuirks gLRendererQuirks3, int n3) {
            this.device = eGLGraphicsDevice;
            this.isAvailable = bl;
            this.rendererQuirksGLn = gLRendererQuirks;
            this.ctpGLn = n;
            this.rendererQuirksES1 = gLRendererQuirks2;
            this.ctpES1 = n2;
            this.rendererQuirksES3ES2 = gLRendererQuirks3;
            this.ctpES3ES2 = n3;
        }

        @Override
        public final boolean isAvailable() {
            return this.isAvailable;
        }

        @Override
        public final EGLGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public AbstractGraphicsScreen getScreen() {
            return null;
        }

        @Override
        public GLDrawableImpl getDrawable() {
            return null;
        }

        @Override
        public GLContextImpl getContext() {
            return null;
        }

        @Override
        public GLRendererQuirks getRendererQuirks(GLProfile gLProfile) {
            if (null == gLProfile) {
                if (null != this.rendererQuirksES3ES2) {
                    return this.rendererQuirksES3ES2;
                }
                if (null != this.rendererQuirksES1) {
                    return this.rendererQuirksES1;
                }
                return this.rendererQuirksGLn;
            }
            if (!gLProfile.isGLES()) {
                return this.rendererQuirksGLn;
            }
            if (gLProfile.isGLES1()) {
                return this.rendererQuirksES1;
            }
            return this.rendererQuirksES3ES2;
        }
    }

    static class EGLAcc
    extends EGL {
        EGLAcc() {
        }

        protected static boolean resetProcAddressTable(DynamicLookupHelper dynamicLookupHelper) {
            return EGL.resetProcAddressTable(dynamicLookupHelper);
        }
    }

    private static class EGLFeatures {
        public final String vendor;
        public final VersionNumber version;
        public final boolean hasGLAPI;
        public final boolean hasKHRCreateContext;
        public final boolean hasKHRSurfaceless;

        public EGLFeatures(EGLGraphicsDevice eGLGraphicsDevice) {
            long l = eGLGraphicsDevice.getHandle();
            this.vendor = EGL.eglQueryString(l, 12371);
            if (DEBUG) {
                System.err.println("EGLFeatures on device " + eGLGraphicsDevice + ", vendor " + this.vendor);
            }
            this.version = eGLGraphicsDevice.getEGLVersion();
            boolean bl = this.version.compareTo(GLContext.Version1_4) >= 0;
            boolean bl2 = this.version.compareTo(GLContext.Version1_5) >= 0;
            boolean bl3 = false;
            String string = EGL.eglQueryString(l, 12429);
            if (bl) {
                String[] stringArray = string.split("\\s");
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    bl3 = stringArray[i].equals("OpenGL");
                }
            }
            this.hasGLAPI = bl3;
            if (DEBUG) {
                System.err.println("  Client APIs: " + string + "; has EGL 1.4 " + bl + " -> has OpenGL " + this.hasGLAPI);
            }
            String string2 = EGLContext.getPlatformExtensionsStringImpl(eGLGraphicsDevice).toString();
            if (bl2) {
                this.hasKHRCreateContext = true;
                this.hasKHRSurfaceless = true;
            } else {
                this.hasKHRCreateContext = bl ? string2.contains("EGL_KHR_create_context") : false;
                this.hasKHRSurfaceless = string2.contains("EGL_KHR_surfaceless_context");
            }
            if (DEBUG) {
                System.err.println("  Extensions: " + string2);
                System.err.println("  KHR_create_context: " + this.hasKHRCreateContext);
                System.err.println("  KHR_surfaceless_context: " + this.hasKHRSurfaceless);
            }
        }

        public final String toString() {
            return "EGLFeatures[vendor " + this.vendor + ", version " + this.version + ", has[GL-API " + this.hasGLAPI + ", KHR[CreateContext " + this.hasKHRCreateContext + ", Surfaceless " + this.hasKHRSurfaceless + "]]]";
        }
    }
}

