/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;

@Component
@Singleton
public class DefaultJobContext
implements JobContext {
    private static final String KEY_CURRENTJOB = "job.current";
    @Inject
    private Execution execution;

    private Stack<Job> getJobstack(boolean create) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Stack stack = (Stack)context.getProperty(KEY_CURRENTJOB);
            if (stack == null && create) {
                stack = new Stack();
                context.setProperty(KEY_CURRENTJOB, stack);
            }
            return stack;
        }
        return null;
    }

    @Override
    public Job getCurrentJob() {
        Stack<Job> stack = this.getJobstack(false);
        return stack == null || stack.isEmpty() ? null : stack.peek();
    }

    @Override
    public void pushCurrentJob(Job job) {
        this.getJobstack(true).push(job);
    }

    @Override
    public void popCurrentJob() {
        this.getJobstack(true).pop();
    }
}

