/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportSchedule;
import net.osmand.data.TransportStop;
import net.osmand.data.TransportStopExit;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.TransportTags;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityParser;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sf.junidecode.Junidecode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.RTree;
import rtree.RTreeException;
import rtree.RTreeInsertException;
import rtree.Rect;

public class IndexTransportCreator
extends AbstractIndexPartCreator {
    private static final Log log = LogFactory.getLog(IndexTransportCreator.class);
    private static final int DISTANCE_THRESHOLD = 50;
    public static final int MISSING_STOP_DISTANCE_THRESHOLD = 30;
    public static final String MISSING_STOP_NAME = "#Missing Stop";
    private Set<Long> visitedStops = new HashSet<Long>();
    private PreparedStatement transRouteStat;
    private PreparedStatement transRouteStopsStat;
    private PreparedStatement transStopsStat;
    private PreparedStatement transRouteGeometryStat;
    private RTree transportStopsTree;
    private Map<Long, Relation> masterRoutes = new HashMap<Long, Relation>();
    private Connection gtfsConnection;
    private static final long TEST_ROUTE_ID_MISSING_STOPS = 192037L;
    private Map<Entity.EntityId, Relation> stopAreas = new HashMap<Entity.EntityId, Relation>();
    private Map<Entity.EntityId, List<TransportStopExit>> exits = new HashMap<Entity.EntityId, List<TransportStopExit>>();
    private final TransportTags transportRouteTagValues = new TransportTags();
    private static Set<String> acceptedRoutes = new HashSet<String>();
    private TLongObjectHashMap<TransportRoute> incompleteRoutesMap = new TLongObjectHashMap();
    private PreparedStatement gtfsSelectRoute;
    private PreparedStatement gtfsSelectStopTimes;
    private GtfsInfoStats gtfsStats = new GtfsInfoStats();
    protected IndexCreatorSettings settings;
    private Pattern platforms = Pattern.compile("^(stop|platform)_(entry|exit)_only$");
    private Matcher stopPlatformMatcher = this.platforms.matcher("");

    public static boolean acceptedPublicTransportRoute(String rt) {
        return acceptedRoutes.contains(rt);
    }

    public IndexTransportCreator(IndexCreatorSettings settings) throws SQLException {
        File gtfs = settings.gtfsData;
        this.settings = settings;
        if (gtfs != null && gtfs.exists()) {
            DBDialect dialect = DBDialect.SQLITE;
            this.gtfsConnection = dialect.getDatabaseConnection(gtfs.getAbsolutePath(), log);
        }
    }

    public void createRTreeFile(String rtreeTransportStopFile) throws RTreeException {
        this.transportStopsTree = new RTree(rtreeTransportStopFile);
    }

    public void writeBinaryTransportTree(rtree.Node parent, RTree r, BinaryMapIndexWriter writer, PreparedStatement selectTransportStop, PreparedStatement selectTransportRouteStop, Map<Long, Long> transportRoutes, Map<String, Integer> stringTable) throws IOException, RTreeException, SQLException {
        Element[] e = parent.getAllElements();
        TLongArrayList routesOffsets = null;
        TLongArrayList routesIds = null;
        TLongArrayList deletedRoutes = null;
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            Rect re = e[i].getRect();
            if (e[i].getElementType() == 1) {
                long id = e[i].getPtr();
                selectTransportStop.setLong(1, id);
                selectTransportRouteStop.setLong(1, id);
                ResultSet rs = selectTransportStop.executeQuery();
                if (rs.next()) {
                    long[] deletedRoutesArray;
                    Gson gson = new Gson();
                    Type t = new TypeToken<Map<String, String>>(){}.getType();
                    int x24 = (int)MapUtils.getTileNumberX((float)24.0f, (double)rs.getDouble(3));
                    int y24 = (int)MapUtils.getTileNumberY((float)24.0f, (double)rs.getDouble(2));
                    String name = rs.getString(4);
                    String nameEn = rs.getString(5);
                    Map names = (Map)gson.fromJson(rs.getString(6), t);
                    if (nameEn != null && nameEn.equals(Junidecode.unidecode((String)name))) {
                        nameEn = null;
                    }
                    String deletedRoutesStr = rs.getString(7);
                    if (deletedRoutes == null) {
                        deletedRoutes = new TLongArrayList();
                    } else {
                        deletedRoutes.clear();
                    }
                    if (!Algorithms.isEmpty((CharSequence)deletedRoutesStr) && (deletedRoutesArray = (long[])gson.fromJson(deletedRoutesStr, long[].class)) != null && deletedRoutesArray.length > 0) {
                        for (long routeId : deletedRoutesArray) {
                            deletedRoutes.add(routeId);
                        }
                    }
                    ResultSet rset = selectTransportRouteStop.executeQuery();
                    if (routesOffsets == null) {
                        routesOffsets = new TLongArrayList();
                    } else {
                        routesOffsets.clear();
                    }
                    if (routesIds == null) {
                        routesIds = new TLongArrayList();
                    } else {
                        routesIds.clear();
                    }
                    while (rset.next()) {
                        long routeId = rset.getLong(1);
                        if (transportRoutes.get(routeId) == null) {
                            log.error((Object)("Something goes wrong with transport route id = " + routeId));
                            continue;
                        }
                        routesIds.add(routeId);
                    }
                    routesIds.sort();
                    for (long routeId : routesIds.toArray()) {
                        Long routeOffset = transportRoutes.get(routeId);
                        routesOffsets.add(routeOffset.longValue());
                    }
                    rset.close();
                    writer.writeTransportStop(id, x24, y24, name, nameEn, names, stringTable, routesOffsets, routesIds, deletedRoutes, this.exits);
                    continue;
                }
                log.error((Object)("Something goes wrong with transport id = " + id));
                continue;
            }
            long ptr = e[i].getPtr();
            rtree.Node ns = r.getReadNode(ptr);
            writer.startTransportTreeElement(re.getMinX(), re.getMaxX(), re.getMinY(), re.getMaxY());
            this.writeBinaryTransportTree(ns, r, writer, selectTransportStop, selectTransportRouteStop, transportRoutes, stringTable);
            writer.endWriteTransportTreeElement();
        }
    }

    public void writeBinaryTransportTree(rtree.Node parent, RTree r, BinaryMapIndexWriter writer, TLongObjectHashMap<TransportStop> transportStops, Map<String, Integer> stringTable) throws IOException, RTreeException, SQLException {
        Element[] e = parent.getAllElements();
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            Rect re = e[i].getRect();
            if (e[i].getElementType() == 1) {
                long id = e[i].getPtr();
                TransportStop stop = (TransportStop)transportStops.get(id);
                if (stop != null) {
                    int x24 = (int)MapUtils.getTileNumberX((float)24.0f, (double)stop.getLocation().getLongitude());
                    int y24 = (int)MapUtils.getTileNumberY((float)24.0f, (double)stop.getLocation().getLatitude());
                    TLongArrayList routesOffsets = new TLongArrayList();
                    if (stop.getReferencesToRoutes() != null) {
                        for (long referencesToRoute : stop.getReferencesToRoutes()) {
                            routesOffsets.add(referencesToRoute);
                        }
                    }
                    TLongArrayList routesIds = new TLongArrayList();
                    if (stop.getRoutesIds() != null) {
                        routesIds.addAll(stop.getRoutesIds());
                    }
                    TLongArrayList deletedRoutes = new TLongArrayList();
                    if (stop.getDeletedRoutesIds() != null) {
                        deletedRoutes.addAll(stop.getDeletedRoutesIds());
                    }
                    HashMap<Entity.EntityId, List<TransportStopExit>> exits = new HashMap<Entity.EntityId, List<TransportStopExit>>();
                    exits.put(new Entity.EntityId(Entity.EntityType.NODE, stop.getId()), stop.getExits());
                    writer.writeTransportStop(id, x24, y24, stop.getName(), stop.getEnName(false), stop.getNamesMap(false), stringTable, routesOffsets, routesIds, deletedRoutes, exits);
                    continue;
                }
                log.error((Object)("Something goes wrong with transport id = " + id));
                continue;
            }
            long ptr = e[i].getPtr();
            rtree.Node ns = r.getReadNode(ptr);
            writer.startTransportTreeElement(re.getMinX(), re.getMaxX(), re.getMinY(), re.getMaxY());
            this.writeBinaryTransportTree(ns, r, writer, transportStops, stringTable);
            writer.endWriteTransportTreeElement();
        }
    }

    public void packRTree(String rtreeTransportStopsFileName, String rtreeTransportStopsPackFileName) throws IOException {
        this.transportStopsTree = IndexTransportCreator.packRtreeFile(this.transportStopsTree, rtreeTransportStopsFileName, rtreeTransportStopsPackFileName);
    }

    public void indexRelations(Relation e, OsmDbAccessorContext ctx) throws SQLException {
        if (e.getTag(OSMSettings.OSMTagKey.ROUTE_MASTER) != null) {
            ctx.loadEntityRelation(e);
            for (Relation.RelationMember child : e.getMembers()) {
                Entity entity = child.getEntity();
                if (entity == null) continue;
                this.masterRoutes.put(entity.getId(), e);
            }
        }
        if ("stop_area".equals(e.getTag(OSMSettings.OSMTagKey.PUBLIC_TRANSPORT))) {
            ctx.loadEntityRelation(e);
            for (Relation.RelationMember entry : e.getMembers()) {
                String role = entry.getRole();
                if (!"platform".equals(role) && !"stop".equals(role) || entry.getEntity() == null || entry.getEntity().getTag(OSMSettings.OSMTagKey.NAME) != null) continue;
                this.stopAreas.put(entry.getEntityId(), e);
            }
            ArrayList<TransportStopExit> stopExitList = new ArrayList<TransportStopExit>();
            for (Relation.RelationMember entryAlt : e.getMembers()) {
                if (entryAlt.getEntity() == null || !"subway_entrance".equals(entryAlt.getEntity().getTag(OSMSettings.OSMTagKey.RAILWAY))) continue;
                TransportStopExit exit = new TransportStopExit();
                exit.setId(Long.valueOf(entryAlt.getEntity().getId()));
                if (entryAlt.getEntity().getTag("ref") != null) {
                    exit.setRef(entryAlt.getEntity().getTag("ref"));
                }
                exit.setLocation(entryAlt.getEntity().getLatitude(), entryAlt.getEntity().getLongitude());
                stopExitList.add(exit);
            }
            for (Relation.RelationMember entry : e.getMembers()) {
                String role = entry.getRole();
                if (entry.getEntity() == null || (!"".equals(role) || !"station".equals(entry.getEntity().getTag(OSMSettings.OSMTagKey.RAILWAY))) && !"stop".equals(role)) continue;
                this.exits.put(entry.getEntityId(), stopExitList);
            }
        }
    }

    public void iterateMainEntity(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if (e instanceof Relation && e.getTag(OSMSettings.OSMTagKey.ROUTE) != null) {
            ctx.loadEntityRelation((Relation)e);
            ArrayList<TransportRoute> troutes = new ArrayList<TransportRoute>();
            this.indexTransportRoute((Relation)e, troutes, icc);
            for (TransportRoute route : troutes) {
                this.insertTransportIntoIndex(route);
            }
        }
    }

    public void createDatabaseStructure(Connection conn, DBDialect dialect, String rtreeStopsFileName) throws SQLException, IOException {
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table transport_route (id bigint primary key, type varchar(1024), operator varchar(1024),ref varchar(1024), name varchar(1024), name_en varchar(1024), dist int, color varchar(1024))");
        stat.executeUpdate("create index transport_route_id on transport_route (id)");
        stat.executeUpdate("create table transport_route_stop (stop bigint, route bigint, ord int, primary key (route, ord))");
        stat.executeUpdate("create index transport_route_stop_stop on transport_route_stop (stop)");
        stat.executeUpdate("create index transport_route_stop_route on transport_route_stop (route)");
        stat.executeUpdate("create table transport_route_geometry (geometry bytes, route bigint, ind int)");
        stat.executeUpdate("create index transport_route_geometry_route on transport_route_geometry (route)");
        stat.executeUpdate("create table transport_stop (id bigint primary key, latitude double, longitude double, name varchar(1024), name_en varchar(1024), names varchar(8096), deleted_routes varchar(1024))");
        stat.executeUpdate("create index transport_stop_id on transport_stop (id)");
        stat.executeUpdate("create index transport_stop_location on transport_stop (latitude, longitude)");
        stat.close();
        try {
            File file = new File(rtreeStopsFileName);
            if (file.exists()) {
                file.delete();
            }
            this.transportStopsTree = new RTree(file.getAbsolutePath());
        }
        catch (RTreeException e) {
            throw new IOException(e);
        }
        this.transRouteStat = conn.prepareStatement("insert into transport_route(id, type, operator, ref, name, name_en, dist, color) values(?, ?, ?, ?, ?, ?, ?, ?)");
        this.transRouteStopsStat = conn.prepareStatement("insert into transport_route_stop(route, stop, ord) values(?, ?, ?)");
        this.transStopsStat = conn.prepareStatement("insert into transport_stop(id, latitude, longitude, name, name_en, names, deleted_routes) values(?, ?, ?, ?, ?, ?, ?)");
        this.transRouteGeometryStat = conn.prepareStatement("insert into transport_route_geometry(route, geometry, ind) values(?, ?, ?)");
        this.pStatements.put(this.transRouteStat, 0);
        this.pStatements.put(this.transRouteStopsStat, 0);
        this.pStatements.put(this.transStopsStat, 0);
        this.pStatements.put(this.transRouteGeometryStat, 0);
        if (this.gtfsConnection != null) {
            boolean hasTripMetadataLoc = false;
            ResultSet columns = this.gtfsConnection.createStatement().executeQuery("PRAGMA table_info(trips)");
            while (columns.next()) {
                String name = columns.getString("name");
                if (!name.equals("firstStopLat")) continue;
                hasTripMetadataLoc = true;
            }
            if (!hasTripMetadataLoc) {
                this.indexBboxForGtfsTrips();
            }
        }
    }

    private void indexBboxForGtfsTrips() throws SQLException {
        ResultSet countRs = this.gtfsConnection.createStatement().executeQuery("SELECT COUNT(*) FROM trips");
        countRs.next();
        int total = countRs.getInt(1);
        countRs.close();
        for (String s : new String[]{"routes:route_id", "trips:trip_id,route_id,shape_id,service_id", "shapes:shape_id", "stops:stop_id", "stop_times:trip_id,stop_id", "calendar_dates:service_id"}) {
            String[] colNames;
            int spl = s.indexOf(58);
            String tableName = s.substring(0, spl);
            for (String colName : colNames = s.substring(spl + 1).split(",")) {
                String indName = tableName + "_" + colName;
                String ddl = "CREATE INDEX IF NOT EXISTS " + indName + " on " + tableName + " (" + colName + ")";
                log.info((Object)ddl);
                this.gtfsConnection.createStatement().execute(ddl);
            }
        }
        log.info((Object)"Alter table and add columns");
        for (String s : new String[]{"firstStopLat", "firstStopLon", "minLat", "maxLat", "minLon", "maxLon"}) {
            try {
                this.gtfsConnection.createStatement().execute("ALTER TABLE trips ADD COLUMN " + s + " double");
            }
            catch (Exception spl) {
                // empty catch block
            }
        }
        log.info((Object)String.format("Indexing %d gtfs trips to compute bbox", total));
        PreparedStatement ins = this.gtfsConnection.prepareStatement("UPDATE trips SET firstStopLat = ?, firstStopLon = ?, minLat = ?, maxLat = ?, minLon = ?, maxLon = ? where trip_id = ?");
        ResultSet selectTimes = this.gtfsConnection.createStatement().executeQuery("SELECT t.trip_id, t.stop_sequence, s.stop_lat, s.stop_lon from stop_times t join stops s on s.stop_id = t.stop_id order by t.trip_id");
        QuadRect bbox = null;
        LatLon start = null;
        String tripId = null;
        int cnt = 0;
        int minStopSeq = 0;
        while (selectTimes.next()) {
            String nTripId = selectTimes.getString(1);
            double lat = selectTimes.getDouble(3);
            double lon = selectTimes.getDouble(4);
            int stopSeq = selectTimes.getInt(2);
            if (!Algorithms.objectEquals((Object)nTripId, tripId)) {
                this.insertTripIds(ins, tripId, start, bbox, ++cnt);
                minStopSeq = stopSeq;
                start = new LatLon(lat, lon);
                bbox = new QuadRect(lon, lat, lon, lat);
                tripId = nTripId;
            }
            if (stopSeq < minStopSeq) {
                minStopSeq = stopSeq;
                start = new LatLon(lat, lon);
            }
            bbox.left = Math.min(bbox.left, lon);
            bbox.right = Math.max(bbox.right, lon);
            bbox.top = Math.max(bbox.top, lat);
            bbox.bottom = Math.min(bbox.bottom, lat);
        }
        this.insertTripIds(ins, tripId, start, bbox, 0);
        ins.close();
        selectTimes.close();
    }

    private void insertTripIds(PreparedStatement ins, String tripId, LatLon start, QuadRect bbox, int i) throws SQLException {
        if (tripId != null) {
            ins.setDouble(1, start.getLatitude());
            ins.setDouble(2, start.getLongitude());
            ins.setDouble(3, bbox.bottom);
            ins.setDouble(4, bbox.top);
            ins.setDouble(5, bbox.left);
            ins.setDouble(6, bbox.right);
            ins.setString(7, tripId);
            ins.addBatch();
        }
        if (i % 10000 == 0) {
            ins.executeBatch();
            log.info((Object)("Progress " + i + " trips"));
        }
    }

    private void insertTransportIntoIndex(TransportRoute route) throws SQLException {
        this.transRouteStat.setLong(1, route.getId());
        this.transRouteStat.setString(2, route.getType());
        this.transRouteStat.setString(3, route.getOperator());
        this.transRouteStat.setString(4, route.getRef());
        this.transRouteStat.setString(5, route.getName());
        this.transRouteStat.setString(6, route.getEnName(false));
        this.transRouteStat.setInt(7, route.getAvgBothDistance());
        this.transRouteStat.setString(8, route.getColor());
        this.addBatch(this.transRouteStat);
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        if (route.getForwardWays() != null) {
            int ind = 0;
            for (Way tr : route.getForwardWays()) {
                this.addBatch(route, ous, tr, ind++);
            }
        }
        this.writeRouteStops(route, route.getForwardStops());
    }

    private void addBatch(TransportRoute route, ByteArrayOutputStream ous, Way tr, int ind) throws SQLException {
        if (tr.getNodes().size() == 0) {
            return;
        }
        this.transRouteGeometryStat.setLong(1, route.getId());
        this.writeWay(ous, tr);
        this.transRouteGeometryStat.setBytes(2, ous.toByteArray());
        this.transRouteGeometryStat.setInt(3, ind);
        this.addBatch(this.transRouteGeometryStat);
    }

    public void writeWay(ByteArrayOutputStream ous, Way way) {
        ous.reset();
        for (Node n : way.getNodes()) {
            int y = MapUtils.get31TileNumberY((double)n.getLatitude());
            int x = MapUtils.get31TileNumberX((double)n.getLongitude());
            try {
                Algorithms.writeInt((OutputStream)ous, (int)x);
                Algorithms.writeInt((OutputStream)ous, (int)y);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeRouteStops(TransportRoute r, List<TransportStop> stops) throws SQLException {
        int i = 0;
        for (TransportStop s : stops) {
            if (!this.visitedStops.contains(s.getId())) {
                Gson gson = new Gson();
                this.transStopsStat.setLong(1, s.getId());
                this.transStopsStat.setDouble(2, s.getLocation().getLatitude());
                this.transStopsStat.setDouble(3, s.getLocation().getLongitude());
                this.transStopsStat.setString(4, s.getName());
                this.transStopsStat.setString(5, s.getEnName(false));
                Map namesMap = s.getNamesMap(false);
                this.transStopsStat.setString(6, namesMap.size() > 0 ? gson.toJson((Object)namesMap) : "{}");
                this.transStopsStat.setString(7, gson.toJson((Object)s.getDeletedRoutesIds()));
                int x = (int)MapUtils.getTileNumberX((float)24.0f, (double)s.getLocation().getLongitude());
                int y = (int)MapUtils.getTileNumberY((float)24.0f, (double)s.getLocation().getLatitude());
                this.addBatch(this.transStopsStat);
                try {
                    this.transportStopsTree.insert(new LeafElement(new Rect(x, y, x, y), s.getId()));
                }
                catch (RTreeInsertException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (IllegalValueException e) {
                    throw new IllegalArgumentException(e);
                }
                this.visitedStops.add(s.getId());
            }
            this.transRouteStopsStat.setLong(1, r.getId());
            this.transRouteStopsStat.setLong(2, s.getId());
            this.transRouteStopsStat.setInt(3, i++);
            this.addBatch(this.transRouteStopsStat);
        }
    }

    public void writeBinaryTransportIndex(BinaryMapIndexWriter writer, String regionName, Connection mapConnection) throws IOException, SQLException {
        try {
            this.closePreparedStatements(this.transRouteStat, this.transRouteStopsStat, this.transStopsStat, this.transRouteGeometryStat);
            mapConnection.commit();
            this.transportStopsTree.flush();
            this.visitedStops = null;
            PreparedStatement selectTransportRouteData = mapConnection.prepareStatement("SELECT id, dist, name, name_en, ref, operator, type, color FROM transport_route");
            PreparedStatement selectTransportData = mapConnection.prepareStatement("SELECT S.stop,   A.latitude,  A.longitude, A.name, A.name_en, A.names, A.deleted_routes FROM transport_route_stop S INNER JOIN transport_stop A ON A.id = S.stop WHERE S.route = ? ORDER BY S.ord asc");
            PreparedStatement selectTransportRouteGeometry = mapConnection.prepareStatement("SELECT S.geometry FROM transport_route_geometry S WHERE S.route = ? order by S.ind");
            long transportIndexOffset = writer.startWriteTransportIndex(regionName);
            writer.startWriteTransportRoutes();
            Map<String, Integer> stringTable = this.createStringTableForTransport();
            LinkedHashMap<Long, Long> transportRoutes = new LinkedHashMap<Long, Long>();
            ResultSet rs = selectTransportRouteData.executeQuery();
            ArrayList<TransportStop> directStops = new ArrayList<TransportStop>();
            ArrayList reverseStops = new ArrayList();
            ArrayList<byte[]> directGeometry = new ArrayList<byte[]>();
            while (rs.next()) {
                long idRoute = rs.getLong(1);
                int dist = rs.getInt(2);
                String routeName = rs.getString(3);
                String routeEnName = rs.getString(4);
                if (routeEnName != null && routeEnName.equals(Junidecode.unidecode((String)routeName))) {
                    routeEnName = null;
                }
                String ref = rs.getString(5);
                String operator = rs.getString(6);
                String type = rs.getString(7);
                String color = rs.getString(8);
                selectTransportData.setLong(1, idRoute);
                ResultSet rset = selectTransportData.executeQuery();
                reverseStops.clear();
                directStops.clear();
                directGeometry.clear();
                while (rset.next()) {
                    long idStop = rset.getLong(1);
                    String stopName = rset.getString(4);
                    String stopEnName = rset.getString(5);
                    Gson gson = new Gson();
                    String names = rset.getString(6);
                    Type t = new TypeToken<Map<String, String>>(){}.getType();
                    Map map = (Map)gson.fromJson(names, t);
                    if (stopEnName != null && stopEnName.equals(Junidecode.unidecode((String)stopName))) {
                        stopEnName = null;
                    }
                    TransportStop st = new TransportStop();
                    st.setNames(map);
                    st.setId(Long.valueOf(idStop));
                    st.setName(stopName);
                    st.setLocation(rset.getDouble(2), rset.getDouble(3));
                    if (stopEnName != null) {
                        st.setEnName(stopEnName);
                    }
                    directStops.add(st);
                }
                selectTransportRouteGeometry.setLong(1, idRoute);
                rset = selectTransportRouteGeometry.executeQuery();
                while (rset.next()) {
                    byte[] bytes = rset.getBytes(1);
                    directGeometry.add(bytes);
                }
                TransportSchedule schedule = this.readSchedule(ref, directStops);
                long ptr = writer.writeTransportRoute(idRoute, routeName, routeEnName, ref, operator, type, dist, color, directStops, directGeometry, stringTable, transportRoutes, schedule, this.transportRouteTagValues);
                if (!this.isRouteIncomplete(idRoute)) continue;
                ((TransportRoute)this.incompleteRoutesMap.get(idRoute)).setFileOffset((long)((int)ptr));
            }
            rs.close();
            selectTransportRouteData.close();
            selectTransportData.close();
            writer.endWriteTransportRoutes();
            PreparedStatement selectTransportStop = mapConnection.prepareStatement("SELECT A.id,  A.latitude,  A.longitude, A.name, A.name_en, A.names, A.deleted_routes FROM transport_stop A where A.id = ?");
            PreparedStatement selectTransportRouteStop = mapConnection.prepareStatement("SELECT DISTINCT S.route FROM transport_route_stop S join transport_route R  on R.id = S.route WHERE S.stop = ? ORDER BY R.type, R.ref ");
            long rootIndex = this.transportStopsTree.getFileHdr().getRootIndex();
            rtree.Node root = this.transportStopsTree.getReadNode(rootIndex);
            Rect rootBounds = this.calcBounds(root);
            if (rootBounds != null) {
                writer.startTransportTreeElement(rootBounds.getMinX(), rootBounds.getMaxX(), rootBounds.getMinY(), rootBounds.getMaxY());
                this.writeBinaryTransportTree(root, this.transportStopsTree, writer, selectTransportStop, selectTransportRouteStop, transportRoutes, stringTable);
                writer.endWriteTransportTreeElement();
            }
            selectTransportStop.close();
            selectTransportRouteStop.close();
            writer.writeIncompleteTransportRoutes(this.incompleteRoutesMap.valueCollection(), stringTable, transportIndexOffset);
            writer.writeTransportStringTable(stringTable);
            writer.endWriteTransportIndex();
            writer.flush();
            log.info((Object)this.gtfsStats);
        }
        catch (RTreeException e) {
            throw new IllegalStateException(e);
        }
    }

    private Rect calcBounds(rtree.Node n) {
        Rect r = null;
        Element[] e = n.getAllElements();
        for (int i = 0; i < n.getTotalElements(); ++i) {
            Rect re = e[i].getRect();
            if (r == null) {
                try {
                    r = new Rect(re.getMinX(), re.getMinY(), re.getMaxX(), re.getMaxY());
                }
                catch (IllegalValueException illegalValueException) {}
                continue;
            }
            r.expandToInclude(re);
        }
        return r;
    }

    private int registerString(Map<String, Integer> stringTable, String s) {
        if (stringTable.containsKey(s)) {
            return stringTable.get(s);
        }
        int size = stringTable.size();
        stringTable.put(s, size);
        return size;
    }

    public Map<String, Integer> createStringTableForTransport() {
        LinkedHashMap<String, Integer> stringTable = new LinkedHashMap<String, Integer>();
        this.registerString(stringTable, "bus");
        this.registerString(stringTable, "trolleybus");
        this.registerString(stringTable, "subway");
        this.registerString(stringTable, "tram");
        this.registerString(stringTable, "share_taxi");
        this.registerString(stringTable, "taxi");
        this.registerString(stringTable, "train");
        this.registerString(stringTable, "ferry");
        return stringTable;
    }

    public void commitAndCloseFiles(String rtreeStopsFileName, String rtreeStopsPackFileName, boolean deleteDatabaseIndexes) throws IOException, SQLException {
        if (this.transportStopsTree != null) {
            this.transportStopsTree.getFileHdr().getFile().close();
            File f = new File(rtreeStopsFileName);
            if (f.exists() && deleteDatabaseIndexes) {
                f.delete();
            }
            if ((f = new File(rtreeStopsPackFileName)).exists() && deleteDatabaseIndexes) {
                f.delete();
            }
        }
        this.closeAllPreparedStatements();
    }

    private void indexTransportRoute(Relation rel, List<TransportRoute> troutes, IndexCreationContext icc) throws SQLException {
        String name;
        String ref = rel.getTag(OSMSettings.OSMTagKey.REF);
        String route = rel.getTag(OSMSettings.OSMTagKey.ROUTE);
        String operator = rel.getTag(OSMSettings.OSMTagKey.OPERATOR);
        Object color = rel.getTag(OSMSettings.OSMTagKey.COLOUR);
        Relation master = this.masterRoutes.get(rel.getId());
        if (master != null) {
            if (ref == null) {
                ref = master.getTag(OSMSettings.OSMTagKey.REF);
            }
            if (route == null) {
                route = master.getTag(OSMSettings.OSMTagKey.ROUTE);
            }
            if (operator == null) {
                operator = master.getTag(OSMSettings.OSMTagKey.OPERATOR);
            }
            if (color == null) {
                color = master.getTag(OSMSettings.OSMTagKey.COLOUR);
            }
        }
        if (ref == null && route != null && (name = rel.getTag(OSMSettings.OSMTagKey.NAME)) != null) {
            if (name.length() <= 5) {
                ref = name.toUpperCase();
            } else if (name.contains(" ") || name.contains("-")) {
                String[] subnames = name.split(" ");
                char[] newRef = new char[subnames.length];
                for (int i = 0; i < subnames.length; ++i) {
                    if (Algorithms.isEmpty((CharSequence)subnames[i])) continue;
                    newRef[i] = subnames[i].charAt(0);
                }
                String string = ref = newRef.length <= 5 ? new String(newRef).toUpperCase() : new String(newRef).substring(0, 4).toUpperCase();
            }
        }
        if (route == null || ref == null) {
            return;
        }
        if (!acceptedRoutes.contains(route)) {
            return;
        }
        if (color != null) {
            String tmp = MapRenderingTypesEncoder.formatColorToPalette((String)color, false).replaceAll("_", "");
            color = "subwayText" + Algorithms.capitalizeFirstLetter((String)tmp) + "Color";
        }
        TransportRoute directRoute = EntityParser.parserRoute((Relation)rel, (String)ref);
        directRoute.setOperator(operator);
        directRoute.setColor((String)color);
        directRoute.setType(route);
        directRoute.setRef(ref);
        directRoute.setId(Long.valueOf(directRoute.getId() << 1));
        this.transportRouteTagValues.registerTagValues(rel, directRoute.getId());
        if (this.processTransportRelationV2(rel, directRoute, icc)) {
            List<Entity> incompleteNodes = this.getIncompleteStops(rel, directRoute);
            List forwardStops = directRoute.getForwardStops();
            if (directRoute.getId() / 2L == 192037L) {
                System.out.println(directRoute.getName() + ":");
            }
            if (this.hasRelationIncompleteWays(rel) && forwardStops.size() > 0 && directRoute.getForwardWays().size() > 1) {
                directRoute.mergeForwardWays();
                for (Way w : directRoute.getForwardWays()) {
                    this.insertMissingStop(directRoute, incompleteNodes, w.getFirstNode(), w.getId() << 1, true);
                    this.insertMissingStop(directRoute, incompleteNodes, w.getLastNode(), (w.getId() << 1) + 1L, false);
                }
            }
            troutes.add(directRoute);
            if (directRoute.getId() / 2L == 192037L) {
                for (TransportStop s : directRoute.getForwardStops()) {
                    System.out.println(" " + s.getId() / 64L + " " + s.getName());
                }
            }
        } else {
            TransportRoute backwardRoute = EntityParser.parserRoute((Relation)rel, (String)ref);
            backwardRoute.setOperator(operator);
            backwardRoute.setColor((String)color);
            backwardRoute.setType(route);
            backwardRoute.setRef(ref);
            backwardRoute.setName(this.reverseName(ref, backwardRoute.getName()));
            if (!Algorithms.isEmpty((CharSequence)backwardRoute.getEnName(false))) {
                backwardRoute.setEnName(this.reverseName(ref, backwardRoute.getEnName(false)));
            }
            if (this.processTransportRelationV1(rel, directRoute, backwardRoute)) {
                backwardRoute.setId(Long.valueOf((backwardRoute.getId() << 1) + 1L));
                troutes.add(directRoute);
                troutes.add(backwardRoute);
                this.transportRouteTagValues.registerTagValues(rel, backwardRoute.getId());
            }
        }
    }

    private void insertMissingStop(TransportRoute directRoute, List<Entity> incompleteStops, Node node, long wayId, boolean before) {
        Entity insertNode = null;
        LatLon loc = node.getLatLon();
        for (int i = 0; i < incompleteStops.size(); i += 2) {
            Entity insertNodeNew;
            Entity entity = insertNodeNew = before ? incompleteStops.get(i + 1) : incompleteStops.get(i);
            if (insertNode == null) {
                insertNode = insertNodeNew;
                continue;
            }
            if (insertNodeNew == null || !(MapUtils.getDistance((LatLon)insertNodeNew.getLatLon(), (LatLon)loc) < MapUtils.getDistance((LatLon)insertNode.getLatLon(), (LatLon)loc))) continue;
            insertNode = insertNodeNew;
        }
        if (insertNode != null && MapUtils.getDistance((LatLon)insertNode.getLatLon(), (LatLon)loc) > 30.0) {
            TransportStop stp = new TransportStop();
            stp.setId(Long.valueOf(-wayId));
            stp.setLocation(node.getLatitude(), node.getLongitude());
            stp.setName(MISSING_STOP_NAME);
            List forwardStops = directRoute.getForwardStops();
            for (int i = 0; i < forwardStops.size(); ++i) {
                TransportStop ts = (TransportStop)forwardStops.get(i);
                if (ts.getId().longValue() != insertNode.getId()) continue;
                int insertInd = before ? i : i + 1;
                boolean alreadyExistMissing = false;
                if (before && i > 0 && ((TransportStop)forwardStops.get(i - 1)).isMissingStop()) {
                    alreadyExistMissing = true;
                } else if (!before && i < forwardStops.size() - 1 && ((TransportStop)forwardStops.get(i + 1)).isMissingStop()) {
                    alreadyExistMissing = true;
                }
                if (alreadyExistMissing) continue;
                forwardStops.add(insertInd, stp);
                break;
            }
            this.addIncompleteRoute(directRoute.getId(), directRoute);
        }
    }

    private void addIncompleteRoute(long routeId, TransportRoute t) {
        this.incompleteRoutesMap.put(routeId, (Object)t);
    }

    public boolean isRouteIncomplete(long routeId) {
        return this.incompleteRoutesMap.contains(routeId);
    }

    private List<Entity> getIncompleteStops(Relation rel, TransportRoute directRoute) {
        ArrayList<Entity> missingStopsAfterStop = new ArrayList<Entity>();
        boolean missingPrevious = false;
        Entity previousStop = null;
        TreeSet<Long> stopPlatformIds = new TreeSet<Long>();
        for (TransportStop s : directRoute.getForwardStops()) {
            stopPlatformIds.add(s.getId());
        }
        for (Relation.RelationMember rm : rel.getMembers()) {
            boolean validNode;
            boolean bl = validNode = "stop".equals(rm.getRole()) || "platform".equals(rm.getRole());
            if (rm.getEntity() == null && validNode) {
                if (!missingPrevious) {
                    missingStopsAfterStop.add(previousStop);
                }
                missingPrevious = true;
                continue;
            }
            if (!stopPlatformIds.contains(rm.getEntityId().getId())) continue;
            previousStop = rm.getEntity();
            if (!missingPrevious) continue;
            missingStopsAfterStop.add(previousStop);
            missingPrevious = false;
        }
        if (missingPrevious) {
            missingStopsAfterStop.add(null);
        }
        return missingStopsAfterStop;
    }

    private boolean hasRelationIncompleteWays(Relation rel) {
        boolean relationHasIncompleteWays = false;
        block0: for (Relation.RelationMember rm : rel.getMembers()) {
            if (!(rm.getEntity() instanceof Way)) continue;
            Way w = (Way)rm.getEntity();
            if (w.getNodeIds().isEmpty()) {
                relationHasIncompleteWays = true;
                break;
            }
            for (Node n : w.getNodes()) {
                if (n != null) continue;
                relationHasIncompleteWays = true;
                continue block0;
            }
        }
        return relationHasIncompleteWays;
    }

    private TransportSchedule readSchedule(String ref, List<TransportStop> directStops) throws SQLException {
        if (!Algorithms.isEmpty((CharSequence)ref) && this.gtfsConnection != null && directStops.size() > 0) {
            if (this.gtfsSelectRoute == null) {
                this.gtfsSelectRoute = this.gtfsConnection.prepareStatement("SELECT r.route_id, r.route_short_name, r.route_long_name,  t.trip_id, t.shape_id, t.service_id, t.firstStopLat, t.firstStopLon from routes r join  trips t on t.route_id = r.route_id where route_short_name = ? order by r.route_id asc, t.trip_id asc ");
            }
            if (this.gtfsSelectStopTimes == null) {
                this.gtfsSelectStopTimes = this.gtfsConnection.prepareStatement("SELECT arrival_time, departure_time, stop_id, stop_sequence from stop_times where trip_id = ? order by stop_sequence ");
            }
            this.gtfsSelectRoute.setString(1, ref);
            ResultSet rs = this.gtfsSelectRoute.executeQuery();
            String routeId = null;
            String routeShortName = null;
            String routeLongName = null;
            TransportSchedule schedule = new TransportSchedule();
            TIntArrayList timeDeparturesFirst = new TIntArrayList();
            while (rs.next()) {
                String nrouteId = rs.getString(1);
                if (!Algorithms.objectEquals(routeId, (Object)nrouteId)) {
                    routeId = nrouteId;
                    routeShortName = rs.getString(2);
                    routeLongName = rs.getString(3);
                }
                String tripId = rs.getString(4);
                double firstLat = rs.getDouble(7);
                double firstLon = rs.getDouble(8);
                double dist = MapUtils.getDistance((LatLon)directStops.get(0).getLocation(), (double)firstLat, (double)firstLon);
                if (!(dist < 50.0)) continue;
                this.gtfsSelectStopTimes.setString(1, tripId);
                ResultSet nrs = this.gtfsSelectStopTimes.executeQuery();
                TIntArrayList stopIntervals = new TIntArrayList(directStops.size());
                TIntArrayList waitIntervals = new TIntArrayList(directStops.size());
                int ftime = 0;
                int ptime = 0;
                while (nrs.next()) {
                    int arrivalTime = this.parseTime(nrs.getString(1));
                    int depTime = this.parseTime(nrs.getString(2));
                    if (arrivalTime == -1 || depTime == -1) {
                        ++this.gtfsStats.errorsTimeParsing;
                        continue;
                    }
                    if (ftime == 0) {
                        ftime = ptime = depTime;
                    } else {
                        stopIntervals.add(arrivalTime - ptime);
                    }
                    waitIntervals.add(depTime - arrivalTime);
                    ptime = arrivalTime;
                }
                if (waitIntervals.size() != directStops.size()) {
                    ++this.gtfsStats.errorsTripsStopCounts;
                } else {
                    int j;
                    ++this.gtfsStats.successTripsParsing;
                    if (schedule.avgWaitIntervals.isEmpty()) {
                        schedule.avgWaitIntervals.addAll((TIntCollection)waitIntervals);
                    } else {
                        for (j = 0; j < waitIntervals.size(); ++j) {
                            if (Math.abs(schedule.avgWaitIntervals.getQuick(j) - waitIntervals.getQuick(j)) <= 3) continue;
                            ++this.gtfsStats.avgWaitDiff30Sec;
                            break;
                        }
                    }
                    if (schedule.avgStopIntervals.isEmpty()) {
                        schedule.avgStopIntervals.addAll((TIntCollection)stopIntervals);
                    } else {
                        for (j = 0; j < stopIntervals.size(); ++j) {
                            if (Math.abs(schedule.avgStopIntervals.getQuick(j) - stopIntervals.getQuick(j)) <= 3) continue;
                            ++this.gtfsStats.avgStopDiff30Sec;
                            break;
                        }
                    }
                    timeDeparturesFirst.add(ftime);
                }
                nrs.close();
            }
            if (timeDeparturesFirst.size() > 0) {
                timeDeparturesFirst.sort();
                int p = 0;
                for (int i = 0; i < timeDeparturesFirst.size(); ++i) {
                    int x = timeDeparturesFirst.get(i) - p;
                    if (x <= 0) continue;
                    schedule.tripIntervals.add(x);
                    p = timeDeparturesFirst.get(i);
                }
                boolean allZeros = true;
                for (int i = 0; i < schedule.avgWaitIntervals.size(); ++i) {
                    if (schedule.avgWaitIntervals.getQuick(i) == 0) continue;
                    allZeros = false;
                    break;
                }
                if (allZeros) {
                    schedule.avgWaitIntervals.clear();
                }
                return schedule;
            }
        }
        return null;
    }

    private int parseTime(String str) {
        int f1 = str.indexOf(58);
        int f2 = str.indexOf(58, f1 + 1);
        if (f1 != -1 && f2 != -1) {
            try {
                int h = Integer.parseInt(str.substring(0, f1));
                int m = Integer.parseInt(str.substring(f1 + 1, f2));
                int s = Integer.parseInt(str.substring(f2 + 1));
                return h * 60 * 6 + m * 6 + s / 10;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private String reverseName(String ref, String name) {
        int i;
        int startPos = name.indexOf(ref);
        Object fname = "";
        if (startPos != -1) {
            fname = name.substring(0, startPos + ref.length()) + " ";
            name = name.substring(startPos + ref.length()).trim();
        }
        fname = (i = name.indexOf(45)) != -1 ? (String)fname + name.substring(i + 1).trim() + " - " + name.substring(0, i).trim() : (String)fname + name;
        return fname;
    }

    private boolean processTransportRelationV2(Relation rel, TransportRoute route, IndexCreationContext icc) {
        String version = rel.getTag("public_transport:version");
        try {
            if (Algorithms.isEmpty((CharSequence)version) || Integer.parseInt(version) < 2) {
                for (Relation.RelationMember entry : rel.getMembers()) {
                    String role;
                    if (entry.getEntity() instanceof Way || (role = entry.getRole()).isEmpty() || "stop".equals(role) || "platform".equals(role)) continue;
                    this.stopPlatformMatcher.reset(role);
                    if (this.stopPlatformMatcher.matches()) continue;
                    return false;
                }
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        ArrayList<Entity> platformsAndStops = new ArrayList<Entity>();
        ArrayList<Entity> platforms = new ArrayList<Entity>();
        ArrayList<Entity> stops = new ArrayList<Entity>();
        LinkedHashMap<Entity.EntityId, Entity> platformNames = new LinkedHashMap<Entity.EntityId, Entity>();
        for (Relation.RelationMember entry : rel.getMembers()) {
            String role = entry.getRole();
            if (entry.getEntity() == null || entry.getEntity().getLatLon() == null) continue;
            Entity e = entry.getEntity();
            icc.translitJapaneseNames(e);
            icc.translitChineseNames(e);
            if (role.startsWith("platform")) {
                platformsAndStops.add(e);
                platforms.add(e);
                continue;
            }
            if (role.startsWith("stop")) {
                platformsAndStops.add(e);
                stops.add(e);
                continue;
            }
            if (!(e instanceof Way) || "backward".equals(entry.getRole())) continue;
            route.addWay((Way)e);
        }
        this.mergePlatformsStops(platformsAndStops, platforms, stops, platformNames);
        if (platformsAndStops.isEmpty()) {
            return true;
        }
        for (Entity s : platformsAndStops) {
            TransportStop stop = EntityParser.parseTransportStop((Entity)s);
            Relation stopArea = this.stopAreas.get(Entity.EntityId.valueOf((Entity)s));
            Relation genericStopName = null;
            if (stopArea != null && !Algorithms.isEmpty((CharSequence)stopArea.getTag(OSMSettings.OSMTagKey.NAME))) {
                genericStopName = stopArea;
            } else if (platformNames.containsKey(Entity.EntityId.valueOf((Entity)s)) && Algorithms.isEmpty((CharSequence)stop.getName())) {
                genericStopName = (Entity)platformNames.get(Entity.EntityId.valueOf((Entity)s));
            }
            if (genericStopName != null) {
                stop.copyNames(genericStopName.getTag(OSMSettings.OSMTagKey.NAME), genericStopName.getTag(OSMSettings.OSMTagKey.NAME_EN), genericStopName.getNameTags(), true);
            }
            route.getForwardStops().add(stop);
        }
        return true;
    }

    private void mergePlatformsStops(List<Entity> platformsAndStopsToProcess, List<Entity> platforms, List<Entity> stops, Map<Entity.EntityId, Entity> nameReplacement) {
        for (Entity platform : platforms) {
            Entity replaceStop = null;
            LatLon loc = platform.getLatLon();
            if (loc == null) {
                platformsAndStopsToProcess.remove(platform);
                continue;
            }
            double dist = 300.0;
            Relation rr = this.stopAreas.get(Entity.EntityId.valueOf((Entity)platform));
            for (Entity stop : stops) {
                if (stop.getLatLon() == null) continue;
                if (rr != null && this.stopAreas.get(Entity.EntityId.valueOf((Entity)stop)) == rr) {
                    replaceStop = stop;
                }
                if (!(MapUtils.getDistance((LatLon)stop.getLatLon(), (LatLon)loc) < dist)) continue;
                replaceStop = stop;
                dist = MapUtils.getDistance((LatLon)stop.getLatLon(), (LatLon)loc);
            }
            if (replaceStop == null) continue;
            platformsAndStopsToProcess.remove(platform);
            if (Algorithms.isEmpty((CharSequence)platform.getTag(OSMSettings.OSMTagKey.NAME))) continue;
            nameReplacement.put(Entity.EntityId.valueOf(replaceStop), platform);
        }
    }

    private boolean processTransportRelationV1(Relation rel, TransportRoute directRoute, TransportRoute backwardRoute) {
        final LinkedHashMap<TransportStop, Integer> forwardStops = new LinkedHashMap<TransportStop, Integer>();
        final LinkedHashMap<TransportStop, Integer> backwardStops = new LinkedHashMap<TransportStop, Integer>();
        int currentStop = 0;
        int forwardStop = 0;
        int backwardStop = 0;
        for (Relation.RelationMember e : rel.getMembers()) {
            int dir;
            if (e.getRole().contains("stop") || e.getRole().contains("platform")) {
                if (!(e.getEntity() instanceof Node)) continue;
                TransportStop stop = EntityParser.parseTransportStop((Entity)e.getEntity());
                Relation stopArea = this.stopAreas.get(Entity.EntityId.valueOf((Entity)e.getEntity()));
                if (stopArea != null) {
                    stop.copyNames(stopArea.getTag(OSMSettings.OSMTagKey.NAME), stopArea.getTag(OSMSettings.OSMTagKey.NAME_EN), stopArea.getNameTags(), true);
                }
                boolean forward = e.getRole().contains("forward");
                boolean backward = e.getRole().contains("backward");
                ++currentStop;
                if (forward || !backward) {
                    ++forwardStop;
                }
                if (backward) {
                    ++backwardStop;
                }
                boolean common = !forward && !backward;
                int index = -1;
                int accum = 1;
                for (int i = e.getRole().length() - 1; i >= 0 && Character.isDigit(e.getRole().charAt(i)); --i) {
                    if (index < 0) {
                        index = 0;
                    }
                    index = accum * Character.getNumericValue(e.getRole().charAt(i)) + index;
                    accum *= 10;
                }
                if (index < 0) {
                    int n = forward ? forwardStop : (index = backward ? backwardStop : currentStop);
                }
                if (forward || common) {
                    forwardStops.put(stop, index);
                    directRoute.getForwardStops().add(stop);
                }
                if (!backward && !common) continue;
                if (common) {
                    backwardStops.put(stop, -index);
                } else {
                    backwardStops.put(stop, index);
                }
                backwardRoute.getForwardStops().add(stop);
                continue;
            }
            if (!(e.getEntity() instanceof Way)) continue;
            int n = e.getRole().equals("backward") ? -1 : (dir = e.getRole().equals("forward") ? 1 : 0);
            if (dir >= 0) {
                directRoute.addWay((Way)e.getEntity());
            }
            if (dir > 0) continue;
            backwardRoute.addWay((Way)e.getEntity());
        }
        if (forwardStops.isEmpty() && backwardStops.isEmpty()) {
            return false;
        }
        Collections.sort(directRoute.getForwardStops(), new Comparator<TransportStop>(){

            @Override
            public int compare(TransportStop o1, TransportStop o2) {
                return (Integer)forwardStops.get(o1) - (Integer)forwardStops.get(o2);
            }
        });
        for (TransportStop s : new ArrayList(backwardStops.keySet())) {
            if ((Integer)backwardStops.get(s) >= 0) continue;
            backwardStops.put(s, backwardStops.size() + (Integer)backwardStops.get(s) - 1);
        }
        Collections.sort(backwardRoute.getForwardStops(), new Comparator<TransportStop>(){

            @Override
            public int compare(TransportStop o1, TransportStop o2) {
                return (Integer)backwardStops.get(o1) - (Integer)backwardStops.get(o2);
            }
        });
        return true;
    }

    static {
        acceptedRoutes.add("bus");
        acceptedRoutes.add("trolleybus");
        acceptedRoutes.add("share_taxi");
        acceptedRoutes.add("funicular");
        acceptedRoutes.add("subway");
        acceptedRoutes.add("light_rail");
        acceptedRoutes.add("monorail");
        acceptedRoutes.add("train");
        acceptedRoutes.add("tram");
        acceptedRoutes.add("ferry");
    }

    private static class GtfsInfoStats {
        public int avgWaitDiff30Sec;
        public int avgStopDiff30Sec;
        int errorsTimeParsing = 0;
        int successTripsParsing = 0;
        int errorsTripsStopCounts = 0;

        private GtfsInfoStats() {
        }

        public String toString() {
            return "GtfsInfoStats [avgWaitDiff30Sec=" + this.avgWaitDiff30Sec + ", avgStopDiff30Sec=" + this.avgStopDiff30Sec + ", errorsTimeParsing=" + this.errorsTimeParsing + ", successTripsParsing=" + this.successTripsParsing + ", errorsTripsStopCounts=" + this.errorsTripsStopCounts + "]";
        }
    }
}

