/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.trie;

import com.atilika.kuromoji.trie.PatriciaTrie;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class PatriciaTrieFormatter<V> {
    private static final String FONT_NAME = "Helvetica";

    public String format(PatriciaTrie<V> trie) {
        return this.format(trie, true);
    }

    public String format(PatriciaTrie<V> trie, boolean formatBitString) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatHeader());
        builder.append(this.formatNode(trie.getRoot().getLeft(), -1, trie.getKeyMapper(), formatBitString));
        builder.append(this.formatTrailer());
        return builder.toString();
    }

    public void format(PatriciaTrie<V> trie, File file) throws FileNotFoundException {
        this.format(trie, file, false);
    }

    public void format(PatriciaTrie<V> trie, File file, boolean formatBitString) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(file));
        writer.println(this.format(trie, formatBitString));
        writer.close();
    }

    private String formatHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph patricia {\n");
        builder.append("nodesep=1.5;");
        builder.append("node [ style=\"filled\" fillcolor=\"#e8e8f0\" shape=\"Mrecord\" fontname=\"Helvetica\" ]\n");
        return builder.toString();
    }

    private String formatTrailer() {
        return "}";
    }

    private String formatNode(PatriciaTrie.PatriciaNode<V> node, int bit, PatriciaTrie.KeyMapper<String> keyMapper, boolean formatBitString) {
        if (node.getBit() <= bit) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\"");
        buffer.append(this.getNodeId(node));
        buffer.append("\"");
        buffer.append(" [ ");
        buffer.append("label=");
        buffer.append(this.formatNodeLabel(node, keyMapper, formatBitString));
        buffer.append(" ]");
        buffer.append("\n");
        buffer.append(this.formatPointer(node, node.getLeft(), "l", "sw"));
        buffer.append(this.formatPointer(node, node.getRight(), "r", "se"));
        buffer.append(this.formatNode(node.getLeft(), node.getBit(), keyMapper, formatBitString));
        buffer.append(this.formatNode(node.getRight(), node.getBit(), keyMapper, formatBitString));
        return buffer.toString();
    }

    private String formatPointer(PatriciaTrie.PatriciaNode<V> from, PatriciaTrie.PatriciaNode<V> to, String label, String tailport) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNodeId(from));
        builder.append(" -> ");
        builder.append(this.getNodeId(to));
        builder.append(" [ ");
        builder.append("label=\"");
        builder.append(label);
        builder.append(" \"");
        builder.append("tailport=\"");
        builder.append(tailport);
        builder.append(" \"");
        builder.append("fontcolor=\"#666666\" ");
        builder.append(" ]");
        builder.append("\n");
        return builder.toString();
    }

    private String formatNodeLabel(PatriciaTrie.PatriciaNode<V> node, PatriciaTrie.KeyMapper<String> keyMapper, boolean formatBitString) {
        StringBuilder builder = new StringBuilder();
        builder.append("<<table border=\"0\" cellborder=\"0\">");
        builder.append("<tr><td>");
        builder.append("key: <font color=\"#00a000\">");
        builder.append(this.getNodeLabel(node));
        builder.append("</font> </td></tr>");
        builder.append("<tr><td>");
        builder.append("bit: <font color=\"blue\">");
        builder.append(node.getBit());
        builder.append("</font> </td></tr>");
        if (formatBitString) {
            builder.append("<tr><td>");
            builder.append("bitString: <font color=\"blue\">");
            String bitString = keyMapper.toBitString(node.getKey());
            int c = node.getBit() + node.getBit() / 4;
            builder.append(bitString.substring(0, c));
            builder.append("<font color=\"red\">");
            builder.append(bitString.charAt(c));
            builder.append("</font>");
            builder.append(bitString.substring(c + 1));
            builder.append("</font> </td></tr>");
        }
        builder.append("<tr><td>");
        builder.append("value: <font color=\"#00a0a0\">");
        builder.append(node.getValue());
        builder.append("</font> </td></tr>");
        builder.append("</table>>");
        return builder.toString();
    }

    private String getNodeLabel(PatriciaTrie.PatriciaNode<V> node) {
        return node.getKey();
    }

    private String getNodeId(PatriciaTrie.PatriciaNode<V> node) {
        if (node == null) {
            return "null";
        }
        return node.getKey();
    }
}

