/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;
import net.osmand.util.Algorithms;

public class TopTagValuesAnalyzer {
    private static final String PLANET_NAME = "planet";
    private static final int MIN_OCCURENCIES_PRINT = 10;
    private static final int MIN_OCCURENCIES = 5;
    private static final int TOP_PER_MAP = 100;
    private static final int WORLD_TOP = 1000;
    public static double BRAND_OWNERSHIP = 0.7;
    private static int VERBOSE = 1;
    private static char KEY_SEP = (char)47;
    private static int BRAND_ID;

    public static void main(String[] args) throws IOException {
        File fl;
        boolean consolidate = false;
        if (args.length == 0) {
            fl = new File("../../../all_brands.csv");
            consolidate = true;
        } else {
            fl = new File(args[0]);
        }
        for (String ar : args) {
            if (!"--consolidate".equals(ar)) continue;
            consolidate = true;
        }
        System.out.printf("Run (%s) %s consolidate=%s", Arrays.toString(args), fl.getName(), consolidate);
        new TopTagValuesAnalyzer().analyzeTopTagValues(fl, consolidate);
    }

    private void analyzeTopTagValues(File fl, boolean consolidate) throws IOException {
        String outFile = "brands";
        Map<String, TagValueRegion> regions = this.parseTagValueFile(fl);
        Map<String, TagValueInfo> tagValues = this.calculateOwnership(regions);
        boolean worldBrandsOnlyOwned = false;
        this.enableTagValuePerRegion(tagValues, regions, worldBrandsOnlyOwned, 5, 1000, true, PLANET_NAME);
        boolean onlyOwned = true;
        this.enableTagValuePerRegion(tagValues, regions, onlyOwned, 5, 100, false, PLANET_NAME);
        if (!onlyOwned && consolidate) {
            this.consolidateEnabledTagValues(tagValues, regions, 1);
        }
        this.printRegionsSorted(regions, tagValues, null, 400, 0);
        this.generateHtmlPage(regions, tagValues, outFile + ".html", 0);
        StringBuilder tagValuesStr = new StringBuilder();
        for (TagValueInfo tagValue : tagValues.values()) {
            if (!tagValue.include) continue;
            tagValuesStr.append(tagValue.tag).append(',').append(tagValue.value).append('\n');
        }
        FileOutputStream fous = new FileOutputStream(outFile + ".lst");
        fous.write(tagValuesStr.toString().getBytes());
        fous.close();
    }

    protected void consolidateEnabledTagValues(Map<String, TagValueInfo> tagValues, Map<String, TagValueRegion> regions, int mindepth) {
        boolean changed = true;
        int iteration = 1;
        while (changed) {
            changed = false;
            for (TagValueInfo b : tagValues.values()) {
                if (!b.include) continue;
                String keyName = b.key;
                while (b != null) {
                    TagValueRegion ownerRegion = b.ownerRegion;
                    for (String topRegionTagValue : ownerRegion.tagValuesSorted.keySet()) {
                        TagValueInfo topBrandToBeEnabled = tagValues.get(topRegionTagValue);
                        if (!topBrandToBeEnabled.include && ownerRegion.depth >= mindepth && topBrandToBeEnabled.regionOwnsThisKey(ownerRegion, false)) {
                            if (VERBOSE >= 3) {
                                System.out.println("Enable " + topRegionTagValue + " for " + ownerRegion.name + " because of " + keyName);
                            }
                            topBrandToBeEnabled.include = true;
                            topBrandToBeEnabled.reasonInclude = String.format("Higher than %s in %s", keyName.substring(0, Math.min(keyName.length(), 7)), ownerRegion.name);
                            changed = true;
                        }
                        if (!topRegionTagValue.equals(keyName)) continue;
                        break;
                    }
                    b = b.anotherOwnRegion;
                }
            }
            System.out.printf("Consolidation # %d - enabled %d brands \n", iteration, this.countAllIncluded(tagValues));
            ++iteration;
        }
    }

    private void enableTagValuePerRegion(Map<String, TagValueInfo> tagValue, Map<String, TagValueRegion> regions, boolean onlyOwned, int minOccurencies, int topPerMap, boolean include, String filter) {
        block0: for (TagValueRegion r : regions.values()) {
            if (include && !r.name.contains(filter) || !include && r.name.contains(filter)) continue;
            Iterator<Map.Entry<String, Integer>> it = r.tagValuesSorted.entrySet().iterator();
            int cnt = 0;
            while (it.hasNext()) {
                Map.Entry<String, Integer> e = it.next();
                String keyName = e.getKey();
                TagValueInfo tagValueInfo = tagValue.get(keyName);
                if (onlyOwned && !tagValueInfo.regionOwnsThisKey(r, false)) continue;
                if (cnt++ >= topPerMap || e.getValue() < minOccurencies) continue block0;
                tagValueInfo.include = true;
                tagValueInfo.reasonInclude = String.format("Top %d (>%d) for %s", topPerMap, minOccurencies, r.name);
                if (VERBOSE < 2) continue;
                System.out.println("Enable " + e.getKey() + " " + r.name + " " + String.valueOf(e.getValue()));
            }
        }
        System.out.printf("For %d min occurencies and top %d per map - enabled %d brands \n", minOccurencies, topPerMap, this.countAllIncluded(tagValue));
    }

    private int countAllIncluded(Map<String, TagValueInfo> brands) {
        int enabled = 0;
        for (TagValueInfo i : brands.values()) {
            if (!i.include) continue;
            ++enabled;
        }
        return enabled;
    }

    private void countIncluded(Map<String, TagValueRegion> regions, Map<String, TagValueInfo> brands) {
        for (TagValueRegion r : regions.values()) {
            int count = 0;
            for (String brandName : r.tagValuesSorted.keySet()) {
                TagValueInfo brand = brands.get(brandName);
                if (!brand.include) continue;
                ++count;
            }
            r.countIncluded = count;
        }
    }

    private void printRegionsSorted(final Map<String, TagValueRegion> regions, Map<String, TagValueInfo> brands, String filter, int limit, int topBrands) {
        this.countIncluded(regions, brands);
        TreeMap<String, TagValueRegion> regSorted = new TreeMap<String, TagValueRegion>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = ((TagValueRegion)regions.get((Object)o1)).countIncluded;
                Integer i2 = ((TagValueRegion)regions.get((Object)o2)).countIncluded;
                if (Integer.compare(i1, i2) != 0) {
                    return -Integer.compare(i1, i2);
                }
                return o1.compareTo(o2);
            }
        });
        regSorted.putAll(regions);
        int i = 0;
        for (TagValueRegion r : regSorted.values()) {
            if (filter != null && !r.name.contains(filter)) continue;
            if (i++ > limit) break;
            int cntFilter = 0;
            int owned = 0;
            int sub_owns = 0;
            for (Map.Entry<String, Integer> brand : r.tagValues.entrySet()) {
                if (brand.getValue() <= 10) continue;
                ++cntFilter;
                TagValueInfo bi = brands.get(brand.getKey());
                if (bi.regionOwnsThisKey(r, false)) {
                    ++owned;
                    continue;
                }
                if (!bi.regionOwnsThisKey(r, true)) continue;
                ++sub_owns;
            }
            System.out.printf("+%d %s --- %d all --- >%d: %d, own %d + subown %d\n", r.countIncluded, r.name, r.tagValues.size(), 10, cntFilter, owned, sub_owns);
            int l = topBrands;
            Iterator<Map.Entry<String, Integer>> it = r.tagValuesSorted.entrySet().iterator();
            while (it.hasNext() && l-- > 0) {
                Map.Entry<String, Integer> n = it.next();
                TagValueInfo brandInfo = brands.get(n.getKey());
                Object owners = brandInfo.ownerRegion.name;
                TagValueInfo next = brandInfo.anotherOwnRegion;
                while (next != null) {
                    owners = (String)owners + ", " + next.ownerRegion.name;
                    next = next.anotherOwnRegion;
                }
                System.out.printf("    %s - %d: owner %s %d/%d %d%%\n", (brandInfo.include ? "+" : "-") + n.getKey(), n.getValue(), owners, brandInfo.ownerCount, brandInfo.globalCount, (int)(brandInfo.ownerPercent * 100.0f));
            }
        }
    }

    private Map<String, TagValueInfo> calculateOwnership(Map<String, TagValueRegion> regions) {
        int maxDepth = 0;
        for (TagValueRegion b : regions.values()) {
            maxDepth = Math.max(maxDepth, b.depth);
        }
        TreeMap<String, TagValueInfo> brandOnwership = new TreeMap<String, TagValueInfo>();
        TagValueRegion planet = regions.get(PLANET_NAME);
        for (int depth = maxDepth; depth >= 0; --depth) {
            for (TagValueRegion reg : regions.values()) {
                if (reg.depth != depth) continue;
                if (VERBOSE >= 2) {
                    System.out.println("---- " + reg.name);
                }
                this.countTagValueOnwershipPerRegion(brandOnwership, planet, reg);
            }
        }
        return brandOnwership;
    }

    private void countTagValueOnwershipPerRegion(Map<String, TagValueInfo> onwershipInfo, TagValueRegion planet, TagValueRegion reg) {
        for (Map.Entry<String, Integer> e : reg.tagValuesSorted.entrySet()) {
            TagValueInfo existing;
            Integer globalCount = planet.tagValuesSorted.get(e.getKey());
            float percent = (float)e.getValue().intValue() / (float)globalCount.intValue();
            if (!((double)percent > BRAND_OWNERSHIP)) continue;
            TagValueInfo info = new TagValueInfo();
            info.key = e.getKey();
            int ind = info.key.indexOf(KEY_SEP);
            info.tag = info.key.substring(0, ind);
            info.value = info.key.substring(ind + 1);
            info.ownerPercent = percent;
            info.globalCount = globalCount;
            info.ownerCount = e.getValue();
            info.ownerRegion = reg;
            TagValueInfo childPossible = existing = onwershipInfo.get(info.key);
            boolean checkIfIncludedInChild = false;
            while (childPossible != null) {
                if (reg.checkIfThisIsParent(childPossible.ownerRegion)) {
                    checkIfIncludedInChild = true;
                    break;
                }
                childPossible = childPossible.anotherOwnRegion;
            }
            if (checkIfIncludedInChild) continue;
            if (VERBOSE >= 2 && info.ownerCount > 5) {
                System.out.printf("%s --- %d/%d (%.2f)\n", info.key, info.ownerCount, info.globalCount, Float.valueOf(percent));
            }
            if (existing != null && existing.ownerRegion.depth > info.ownerRegion.depth) continue;
            if (existing == null || existing.ownerRegion.depth == info.ownerRegion.depth) {
                info.anotherOwnRegion = existing;
            }
            onwershipInfo.put(info.key, info);
        }
    }

    private Map<String, TagValueRegion> parseTagValueFile(File fl) throws FileNotFoundException, IOException {
        BufferedReader r = new BufferedReader(new FileReader(fl));
        TreeMap<String, TagValueRegion> regions = new TreeMap<String, TagValueRegion>();
        String line = r.readLine();
        while ((line = r.readLine()) != null) {
            String[] splitValues;
            int ind = line.indexOf(44);
            String regName = line.substring(0, ind);
            line = line.substring(ind + 1);
            if (!regions.containsKey(regName)) {
                regions.put(regName, new TagValueRegion(regName));
            }
            TagValueRegion region = (TagValueRegion)regions.get(regName);
            ind = line.indexOf(44);
            int count = Algorithms.parseIntSilently((String)line.substring(0, ind), (int)0);
            line = line.substring(ind + 1);
            ind = line.indexOf(44);
            region.parent = line.substring(0, ind);
            line = line.substring(ind + 1);
            ind = line.indexOf(44);
            region.depth = Algorithms.parseIntSilently((String)line.substring(0, ind), (int)0);
            line = line.substring(ind + 1);
            ind = line.indexOf(44);
            region.map = "true".equalsIgnoreCase(line.substring(0, ind));
            line = line.substring(ind + 1);
            ind = line.indexOf(44);
            String tag = line.substring(0, ind).toLowerCase();
            String allValues = line = line.substring(ind + 1);
            if (count <= 0) continue;
            for (String tagValueKey : splitValues = allValues.split(";")) {
                tagValueKey = TopTagValuesAnalyzer.normalizeTagValue(tagValueKey);
                int existing = region.tagValues.getOrDefault(tag + KEY_SEP + tagValueKey, 0);
                region.tagValues.put(tag + KEY_SEP + tagValueKey, count + existing);
            }
        }
        r.close();
        this.finishReading(regions);
        return regions;
    }

    public static String normalizeTagValue(String tagValueKey) {
        return tagValueKey.toLowerCase().trim().replaceAll("[`\u2019\u2018\u02bc]", "'");
    }

    private void finishReading(Map<String, TagValueRegion> regions) {
        TagValueRegion planet = regions.get(PLANET_NAME);
        planet.map = true;
        for (TagValueRegion b : regions.values()) {
            b.tagValuesSorted.putAll(b.tagValues);
            if (b == planet) continue;
            b.parentRegion = regions.get(b.parent);
            if (b.parentRegion == null) {
                throw new NullPointerException(b.name + " missing parent");
            }
            b.parentRegion.leaf = false;
        }
        for (TagValueRegion b : regions.values()) {
            if (b == planet) continue;
            while (!b.parentRegion.map) {
                b.parentRegion = b.parentRegion.parentRegion;
                b.parent = b.parentRegion.name;
            }
        }
        for (TagValueRegion b : new ArrayList<TagValueRegion>(regions.values())) {
            if (!b.map) {
                regions.remove(b.name);
                continue;
            }
            int calcdepth = 0;
            TagValueRegion p = b.parentRegion;
            while (p != null) {
                ++calcdepth;
                p = p.parentRegion;
            }
            if (calcdepth == b.depth) continue;
            b.depth = calcdepth;
        }
    }

    public void generateHtmlPage(Map<String, TagValueRegion> regions, Map<String, TagValueInfo> brands, String outputFile, int excludeGlobal) throws IOException {
        FileOutputStream out = new FileOutputStream(outputFile);
        InputStream in = TopTagValuesAnalyzer.class.getResourceAsStream("/brands.html");
        Algorithms.streamCopy((InputStream)in, (OutputStream)out);
        out.close();
        in.close();
        System.out.println("Generated HTML page: " + outputFile);
        StringBuilder brandData = new StringBuilder();
        brandData.append("const brandsData = {\n");
        for (TagValueInfo tagValueInfo : brands.values()) {
            Object shortKeyName = tagValueInfo.value;
            if (tagValueInfo.tag.startsWith("brand:")) {
                shortKeyName = tagValueInfo.tag.substring("brand:".length()) + ":" + (String)shortKeyName;
            } else if (!tagValueInfo.tag.equals("brand")) {
                shortKeyName = tagValueInfo.tag + ":" + (String)shortKeyName;
            }
            brandData.append(String.format("\t\t\t\t'%s': { name: '%s', owner: '%s', ownerCount: %d, globalCount: %d, ownerPercent: %d, includeReason: '%s', include: %s },\n", tagValueInfo.id, this.formatString((String)shortKeyName), this.formatString(tagValueInfo.ownerRegion.name), tagValueInfo.ownerCount, tagValueInfo.globalCount, (int)(tagValueInfo.ownerPercent * 100.0f), this.formatString(tagValueInfo.reasonInclude), tagValueInfo.include));
        }
        brandData.append("};\n");
        brandData.append("\n");
        brandData.append("const brandsRegionData = {\n");
        TreeMap<String, TagValueRegion> sortedRegions = new TreeMap<String, TagValueRegion>(regions);
        for (TagValueRegion region : sortedRegions.values()) {
            brandData.append(String.format("\t'%s': {\n", region.name));
            brandData.append(String.format("\t\t'parent': '%s',", region.parent));
            brandData.append(String.format("\t\t'included': '%s',", region.countIncluded));
            brandData.append(String.format("\t\t'depth': %s,", region.depth));
            brandData.append(String.format("\t\t'leaf': %s,", region.leaf));
            brandData.append(String.format("\t\t'brands': [\n", new Object[0]));
            for (Map.Entry<String, Integer> entry : region.tagValuesSorted.entrySet()) {
                TagValueInfo brandInfo = brands.get(entry.getKey());
                if (brandInfo == null || !brandInfo.include && brandInfo.globalCount <= excludeGlobal) continue;
                brandData.append(String.format("\t\t\t{ id: %d, count: %d },\n", brandInfo.id, entry.getValue()));
            }
            brandData.append("\t\t] },\n");
        }
        brandData.append("};\n");
        File file = new File(outputFile);
        String jsFileName = "brands-data.js";
        File jsFile = new File(file.getParentFile(), jsFileName);
        File gzippedJsFile = new File(file.getParentFile(), jsFileName + ".gz");
        try (PrintWriter writer = new PrintWriter(jsFile, "UTF-8");){
            writer.print(brandData.toString());
        }
        System.out.println("Generated JS data file: " + jsFile.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(gzippedJsFile);
        GZIPOutputStream gzipos = new GZIPOutputStream(fos);
        gzipos.write(brandData.toString().getBytes("UTF-8"));
        gzipos.close();
        System.out.println("Generated gzipped JS data file: " + gzippedJsFile.getAbsolutePath());
    }

    private String formatString(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("'", "\\'");
    }

    public static class TagValueInfo {
        String tag;
        String value;
        String key;
        TagValueRegion ownerRegion;
        float ownerPercent;
        Integer ownerCount;
        Integer globalCount;
        boolean include;
        String reasonInclude;
        int id = BRAND_ID++;
        TagValueInfo anotherOwnRegion = null;

        public boolean regionOwnsThisKey(TagValueRegion r, boolean includeChildren) {
            if (this.ownerRegion == r) {
                return true;
            }
            if (includeChildren && r.checkIfThisIsParent(this.ownerRegion)) {
                return true;
            }
            if (this.anotherOwnRegion == null) {
                return false;
            }
            return this.anotherOwnRegion.regionOwnsThisKey(r, includeChildren);
        }
    }

    public static class TagValueRegion {
        final String name;
        final Map<String, Integer> tagValues = new TreeMap<String, Integer>();
        Map<String, Integer> tagValuesSorted = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = tagValues.get(o1);
                Integer i2 = tagValues.get(o2);
                if (Integer.compare(i1, i2) != 0) {
                    return -Integer.compare(i1, i2);
                }
                return o1.compareTo(o2);
            }
        });
        int depth;
        boolean leaf = true;
        String parent;
        boolean map;
        TagValueRegion parentRegion;
        int countIncluded;

        public TagValueRegion(String regName) {
            this.name = regName;
        }

        public boolean checkIfThisIsParent(TagValueRegion child) {
            if (child == this) {
                return true;
            }
            TagValueRegion p = child.parentRegion;
            while (p != null) {
                if (p == this) {
                    return true;
                }
                p = p.parentRegion;
            }
            return false;
        }
    }
}

