/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import com.google.gson.Gson;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.data.LatLon;
import net.osmand.obf.ToolsOsmAndContextImpl;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.obf.preparation.IndexRouteRelationCreator;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.OsmRouteType;
import net.osmand.osm.PoiType;
import net.osmand.shared.api.OsmAndContext;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.primitives.Metadata;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import rtree.RTree;

public class OsmGpxWriteContext {
    private static final NumberFormat oneTenthFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    private static final NumberFormat latLonFormat = new DecimalFormat("0.00#####", new DecimalFormatSymbols(Locale.US));
    public final QueryParams qp;
    public int tracks = 0;
    public int segments = 0;
    private long baseOsmId = -10L;
    XmlSerializer serializer = null;
    OutputStream outputStream = null;
    private final Gson gson = new Gson();
    final Set<String> alwaysExtraTags = Set.of("route", "note", "fixme");

    public OsmGpxWriteContext(QueryParams qp) {
        net.osmand.shared.util.PlatformUtil.INSTANCE.initialize((OsmAndContext)new ToolsOsmAndContextImpl());
        this.qp = qp;
    }

    private boolean validatedTrackSegment(TrkSegment t) {
        boolean isOnePointIn = false;
        boolean testPoints = this.qp.minlat != -1000.0 || this.qp.minlon != -1000.0 || this.qp.maxlat != -1000.0 || this.qp.maxlon != -1000.0;
        for (WptPt p : t.getPoints()) {
            if (p.getLat() >= 90.0 || p.getLat() <= -90.0 || p.getLon() >= 180.0 || p.getLon() <= -180.0) {
                return false;
            }
            if (!testPoints || !(p.getLat() >= this.qp.minlat) || !(p.getLat() <= this.qp.maxlat) || !(p.getLon() >= this.qp.minlon) || !(p.getLon() <= this.qp.maxlon)) continue;
            isOnePointIn = true;
        }
        return !testPoints || isOnePointIn;
    }

    public void startDocument() throws IllegalArgumentException, IllegalStateException, IOException {
        if (this.qp.osmFile != null) {
            this.outputStream = new FileOutputStream(this.qp.osmFile);
            if (this.qp.osmFile.getName().endsWith(".gz")) {
                this.outputStream = new GZIPOutputStream(this.outputStream);
            }
            this.serializer = PlatformUtil.newSerializer();
            this.serializer.setOutput((Writer)new BufferedWriter(new OutputStreamWriter(this.outputStream)));
            this.serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.serializer.startDocument("UTF-8", Boolean.valueOf(true));
            this.serializer.startTag(null, "osm");
            this.serializer.attribute(null, "version", "0.6");
        }
    }

    private void updateGpxInfoByGpxExtensions(OsmGpxFile gpxInfo, GpxFile gpxFile) {
        LinkedHashMap extensions = new LinkedHashMap();
        extensions.putAll(gpxFile.getMetadata().getExtensionsToRead());
        extensions.putAll(gpxFile.getExtensionsToRead());
        gpxInfo.updateRouteId((String)extensions.get("route_id"));
        if ("O".equals(gpxInfo.routeIdPrefix)) {
            gpxInfo.name = null;
        }
        gpxInfo.updateName(gpxFile.getMetadata().getName());
        gpxInfo.updateDescription(gpxFile.getMetadata().getDescription());
        gpxInfo.updateRef((String)extensions.get("ref"));
        gpxInfo.updateName((String)extensions.get("name"));
        gpxInfo.updateDescription((String)extensions.get("description"));
    }

    private void flushXmlTag(String xmlTag, Map<String, String> osmTags, LatLon ll, long idStart, long idEnd) throws IOException {
        this.serializer.startTag(null, xmlTag);
        this.serializer.attribute(null, "id", "" + this.baseOsmId--);
        this.serializer.attribute(null, "action", "modify");
        this.serializer.attribute(null, "version", "1");
        if (ll != null) {
            this.serializer.attribute(null, "lat", latLonFormat.format(ll.getLatitude()));
            this.serializer.attribute(null, "lon", latLonFormat.format(ll.getLongitude()));
        }
        if (idStart != 0L && idEnd != 0L) {
            for (long nid = idStart; nid > idEnd; --nid) {
                this.serializer.startTag(null, "nd");
                this.serializer.attribute(null, "ref", "" + nid);
                this.serializer.endTag(null, "nd");
            }
        }
        this.serializeTags(osmTags);
        this.serializer.endTag(null, xmlTag);
    }

    private void writeTrackWithoutDetails(OsmGpxFile gpxInfo, GpxFile gpxFile, GpxTrackAnalysis analysis) throws IOException {
        boolean validTrack = false;
        for (Track t : gpxFile.getTracks()) {
            for (TrkSegment s : t.getSegments()) {
                if (s.getPoints().isEmpty() || !this.validatedTrackSegment(s)) continue;
                validTrack = true;
            }
        }
        if (validTrack) {
            WptPt pointToShow = gpxFile.findPointToShow();
            LatLon ll = new LatLon(pointToShow.getLat(), pointToShow.getLon());
            LinkedHashMap<String, String> poiSectionTags = new LinkedHashMap<String, String>();
            this.collectGpxTrackTags(gpxInfo, gpxFile, analysis, poiSectionTags, null, null, null);
            this.flushXmlTag("node", poiSectionTags, ll, 0L, 0L);
        }
    }

    private void writeWaysAndPoints(OsmGpxFile gpxInfo, GpxFile gpxFile, GpxTrackAnalysis analysis) throws IOException {
        boolean hasSegments = false;
        boolean hasPoints = false;
        for (Track t : gpxFile.getTracks()) {
            for (TrkSegment s : t.getSegments()) {
                if (s.getPoints().isEmpty() || !this.validatedTrackSegment(s)) continue;
                hasSegments = true;
                ++this.segments;
                ArrayList<LatLon> pointsForPoiSearch = new ArrayList<LatLon>();
                long idStart = this.baseOsmId;
                List points = s.getPoints();
                if (points.size() >= 2) {
                    WptPt middle = (WptPt)points.get(points.size() / 2);
                    pointsForPoiSearch.add(new LatLon(middle.getLatitude(), middle.getLongitude()));
                    for (int i = 0; i < points.size(); ++i) {
                        this.writePoint(this.baseOsmId--, (WptPt)points.get(i), null, null, null);
                        int alternateIndex = i % 2 == 0 ? i : points.size() - i - 1;
                        WptPt candidate = (WptPt)points.get(alternateIndex);
                        WptPt firstPoint = (WptPt)points.get(0);
                        WptPt lastPoint = (WptPt)points.get(points.size() - 1);
                        double distStart = MapUtils.getDistance((double)candidate.getLatitude(), (double)candidate.getLongitude(), (double)firstPoint.getLatitude(), (double)firstPoint.getLongitude());
                        double distEnd = MapUtils.getDistance((double)candidate.getLatitude(), (double)candidate.getLongitude(), (double)lastPoint.getLatitude(), (double)lastPoint.getLongitude());
                        if (!(distStart > 100.0) || !(distEnd > 100.0) || !pointsForPoiSearch.stream().noneMatch(wpt -> MapUtils.getDistance((double)candidate.getLatitude(), (double)candidate.getLongitude(), (double)wpt.getLatitude(), (double)wpt.getLongitude()) < 5000.0)) continue;
                        pointsForPoiSearch.add(new LatLon(candidate.getLatitude(), candidate.getLongitude()));
                    }
                }
                long idEnd = this.baseOsmId;
                LinkedHashMap<String, String> poiSectionTags = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> mapSectionTags = new LinkedHashMap<String, String>();
                this.collectGpxTrackTags(gpxInfo, gpxFile, analysis, poiSectionTags, mapSectionTags, t, s);
                this.flushXmlTag("way", mapSectionTags, null, idStart, idEnd);
                for (LatLon ll : pointsForPoiSearch) {
                    this.flushXmlTag("node", poiSectionTags, ll, 0L, 0L);
                }
            }
        }
        for (WptPt p : gpxFile.getPointsList()) {
            if (gpxInfo == null) continue;
            this.writePoint(this.baseOsmId--, p, "point", gpxInfo.getRouteId(), gpxInfo.name);
            hasPoints = true;
        }
        if (!hasSegments && hasPoints) {
            KQuadRect bbox = gpxFile.getRect();
            LatLon center = new LatLon(bbox.centerY(), bbox.centerX());
            LinkedHashMap<String, String> poiSectionTags = new LinkedHashMap<String, String>();
            this.collectGpxTrackTags(gpxInfo, gpxFile, analysis, poiSectionTags, null, null, null);
            this.flushXmlTag("node", poiSectionTags, center, 0L, 0L);
        }
    }

    public void writeTrack(OsmGpxFile gpxInfo, GpxFile gpxFile, GpxTrackAnalysis analysis) throws IOException {
        this.updateGpxInfoByGpxExtensions(gpxInfo, gpxFile);
        if (this.qp.details < 1) {
            this.writeTrackWithoutDetails(gpxInfo, gpxFile, analysis);
        } else {
            this.writeWaysAndPoints(gpxInfo, gpxFile, analysis);
        }
        ++this.tracks;
    }

    private Map<String, String> collectGpxTrackTags(OsmGpxFile gpxInfo, GpxFile gpxFile, GpxTrackAnalysis analysis, @Nullable Map<String, String> poiSectionTags, @Nullable Map<String, String> mapSectionTags, @Nullable Track track, @Nullable TrkSegment segment) {
        LinkedHashMap<String, String> allTags = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> metadataExtraTags = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> extensionsExtraTags = new LinkedHashMap<String, String>();
        try {
            this.addGpxInfoTags(allTags, gpxInfo);
            this.addAnalysisTags(allTags, analysis);
            this.addElevationGraphTags(allTags, segment);
            this.addMetadataTags(allTags, gpxFile.getMetadata());
            this.addPointGroupsTags(allTags, gpxFile.getPointsGroups());
            this.addNameDescDisplaycolor(allTags, extensionsExtraTags, track);
            this.addExtensionsTags(allTags, extensionsExtraTags, gpxFile.getExtensionsToRead());
            this.addExtensionsTags(allTags, metadataExtraTags, gpxFile.getMetadata().getExtensionsToRead());
            IndexRouteRelationCreator.finalizeRouteShieldTags(allTags);
            IndexRouteRelationCreator.finalizeActivityTypeAndColors(allTags, metadataExtraTags, extensionsExtraTags, gpxInfo.tags);
            allTags.put("route_bbox_radius", gpxFile.getOuterRadius());
            if (!metadataExtraTags.isEmpty()) {
                allTags.put("metadata_extra_tags", this.gson.toJson(metadataExtraTags));
            }
            if (!extensionsExtraTags.isEmpty()) {
                allTags.put("extensions_extra_tags", this.gson.toJson(extensionsExtraTags));
            }
            if (poiSectionTags != null) {
                poiSectionTags.putAll(allTags);
                poiSectionTags.remove("track_color");
            }
            if (mapSectionTags != null) {
                mapSectionTags.putAll(allTags);
                mapSectionTags.put("route", "segment");
                mapSectionTags.remove("route_type");
            }
        }
        catch (RuntimeException e) {
            System.err.printf("Error for object with all tags %s,  metadata tags %s \n", allTags, metadataExtraTags);
            throw e;
        }
        return allTags;
    }

    private void addMetadataTags(Map<String, String> allTags, Metadata metadata) {
        if (metadata.getLink() != null && !Algorithms.isEmpty((CharSequence)metadata.getLink().getHref())) {
            allTags.put("url", metadata.getLink().getHref());
            if (!Algorithms.isEmpty((CharSequence)metadata.getLink().getText())) {
                allTags.put("url_text", metadata.getLink().getText());
            }
        }
    }

    private void addPointGroupsTags(Map<String, String> gpxTrackTags, Map<String, GpxUtilities.PointsGroup> pointsGroups) {
        ArrayList<String> pgNames = new ArrayList<String>();
        ArrayList<String> pgIcons = new ArrayList<String>();
        ArrayList<String> pgColors = new ArrayList<String>();
        ArrayList<String> pgBackgrounds = new ArrayList<String>();
        for (String name : pointsGroups.keySet()) {
            GpxUtilities.PointsGroup pg = pointsGroups.get(name);
            if (pg.getIconName() == null || pg.getBackgroundType() == null || pg.getColor() == 0) continue;
            pgNames.add(name.isEmpty() ? "." : name);
            pgIcons.add(pg.getIconName());
            pgBackgrounds.add(pg.getBackgroundType());
            pgColors.add(KAlgorithms.INSTANCE.colorToString(pg.getColor()));
        }
        if (!pgNames.isEmpty()) {
            String delimiter = "~~~";
            gpxTrackTags.put("points_groups_names", String.join((CharSequence)"~~~", pgNames));
            gpxTrackTags.put("points_groups_icons", String.join((CharSequence)"~~~", pgIcons));
            gpxTrackTags.put("points_groups_colors", String.join((CharSequence)"~~~", pgColors));
            gpxTrackTags.put("points_groups_backgrounds", String.join((CharSequence)"~~~", pgBackgrounds));
        }
    }

    private void addExtensionsTags(@Nonnull Map<String, String> gpxTrackTags, @Nonnull Map<String, String> extraTags, @Nonnull Map<String, String> extensions) {
        MapPoiTypes poiTypes = MapPoiTypes.getDefault();
        for (String tag : extensions.keySet()) {
            String val = extensions.get(tag);
            PoiType pt = poiTypes.getPoiTypeByTagValue(tag.replaceAll("_-_", ":"), val);
            if (!this.alwaysExtraTags.contains(tag) && pt != null && ("routes".equals(pt.getCategory().getKeyName()) || "Other".equals(pt.getCategory().getKeyName()))) {
                gpxTrackTags.putIfAbsent(tag, val);
                continue;
            }
            extraTags.putIfAbsent(tag, val);
        }
    }

    private void addElevationGraphTags(Map<String, String> gpxTrackTags, TrkSegment s) {
        if (s != null) {
            IndexHeightData.WayGeneralStats wgs = new IndexHeightData.WayGeneralStats();
            for (WptPt p : s.getPoints()) {
                wgs.altitudes.add(p.getEle());
                wgs.dists.add(p.getDistance());
            }
            IndexHeightData.calculateEleStats(wgs, 25);
            if (wgs.eleCount > 0 && !Double.isNaN(wgs.startEle) && !Double.isNaN(wgs.endEle)) {
                gpxTrackTags.put("start_ele", String.valueOf((int)wgs.startEle));
                gpxTrackTags.putIfAbsent("diff_ele_up", String.valueOf((int)wgs.up));
                gpxTrackTags.putIfAbsent("diff_ele_down", String.valueOf((int)wgs.down));
                gpxTrackTags.put("ele_graph", MapAlgorithms.encodeIntHeightArrayGraph((int)wgs.step, (TIntArrayList)wgs.altIncs, (int)3));
            }
        }
    }

    private void serializeTags(Map<String, String> gpxTrackTags) throws IOException {
        for (Map.Entry<String, String> e : gpxTrackTags.entrySet()) {
            this.tagValue(this.serializer, e.getKey().replaceAll("_-_", ":"), e.getValue());
        }
    }

    public void endDocument() throws IOException {
        if (this.serializer != null) {
            this.serializer.endDocument();
            this.serializer.flush();
            this.outputStream.close();
        }
    }

    private void addNameDescDisplaycolor(Map<String, String> gpxTrackTags, Map<String, String> extensionsExtraTags, Track t) {
        if (t != null) {
            int color;
            if (!Algorithms.isEmpty((CharSequence)t.getName())) {
                if (gpxTrackTags.containsKey("name") && gpxTrackTags.containsKey("filename") && !t.getName().equals(gpxTrackTags.get("name"))) {
                    gpxTrackTags.put("name:file", gpxTrackTags.get("filename"));
                }
                gpxTrackTags.put("name", t.getName());
            }
            if (!Algorithms.isEmpty((CharSequence)t.getDesc())) {
                gpxTrackTags.put("description", t.getDesc());
            }
            if ((color = t.getColor(Integer.valueOf(0)).intValue()) != 0) {
                extensionsExtraTags.put("displaycolor", MapRenderingTypesEncoder.formatColorToPalette(Algorithms.colorToString((int)color), false));
            }
        }
    }

    private void addGpxInfoTags(Map<String, String> gpxTrackTags, OsmGpxFile gpxInfo) {
        if (gpxInfo != null) {
            if (!Algorithms.isEmpty((CharSequence)gpxInfo.user)) {
                gpxTrackTags.put("user", gpxInfo.user);
            }
            if (!Algorithms.isEmpty((CharSequence)gpxInfo.name)) {
                gpxTrackTags.put("name", gpxInfo.name);
            }
            if (!Algorithms.isEmpty((CharSequence)gpxInfo.filename)) {
                gpxTrackTags.put("filename", gpxInfo.filename);
            }
            if (!Algorithms.isEmpty((CharSequence)gpxInfo.ref)) {
                gpxTrackTags.put("ref", gpxInfo.ref);
                if (gpxInfo.ref.length() >= 3) {
                    gpxTrackTags.put("name:ref", gpxInfo.ref);
                }
            }
            if (!Algorithms.isEmpty((CharSequence)gpxInfo.description)) {
                gpxTrackTags.put("description", gpxInfo.description);
            }
            gpxTrackTags.put("route_id", gpxInfo.getRouteId());
            if (gpxInfo.timestamp.getTime() > 0L) {
                gpxTrackTags.put("date", gpxInfo.timestamp.toString());
            }
        }
    }

    private void addAnalysisTags(Map<String, String> gpxTrackTags, GpxTrackAnalysis analysis) {
        gpxTrackTags.put("distance", oneTenthFormat.format(analysis.getTotalDistance() / 1000.0f));
        if (analysis.isTimeSpecified()) {
            gpxTrackTags.put("time_span", "" + analysis.getTimeSpan());
            gpxTrackTags.put("time_span_no_gaps", "" + analysis.getTimeSpanWithoutGaps());
            gpxTrackTags.put("time_moving", "" + analysis.getTimeMoving());
            gpxTrackTags.put("time_moving_no_gaps", "" + analysis.getTimeMovingWithoutGaps());
        }
        if (analysis.hasElevationData()) {
            gpxTrackTags.put("avg_ele", oneTenthFormat.format(analysis.getAvgElevation()));
            gpxTrackTags.put("min_ele", oneTenthFormat.format(analysis.getMinElevation()));
            gpxTrackTags.put("max_ele", oneTenthFormat.format(analysis.getMaxElevation()));
            gpxTrackTags.put("diff_ele_up", oneTenthFormat.format(analysis.getDiffElevationUp()));
            gpxTrackTags.put("diff_ele_down", oneTenthFormat.format(analysis.getDiffElevationDown()));
        }
        if (analysis.hasSpeedData()) {
            gpxTrackTags.put("avg_speed", oneTenthFormat.format(analysis.getAvgSpeed()));
            gpxTrackTags.put("max_speed", oneTenthFormat.format(analysis.getMaxSpeed()));
            gpxTrackTags.put("min_speed", oneTenthFormat.format(analysis.getMinSpeed()));
        }
    }

    private void writePoint(long id, WptPt p, String routeType, String routeId, String routeName) throws IOException {
        int color;
        this.serializer.startTag(null, "node");
        this.serializer.attribute(null, "lat", latLonFormat.format(p.getLat()));
        this.serializer.attribute(null, "lon", latLonFormat.format(p.getLon()));
        this.serializer.attribute(null, "id", "" + id);
        this.serializer.attribute(null, "action", "modify");
        this.serializer.attribute(null, "version", "1");
        LinkedHashMap<String, String> pointPoiTags = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> pointExtraTags = new LinkedHashMap<String, String>();
        this.addExtensionsTags(pointPoiTags, pointExtraTags, p.getExtensionsToRead());
        if (!pointExtraTags.isEmpty()) {
            this.tagValue(this.serializer, "wpt_extra_tags", this.gson.toJson(pointExtraTags));
        }
        this.serializeTags(pointPoiTags);
        if (routeType != null) {
            this.tagValue(this.serializer, "route", routeType);
            this.tagValue(this.serializer, "route_type", "track_point");
            this.tagValue(this.serializer, "route_id", routeId);
            this.tagValue(this.serializer, "route_name", routeName);
        }
        if (!Algorithms.isEmpty((CharSequence)p.getName())) {
            this.tagValue(this.serializer, "name", p.getName());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getDesc())) {
            this.tagValue(this.serializer, "description", p.getDesc());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getCategory())) {
            this.tagValue(this.serializer, "category", p.getCategory());
            this.tagValue(this.serializer, "points_groups_category", p.getCategory());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getComment())) {
            this.tagValue(this.serializer, "note", p.getComment());
        }
        if (p.getLink() != null && !Algorithms.isEmpty((CharSequence)p.getLink().getHref())) {
            this.tagValue(this.serializer, "url", p.getLink().getHref());
            if (!Algorithms.isEmpty((CharSequence)p.getLink().getText())) {
                this.tagValue(this.serializer, "url_text", p.getLink().getText());
            }
        }
        if (!Algorithms.isEmpty((CharSequence)p.getIconName())) {
            this.tagValue(this.serializer, "icon", p.getIconName());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getBackgroundType())) {
            this.tagValue(this.serializer, "background", p.getBackgroundType());
        }
        if ((color = p.getColor(Integer.valueOf(0)).intValue()) != 0) {
            this.tagValue(this.serializer, "color", MapRenderingTypesEncoder.formatColorToPalette(Algorithms.colorToString((int)color), false));
        }
        if (this.qp.details >= 2) {
            if (!Double.isNaN(p.getEle())) {
                this.tagValue(this.serializer, "ele", oneTenthFormat.format(p.getEle()));
            }
            if (!Double.isNaN(p.getSpeed()) && p.getSpeed() > 0.0) {
                this.tagValue(this.serializer, "speed", oneTenthFormat.format(p.getSpeed()));
            }
            if (!Double.isNaN(p.getHdop())) {
                this.tagValue(this.serializer, "hdop", oneTenthFormat.format(p.getHdop()));
            }
        }
        this.serializer.endTag(null, "node");
    }

    private void tagValue(XmlSerializer serializer, String tag, String value) throws IOException {
        if (Algorithms.isEmpty((CharSequence)value)) {
            return;
        }
        serializer.startTag(null, "tag");
        serializer.attribute(null, "k", tag);
        serializer.attribute(null, "v", value);
        serializer.endTag(null, "tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeObf(Map<String, GpxFile> gpxFiles, List<KFile> files, File tmpFolder, String fileName, File targetObf) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        this.startDocument();
        if (gpxFiles != null) {
            for (Map.Entry<String, GpxFile> entry : gpxFiles.entrySet()) {
                gpxFile = entry.getValue();
                this.writeFile(gpxFile, entry.getKey());
            }
        } else if (files != null) {
            for (KFile gf : files) {
                if (gf.name().endsWith(".bz2")) {
                    throw new RuntimeException("writeObf: unsupported input file extension: " + gf.name());
                }
                if (gf.name().endsWith(".gz")) {
                    FileInputStream fis = new FileInputStream(gf.absolutePath());
                    GpxFile gpxFile = GpxUtilities.INSTANCE.loadGpxFile(null, (Source)new GzipSource(Okio.source((InputStream)fis)), null, false);
                    this.writeFile(gpxFile, gf.name());
                    continue;
                }
                if (!gf.name().endsWith(".gpx")) continue;
                gpxFile = GpxUtilities.INSTANCE.loadGpxFile(gf, null, false);
                this.writeFile(gpxFile, gf.name());
            }
        }
        this.endDocument();
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexMap = true;
        settings.indexPOI = true;
        settings.indexAddress = false;
        settings.indexRouting = false;
        settings.indexTransport = false;
        RTree.clearCache();
        try {
            tmpFolder.mkdirs();
            IndexCreator ic = new IndexCreator(tmpFolder, settings);
            MapRenderingTypesEncoder types = new MapRenderingTypesEncoder(null, fileName);
            ic.setMapFileName(fileName);
            IProgress prog = IProgress.EMPTY_PROGRESS;
            ic.generateIndexes(this.qp.osmFile, prog, null, MapZooms.getDefault(), types, null);
            File obfInTmpFolder = new File(tmpFolder, ic.getMapFileName());
            Files.move(obfInTmpFolder.toPath(), targetObf.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Algorithms.removeAllFiles((File)tmpFolder);
        }
        return targetObf;
    }

    private void writeFile(GpxFile gpxFile, String fileName) throws SQLException, IOException {
        if (gpxFile == null || gpxFile.getError() != null) {
            System.err.printf("WARN: writeFile %s gpxFile error (%s)\n", fileName, gpxFile != null ? gpxFile.getError().getMessage() : "unknown");
            return;
        }
        GpxTrackAnalysis analysis = gpxFile.getAnalysis(0L);
        OsmGpxFile file = new OsmGpxFile("GPX");
        String baseFileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        String noGzFileName = baseFileName.replaceAll("(?i)\\.gz$", "");
        String noGpxFileName = noGzFileName.replaceAll("(?i)\\.gpx$", "");
        file.filename = noGzFileName;
        file.name = noGpxFileName;
        file.tags = new String[0];
        int xor = 0;
        for (int i = 0; i < file.name.length(); ++i) {
            xor += file.name.charAt(i);
        }
        long ts = gpxFile.getModifiedTime() > 0L ? gpxFile.getModifiedTime() : System.currentTimeMillis();
        file.timestamp = new Date(ts);
        file.id = ts ^ (long)xor;
        this.writeTrack(file, gpxFile, analysis);
    }

    public static void main(String[] args) throws IOException, SQLException, XmlPullParserException, InterruptedException {
        OsmGpxWriteContext.generateObfFromGpx(Arrays.asList(args));
    }

    public static void generateObfFromGpx(List<String> subArgs) throws IOException, SQLException, XmlPullParserException, InterruptedException {
        KFile file;
        if (subArgs.size() != 0 && ((file = new KFile(subArgs.get(0))).isDirectory() || file.name().endsWith(".gpx") || file.name().endsWith(".gpx.gz"))) {
            QueryParams qp = new QueryParams();
            qp.osmFile = File.createTempFile(file.getFileNameWithoutExtension(), ".osm");
            OsmGpxWriteContext ctx = new OsmGpxWriteContext(qp);
            File dir = new File(file.isDirectory() ? file.name() : file.parent().name());
            File tmpFolder = new File(dir, String.valueOf(System.currentTimeMillis()));
            File targetObf = new File(dir, file.getFileNameWithoutExtension() + ".obf");
            List<KFile> files = new ArrayList<KFile>();
            if (file.isDirectory()) {
                files = file.listFiles();
            } else {
                files.add(file);
            }
            if (!files.isEmpty()) {
                ctx.writeObf(null, files, tmpFolder, file.getFileNameWithoutExtension(), targetObf);
            }
            if (!qp.osmFile.delete()) {
                qp.osmFile.deleteOnExit();
            }
        }
    }

    public static class QueryParams {
        public static final int DETAILS_POINTS = 0;
        public static final int DETAILS_TRACKS = 1;
        public static final int DETAILS_ELE_SPEED = 2;
        public int details = 2;
        public File osmFile;
        public File obfFile;
        public String tag;
        public int limit = -1;
        public String user;
        public String datestart;
        public String dateend;
        public Set<OsmRouteType> activityTypes = null;
        public double minlat = -1000.0;
        public double maxlat = -1000.0;
        public double maxlon = -1000.0;
        public double minlon = -1000.0;
    }

    public static class OsmGpxFile {
        private String routeIdPrefix;
        public long id;
        public String ref;
        public String name;
        public Date timestamp;
        public boolean pending;
        public String user;
        public String visibility;
        public double lat;
        public double lon;
        public String description;
        public String filename;
        public static final double ERROR_NUMBER = -1000.0;
        public double minlat = -1000.0;
        public double minlon = -1000.0;
        public double maxlat = -1000.0;
        public double maxlon = -1000.0;
        public String[] tags;
        public String gpx;
        public byte[] gpxGzip;

        public OsmGpxFile(@Nonnull String prefix) {
            this.routeIdPrefix = prefix;
        }

        public String getRouteId() {
            return this.routeIdPrefix + this.id;
        }

        public void updateRouteId(@Nullable String routeId) {
            if (routeId != null) {
                String letters = routeId.replaceAll("[^A-Za-z]", "");
                String digits = routeId.replaceAll("[^0-9]", "");
                if (!letters.isEmpty() && !digits.isEmpty()) {
                    this.id = Long.parseLong(digits);
                    this.routeIdPrefix = letters;
                }
            }
        }

        public void updateName(@Nullable String name) {
            if (!Algorithms.isEmpty((CharSequence)name)) {
                this.name = name;
            }
        }

        public void updateRef(@Nullable String ref) {
            if (!Algorithms.isEmpty((CharSequence)ref)) {
                this.ref = ref;
            }
        }

        public void updateDescription(@Nullable String description) {
            if (!Algorithms.isEmpty((CharSequence)description)) {
                this.description = description;
            }
        }
    }
}

