/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCPPBasedCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;

public class GroovyCodeFilter
extends AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    private static HashMap<String, String> KEYWORD_SET;
    private static final String[] KEYWORDS;
    private static final String[] OBJECT_WORDS;
    private static HashMap<String, String> OBJECT_SET;

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result.append("<span style=\"color:#2A00FF; \">");
                    GroovyCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        GroovyCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            GroovyCodeFilter.appendChar(result, currentChar);
                            continue;
                        }
                        if (currentChar != 34) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '\'' && currentPosition < input.length() - 1 && source[currentPosition] == '\'' && source[currentPosition + 1] == '\'') {
                    result.append("<span style=\"color:#2A00FF; \">");
                    GroovyCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        GroovyCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            GroovyCodeFilter.appendChar(result, currentChar);
                            continue;
                        }
                        if (currentChar != 39 || currentPosition >= input.length() - 1 || source[currentPosition] != '\'' || source[currentPosition + 1] != '\'') continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '\'') {
                    result.append("<span style=\"color:#2A00FF; \">");
                    GroovyCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        GroovyCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            GroovyCodeFilter.appendChar(result, currentChar);
                            continue;
                        }
                        if (currentChar != 39) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result.append("<span style=\"color:#3F7F5F; \">");
                    GroovyCodeFilter.appendChar(result, currentChar);
                    GroovyCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        GroovyCodeFilter.appendChar(result, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result.append("<span style=\"color:#3F5FBF; \">");
                    } else {
                        result.append("<span style=\"color:#3F7F5F; \">");
                    }
                    GroovyCodeFilter.appendChar(result, currentChar);
                    GroovyCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        GroovyCodeFilter.appendChar(result, currentChar);
                        if (currentChar != 47 || source[currentPosition - 2] != '*') continue;
                    }
                    result.append("</span>");
                    continue;
                }
                GroovyCodeFilter.appendChar(result, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result);
            }
            return result.toString();
        }
    }

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    public String getName() {
        return "groovy";
    }

    @Override
    public HashMap<String, String> getObjectSet() {
        return OBJECT_SET;
    }

    static {
        int i;
        KEYWORD_SET = new HashMap();
        KEYWORDS = new String[]{"any", "as", "class", "abstract", "break", "byvalue", "case", "cast", "catch", "const", "continue", "def", "default", "do", "else", "extends", "false", "final", "finally", "for", "future", "generic", "goto", "if", "implements", "import", "in", "inner", "instanceof", "interface", "mixin", "native", "new", "null", "operator", "outer", "package", "private", "property", "protected", "public", "rest", "return", "static", "super", "switch", "synchronized", "test", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "using", "var", "volatile", "while", "assert", "enum", "boolean", "char", "byte", "short", "int", "long", "float", "double", "void"};
        OBJECT_WORDS = new String[]{"Boolean", "Byte", "Character", "Class", "ClassLoader", "Cloneable", "Compiler", "Double", "Float", "Integer", "Long", "Math", "Number", "Object", "Process", "Runnable", "Runtime", "SecurityManager", "Short", "String", "StringBuffer", "System", "Thread", "ThreadGroup", "Void"};
        OBJECT_SET = new HashMap();
        for (i = 0; i < KEYWORDS.length; ++i) {
            GroovyCodeFilter.createHashMap(KEYWORD_SET, KEYWORDS[i]);
        }
        for (i = 0; i < OBJECT_WORDS.length; ++i) {
            GroovyCodeFilter.createObjectsMap(OBJECT_SET, OBJECT_WORDS[i]);
        }
    }
}

