/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.dump;

import info.bliki.wiki.dump.IArticleFilter;
import info.bliki.wiki.dump.Siteinfo;
import info.bliki.wiki.dump.WikiArticle;
import info.bliki.wiki.dump.WikiXMLParser;
import info.bliki.wiki.model.WikiModel;
import java.io.File;
import java.io.IOException;

public class PrintArticle
implements IArticleFilter {
    private int counter = 0;
    private int max_counter;

    public PrintArticle(int max_count) {
        this.max_counter = max_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WikiArticle article, Siteinfo siteinfo) throws IOException {
        ++this.counter;
        if (this.counter >= this.max_counter) {
            throw new IOException("\nLimit reached after " + this.max_counter + " entries.");
        }
        String htmlText = "";
        WikiModel wikiModel = new WikiModel("${image}", "${title}");
        try {
            wikiModel.setUp();
            htmlText = wikiModel.render(article.getText(), false);
            if (htmlText == null) {
                System.out.println("An IOException occured!");
            } else {
                System.out.println(htmlText);
            }
        }
        finally {
            wikiModel.tearDown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            File file = new File(args[0]);
            WikiXMLParser parser = new WikiXMLParser(file, (IArticleFilter)new PrintArticle(999999));
            parser.parse();
        } else {
            System.err.println("PrintArticle <dump.xml>");
            System.exit(1);
        }
    }
}

