/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.IMapDataProvider;
import net.osmand.core.jni.Metric;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapDataProvider__Request_t;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t;
import net.osmand.core.jni.TileId;
import net.osmand.core.jni.ZoomLevel;

public class IMapTiledDataProvider
extends IMapDataProvider {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected IMapTiledDataProvider(long l, boolean bl) {
        super(OsmAndCoreJNI.IMapTiledDataProvider_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(IMapTiledDataProvider iMapTiledDataProvider) {
        return iMapTiledDataProvider == null ? 0L : iMapTiledDataProvider.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_IMapTiledDataProvider(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ZoomLevel getMinZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_getMinZoom(this.swigCPtr, this));
    }

    public ZoomLevel getMaxZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_getMaxZoom(this.swigCPtr, this));
    }

    public ZoomLevel getMinVisibleZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_getMinVisibleZoom(this.swigCPtr, this));
    }

    public ZoomLevel getMaxVisibleZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_getMaxVisibleZoom(this.swigCPtr, this));
    }

    public int getMaxMissingDataZoomShift() {
        return OsmAndCoreJNI.IMapTiledDataProvider_getMaxMissingDataZoomShift(this.swigCPtr, this);
    }

    public int getMaxMissingDataUnderZoomShift() {
        return OsmAndCoreJNI.IMapTiledDataProvider_getMaxMissingDataUnderZoomShift(this.swigCPtr, this);
    }

    public boolean isMetaTiled() {
        return OsmAndCoreJNI.IMapTiledDataProvider_isMetaTiled(this.swigCPtr, this);
    }

    public boolean obtainTiledData(Request request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t, Metric metric) {
        return OsmAndCoreJNI.IMapTiledDataProvider_obtainTiledData__SWIG_0(this.swigCPtr, this, Request.getCPtr(request), request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t.getCPtr(sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t), Metric.getCPtr(metric), metric);
    }

    public boolean obtainTiledData(Request request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t) {
        return OsmAndCoreJNI.IMapTiledDataProvider_obtainTiledData__SWIG_1(this.swigCPtr, this, Request.getCPtr(request), request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t.getCPtr(sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapTiledDataProvider__Data_t));
    }

    public static class Request
    extends IMapDataProvider.Request {
        private transient long swigCPtr;

        protected Request(long l, boolean bl) {
            super(OsmAndCoreJNI.IMapTiledDataProvider_Request_SWIGUpcast(l), bl);
            this.swigCPtr = l;
        }

        protected static long getCPtr(Request request) {
            return request == null ? 0L : request.swigCPtr;
        }

        protected static long swigRelease(Request request) {
            long l = 0L;
            if (request != null) {
                if (!request.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = request.swigCPtr;
                request.swigCMemOwn = false;
                request.delete();
            }
            return l;
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_IMapTiledDataProvider_Request(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public Request() {
            this(OsmAndCoreJNI.new_IMapTiledDataProvider_Request__SWIG_0(), true);
        }

        public Request(IMapDataProvider.Request request) {
            this(OsmAndCoreJNI.new_IMapTiledDataProvider_Request__SWIG_1(IMapDataProvider.Request.getCPtr(request), request), true);
        }

        public void setTileId(TileId tileId) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_tileId_set(this.swigCPtr, this, TileId.getCPtr(tileId), tileId);
        }

        public TileId getTileId() {
            long l = OsmAndCoreJNI.IMapTiledDataProvider_Request_tileId_get(this.swigCPtr, this);
            return l == 0L ? null : new TileId(l, false);
        }

        public void setZoom(ZoomLevel zoomLevel) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_zoom_set(this.swigCPtr, this, zoomLevel.swigValue());
        }

        public ZoomLevel getZoom() {
            return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_Request_zoom_get(this.swigCPtr, this));
        }

        public void setDetailedZoom(ZoomLevel zoomLevel) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_detailedZoom_set(this.swigCPtr, this, zoomLevel.swigValue());
        }

        public ZoomLevel getDetailedZoom() {
            return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_Request_detailedZoom_get(this.swigCPtr, this));
        }

        public void setVisibleArea31(AreaI areaI) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_visibleArea31_set(this.swigCPtr, this, AreaI.getCPtr(areaI), areaI);
        }

        public AreaI getVisibleArea31() {
            long l = OsmAndCoreJNI.IMapTiledDataProvider_Request_visibleArea31_get(this.swigCPtr, this);
            return l == 0L ? null : new AreaI(l, false);
        }

        public void setAreaTime(long l) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_areaTime_set(this.swigCPtr, this, l);
        }

        public long getAreaTime() {
            return OsmAndCoreJNI.IMapTiledDataProvider_Request_areaTime_get(this.swigCPtr, this);
        }

        public void setCacheOnly(boolean bl) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_cacheOnly_set(this.swigCPtr, this, bl);
        }

        public boolean getCacheOnly() {
            return OsmAndCoreJNI.IMapTiledDataProvider_Request_cacheOnly_get(this.swigCPtr, this);
        }

        public static void copy(Request request, IMapDataProvider.Request request2) {
            OsmAndCoreJNI.IMapTiledDataProvider_Request_copy(Request.getCPtr(request), request, IMapDataProvider.Request.getCPtr(request2), request2);
        }

        @Override
        public SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapDataProvider__Request_t clone() {
            return new SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapDataProvider__Request_t(OsmAndCoreJNI.IMapTiledDataProvider_Request_clone(this.swigCPtr, this), true);
        }
    }

    public static class Data
    extends IMapDataProvider.Data {
        private transient long swigCPtr;

        protected Data(long l, boolean bl) {
            super(OsmAndCoreJNI.IMapTiledDataProvider_Data_SWIGUpcast(l), bl);
            this.swigCPtr = l;
        }

        protected static long getCPtr(Data data) {
            return data == null ? 0L : data.swigCPtr;
        }

        protected static long swigRelease(Data data) {
            long l = 0L;
            if (data != null) {
                if (!data.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = data.swigCPtr;
                data.swigCMemOwn = false;
                data.delete();
            }
            return l;
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_IMapTiledDataProvider_Data(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public Data(TileId tileId, ZoomLevel zoomLevel, IMapDataProvider.RetainableCacheMetadata retainableCacheMetadata) {
            this(OsmAndCoreJNI.new_IMapTiledDataProvider_Data__SWIG_0(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), IMapDataProvider.RetainableCacheMetadata.getCPtr(retainableCacheMetadata), retainableCacheMetadata), true);
        }

        public Data(TileId tileId, ZoomLevel zoomLevel) {
            this(OsmAndCoreJNI.new_IMapTiledDataProvider_Data__SWIG_1(TileId.getCPtr(tileId), tileId, zoomLevel.swigValue()), true);
        }

        public void setTileId(TileId tileId) {
            OsmAndCoreJNI.IMapTiledDataProvider_Data_tileId_set(this.swigCPtr, this, TileId.getCPtr(tileId), tileId);
        }

        public TileId getTileId() {
            long l = OsmAndCoreJNI.IMapTiledDataProvider_Data_tileId_get(this.swigCPtr, this);
            return l == 0L ? null : new TileId(l, false);
        }

        public void setZoom(ZoomLevel zoomLevel) {
            OsmAndCoreJNI.IMapTiledDataProvider_Data_zoom_set(this.swigCPtr, this, zoomLevel.swigValue());
        }

        public ZoomLevel getZoom() {
            return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapTiledDataProvider_Data_zoom_get(this.swigCPtr, this));
        }
    }
}

