/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.compile.Compiler;
import com.atilika.kuromoji.dict.GenericDictionaryEntry;
import com.atilika.kuromoji.io.IntegerArrayIO;
import com.atilika.kuromoji.io.StringArrayIO;
import com.atilika.kuromoji.util.UnknownDictionaryEntryParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnknownDictionaryCompiler
implements Compiler {
    private OutputStream output;
    protected Map<String, Integer> categoryMap;
    protected List<GenericDictionaryEntry> dictionaryEntries = new ArrayList<GenericDictionaryEntry>();

    public UnknownDictionaryCompiler(Map<String, Integer> categoryMap, OutputStream output) {
        this.categoryMap = categoryMap;
        this.output = output;
    }

    public void readUnknownDefinition(InputStream input, String encoding) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(input, encoding));
        UnknownDictionaryEntryParser parser = new UnknownDictionaryEntryParser();
        while ((line = reader.readLine()) != null) {
            GenericDictionaryEntry entry = parser.parse(line);
            this.dictionaryEntries.add(entry);
        }
    }

    public int[][] makeCosts() {
        int[][] costs = new int[this.dictionaryEntries.size()][];
        for (int i = 0; i < this.dictionaryEntries.size(); ++i) {
            GenericDictionaryEntry entry = this.dictionaryEntries.get(i);
            costs[i] = new int[]{entry.getLeftId(), entry.getRightId(), entry.getWordCost()};
        }
        return costs;
    }

    public String[][] makeFeatures() {
        String[][] features = new String[this.dictionaryEntries.size()][];
        for (int i = 0; i < this.dictionaryEntries.size(); ++i) {
            GenericDictionaryEntry entry = this.dictionaryEntries.get(i);
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.addAll(entry.getPosFeatures());
            tmp.addAll(entry.getFeatures());
            String[] f = new String[tmp.size()];
            features[i] = tmp.toArray(f);
        }
        return features;
    }

    public int[][] makeCategoryReferences() {
        int[][] entries = new int[this.categoryMap.size()][];
        for (String category : this.categoryMap.keySet()) {
            int categoryId = this.categoryMap.get(category);
            entries[categoryId] = this.getEntryIndices(category);
        }
        return entries;
    }

    public void printFeatures(String[][] features) {
        for (int i = 0; i < features.length; ++i) {
            System.out.println(i);
            String[] array = features[i];
            for (int j = 0; j < array.length; ++j) {
                System.out.println("\t" + array[j]);
            }
        }
    }

    public int[] getEntryIndices(String surface) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.dictionaryEntries.size(); ++i) {
            GenericDictionaryEntry entry = this.dictionaryEntries.get(i);
            if (!entry.getSurface().equals(surface)) continue;
            indices.add(i);
        }
        return this.toArray(indices);
    }

    private int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public List<GenericDictionaryEntry> getDictionaryEntries() {
        return this.dictionaryEntries;
    }

    @Override
    public void compile() throws IOException {
        IntegerArrayIO.writeArray2D(this.output, this.makeCosts());
        IntegerArrayIO.writeArray2D(this.output, this.makeCategoryReferences());
        StringArrayIO.writeArray2D(this.output, this.makeFeatures());
        this.output.close();
    }
}

