/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.template.AbstractTemplateFunction;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ParsedPageName {
    public final INamespace.INamespaceValue namespace;
    public final String pagename;
    public final boolean valid;
    public final Object magicWord;
    public final String magicWordParameter;

    public ParsedPageName(INamespace.INamespaceValue namespace, String pagename, boolean valid) {
        this.namespace = namespace;
        this.pagename = pagename;
        this.valid = valid;
        this.magicWord = null;
        this.magicWordParameter = null;
    }

    public ParsedPageName(INamespace.INamespaceValue namespace, String pagename, Object magicWord, String magicWordParameter, boolean valid) {
        this.namespace = namespace;
        this.pagename = pagename;
        this.valid = valid;
        this.magicWord = magicWord;
        this.magicWordParameter = magicWordParameter;
    }

    @Nonnull
    public static ParsedPageName parsePageName(@Nonnull IWikiModel wikiModel, @Nonnull String pagename, INamespace.INamespaceValue namespace, boolean magicWordAllowed, boolean stripOffSection) {
        Object maybeMagicWord;
        int index;
        int hashIndex;
        Object magicWord = null;
        String magicWordParameter = null;
        if (pagename.length() > 0 && pagename.charAt(0) == ':') {
            magicWordAllowed = false;
            if (pagename.length() > 1 && pagename.charAt(1) == ':') {
                return new ParsedPageName(namespace, pagename, false);
            }
            namespace = wikiModel.getNamespace().getMain();
            pagename = pagename.substring(1);
        }
        if (stripOffSection && (hashIndex = pagename.indexOf(35)) != -1) {
            pagename = pagename.substring(0, hashIndex);
        }
        if ((index = pagename.indexOf(58)) > 0) {
            String maybeNamespaceStr0 = pagename.substring(0, index);
            INamespace.INamespaceValue maybeNamespace = wikiModel.getNamespace().getNamespace(maybeNamespaceStr0);
            if (maybeNamespace != null) {
                return new ParsedPageName(maybeNamespace, pagename.substring(index + 1), true);
            }
            if (magicWordAllowed && (magicWord = wikiModel.getMagicWord(maybeNamespaceStr0)) != null && (magicWordParameter = pagename.substring(index + 1)).length() != 0) {
                magicWordParameter = AbstractTemplateFunction.parseTrim(magicWordParameter, wikiModel);
            }
        } else if (magicWordAllowed && namespace.isType(INamespace.NamespaceCode.TEMPLATE_NAMESPACE_KEY) && (maybeMagicWord = wikiModel.getMagicWord(pagename)) != null) {
            magicWord = maybeMagicWord;
        }
        return new ParsedPageName(namespace, pagename, magicWord, magicWordParameter, true);
    }

    public String toString() {
        return "ParsedPageName{namespace=" + this.namespace + ", pagename='" + this.pagename + '\'' + '}';
    }

    public String fullPagename() {
        return this.namespace.makeFullPagename(this.pagename);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedPageName pageName = (ParsedPageName)o;
        return Objects.equals(this.valid, pageName.valid) && Objects.equals(this.namespace, pageName.namespace) && Objects.equals(this.pagename, pageName.pagename) && Objects.equals(this.magicWord, pageName.magicWord) && Objects.equals(this.magicWordParameter, pageName.magicWordParameter);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.pagename, this.valid, this.magicWord, this.magicWordParameter);
    }
}

