/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner.conditional;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.Display;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.conditional.ITagNodeCondition;

public class TagNodeEmptyContentCondition
implements ITagNodeCondition {
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final Set<String> unsafeBlockElements = new HashSet<String>();
    private ITagInfoProvider tagInfoProvider;

    public TagNodeEmptyContentCondition(ITagInfoProvider provider) {
        this.tagInfoProvider = provider;
    }

    public boolean satisfy(TagNode tagNode) {
        return this.satisfy(tagNode, false);
    }

    private boolean satisfy(TagNode tagNode, boolean override) {
        CharSequence contentString;
        String name = tagNode.getName();
        TagInfo tagInfo = this.tagInfoProvider.getTagInfo(name);
        if (!(tagInfo == null || this.hasIdAttributeSet(tagNode) || Display.none == tagInfo.getDisplay() || tagInfo.isEmptyTag() || !override && unsafeBlockElements.contains(name) || !Utils.isEmptyString(contentString = tagNode.getText()))) {
            if (tagNode.isEmpty()) {
                return true;
            }
            for (BaseToken baseToken : tagNode.getAllChildren()) {
                if (baseToken instanceof TagNode) {
                    if (this.satisfy((TagNode)baseToken, true)) continue;
                    return false;
                }
                if (baseToken instanceof ContentNode) {
                    if (((ContentNode)baseToken).isBlank()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasIdAttributeSet(TagNode tagNode) {
        Map<String, String> attributes = tagNode.getAttributes();
        return !Utils.isEmptyString(attributes.get(ID_ATTRIBUTE_NAME));
    }

    static {
        unsafeBlockElements.add("td");
        unsafeBlockElements.add("th");
    }
}

