/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

public class ArabicNormalizer {
    private static final String[] DIACRITIC_REGEX = new String[]{"[\\u064B-\\u065F]", "[\\u0610-\\u061A]", "[\\u06D6-\\u06ED]", "\\u0640", "\\u0670"};
    private static final String[] DIACRITIC_REPLACE = new String[]{"\u0624", "\u0648", "\u0629", "\u0647", "\u064a", "\u0649", "\u0626", "\u0649", "\u0622", "\u0627", "\u0623", "\u0627", "\u0625", "\u0627"};
    private static final String ARABIC_DIGITS = "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669";
    private static final String DIGITS_REPLACEMENT = "0123456789";

    public static boolean isSpecialArabic(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        char first = text.charAt(0);
        if (Character.UnicodeBlock.of(first) == Character.UnicodeBlock.ARABIC) {
            for (char c : text.toCharArray()) {
                if (!ArabicNormalizer.isDiacritic(c) && !ArabicNormalizer.isArabicDigit(c) && !ArabicNormalizer.isNeedReplace(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static String normalize(String text) {
        int i;
        if (text == null || text.isEmpty()) {
            return text;
        }
        String result = text;
        for (i = 0; i < DIACRITIC_REGEX.length; ++i) {
            result = result.replaceAll(DIACRITIC_REGEX[i], "");
        }
        for (i = 0; i < DIACRITIC_REPLACE.length; i += 2) {
            result = result.replace(DIACRITIC_REPLACE[i], DIACRITIC_REPLACE[i + 1]);
        }
        return ArabicNormalizer.replaceDigits(result);
    }

    private static String replaceDigits(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        char first = text.charAt(0);
        if (Character.UnicodeBlock.of(first) != Character.UnicodeBlock.ARABIC) {
            return text;
        }
        char[] textChars = text.toCharArray();
        for (int i = 0; i < ARABIC_DIGITS.length(); ++i) {
            char c = ARABIC_DIGITS.charAt(i);
            char replacement = DIGITS_REPLACEMENT.charAt(i);
            int index = text.indexOf(c);
            while (index >= 0) {
                textChars[index] = replacement;
                index = text.indexOf(c, index + 1);
            }
        }
        return String.valueOf(textChars);
    }

    private static boolean isDiacritic(char c) {
        return c >= '\u064b' && c <= '\u065f' || c >= '\u0610' && c <= '\u061a' || c >= '\u06d6' && c <= '\u06ed' || c == '\u0640' || c == '\u0670';
    }

    private static boolean isNeedReplace(char c) {
        String charAsString = String.valueOf(c);
        for (int i = 0; i < DIACRITIC_REPLACE.length; i += 2) {
            if (!DIACRITIC_REPLACE[i].equals(charAsString)) continue;
            return true;
        }
        return false;
    }

    private static boolean isArabicDigit(char c) {
        return c >= '\u0660' && c <= '\u0669';
    }
}

