/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import net.osmand.Node;
import net.osmand.NodeComparator;
import net.osmand.data.LatLon;
import net.osmand.util.MapUtils;

public class TspHeldKarp {
    private int n;
    private double[][] cost;
    private int[] order;
    private double[][] costWithPi;
    Node bestNode = new Node();

    public TspHeldKarp readInput(List<LatLon> ls, boolean returnToInitialPoint) {
        this.n = ls.size();
        this.order = new int[this.n];
        this.cost = new double[this.n][this.n];
        System.out.println("Cost");
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.cost[i][j] = !returnToInitialPoint && j == 0 ? 0.0 : Math.rint(MapUtils.getDistance(ls.get(i), ls.get(j)));
            }
            System.out.println(Arrays.toString(this.cost[i]));
        }
        return this;
    }

    public int[] solve() {
        int i;
        this.bestNode.lowerBound = Double.MAX_VALUE;
        Node currentNode = new Node();
        currentNode.excluded = new boolean[this.n][this.n];
        this.costWithPi = new double[this.n][this.n];
        this.computeHeldKarp(currentNode);
        PriorityQueue<Node> pq = new PriorityQueue<Node>(11, new NodeComparator());
        while (true) {
            boolean isTour = true;
            int i2 = -1;
            for (int j = 0; j < this.n; ++j) {
                if (currentNode.degree[j] <= 2 || i2 >= 0 && currentNode.degree[j] >= currentNode.degree[i2]) continue;
                i2 = j;
            }
            if (i2 < 0) {
                if (currentNode.lowerBound < this.bestNode.lowerBound) {
                    this.bestNode = currentNode;
                    System.err.printf("%.0f", this.bestNode.lowerBound);
                }
            } else {
                System.err.print(".");
                PriorityQueue<Node> children = new PriorityQueue<Node>(11, new NodeComparator());
                children.add(this.exclude(currentNode, i2, currentNode.parent[i2]));
                for (int j = 0; j < this.n; ++j) {
                    if (currentNode.parent[j] != i2) continue;
                    children.add(this.exclude(currentNode, i2, j));
                }
                currentNode = children.poll();
                pq.addAll(children);
                if (currentNode.lowerBound < this.bestNode.lowerBound) continue;
            }
            System.err.printf("%n", new Object[0]);
            currentNode = pq.poll();
            if (currentNode == null || !(currentNode.lowerBound < this.bestNode.lowerBound)) break;
        }
        int j = 0;
        int k = 0;
        do {
            i = this.bestNode.parent[j];
            this.order[k++] = j;
            System.out.printf("%f\t\n", this.cost[j][i]);
        } while ((j = i) != 0);
        return this.order;
    }

    private Node exclude(Node node, int i, int j) {
        Node child = new Node();
        child.excluded = (boolean[][])node.excluded.clone();
        child.excluded[i] = (boolean[])node.excluded[i].clone();
        child.excluded[j] = (boolean[])node.excluded[j].clone();
        child.excluded[i][j] = true;
        child.excluded[j][i] = true;
        this.computeHeldKarp(child);
        return child;
    }

    private void computeHeldKarp(Node node) {
        node.pi = new double[this.n];
        node.lowerBound = Double.MIN_VALUE;
        node.degree = new int[this.n];
        node.parent = new int[this.n];
        double lambda = 0.1;
        while (lambda > 1.0E-6) {
            double previousLowerBound = node.lowerBound;
            this.computeOneTree(node);
            if (!(node.lowerBound < this.bestNode.lowerBound)) {
                return;
            }
            if (!(node.lowerBound < previousLowerBound)) {
                lambda *= 0.9;
            }
            int denom = 0;
            for (int i = 1; i < this.n; ++i) {
                int d = node.degree[i] - 2;
                denom += d * d;
            }
            if (denom == 0) {
                return;
            }
            double t = lambda * node.lowerBound / (double)denom;
            for (int i = 1; i < this.n; ++i) {
                int n = i;
                node.pi[n] = node.pi[n] + t * (double)(node.degree[i] - 2);
            }
        }
    }

    private void computeOneTree(Node node) {
        int secondNeighbor;
        int firstNeighbor;
        node.lowerBound = 0.0;
        Arrays.fill(node.degree, 0);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.costWithPi[i][j] = node.excluded[i][j] ? Double.MAX_VALUE : this.cost[i][j] + node.pi[i] + node.pi[j];
            }
        }
        if (this.costWithPi[0][2] < this.costWithPi[0][1]) {
            firstNeighbor = 2;
            secondNeighbor = 1;
        } else {
            firstNeighbor = 1;
            secondNeighbor = 2;
        }
        for (int j = 3; j < this.n; ++j) {
            if (!(this.costWithPi[0][j] < this.costWithPi[0][secondNeighbor])) continue;
            if (this.costWithPi[0][j] < this.costWithPi[0][firstNeighbor]) {
                secondNeighbor = firstNeighbor;
                firstNeighbor = j;
                continue;
            }
            secondNeighbor = j;
        }
        this.addEdge(node, 0, firstNeighbor);
        Arrays.fill(node.parent, firstNeighbor);
        node.parent[firstNeighbor] = 0;
        double[] minCost = (double[])this.costWithPi[firstNeighbor].clone();
        for (int k = 2; k < this.n; ++k) {
            int j;
            int i;
            for (i = 1; i < this.n && node.degree[i] != 0; ++i) {
            }
            for (j = i + 1; j < this.n; ++j) {
                if (node.degree[j] != 0 || !(minCost[j] < minCost[i])) continue;
                i = j;
            }
            this.addEdge(node, node.parent[i], i);
            for (j = 1; j < this.n; ++j) {
                if (node.degree[j] != 0 || !(this.costWithPi[i][j] < minCost[j])) continue;
                minCost[j] = this.costWithPi[i][j];
                node.parent[j] = i;
            }
        }
        this.addEdge(node, 0, secondNeighbor);
        node.parent[0] = secondNeighbor;
        node.lowerBound = Math.rint(node.lowerBound);
    }

    private void addEdge(Node node, int i, int j) {
        double q = node.lowerBound;
        node.lowerBound += this.costWithPi[i][j];
        int n = i;
        node.degree[n] = node.degree[n] + 1;
        int n2 = j;
        node.degree[n2] = node.degree[n2] + 1;
    }
}

