/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.Connector;
import info.bliki.api.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class User {
    protected static final String SUCCESS_ID = "Success";
    protected static final String NEED_TOKEN_ID = "NeedToken";
    private static final String ILLEGAL_ID = "Illegal";
    private String result = "Illegal";
    private String userId = "";
    private final String username;
    private String normalizedUsername;
    private String token;
    private final String password;
    private final String actionUrl;
    private final String domain;
    protected Connector connector;

    public User(String name, String password, String mediawikiApiUrl) {
        this(name, password, mediawikiApiUrl, "");
    }

    public User(String name, String password, String mediawikiApiUrl, String domain) {
        this.username = name;
        this.normalizedUsername = "";
        this.password = password;
        this.domain = domain;
        this.actionUrl = mediawikiApiUrl;
        this.connector = new Connector();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.normalizedUsername, user.normalizedUsername);
    }

    public int hashCode() {
        return Objects.hash(this.normalizedUsername);
    }

    public boolean login() {
        return this.connector.login(this) != null;
    }

    public List<Page> queryContent(List<String> listOfTitleStrings) {
        return this.connector.queryContent(this, listOfTitleStrings);
    }

    public List<Page> queryContent(String ... listOfTitleStrings) {
        return this.queryContent(this.arrayToList(listOfTitleStrings));
    }

    public List<Page> queryCategories(List<String> listOfTitleStrings) {
        return this.connector.queryCategories(this, listOfTitleStrings);
    }

    public List<Page> queryCategories(String ... listOfTitleStrings) {
        return this.queryCategories(this.arrayToList(listOfTitleStrings));
    }

    public List<Page> queryInfo(List<String> listOfTitleStrings) {
        return this.connector.queryInfo(this, listOfTitleStrings);
    }

    public List<Page> queryInfo(String ... listOfTitleStrings) {
        return this.queryInfo(this.arrayToList(listOfTitleStrings));
    }

    public List<Page> queryLinks(List<String> listOfTitleStrings) {
        return this.connector.queryLinks(this, listOfTitleStrings);
    }

    public List<Page> queryLinks(String ... listOfTitleStrings) {
        return this.queryLinks(this.arrayToList(listOfTitleStrings));
    }

    public List<Page> queryImageinfo(List<String> listOfImageStrings) {
        return this.connector.queryImageinfo(this, listOfImageStrings);
    }

    public List<Page> queryImageinfo(List<String> listOfImageStrings, int imageWidth) {
        return this.connector.queryImageinfo(this, listOfImageStrings, imageWidth);
    }

    public List<Page> queryImageinfo(String ... listOfImageStrings) {
        return this.queryImageinfo(this.arrayToList(listOfImageStrings));
    }

    public List<Page> queryImageinfo(String[] listOfImageStrings, int imageWidth) {
        return this.queryImageinfo(this.arrayToList(listOfImageStrings), imageWidth);
    }

    public String getResult() {
        return this.result;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    public String getToken() {
        return this.token;
    }

    protected void setToken(String token) {
        this.token = token;
    }

    public String getUserid() {
        return this.userId;
    }

    protected void setUserid(String userid) {
        this.userId = userid;
    }

    public String getUsername() {
        return this.username;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticated() {
        return SUCCESS_ID.equals(this.result);
    }

    public String toString() {
        return "Result: " + this.result + "; UserID: " + this.userId + "; UserName: " + this.username + "; NormalizedUsername: " + this.normalizedUsername + "; Token: " + this.token + "; ActionURL: " + this.actionUrl;
    }

    public String getNormalizedUsername() {
        return this.normalizedUsername;
    }

    protected void setNormalizedUsername(String normalizedUsername) {
        this.normalizedUsername = normalizedUsername;
    }

    private List<String> arrayToList(String[] listOfTitleStrings) {
        ArrayList<String> list = new ArrayList<String>();
        if (listOfTitleStrings != null) {
            Collections.addAll(list, listOfTitleStrings);
        }
        return list;
    }
}

