/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import rtree.IllegalValueException;
import rtree.RTreeException;
import rtree.StackOverflowException;
import rtree.StackUnderflowException;
import rtree.ThreadInfo;

public class FileHdr {
    int totalNodes;
    long rootIndex;
    protected boolean writeThr = false;
    int stkLimit;
    private int[] S;
    private int topIdx;
    private RandomAccessFile file;
    private String fileName;
    private boolean dirty = false;
    private boolean interested;
    private Vector waiters;

    FileHdr(int stkLimit, String fileName) throws RTreeException {
        try {
            this.file = new RandomAccessFile(fileName, "rw");
            this.fileName = fileName;
            this.writeThr = false;
            this.stkLimit = stkLimit;
            this.waiters = new Vector();
            this.S = new int[this.stkLimit];
            this.topIdx = -1;
            this.writeThr = false;
            if (this.file.length() <= 4L) {
                this.file.seek(0L);
                this.file.writeInt(0);
                this.file.writeLong(-999L);
                this.file.writeInt(-999);
                this.totalNodes = 0;
                this.rootIndex = -999L;
            } else {
                int frNode;
                this.file.seek(0L);
                byte[] data = new byte[4096];
                this.file.read(data);
                DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
                this.totalNodes = ds.readInt();
                this.rootIndex = ds.readLong();
                while (this.topIdx < stkLimit && (frNode = ds.readInt()) != -999) {
                    this.S[++this.topIdx] = frNode;
                }
                ds.close();
            }
        }
        catch (Exception e) {
            throw new RTreeException("FileHdr.FileHdr: " + e.getMessage());
        }
    }

    public void setBufferPolicy(boolean writeThr) throws IOException {
        this.flush();
        this.writeThr = writeThr;
    }

    void update(String fileName) throws RTreeException {
        try {
            this.file.close();
            this.file = new RandomAccessFile(fileName, "rw");
            this.S = new int[this.stkLimit];
            this.topIdx = -1;
            this.dirty = false;
            if (this.file.length() <= 4L) {
                this.file.seek(0L);
                this.file.writeInt(0);
                this.file.writeLong(-999L);
                this.file.writeInt(-999);
                this.totalNodes = 0;
                this.rootIndex = -999L;
            } else {
                int frNode;
                this.file.seek(0L);
                byte[] data = new byte[4096];
                this.file.read(data);
                DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
                this.totalNodes = ds.readInt();
                this.rootIndex = ds.readLong();
                while (this.topIdx < this.stkLimit && (frNode = ds.readInt()) != -999) {
                    this.S[++this.topIdx] = frNode;
                }
                ds.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException("FileHdr.FileHdr: " + e.getMessage());
        }
    }

    void resetHeader() throws Exception {
        this.S = new int[this.stkLimit];
        this.topIdx = -1;
        this.file.setLength(1L);
        this.file.seek(0L);
        this.file.writeInt(0);
        this.file.writeLong(-999L);
        this.file.writeInt(-999);
        this.totalNodes = 0;
        this.rootIndex = -999L;
        this.dirty = false;
    }

    synchronized void push(long lval) throws StackOverflowException, IOException {
        int val = (int)lval;
        if (this.topIdx >= this.stkLimit - 1) {
            throw new StackOverflowException("FileHdr.push: Overflow but not fatal");
        }
        this.S[++this.topIdx] = val;
        this.dirty = true;
        if (this.writeThr) {
            this.file.seek(12 + 4 * this.topIdx);
            this.file.writeInt(val);
            if (this.topIdx < 1019) {
                this.file.writeInt(-999);
            }
        }
    }

    synchronized int pop() throws StackUnderflowException, IOException {
        if (this.topIdx < 0) {
            throw new StackUnderflowException("FileHdr.pop: Underflow");
        }
        if (this.writeThr) {
            this.file.seek(12 + 4 * this.topIdx);
            this.file.writeInt(-999);
        }
        this.dirty = true;
        return this.S[this.topIdx--];
    }

    int stackSize() {
        return this.topIdx + 1;
    }

    int peep(int index) throws IllegalValueException {
        if (index > this.topIdx || index < 0) {
            throw new IllegalValueException("FileHdr.peep: Index out of bound");
        }
        return this.S[index];
    }

    private synchronized void writeFileHeader() throws IOException {
        if (this.dirty) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(4096);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(this.totalNodes);
            ds.writeLong(this.rootIndex);
            if (this.topIdx == -1) {
                ds.writeInt(-999);
            } else {
                for (int i = 0; i <= this.topIdx; ++i) {
                    ds.writeInt(this.S[i]);
                }
                ds.writeInt(-999);
            }
            bs.flush();
            ds.flush();
            this.file.seek(0L);
            this.file.write(bs.toByteArray());
        }
        this.dirty = false;
    }

    synchronized void writeFileHeader(int totNodes, long rootIdx) throws IOException {
        if (this.writeThr) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(12);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(totNodes);
            ds.writeLong(rootIdx);
            bs.flush();
            ds.flush();
            this.file.seek(0L);
            this.file.write(bs.toByteArray());
            this.dirty = false;
        }
        this.dirty = true;
        this.totalNodes = totNodes;
        this.rootIndex = rootIdx;
    }

    public static long getRootIndex(String fileName) throws FileNotFoundException {
        RandomAccessFile fl = new RandomAccessFile(fileName, "r");
        try {
            if (fl.length() == 0L) {
                throw new FileNotFoundException("Node.getRootIndex : File not found");
            }
            fl.seek(4L);
            long rootIndx = fl.readLong();
            fl.close();
            return rootIndx;
        }
        catch (IOException e) {
            System.out.println("Node.getRootIndex: Couldn't get root index");
            return -999L;
        }
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public int getTotalNodes() {
        if (this.topIdx < 0) {
            return this.totalNodes;
        }
        return this.totalNodes - this.topIdx;
    }

    public long getRootIndex() {
        return this.rootIndex;
    }

    protected void finalize() throws Throwable {
        try {
            this.flush();
            this.file.close();
        }
        catch (Exception e) {
            System.err.println(this.fileName);
            e.printStackTrace();
        }
    }

    void flush() throws IOException {
        if (this.dirty && !this.writeThr) {
            this.writeFileHeader();
            this.dirty = false;
        }
    }

    public boolean isWriteThr() {
        return this.writeThr;
    }

    void setDirty(boolean val) {
        this.dirty = val;
    }

    private int firstWriter() {
        Enumeration e = this.waiters.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            ThreadInfo threadinfo = (ThreadInfo)e.nextElement();
            if (threadinfo.lockType == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        Enumeration e = this.waiters.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            ThreadInfo threadinfo = (ThreadInfo)e.nextElement();
            if (threadinfo.t == t) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public synchronized void lockRead() {
        ThreadInfo threadinfo;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            threadinfo = new ThreadInfo(me, 0);
            this.waiters.addElement(threadinfo);
        } else {
            threadinfo = (ThreadInfo)this.waiters.elementAt(index);
        }
        while (this.getIndex(me) >= this.firstWriter()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        ++threadinfo.nAcquired;
    }

    public synchronized void lockWrite() throws IllegalArgumentException {
        ThreadInfo threadinfo;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            threadinfo = new ThreadInfo(me, 1);
            this.waiters.addElement(threadinfo);
        } else {
            threadinfo = (ThreadInfo)this.waiters.elementAt(index);
        }
        while (this.getIndex(me) != 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        ++threadinfo.nAcquired;
    }

    public synchronized void unlock() throws IllegalArgumentException {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index > this.firstWriter()) {
            throw new IllegalArgumentException("FileHdr.unlock: Lock not Held for the thread");
        }
        ThreadInfo threadinfo = (ThreadInfo)this.waiters.elementAt(index);
        --threadinfo.nAcquired;
        if (threadinfo.nAcquired == 0) {
            this.waiters.removeElementAt(index);
            if (this.waiters.size() > 0) {
                this.notifyAll();
            }
        }
    }

    public String toString() {
        try {
            Object str = "";
            str = (String)str + "\nTotal Nodes " + this.totalNodes;
            str = (String)str + "\nRoot Index " + this.rootIndex;
            str = (String)str + "\nFile length " + this.file.length();
            if (this.waiters != null) {
                str = (String)str + "\nWaiters : total " + this.waiters.size();
                for (int i = 0; i < this.waiters.size(); ++i) {
                    str = (String)str + "\n" + i + " : " + this.waiters.get(i).toString();
                }
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Vector getWaiters() {
        return this.waiters;
    }

    synchronized void setWaiters(Vector wtrs) {
        this.waiters = wtrs;
    }
}

