/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.tester;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osmand.MainUtilities;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.router.GeneralRouter;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.NativeTransportRoutingResult;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.router.TransportRoutePlanner;
import net.osmand.router.TransportRoutingConfiguration;
import net.osmand.router.TransportRoutingContext;
import net.osmand.router.tester.RandomRouteEntry;
import net.osmand.router.tester.RandomRouteGenerator;
import net.osmand.router.tester.RandomRouteReport;
import net.osmand.router.tester.RandomRouteResult;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class RandomRouteTester {
    static final String PUBLIC_TRANSPORT_PROFILE = "public_transport";
    static final String PUBLIC_TRANSPORT_PROFILE_UNLIMITED = "public_transport,pt_limit=0";
    static final int MEM_LIMIT = 4096;
    private final MainUtilities.CommandLineOpts opts;
    private String optMapsDir;
    private String optLibsDir;
    private String optObfPrefix;
    private String optHtmlReport;
    private String optHtmlDomain;
    private boolean optNoHtmlReport;
    private boolean optNoNativeLibrary;
    private boolean optStopAtFirstRoute;
    private PrimaryRouting optPrimaryRouting;
    private final long started;
    private NativeLibrary nativeLibrary = null;
    private final List<BinaryMapIndexReader> obfReaders = new ArrayList<BinaryMapIndexReader>();
    private final RandomRouteGenerator generator;
    private final GeneratorConfig config = new GeneratorConfig();
    private List<RandomRouteEntry> testList = new ArrayList<RandomRouteEntry>();
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_TEST_FAILED = 1;
    public static final int EXIT_RED_LIMIT_REACHED = 2;

    public static void main(String[] args) throws Exception {
        System.exit(RandomRouteTester.run(args));
    }

    public static int run(String[] args) throws Exception {
        PlatformUtil.initOsmandRegionsAsTempFile();
        RandomRouteTester test = new RandomRouteTester(args);
        test.applyCommandLineOpts();
        test.loadNativeLibrary();
        test.initObfReaders();
        test.generateRoutes();
        test.startSlowDown();
        test.collectRoutes();
        test.stopSlowDown();
        return test.reportResult();
    }

    private RandomRouteTester(String[] args) {
        this.opts = new MainUtilities.CommandLineOpts(args);
        this.started = System.currentTimeMillis();
        this.generator = new RandomRouteGenerator(this.config);
    }

    private Boolean isFileWriteable(String name) {
        Path path = Paths.get(name, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isWritable(path)) {
            return true;
        }
        Path parent = path.normalize().toAbsolutePath().getParent();
        return Files.exists(parent, new LinkOption[0]) && Files.isWritable(parent);
    }

    private void applyCommandLineOpts() {
        this.optMapsDir = this.opts.getOrDefault("--maps-dir", "./");
        this.optObfPrefix = this.opts.getOrDefault("--obf-prefix", "");
        this.optHtmlReport = this.opts.getOrDefault("--html-report", "rr-report.html");
        this.optHtmlDomain = this.opts.getOrDefault("--html-domain", "test.osmand.net");
        this.optLibsDir = this.opts.getOrDefault("--libs-dir", this.optMapsDir + "/../core-legacy/binaries");
        this.optNoHtmlReport = this.opts.getBoolean("--no-html-report");
        this.optNoNativeLibrary = this.opts.getBoolean("--no-native-library");
        this.optStopAtFirstRoute = this.opts.getBoolean("--stop-at-first-route");
        if (this.opts.getBoolean("--use-hh-points")) {
            this.config.optRandomPointsSource = RandomPointsSource.HH_SECTION_POINTS;
        }
        if (!this.isFileWriteable(this.optHtmlReport).booleanValue()) {
            throw new IllegalStateException(this.optHtmlReport + " (html-report) file is not writable");
        }
        this.config.ITERATIONS = this.opts.getIntOrDefault("--iterations", this.config.ITERATIONS);
        this.config.MIN_DISTANCE_KM = this.opts.getIntOrDefault("--min-dist", this.config.MIN_DISTANCE_KM);
        this.config.MAX_DISTANCE_KM = this.opts.getIntOrDefault("--max-dist", this.config.MAX_DISTANCE_KM);
        this.config.MAX_INTER_POINTS = this.opts.getIntOrDefault("--max-inter", this.config.MAX_INTER_POINTS);
        this.config.MAX_SHIFT_ALL_POINTS_M = this.opts.getIntOrDefault("--max-shift", this.config.MAX_SHIFT_ALL_POINTS_M);
        this.config.DEVIATION_RED = Algorithms.parseDoubleSilently((String)this.opts.getOpt("--red"), (double)this.config.DEVIATION_RED);
        this.config.DEVIATION_YELLOW = Algorithms.parseDoubleSilently((String)this.opts.getOpt("--yellow"), (double)this.config.DEVIATION_YELLOW);
        if (this.opts.getOpt("--profile") != null) {
            this.config.RANDOM_PROFILES = new String[]{this.opts.getOpt("--profile")};
        }
        if (!this.opts.getStrings().isEmpty()) {
            this.config.PREDEFINED_TESTS = this.opts.getStrings().toArray(new String[0]);
        }
        if (this.opts.getOpt("--primary") != null) {
            if ("brp-java".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.BRP_JAVA;
            } else if ("brp-cpp".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.BRP_CPP;
            } else if ("hh-java".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.HH_JAVA;
            } else if ("hh-cpp".equals(this.opts.getOpt("--primary"))) {
                this.optPrimaryRouting = PrimaryRouting.HH_CPP;
            }
        }
        if (this.opts.getBoolean("--car-2phase")) {
            this.config.CAR_2PHASE_MODE = true;
        }
        if (this.opts.getBoolean("--no-conditionals")) {
            this.config.USE_TIME_CONDITIONAL_ROUTING = 0L;
        }
        if (this.opts.getBoolean("--help")) {
            System.err.printf("%s\n", String.join((CharSequence)"\n", "", "Usage: random-route-tester [--options] [TEST_ROUTE(s)]", "", "[TEST_ROUTE] run specific test (url or query_string format)", "", "--maps-dir=/path/to/directory/with/*.obf (default ./)", "--obf-prefix=prefix to filter obf files (default all)", "", "--no-html-report do not create html report", "--html-report=/path/to/report.html (rr-report.html)", "--html-domain=test.osmand.net (route-href in html-report)", "", "--no-native-library useful for Java-only tests", "--libs-dir=/path/to/native/libs/dir (default auto)", "", "--iterations=N", "--min-dist=N km", "--max-dist=N km", "--max-shift=N meters", "--max-inter=N number", "--profile=profile,settings,key:value force one profile", "--profile=public_transport,settings,key:value run PT test", "--stop-at-first-route stop iterations and return 1st calculated route", "", "--primary=(brp-java|brp-cpp|hh-java|hh-cpp) compare others against this", "--avoid-brp-java avoid BinaryRoutePlanner (java)", "--avoid-brp-cpp avoid BinaryRoutePlanner (cpp)", "--avoid-hh-java avoid HHRoutePlanner (java)", "--avoid-hh-cpp avoid HHRoutePlanner (cpp)", "", "--use-hh-points use random HH-points instead of highway-points", "--car-2phase use COMPLEX mode for car (Android default)", "--no-conditionals disable *:conditional restrictions", "", "--yellow=N % yellow-color limit", "--red=N % red-color limit (affects exit code)", "", "--help show help", ""));
            System.exit(0);
        }
    }

    private int reportResult() throws IOException {
        long runTime = System.currentTimeMillis() - this.started;
        RandomRouteReport report = new RandomRouteReport(runTime, this.obfReaders.size(), this.testList.size(), this.config.DEVIATION_RED, this.config.DEVIATION_YELLOW, this.optHtmlDomain, this.config.CAR_2PHASE_MODE);
        for (int i = 0; i < this.testList.size(); ++i) {
            RandomRouteResult result;
            RandomRouteResult primary;
            int j;
            report.entryOpen(i + 1);
            RandomRouteEntry entry = this.testList.get(i);
            for (j = 0; j < entry.routeResults.size(); ++j) {
                primary = entry.routeResults.get(0);
                result = entry.routeResults.get(j);
                if (j == 0) {
                    report.resultPrimary(i + 1, primary);
                    continue;
                }
                report.resultCompare(i + 1, result, primary);
            }
            for (j = 0; j < entry.transportResults.size(); ++j) {
                primary = entry.transportResults.get(0);
                result = entry.transportResults.get(j);
                if (j == 0) {
                    report.resultPrimary(i + 1, primary);
                    continue;
                }
                report.resultCompare(i + 1, result, primary);
            }
            report.entryClose();
        }
        if (!this.optNoHtmlReport) {
            report.flush(this.optHtmlReport);
        }
        if (report.isFailed()) {
            return 1;
        }
        if (report.isDeviated()) {
            return 2;
        }
        return 0;
    }

    private void initObfReaders() throws IOException {
        ArrayList<Object> obfFiles = new ArrayList<Object>();
        File obfDirectory = new File(this.optMapsDir);
        if (obfDirectory.isDirectory()) {
            for (File f : Algorithms.getSortedFilesVersions((File)obfDirectory)) {
                if (!f.isFile() || !f.getName().endsWith(".obf") || !f.getName().startsWith(this.optObfPrefix)) continue;
                obfFiles.add(f);
            }
        } else {
            obfFiles.add(obfDirectory);
        }
        for (File file : obfFiles) {
            System.out.printf("Use OBF %s ...\n", file.getName());
            if (this.nativeLibrary != null) {
                this.nativeLibrary.initMapFile(file.getAbsolutePath(), true);
            }
            this.obfReaders.add(new BinaryMapIndexReader(new RandomAccessFile(file, "r"), file));
        }
        if (this.obfReaders.isEmpty()) {
            throw new IllegalStateException("OBF files not initialized");
        }
    }

    private void generateRoutes() {
        this.testList = this.generator.generateTestList(this.obfReaders);
    }

    private void startSlowDown() {
        Runnable endless = () -> {
            while (this.config.OPTIONAL_SLOW_DOWN_THREADS > 0) {
                for (long i = 0L; i < 1000000000L; ++i) {
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (int i = 0; i < this.config.OPTIONAL_SLOW_DOWN_THREADS; ++i) {
            new Thread(endless).start();
        }
    }

    private void stopSlowDown() {
        this.config.OPTIONAL_SLOW_DOWN_THREADS = 0;
    }

    private void collectRoutes() {
        for (int i = 0; i < this.testList.size(); ++i) {
            RandomRouteEntry entry = this.testList.get(i);
            if (entry.isPublicTransport()) {
                this.opts.setOpt("--avoid-hh-java", "true");
                this.opts.setOpt("--avoid-hh-cpp", "true");
            }
            try {
                if (this.optPrimaryRouting != null) {
                    switch (this.optPrimaryRouting) {
                        case BRP_JAVA: {
                            this.opts.setOpt("--avoid-brp-java", "true");
                            if (entry.isPublicTransport()) {
                                entry.transportResults.add(this.runTransportRoutePlannerJava(entry));
                                break;
                            }
                            entry.routeResults.add(this.runBinaryRoutePlannerJava(entry));
                            break;
                        }
                        case BRP_CPP: {
                            this.opts.setOpt("--avoid-brp-cpp", "true");
                            if (entry.isPublicTransport()) {
                                entry.transportResults.add(this.runTransportRoutePlannerCpp(entry));
                                break;
                            }
                            entry.routeResults.add(this.runBinaryRoutePlannerCpp(entry));
                            break;
                        }
                        case HH_JAVA: {
                            this.opts.setOpt("--avoid-hh-java", "true");
                            entry.routeResults.add(this.runHHRoutePlannerJava(entry));
                            break;
                        }
                        case HH_CPP: {
                            this.opts.setOpt("--avoid-hh-cpp", "true");
                            entry.routeResults.add(this.runHHRoutePlannerCpp(entry));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Wrong primary routing defined");
                        }
                    }
                }
                if (!this.opts.getBoolean("--avoid-brp-java")) {
                    if (entry.isPublicTransport()) {
                        entry.transportResults.add(this.runTransportRoutePlannerJava(entry));
                    } else {
                        entry.routeResults.add(this.runBinaryRoutePlannerJava(entry));
                    }
                }
                if (!this.opts.getBoolean("--avoid-brp-cpp")) {
                    if (entry.isPublicTransport()) {
                        entry.transportResults.add(this.runTransportRoutePlannerCpp(entry));
                    } else {
                        entry.routeResults.add(this.runBinaryRoutePlannerCpp(entry));
                    }
                }
                if (!this.opts.getBoolean("--avoid-hh-java")) {
                    entry.routeResults.add(this.runHHRoutePlannerJava(entry));
                }
                if (!this.opts.getBoolean("--avoid-hh-cpp")) {
                    entry.routeResults.add(this.runHHRoutePlannerCpp(entry));
                }
            }
            catch (IOException | InterruptedException | SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!entry.routeResults.isEmpty() || !entry.transportResults.isEmpty()) {
                    int j;
                    String sep = "---------------------------------------------------------------------------------";
                    System.err.println(sep);
                    for (j = 0; j < entry.routeResults.size(); ++j) {
                        System.err.println(RandomRouteReport.resultPrimaryText(i + 1, entry.routeResults.get(j)));
                    }
                    for (j = 0; j < entry.transportResults.size(); ++j) {
                        System.err.println(RandomRouteReport.resultPrimaryText(i + 1, entry.transportResults.get(j)));
                    }
                    System.err.println(sep);
                }
            }
            if (!this.optStopAtFirstRoute || entry.routeResults.isEmpty() || !(entry.routeResults.get((int)0).distance > 0.0f)) continue;
            this.testList = new ArrayList<RandomRouteEntry>(List.of(entry));
            break;
        }
    }

    private RandomRouteResult runTransportRoutePlannerJava(RandomRouteEntry entry) throws IOException, InterruptedException {
        return this.runTransportRoutePlanner(entry, false);
    }

    private RandomRouteResult runTransportRoutePlannerCpp(RandomRouteEntry entry) throws IOException, InterruptedException {
        return this.runTransportRoutePlanner(entry, true);
    }

    private RandomRouteResult runBinaryRoutePlannerJava(RandomRouteEntry entry) throws IOException, InterruptedException {
        return this.runBinaryRoutePlanner(entry, false);
    }

    private RandomRouteResult runBinaryRoutePlannerCpp(RandomRouteEntry entry) throws IOException, InterruptedException {
        return this.runBinaryRoutePlanner(entry, true);
    }

    private RandomRouteResult runTransportRoutePlanner(RandomRouteEntry entry, boolean useNative) throws IOException, InterruptedException {
        List results;
        long started = System.currentTimeMillis();
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        GeneralRouter ptRouter = builder.getRouter(PUBLIC_TRANSPORT_PROFILE);
        Map<String, String> routeParameters = this.getDefaultParameters(ptRouter);
        routeParameters.putAll(entry.mapParams());
        TransportRoutingConfiguration cfg = new TransportRoutingConfiguration(ptRouter, routeParameters);
        TransportRoutingContext ctx = new TransportRoutingContext(cfg, this.nativeLibrary, this.obfReaders.toArray(new BinaryMapIndexReader[0]));
        TransportRoutePlanner planner = new TransportRoutePlanner();
        if (useNative) {
            NativeTransportRoutingResult[] nativeRes = ctx.library.runNativePTRouting(MapUtils.get31TileNumberX((double)entry.start.getLongitude()), MapUtils.get31TileNumberY((double)entry.start.getLatitude()), MapUtils.get31TileNumberX((double)entry.finish.getLongitude()), MapUtils.get31TileNumberY((double)entry.finish.getLatitude()), cfg, null);
            results = TransportRoutePlanner.convertToTransportRoutingResult((NativeTransportRoutingResult[])nativeRes, (TransportRoutingConfiguration)cfg);
        } else {
            results = planner.buildRoute(ctx, entry.start, entry.finish);
        }
        long runTime = System.currentTimeMillis() - started;
        return new RandomRouteResult(useNative ? "transport-cpp" : "transport-java", entry, runTime, results);
    }

    private Map<String, String> getDefaultParameters(GeneralRouter router) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Map.Entry entry : router.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            GeneralRouter.RoutingParameter rp = (GeneralRouter.RoutingParameter)entry.getValue();
            if (rp.getType() == GeneralRouter.RoutingParameterType.BOOLEAN) {
                if (!rp.getDefaultBoolean()) continue;
                params.put(key, "true");
                continue;
            }
            if (!(rp.getDefaultNumeric() > 0.0)) continue;
            params.put(key, rp.getDefaultString());
        }
        return params;
    }

    private RandomRouteResult runBinaryRoutePlanner(RandomRouteEntry entry, boolean useNative) throws IOException, InterruptedException {
        RoutePlannerFrontEnd.RouteCalculationMode mode;
        long started = System.currentTimeMillis();
        RoutePlannerFrontEnd fe = new RoutePlannerFrontEnd();
        RoutePlannerFrontEnd.CALCULATE_MISSING_MAPS = false;
        fe.setHHRoutingConfig(null);
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimits = new RoutingConfiguration.RoutingMemoryLimits(4096, 4096);
        RoutingConfiguration config = builder.build(entry.profile, memoryLimits, entry.mapParams());
        RoutePlannerFrontEnd.RouteCalculationMode routeCalculationMode = mode = this.config.CAR_2PHASE_MODE && "car".equals(entry.profile) ? RoutePlannerFrontEnd.RouteCalculationMode.COMPLEX : RoutePlannerFrontEnd.RouteCalculationMode.NORMAL;
        if (this.config.USE_TIME_CONDITIONAL_ROUTING == 1L) {
            config.routeCalculationTime = System.currentTimeMillis();
        } else if (this.config.USE_TIME_CONDITIONAL_ROUTING != 0L) {
            config.routeCalculationTime = this.config.USE_TIME_CONDITIONAL_ROUTING;
        }
        if (GeneratorConfig.ambiguousConditionalTags != null) {
            config.ambiguousConditionalTags = GeneratorConfig.ambiguousConditionalTags;
        }
        RoutingContext ctx = fe.buildRoutingContext(config, useNative ? this.nativeLibrary : null, this.obfReaders.toArray(new BinaryMapIndexReader[0]), mode);
        RouteResultPreparation.RouteCalcResult res = fe.searchRoute(ctx, entry.start, entry.finish, entry.via, null);
        List routeSegments = res != null ? res.getList() : new ArrayList();
        long runTime = System.currentTimeMillis() - started;
        return new RandomRouteResult(useNative ? "brp-cpp" : "brp-java", entry, runTime, ctx, routeSegments);
    }

    private RandomRouteResult runHHRoutePlannerJava(RandomRouteEntry entry) throws SQLException, IOException, InterruptedException {
        return this.runHHRoutePlanner(entry, false);
    }

    private RandomRouteResult runHHRoutePlannerCpp(RandomRouteEntry entry) throws SQLException, IOException, InterruptedException {
        return this.runHHRoutePlanner(entry, true);
    }

    private RandomRouteResult runHHRoutePlanner(RandomRouteEntry entry, boolean useNative) throws IOException, InterruptedException {
        long started = System.currentTimeMillis();
        HHRoutePlanner.DEBUG_VERBOSE_LEVEL = 1;
        HHRouteDataStructure.HHRoutingConfig.STATS_VERBOSE_LEVEL = 1;
        RouteResultPreparation.PRINT_TO_CONSOLE_ROUTE_INFORMATION = true;
        RoutePlannerFrontEnd fe = new RoutePlannerFrontEnd();
        RoutePlannerFrontEnd.CALCULATE_MISSING_MAPS = false;
        fe.setDefaultHHRoutingConfig();
        fe.setUseOnlyHHRouting(true);
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimits = new RoutingConfiguration.RoutingMemoryLimits(4096, 4096);
        RoutingConfiguration config = builder.build(entry.profile, memoryLimits, entry.mapParams());
        if (this.config.USE_TIME_CONDITIONAL_ROUTING == 1L) {
            config.routeCalculationTime = System.currentTimeMillis();
        } else if (this.config.USE_TIME_CONDITIONAL_ROUTING != 0L) {
            config.routeCalculationTime = this.config.USE_TIME_CONDITIONAL_ROUTING;
        }
        if (GeneratorConfig.ambiguousConditionalTags != null) {
            config.ambiguousConditionalTags = GeneratorConfig.ambiguousConditionalTags;
        }
        RoutingContext ctx = fe.buildRoutingContext(config, useNative ? this.nativeLibrary : null, this.obfReaders.toArray(new BinaryMapIndexReader[0]), RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
        fe.setHHRouteCpp(useNative);
        RouteResultPreparation.RouteCalcResult res = fe.searchRoute(ctx, entry.start, entry.finish, entry.via, null);
        List routeSegments = res != null ? res.getList() : new ArrayList();
        long runTime = System.currentTimeMillis() - started;
        return new RandomRouteResult(useNative ? "hh-cpp" : "hh-java", entry, runTime, ctx, routeSegments);
    }

    private void loadNativeLibrary() {
        if (this.optNoNativeLibrary) {
            return;
        }
        String nativePath = this.getNativeLibPath();
        if (NativeLibrary.loadOldLib((String)nativePath)) {
            this.nativeLibrary = new NativeLibrary();
            return;
        }
        throw new IllegalStateException("Native library not loaded");
    }

    private String getNativeLibPath() {
        Path path = FileSystems.getDefault().getPath(this.optLibsDir, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            path = FileSystems.getDefault().getPath(this.optLibsDir.replaceFirst("../", "../../"), new String[0]);
        }
        if (Files.exists(path, new LinkOption[0])) {
            File nativeLibPath = path.normalize().toAbsolutePath().toFile();
            for (File f1 : Objects.requireNonNull(nativeLibPath.listFiles())) {
                if (!f1.isDirectory()) continue;
                for (File f2 : Objects.requireNonNull(f1.listFiles())) {
                    if (!f2.isDirectory()) continue;
                    File libDir = this.getLatestLib(f2.listFiles());
                    return libDir == null ? f2.getAbsolutePath() : libDir.getAbsolutePath();
                }
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                return nativeLibPath.getAbsolutePath();
            }
        }
        return null;
    }

    private File getLatestLib(File[] f3) {
        File libDir = null;
        for (File f4 : Objects.requireNonNull(f3)) {
            if (!f4.isDirectory() || !f4.getName().equals("Release") && !f4.getName().equals("Debug")) continue;
            if (libDir == null) {
                libDir = f4.getAbsoluteFile();
                continue;
            }
            if (libDir.lastModified() >= f4.lastModified()) continue;
            libDir = f4;
        }
        return libDir;
    }

    static class GeneratorConfig {
        String[] PREDEFINED_TESTS = new String[0];
        int ITERATIONS = 10;
        int MAX_INTER_POINTS = 0;
        int MIN_DISTANCE_KM = 10;
        int MAX_DISTANCE_KM = 20;
        int MAX_SHIFT_ALL_POINTS_M = 500;
        int OPTIONAL_SLOW_DOWN_THREADS = 0;
        String[] RANDOM_PROFILES = new String[]{"public_transport,pt_limit=0"};
        double DEVIATION_RED = 5.0;
        double DEVIATION_YELLOW = 1.0;
        boolean CAR_2PHASE_MODE = false;
        long USE_TIME_CONDITIONAL_ROUTING = 1L;
        static final Map<String, String> ambiguousConditionalTags = null;
        RandomPointsSource optRandomPointsSource = RandomPointsSource.ROUTE_SECTION_POINTS;

        GeneratorConfig() {
        }
    }

    public static enum RandomPointsSource {
        ROUTE_SECTION_POINTS,
        HH_SECTION_POINTS;

    }

    private static enum PrimaryRouting {
        BRP_JAVA,
        BRP_CPP,
        HH_JAVA,
        HH_CPP;

    }
}

