/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.osmand.data.LatLon;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelLayer;
import net.osmand.swing.Messages;
import net.osmand.swing.NativePreferencesDialog;
import net.osmand.swing.OsmExtractionUI;
import net.osmand.swing.QtCorePanel;
import net.osmand.swing.SelectPointDialog;
import net.osmand.swing.TileBundleDownloadDialog;

public class MapInformationLayer
implements MapPanelLayer {
    private MapPanel map;
    private JButton setStart;
    private JButton setEnd;
    private JButton areaButton;

    @Override
    public void destroyLayer() {
    }

    public void addSetStartActionListener(ActionListener listener) {
        this.setStart.addActionListener(listener);
    }

    public void addSetEndActionListener(ActionListener listener) {
        this.setEnd.addActionListener(listener);
    }

    @Override
    public void initLayer(final MapPanel map) {
        this.map = map;
        BoxLayout layout = new BoxLayout(map, 1);
        map.setLayout(layout);
        map.setBorder(BorderFactory.createEmptyBorder(2, 10, 10, 10));
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 2));
        btnPanel.setOpaque(false);
        this.setStart = new JButton("S");
        this.setEnd = new JButton("E");
        JButton zoomIn = new JButton("+");
        JButton zoomOut = new JButton("-");
        JButton offline = new JButton("*");
        this.areaButton = new JButton();
        this.areaButton.setAction(new AbstractAction(Messages.getString("MapInformationLayer.PRELOAD.AREA")){
            private static final long serialVersionUID = -5512220294374994021L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new TileBundleDownloadDialog(map, map).showDialog();
            }
        });
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                map.setZoom(map.getZoom() + 1);
            }
        });
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                map.setZoom(map.getZoom() - 1);
            }
        });
        offline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!QtCorePanel.isUnix()) {
                    JOptionPane.showMessageDialog(OsmExtractionUI.MAIN_APP.getFrame(), "Native rendering supported only on Linux", "Info", 0);
                    return;
                }
                NativePreferencesDialog dlg = new NativePreferencesDialog(map);
                dlg.showDialog();
                if (dlg.isOkPressed()) {
                    String folder = DataExtractionSettings.getSettings().getQtLibFolder();
                    if (folder.equals("")) {
                        folder = new File("lib").getAbsolutePath();
                    }
                    QtCorePanel.loadNative(folder);
                    QtCorePanel sample = new QtCorePanel(new LatLon(map.getLatitude(), map.getLongitude()), map.getZoom());
                    sample.setRenderingProperties(DataExtractionSettings.getSettings().getRenderingProperties());
                    sample.setRenderingStyleFile(DataExtractionSettings.getSettings().getRenderXmlPath());
                    Frame frame = sample.showFrame(800, 600);
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            map.loadSettingsLocation();
                            map.refresh();
                        }
                    });
                }
            }
        });
        this.areaButton.setVisible(false);
        this.areaButton.setAlignmentY(0.0f);
        this.setStart.setAlignmentY(0.0f);
        this.setEnd.setAlignmentY(0.0f);
        zoomOut.setAlignmentY(0.0f);
        zoomIn.setAlignmentY(0.0f);
        offline.setAlignmentY(0.0f);
        map.add(btnPanel);
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(this.areaButton);
        btnPanel.add(this.setStart);
        btnPanel.add(this.setEnd);
        btnPanel.add(zoomIn);
        btnPanel.add(zoomOut);
        btnPanel.add(offline);
        this.applySettings();
    }

    @Override
    public void fillPopupMenuWithActions(JPopupMenu popupMenu) {
        AbstractAction selectMenu = new AbstractAction("Select point..."){
            private static final long serialVersionUID = -3022499800877796459L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPointDialog dlg = new SelectPointDialog(MapInformationLayer.this.map, new LatLon(MapInformationLayer.this.map.getLatitude(), MapInformationLayer.this.map.getLongitude()));
                dlg.showDialog();
                LatLon l = dlg.getResult();
                if (l != null) {
                    MapInformationLayer.this.map.setLatLon(l.getLatitude(), l.getLongitude());
                    MapInformationLayer.this.map.setZoom(15);
                }
            }
        };
        popupMenu.add(selectMenu);
    }

    public void setAreaButtonVisible(boolean b) {
        this.areaButton.setVisible(b);
    }

    public void setAreaActionHandler(Action a) {
        this.areaButton.setAction(a);
    }

    @Override
    public void applySettings() {
        DataExtractionSettings settings = DataExtractionSettings.getSettings();
        this.setStart.setVisible(settings.useAdvancedRoutingUI());
        this.setEnd.setVisible(settings.useAdvancedRoutingUI());
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void paintLayer(Graphics2D g) {
        g.setColor(Color.black);
        g.fillOval((int)this.map.getCenterPointX() - 2, (int)this.map.getCenterPointY() - 2, 4, 4);
        g.drawOval((int)this.map.getCenterPointX() - 2, (int)this.map.getCenterPointY() - 2, 4, 4);
        g.drawOval((int)this.map.getCenterPointX() - 5, (int)this.map.getCenterPointY() - 5, 10, 10);
    }
}

