/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.wikidata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import net.osmand.PlatformUtil;
import net.osmand.impl.FileProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.util.Algorithms;
import net.osmand.wiki.OsmCoordinatesByTag;
import net.osmand.wiki.wikidata.ArticleMapper;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class WikiDataHandler
extends DefaultHandler {
    private static final Log log = PlatformUtil.getLog(WikiDataHandler.class);
    private final SAXParser saxParser;
    private boolean page = false;
    private StringBuilder ctext = null;
    private final StringBuilder title = new StringBuilder();
    private final StringBuilder ns = new StringBuilder();
    private final StringBuilder text = new StringBuilder();
    private final StringBuilder format = new StringBuilder();
    private String lastRevisionText = null;
    private FileProgressImplementation progress;
    private Connection conn;
    private PreparedStatement coordsPrep;
    private PreparedStatement mappingPrep;
    private PreparedStatement wikiRegionPrep;
    private PreparedStatement wikidataPropPrep;
    private PreparedStatement wikidataBlobPrep;
    private int[] mappingBatch = new int[]{0};
    private int[] coordsBatch = new int[]{0};
    private int[] regionBatch = new int[]{0};
    private int[] wikidataPropBatch = new int[]{0};
    private int[] wikidataBlobBatch = new int[]{0};
    public static final int BATCH_SIZE = 5000;
    private static final int ARTICLE_BATCH_SIZE = 10000;
    private static final int ERROR_BATCH_SIZE = 200;
    private int articleCount = 0;
    private int errorCount = 0;
    private Gson gson;
    private OsmandRegions regions;
    private List<String> keyNames = new ArrayList<String>();
    OsmCoordinatesByTag osmWikiCoordinates;
    private long lastProcessedId;
    private long limit = -1L;
    private Map<Long, String> allAstroWids;

    public WikiDataHandler(SAXParser saxParser, FileProgressImplementation progress, File wikidataSqlite, OsmCoordinatesByTag osmWikiCoordinates, OsmandRegions regions, long lastProcessedId) throws SQLException {
        this.saxParser = saxParser;
        this.osmWikiCoordinates = osmWikiCoordinates;
        this.regions = regions;
        this.progress = progress;
        this.lastProcessedId = lastProcessedId;
        DBDialect dialect = DBDialect.SQLITE;
        this.conn = dialect.getDatabaseConnection(wikidataSqlite.getAbsolutePath(), log);
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_coords(id bigint PRIMARY KEY, originalId text, lat double, lon double, wlat double, wlon double, osmtype int, osmid bigint, poitype text, poisubtype text, labelsJson text)");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_mapping(id bigint, lang text, title text, UNIQUE(id, lang))");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wiki_region(id bigint, regionName text, UNIQUE(id, regionName))");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wikidata_properties(id bigint, type text, value text, UNIQUE(id, type))");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS wikidata_blobs(id bigint PRIMARY KEY, page blob)");
        this.coordsPrep = this.conn.prepareStatement("INSERT INTO wiki_coords(id, originalId, lat, lon, wlat, wlon, osmtype, osmid, poitype, poisubtype, labelsJson)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(id) DO UPDATE SET\noriginalId = excluded.originalId,\nlat = excluded.lat,\nlon = excluded.lon,\nwlat = excluded.wlat,\nwlon = excluded.wlon,\nosmtype = excluded.osmtype,\nosmid = excluded.osmid,\npoitype = excluded.poitype,\npoisubtype = excluded.poisubtype,\nlabelsJson = excluded.labelsJson;\n");
        this.mappingPrep = this.conn.prepareStatement("INSERT INTO wiki_mapping(id, lang, title) VALUES (?, ?, ?)\nON CONFLICT(id, lang) DO UPDATE SET\ntitle = excluded.title;\n");
        this.wikiRegionPrep = this.conn.prepareStatement("INSERT OR IGNORE INTO wiki_region(id, regionName) VALUES(?, ? )");
        this.wikidataPropPrep = this.conn.prepareStatement("INSERT INTO wikidata_properties(id, type, value) VALUES(?, ?, ?)\nON CONFLICT(id, type) DO UPDATE SET\nvalue = excluded.value;\n");
        this.wikidataBlobPrep = this.conn.prepareStatement("INSERT INTO wikidata_blobs(id, page) VALUES(?, ?)\nON CONFLICT(id) DO UPDATE SET\npage = excluded.page;\n");
        this.gson = new GsonBuilder().registerTypeAdapter(ArticleMapper.Article.class, (Object)new ArticleMapper()).create();
        this.allAstroWids = WikiDataHandler.getAllAstroWids();
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public static Map<Long, String> getAllAstroWids() {
        HashMap<Long, String> wids = new HashMap<Long, String>();
        Gson gson = new Gson();
        Type listType = new TypeToken<List<AstroObject>>(){}.getType();
        String path = "/astro";
        try {
            URL url = WikiDataHandler.class.getResource(path);
            if (url == null) {
                return wids;
            }
            ArrayList<CallSite> jsonPaths = new ArrayList<CallSite>();
            if (url.getProtocol().equals("jar")) {
                String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
                try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(Paths.get(jarPath, new String[0]), new OpenOption[0]));){
                    ZipEntry entry;
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (entry.isDirectory() || !entry.getName().startsWith("astro/") || !entry.getName().endsWith(".json")) continue;
                        jsonPaths.add((CallSite)((Object)("/" + entry.getName())));
                    }
                }
            }
            try (Stream<Path> walk = Files.walk(Paths.get(url.toURI()), 1, new FileVisitOption[0]);){
                walk.filter(p -> p.toString().endsWith(".json")).forEach(p -> jsonPaths.add((CallSite)((Object)(path + "/" + p.getFileName().toString()))));
            }
            for (String string : jsonPaths) {
                try (InputStreamReader reader = new InputStreamReader(WikiDataHandler.class.getResourceAsStream(string));){
                    List objects = (List)gson.fromJson((Reader)reader, new TypeToken<List<AstroObject>>(){}.getType());
                    if (objects == null) continue;
                    String type = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf(46));
                    for (AstroObject obj : objects) {
                        if (obj.wid == null || !obj.wid.startsWith("Q")) continue;
                        wids.put(Long.parseLong(obj.wid.substring(1)), type);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wids;
    }

    public void addBatch(PreparedStatement prep, int[] bt) throws SQLException {
        prep.addBatch();
        bt[0] = bt[0] + 1;
        int batch = bt[0];
        if (batch > 5000) {
            prep.executeBatch();
            bt[0] = 0;
        }
    }

    public void finish() throws SQLException {
        log.info((Object)("Total accepted: " + this.articleCount));
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS map_lang_title_idx ON wiki_mapping(lang, title)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_mapping_index on wiki_mapping(id)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_coords_idx on wiki_coords(id)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_coords_originalId on wiki_coords(originalId)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_region_idx on wiki_region(id)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS reg_region_idx on wiki_region(regionName)");
        this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS wikidata_properties_idx on wikidata_properties(id)");
        this.coordsPrep.executeBatch();
        this.mappingPrep.executeBatch();
        this.wikiRegionPrep.executeBatch();
        this.wikidataPropPrep.executeBatch();
        this.wikidataBlobPrep.executeBatch();
        if (!this.conn.getAutoCommit()) {
            this.conn.commit();
        }
        this.mappingPrep.close();
        this.coordsPrep.close();
        this.wikiRegionPrep.close();
        this.wikidataPropPrep.close();
        this.wikidataBlobPrep.close();
        this.conn.close();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String name;
        String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
        if (!this.page) {
            this.page = name.equals("page");
        } else {
            switch (name) {
                case "title": {
                    this.title.setLength(0);
                    this.ctext = this.title;
                    break;
                }
                case "ns": {
                    this.ns.setLength(0);
                    this.ctext = this.ns;
                    break;
                }
                case "text": {
                    this.text.setLength(0);
                    this.ctext = this.text;
                    break;
                }
                case "format": {
                    this.format.setLength(0);
                    this.ctext = this.format;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.page && this.ctext != null) {
            this.ctext.append(ch, start, length);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        block18: {
            v0 = name = this.saxParser.isNamespaceAware() != false ? localName : qName;
            if (!this.page) break block18;
            var5_5 = name;
            var6_6 = -1;
            switch (var5_5.hashCode()) {
                case -260786213: {
                    if (!var5_5.equals("revision")) break;
                    var6_6 = 0;
                    break;
                }
                case 3433103: {
                    if (!var5_5.equals("page")) break;
                    var6_6 = 1;
                    break;
                }
                case 110371416: {
                    if (!var5_5.equals("title")) break;
                    var6_6 = 2;
                    break;
                }
                case 3525: {
                    if (!var5_5.equals("ns")) break;
                    var6_6 = 3;
                    break;
                }
                case -1268779017: {
                    if (!var5_5.equals("format")) break;
                    var6_6 = 4;
                    break;
                }
                case 3556653: {
                    if (!var5_5.equals("text")) break;
                    var6_6 = 5;
                }
            }
            switch (var6_6) {
                case 0: {
                    this.lastRevisionText = this.text.toString();
                    break;
                }
                case 1: {
                    this.page = false;
                    this.progress.update();
                    if (this.limit > 0L && (long)this.articleCount >= this.limit) {
                        throw new IllegalStateException();
                    }
                    if (this.ns.charAt(0) != '0' || this.lastRevisionText == null || !"application/json".contentEquals(this.format)) ** GOTO lbl49
                    try {
                        if (this.title.charAt(0) == 'Q' && (id = Long.parseLong(this.title.substring(1))) >= this.lastProcessedId) {
                            this.processJsonPage(id, this.lastRevisionText);
                        }
                    }
                    catch (Exception e) {
                        ++this.errorCount;
                        if (this.errorCount == 200) {
                            WikiDataHandler.log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        if (this.errorCount % 200 != 0) ** GOTO lbl49
                        WikiDataHandler.log.error((Object)String.format("Error pages %s (total %d)", new Object[]{this.title, this.errorCount}));
                    }
lbl49:
                    // 4 sources

                    this.lastRevisionText = null;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.ctext = null;
                }
            }
        }
    }

    public void processJsonPage(long id, String json) throws SQLException, IOException {
        String starType = this.allAstroWids.get(id);
        boolean storeJson = starType != null;
        ArticleMapper.Article article = (ArticleMapper.Article)this.gson.fromJson(json, ArticleMapper.Article.class);
        OsmCoordinatesByTag.OsmLatLonId osmCoordinates = null;
        double wlat = article.getLat();
        double wlon = article.getLon();
        if ((osmCoordinates = this.getOsmCoordinates(id, article, osmCoordinates)) != null) {
            article.setLat(osmCoordinates.lat);
            article.setLon(osmCoordinates.lon);
        }
        if (article.getLat() != 0.0 || article.getLon() != 0.0 || starType != null) {
            Map names;
            if (++this.articleCount % 10000 == 0) {
                log.info((Object)String.format("Article accepted %s (%d)", this.title, this.articleCount));
            }
            Map<String, String> labels = article.getLabels();
            LinkedHashMap<String, String> merged = null;
            if (osmCoordinates != null && osmCoordinates.amenity != null && (names = osmCoordinates.amenity.getNamesMap(true)) != null) {
                merged = new LinkedHashMap(names);
            }
            if (labels != null) {
                if (merged == null) {
                    merged = new LinkedHashMap<String, String>();
                }
                merged.putAll(labels);
            }
            String labelsJson = merged != null ? this.gson.toJson(merged) : null;
            int ind = 0;
            this.coordsPrep.setLong(++ind, id);
            this.coordsPrep.setString(++ind, this.title.toString());
            this.coordsPrep.setDouble(++ind, article.getLat());
            this.coordsPrep.setDouble(++ind, article.getLon());
            this.coordsPrep.setDouble(++ind, wlat);
            this.coordsPrep.setDouble(++ind, wlon);
            this.coordsPrep.setInt(++ind, osmCoordinates != null ? osmCoordinates.type + 1 : 0);
            this.coordsPrep.setLong(++ind, osmCoordinates != null ? osmCoordinates.id : 0L);
            String type = osmCoordinates != null && osmCoordinates.amenity != null ? osmCoordinates.amenity.getType().getKeyName() : null;
            this.coordsPrep.setString(++ind, starType != null ? "starmap" : type);
            String subtype = osmCoordinates != null && osmCoordinates.amenity != null ? osmCoordinates.amenity.getSubType() : null;
            this.coordsPrep.setString(++ind, starType != null ? starType : subtype);
            this.coordsPrep.setString(++ind, labelsJson);
            this.addBatch(this.coordsPrep, this.coordsBatch);
            List rgs = this.regions.getRegionsToDownload(article.getLat(), article.getLon(), this.keyNames);
            for (String reg : rgs) {
                this.wikiRegionPrep.setLong(1, id);
                this.wikiRegionPrep.setString(2, reg);
                this.addBatch(this.wikiRegionPrep, this.regionBatch);
            }
            for (ArticleMapper.SiteLink siteLink : article.getSiteLinks()) {
                this.mappingPrep.setLong(1, id);
                this.mappingPrep.setString(2, siteLink.lang());
                this.mappingPrep.setString(3, siteLink.title());
                this.addBatch(this.mappingPrep, this.mappingBatch);
            }
            if (article.getImage() != null) {
                String image = StringEscapeUtils.unescapeJava((String)article.getImage());
                this.wikidataPropPrep.setLong(1, id);
                this.wikidataPropPrep.setString(2, article.getImageProp());
                this.wikidataPropPrep.setString(3, image);
                this.addBatch(this.wikidataPropPrep, this.wikidataPropBatch);
            }
            if (article.getCommonCat() != null) {
                String commonCat = StringEscapeUtils.unescapeJava((String)article.getCommonCat());
                this.wikidataPropPrep.setLong(1, id);
                this.wikidataPropPrep.setString(2, "P373");
                this.wikidataPropPrep.setString(3, commonCat);
                this.addBatch(this.wikidataPropPrep, this.wikidataPropBatch);
            }
            if (storeJson) {
                this.wikidataBlobPrep.setLong(1, id);
                this.wikidataBlobPrep.setBytes(2, Algorithms.stringToGzip((String)json));
                this.addBatch(this.wikidataBlobPrep, this.wikidataBlobBatch);
            }
        }
    }

    private OsmCoordinatesByTag.OsmLatLonId getOsmCoordinates(long wid, ArticleMapper.Article article, OsmCoordinatesByTag.OsmLatLonId osmCoordinates) {
        for (ArticleMapper.SiteLink siteLink : article.getSiteLinks()) {
            String articleTitle = siteLink.title();
            String articleLang = siteLink.lang();
            osmCoordinates = this.osmWikiCoordinates.getCoordinates("wikipedia:" + articleLang, articleTitle);
            if (osmCoordinates == null) {
                osmCoordinates = this.osmWikiCoordinates.getCoordinates("wikipedia", articleLang + ":" + articleTitle);
            }
            if (osmCoordinates == null) {
                osmCoordinates = this.osmWikiCoordinates.getCoordinates("wikipedia", articleTitle);
            }
            if (osmCoordinates == null) continue;
            return osmCoordinates;
        }
        return this.osmWikiCoordinates.getCoordinates("wikidata", "Q" + wid);
    }

    public class AstroObject {
        @SerializedName(value="wid")
        public String wid;

        public String toString() {
            return this.wid;
        }
    }
}

