/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPoint;
import net.osmand.data.QuadPointDouble;
import net.osmand.data.QuadRect;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class RotatedTileBox {
    private double lat;
    private double lon;
    private float height;
    private float rotate;
    private float density;
    private int zoom;
    private double mapDensity = 1.0;
    private double zoomAnimation;
    private double zoomFloatPart;
    private int cx;
    private int cy;
    private int pixWidth;
    private int pixHeight;
    private float ratiocx;
    private float ratiocy;
    private double zoomFactor;
    private double rotateCos;
    private double rotateSin;
    private double oxTile;
    private double oyTile;
    private QuadRect tileBounds;
    private QuadRect latLonBounds;
    private List<LatLon> rotatedLatLonBounds;
    private QuadPointDouble tileLT;
    private QuadPointDouble tileRT;
    private QuadPointDouble tileRB;
    private QuadPointDouble tileLB;

    private RotatedTileBox() {
    }

    public RotatedTileBox(RotatedTileBox r) {
        this.pixWidth = r.pixWidth;
        this.pixHeight = r.pixHeight;
        this.lat = r.lat;
        this.lon = r.lon;
        this.zoom = r.zoom;
        this.mapDensity = r.mapDensity;
        this.zoomFloatPart = r.zoomFloatPart;
        this.zoomAnimation = r.zoomAnimation;
        this.rotate = r.rotate;
        this.density = r.density;
        this.cx = r.cx;
        this.cy = r.cy;
        this.ratiocx = r.ratiocx;
        this.ratiocy = r.ratiocy;
        this.copyDerivedFields(r);
    }

    private void copyDerivedFields(RotatedTileBox r) {
        this.zoomFactor = r.zoomFactor;
        this.rotateCos = r.rotateCos;
        this.rotateSin = r.rotateSin;
        this.oxTile = r.oxTile;
        this.oyTile = r.oyTile;
        QuadRect tileBounds = r.tileBounds;
        QuadRect latLonBounds = r.latLonBounds;
        if (tileBounds != null && latLonBounds != null && !Algorithms.isEmpty(r.rotatedLatLonBounds)) {
            this.tileBounds = new QuadRect(tileBounds);
            this.latLonBounds = new QuadRect(latLonBounds);
            this.tileLT = new QuadPointDouble(r.tileLT);
            this.tileRT = new QuadPointDouble(r.tileRT);
            this.tileRB = new QuadPointDouble(r.tileRB);
            this.tileLB = new QuadPointDouble(r.tileLB);
            this.rotatedLatLonBounds = new ArrayList<LatLon>(r.rotatedLatLonBounds);
        }
    }

    public void calculateDerivedFields() {
        this.zoomFactor = Math.pow(2.0, this.zoomAnimation + this.zoomFloatPart) * 256.0 * this.mapDensity;
        double rad = Math.toRadians(this.rotate);
        this.rotateCos = Math.cos(rad);
        this.rotateSin = Math.sin(rad);
        this.oxTile = MapUtils.getTileNumberX(this.zoom, this.lon);
        this.oyTile = MapUtils.getTileNumberY(this.zoom, this.lat);
        while (this.rotate < 0.0f) {
            this.rotate += 360.0f;
        }
        while (this.rotate > 360.0f) {
            this.rotate -= 360.0f;
        }
        this.tileBounds = null;
    }

    public double getLatFromPixel(float x, float y) {
        return MapUtils.getLatitudeFromTile(this.zoom, this.getTileYFromPixel(x, y));
    }

    public double getLonFromPixel(float x, float y) {
        return MapUtils.getLongitudeFromTile(this.zoom, this.getTileXFromPixel(x, y));
    }

    public LatLon getLatLonFromPixel(float x, float y) {
        return new LatLon(this.getLatFromPixel(x, y), this.getLonFromPixel(x, y));
    }

    public LatLon getCenterLatLon() {
        return new LatLon(this.lat, this.lon);
    }

    public QuadPoint getCenterPixelPoint() {
        return new QuadPoint(this.cx, this.cy);
    }

    public int getCenterPixelX() {
        return this.cx;
    }

    public int getCenterPixelY() {
        return this.cy;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public double getCenterTileX() {
        return this.oxTile;
    }

    public int getCenter31X() {
        return MapUtils.get31TileNumberX(this.lon);
    }

    public int getCenter31Y() {
        return MapUtils.get31TileNumberY(this.lat);
    }

    public double getCenterTileY() {
        return this.oyTile;
    }

    protected double getTileXFromPixel(float x, float y) {
        float dx = x - (float)this.cx;
        float dy = y - (float)this.cy;
        double dtilex = this.isMapRotateEnabled() ? this.rotateCos * (double)dx + this.rotateSin * (double)dy : (double)dx;
        return dtilex / this.zoomFactor + this.oxTile;
    }

    protected double getTileYFromPixel(float x, float y) {
        float dx = x - (float)this.cx;
        float dy = y - (float)this.cy;
        double dtiley = this.isMapRotateEnabled() ? -this.rotateSin * (double)dx + this.rotateCos * (double)dy : (double)dy;
        return dtiley / this.zoomFactor + this.oyTile;
    }

    public QuadRect getTileBounds() {
        this.checkTileRectangleCalculated();
        return this.tileBounds;
    }

    public void calculateTileRectangle() {
        double x1 = this.getTileXFromPixel(0.0f, 0.0f);
        double x2 = this.getTileXFromPixel(this.pixWidth, 0.0f);
        double x3 = this.getTileXFromPixel(this.pixWidth, this.pixHeight);
        double x4 = this.getTileXFromPixel(0.0f, this.pixHeight);
        double y1 = this.getTileYFromPixel(0.0f, 0.0f);
        double y2 = this.getTileYFromPixel(this.pixWidth, 0.0f);
        double y3 = this.getTileYFromPixel(this.pixWidth, this.pixHeight);
        double y4 = this.getTileYFromPixel(0.0f, this.pixHeight);
        this.tileLT = new QuadPointDouble(x1, y1);
        this.tileRT = new QuadPointDouble(x2, y2);
        this.tileRB = new QuadPointDouble(x3, y3);
        this.tileLB = new QuadPointDouble(x4, y4);
        double l = Math.min(Math.min(x1, x2), Math.min(x3, x4));
        double r = Math.max(Math.max(x1, x2), Math.max(x3, x4));
        double t = Math.min(Math.min(y1, y2), Math.min(y3, y4));
        double b = Math.max(Math.max(y1, y2), Math.max(y3, y4));
        QuadRect bounds = new QuadRect((float)l, (float)t, (float)r, (float)b);
        float top = (float)MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(bounds.top));
        float left = (float)MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(bounds.left));
        float bottom = (float)MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(bounds.bottom));
        float right = (float)MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(bounds.right));
        this.tileBounds = bounds;
        this.latLonBounds = new QuadRect(left, top, right, bottom);
        ArrayList<LatLon> crotatedLatLonBounds = new ArrayList<LatLon>();
        crotatedLatLonBounds.add(new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(y1)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(x1))));
        crotatedLatLonBounds.add(new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(y2)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(x2))));
        crotatedLatLonBounds.add(new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(y3)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(x3))));
        crotatedLatLonBounds.add(new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(y4)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(x4))));
        this.rotatedLatLonBounds = crotatedLatLonBounds;
    }

    private double alignTile(double tile) {
        if (tile < 0.0) {
            return 0.0;
        }
        if (tile >= MapUtils.getPowZoom(this.zoom)) {
            return MapUtils.getPowZoom(this.zoom) - 1.0E-6;
        }
        return tile;
    }

    public double getPixDensity() {
        double dist = this.getDistance(0, this.getPixHeight() / 2, this.getPixWidth(), this.getPixHeight() / 2);
        return (double)this.getPixWidth() / dist;
    }

    public int getPixWidth() {
        return this.pixWidth;
    }

    public int getPixHeight() {
        return this.pixHeight;
    }

    public float getPixXFrom31(int x31, int y31) {
        double zm = MapUtils.getPowZoom(31 - this.zoom);
        double xTile = (double)x31 / zm;
        double yTile = (double)y31 / zm;
        return this.getPixXFromTile(xTile, yTile);
    }

    public float getPixYFrom31(int x31, int y31) {
        double zm = MapUtils.getPowZoom(31 - this.zoom);
        double xTile = (double)x31 / zm;
        double yTile = (double)y31 / zm;
        return this.getPixYFromTile(xTile, yTile);
    }

    public float getPixXFromLatLon(double latitude, double longitude) {
        double xTile = MapUtils.getTileNumberX(this.zoom, longitude);
        double yTile = MapUtils.getTileNumberY(this.zoom, latitude);
        return this.getPixXFromTile(xTile, yTile);
    }

    public float getPixXFromTile(double tileX, double tileY, float zoom) {
        double pw = MapUtils.getPowZoom(zoom - (float)this.zoom);
        double xTile = tileX / pw;
        double yTile = tileY / pw;
        return this.getPixXFromTile(xTile, yTile);
    }

    protected float getPixXFromTile(double xTile, double yTile) {
        double dTileX = xTile - this.oxTile;
        double dTileY = yTile - this.oyTile;
        double rotX = this.isMapRotateEnabled() ? this.rotateCos * dTileX - this.rotateSin * dTileY : dTileX;
        double dx = rotX * this.zoomFactor;
        return (float)(dx + (double)this.cx);
    }

    public float getPixYFromLatLon(double latitude, double longitude) {
        double xTile = MapUtils.getTileNumberX(this.zoom, longitude);
        double yTile = MapUtils.getTileNumberY(this.zoom, latitude);
        return this.getPixYFromTile(xTile, yTile);
    }

    public float getPixYFromTile(double tileX, double tileY, float zoom) {
        double pw = MapUtils.getPowZoom(zoom - (float)this.zoom);
        double xTile = tileX / pw;
        double yTile = tileY / pw;
        return this.getPixYFromTile(xTile, yTile);
    }

    protected float getPixYFromTile(double xTile, double yTile) {
        double dTileX = xTile - this.oxTile;
        double dTileY = yTile - this.oyTile;
        double rotY = this.isMapRotateEnabled() ? this.rotateSin * dTileX + this.rotateCos * dTileY : dTileY;
        double dy = rotY * this.zoomFactor;
        return (float)(dy + (double)this.cy);
    }

    public int getPixXFromLonNoRot(double longitude) {
        double dTilex = MapUtils.getTileNumberX(this.zoom, longitude) - this.oxTile;
        return (int)(dTilex * this.zoomFactor + (double)this.cx);
    }

    public int getPixXFromTileXNoRot(double tileX) {
        double dTilex = tileX - this.oxTile;
        return (int)(dTilex * this.zoomFactor + (double)this.cx);
    }

    public int getPixYFromLatNoRot(double latitude) {
        double dTileY = MapUtils.getTileNumberY(this.zoom, latitude) - this.oyTile;
        return (int)(dTileY * this.zoomFactor + (double)this.cy);
    }

    public int getPixYFromTileYNoRot(double tileY) {
        double dTileY = tileY - this.oyTile;
        return (int)(dTileY * this.zoomFactor + (double)this.cy);
    }

    private boolean isMapRotateEnabled() {
        return this.rotate != 0.0f;
    }

    public QuadRect getLatLonBounds() {
        this.checkTileRectangleCalculated();
        return this.latLonBounds;
    }

    public double getRotateCos() {
        return this.rotateCos;
    }

    public double getRotateSin() {
        return this.rotateSin;
    }

    public double getFullZoom() {
        return (double)this.getZoom() + this.getZoomFloatPart() + this.getZoomAnimation();
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getDefaultRadiusPoi() {
        double zoom = this.getZoom();
        int radius = zoom <= 15.0 ? 10 : (zoom <= 16.0 ? 14 : (zoom <= 17.0 ? 16 : 18));
        return (int)((float)radius * this.getDensity());
    }

    public void setLatLonCenter(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        this.calculateDerivedFields();
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setRotate(float rotate) {
        this.rotate = rotate;
        this.calculateDerivedFields();
    }

    public void increasePixelDimensions(int dwidth, int dheight) {
        this.pixWidth += 2 * dwidth;
        this.pixHeight += 2 * dheight;
        this.cx += dwidth;
        this.cy += dheight;
        this.calculateDerivedFields();
    }

    public void setPixelDimensions(int width, int height) {
        this.setPixelDimensions(width, height, 0.5f, 0.5f);
    }

    public void setPixelDimensions(int width, int height, float ratiocx, float ratiocy) {
        this.pixHeight = height;
        this.pixWidth = width;
        this.cx = (int)((float)this.pixWidth * ratiocx);
        this.cy = (int)((float)this.pixHeight * ratiocy);
        this.ratiocx = ratiocx;
        this.ratiocy = ratiocy;
        this.calculateDerivedFields();
    }

    public boolean isZoomAnimated() {
        return this.zoomAnimation != 0.0;
    }

    public double getZoomAnimation() {
        return this.zoomAnimation;
    }

    public double getZoomFloatPart() {
        return this.zoomFloatPart;
    }

    public void setZoomAndAnimation(int zoom, double zoomAnimation, double zoomFloatPart) {
        this.zoomAnimation = zoomAnimation;
        this.zoomFloatPart = zoomFloatPart;
        this.zoom = zoom;
        this.calculateDerivedFields();
    }

    public void setZoomAndAnimation(int zoom, double zoomAnimation) {
        this.zoomAnimation = zoomAnimation;
        this.zoom = zoom;
        this.calculateDerivedFields();
    }

    public void setCenterLocation(float ratiocx, float ratiocy) {
        this.cx = (int)((float)this.pixWidth * ratiocx);
        this.cy = (int)((float)this.pixHeight * ratiocy);
        this.ratiocx = ratiocx;
        this.ratiocy = ratiocy;
        this.calculateDerivedFields();
    }

    public boolean isCenterShifted() {
        return this.ratiocx != 0.5f || this.ratiocy != 0.5f;
    }

    public LatLon getLeftTopLatLon() {
        this.checkTileRectangleCalculated();
        return new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(this.tileLT.y)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(this.tileLT.x)));
    }

    public QuadPointDouble getLeftTopTile(double zoom) {
        this.checkTileRectangleCalculated();
        return new QuadPointDouble(this.tileLT.x * MapUtils.getPowZoom(zoom - (double)this.zoom), this.tileLT.y * MapUtils.getPowZoom(zoom - (double)this.zoom));
    }

    public QuadPointDouble getRightBottomTile(float zoom) {
        this.checkTileRectangleCalculated();
        return new QuadPointDouble(this.tileRB.x * MapUtils.getPowZoom(zoom - (float)this.zoom), this.tileRB.y * MapUtils.getPowZoom(zoom - (float)this.zoom));
    }

    private void checkTileRectangleCalculated() {
        if (this.tileBounds == null) {
            this.calculateTileRectangle();
        }
    }

    public LatLon getRightBottomLatLon() {
        this.checkTileRectangleCalculated();
        return new LatLon(MapUtils.getLatitudeFromTile(this.zoom, this.alignTile(this.tileRB.y)), MapUtils.getLongitudeFromTile(this.zoom, this.alignTile(this.tileRB.x)));
    }

    public void setMapDensity(double mapDensity) {
        this.mapDensity = mapDensity;
        this.calculateDerivedFields();
    }

    public double getMapDensity() {
        return this.mapDensity;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
        this.calculateDerivedFields();
    }

    public float getHeight() {
        return this.height;
    }

    public float getRotate() {
        return this.rotate;
    }

    public float getDensity() {
        return this.density;
    }

    public RotatedTileBox copy() {
        return new RotatedTileBox(this);
    }

    public boolean containsTileBox(RotatedTileBox box) {
        this.checkTileRectangleCalculated();
        box = box.copy();
        box.checkTileRectangleCalculated();
        if (!this.containsTilePoint(box.tileLB)) {
            return false;
        }
        if (!this.containsTilePoint(box.tileLT)) {
            return false;
        }
        if (!this.containsTilePoint(box.tileRB)) {
            return false;
        }
        return this.containsTilePoint(box.tileRT);
    }

    public boolean containsTilePoint(QuadPoint qp) {
        double tx = this.getPixXFromTile(qp.x, qp.y);
        double ty = this.getPixYFromTile(qp.x, qp.y);
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsTilePoint(QuadPointDouble qp) {
        double tx = this.getPixXFromTile(qp.x, qp.y);
        double ty = this.getPixYFromTile(qp.x, qp.y);
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsRectInRotatedRect(double left, double top, double right, double bottom) {
        ArrayList<LatLon> rect = new ArrayList<LatLon>();
        rect.add(new LatLon(top, left));
        rect.add(new LatLon(top, right));
        rect.add(new LatLon(bottom, right));
        rect.add(new LatLon(bottom, left));
        rect.add((LatLon)rect.get(0));
        this.checkTileRectangleCalculated();
        ArrayList<LatLon> rotatedLatLonRect = new ArrayList<LatLon>(this.rotatedLatLonBounds);
        rotatedLatLonRect.add((LatLon)rotatedLatLonRect.get(0));
        return Algorithms.isFirstPolygonInsideSecond(rect, rotatedLatLonRect);
    }

    public boolean containsLatLon(double lat, double lon) {
        double tx = this.getPixXFromLatLon(lat, lon);
        double ty = this.getPixYFromLatLon(lat, lon);
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsLatLon(LatLon latLon) {
        double tx = this.getPixXFromLatLon(latLon.getLatitude(), latLon.getLongitude());
        double ty = this.getPixYFromLatLon(latLon.getLatitude(), latLon.getLongitude());
        return tx >= 0.0 && tx <= (double)this.pixWidth && ty >= 0.0 && ty <= (double)this.pixHeight;
    }

    public boolean containsPoint(float tx, float ty, float outMargin) {
        return tx >= -outMargin && tx <= (float)this.pixWidth + outMargin && ty >= -outMargin && ty <= (float)this.pixHeight + outMargin;
    }

    public double getDistance(int pixX, int pixY, int pixX2, int pixY2) {
        double lat1 = this.getLatFromPixel(pixX, pixY);
        double lon1 = this.getLonFromPixel(pixX, pixY);
        double lat2 = this.getLatFromPixel(pixX2, pixY2);
        double lon2 = this.getLonFromPixel(pixX2, pixY2);
        return MapUtils.getDistance(lat1, lon1, lat2, lon2);
    }

    public boolean isLatLonNearPixel(LatLon latLon, float centerPixX, float centerPixY, float radius) {
        return this.isLatLonNearPixel(latLon.getLatitude(), latLon.getLongitude(), centerPixX, centerPixY, radius);
    }

    public boolean isLatLonNearPixel(double lat, double lon, float centerPixX, float centerPixY, float radius) {
        QuadRect pixelArea = new QuadRect(centerPixX - radius, centerPixY - radius, centerPixX + radius, centerPixY + radius);
        return this.isLatLonInsidePixelArea(lat, lon, pixelArea);
    }

    public boolean isLatLonInsidePixelArea(LatLon latLon, QuadRect pixelArea) {
        return this.isLatLonInsidePixelArea(latLon.getLatitude(), latLon.getLongitude(), pixelArea);
    }

    public boolean isLatLonInsidePixelArea(double lat, double lon, QuadRect pixelArea) {
        float pixX = this.getPixXFromLatLon(lat, lon);
        float pixY = this.getPixYFromLatLon(lat, lon);
        return pixelArea.contains(pixX, pixY, pixX, pixY);
    }

    public double getLongitude() {
        return this.lon;
    }

    public double getLatitude() {
        return this.lat;
    }

    public String toString() {
        return "RotatedTileBox [lat=" + this.lat + ", lon=" + this.lon + ", rotate=" + this.rotate + ", density=" + this.density + ", zoom=" + this.zoom + ", mapDensity=" + this.mapDensity + ", zoomAnimation=" + this.zoomAnimation + ", zoomFloatPart=" + this.zoomFloatPart + ", cx=" + this.cx + ", cy=" + this.cy + ", pixWidth=" + this.pixWidth + ", pixHeight=" + this.pixHeight + "]";
    }

    public static class RotatedTileBoxBuilder {
        private RotatedTileBox tb = new RotatedTileBox();
        private boolean pixelDimensionsSet = false;
        private boolean locationSet = false;
        private boolean zoomSet = false;

        public RotatedTileBoxBuilder() {
            this.tb.density = 1.0f;
            this.tb.rotate = 0.0f;
        }

        public RotatedTileBoxBuilder density(float d) {
            this.tb.density = d;
            return this;
        }

        public RotatedTileBoxBuilder setMapDensity(double mapDensity) {
            this.tb.mapDensity = mapDensity;
            return this;
        }

        public RotatedTileBoxBuilder setZoom(int zoom) {
            this.tb.zoom = zoom;
            this.zoomSet = true;
            return this;
        }

        public RotatedTileBoxBuilder setZoomFloatPart(double zoomFloatPart) {
            this.tb.zoomFloatPart = zoomFloatPart;
            return this;
        }

        public RotatedTileBoxBuilder setLocation(double lat, double lon) {
            this.tb.lat = lat;
            this.tb.lon = lon;
            this.locationSet = true;
            return this;
        }

        public RotatedTileBoxBuilder setRotate(float degrees) {
            this.tb.rotate = degrees;
            return this;
        }

        public RotatedTileBoxBuilder setPixelDimensions(int pixWidth, int pixHeight, float centerX, float centerY) {
            this.tb.pixWidth = pixWidth;
            this.tb.pixHeight = pixHeight;
            this.tb.cx = (int)((float)pixWidth * centerX);
            this.tb.cy = (int)((float)pixHeight * centerY);
            this.tb.ratiocx = centerX;
            this.tb.ratiocy = centerY;
            this.pixelDimensionsSet = true;
            return this;
        }

        public RotatedTileBoxBuilder setPixelDimensions(int pixWidth, int pixHeight) {
            return this.setPixelDimensions(pixWidth, pixHeight, 0.5f, 0.5f);
        }

        public RotatedTileBox build() {
            if (!this.pixelDimensionsSet) {
                throw new IllegalArgumentException("Please specify pixel dimensions");
            }
            if (!this.zoomSet) {
                throw new IllegalArgumentException("Please specify zoom");
            }
            if (!this.locationSet) {
                throw new IllegalArgumentException("Please specify location");
            }
            RotatedTileBox local = this.tb;
            local.calculateDerivedFields();
            this.tb = null;
            return local;
        }
    }
}

