/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.IProgress;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Amenity;
import net.osmand.data.Boundary;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.Ring;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.CityDataStorage;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexRouteRelationCreator;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityParser;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.router.RoutingContext;
import net.osmand.util.Algorithms;
import net.osmand.util.ArabicNormalizer;
import net.osmand.util.MapUtils;
import net.osmand.util.TopTagValuesAnalyzer;
import net.sf.junidecode.Junidecode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexPoiCreator
extends AbstractIndexPartCreator {
    private static final Log log = LogFactory.getLog(IndexPoiCreator.class);
    private Connection poiConnection;
    private File poiIndexFile;
    private PreparedStatement poiPreparedStatement;
    private PreparedStatement tagGroupsPreparedStatement;
    private static final int ZOOM_TO_SAVE_END = 16;
    private static final int ZOOM_TO_SAVE_START = 6;
    private static final int ZOOM_TO_WRITE_CATEGORIES_START = 12;
    private static final int ZOOM_TO_WRITE_CATEGORIES_END = 16;
    private static final double GEOCODING_DISTANCE = 150.0;
    private boolean useInMemoryCreator = true;
    public static long GENERATE_OBJ_ID = -1024L;
    public TLongHashSet generatedIds = new TLongHashSet();
    private List<Amenity> tempAmenityList = new ArrayList<Amenity>();
    RelationTagsPropagation tagsTransform = new RelationTagsPropagation();
    private final MapRenderingTypesEncoder renderingTypes;
    private MapPoiTypes poiTypes;
    private List<PoiAdditionalType> additionalTypesId = new ArrayList<PoiAdditionalType>();
    private Map<String, PoiAdditionalType> additionalTypesByTag = new HashMap<String, PoiAdditionalType>();
    private IndexCreatorSettings settings;
    private Map<String, Set<String>> topIndexAdditional;
    private Set<String> topIndexKeys = new HashSet<String>();
    private TLongHashSet excludedRelations = new TLongHashSet();
    private QuadTree<Multipolygon> cityQuadTree;
    private Map<Multipolygon, List<PoiCreatorTagGroup>> cityTagsGroup;
    private Map<Long, List<Integer>> poiTagGroups = new HashMap<Long, List<Integer>>();
    private Map<String, Map<Integer, Integer>> tagGroupIdsByRegion = new HashMap<String, Map<Integer, Integer>>();
    private int maxTagGroupId = 0;
    private Map<Integer, PoiCreatorTagGroup> tagGroupsFromDB;
    private static final String ENV_POI_TOP_INDEXES_URL = "POI_TOP_INDEXES_URL";
    public static final int DEFAULT_TOP_INDEX_MIN_COUNT = 3;
    public static final int DEFAULT_TOP_INDEX_MAX_PER_MAP = 100;
    public static final int DEFAULT_TOP_INDEX_LIMIT_PER_MAP = 1000;
    private final List<String> WORLD_BRANDS = Arrays.asList("McDonald's", "Starbucks", "Subway", "KFC", "Burger King", "Domino's Pizza", "Pizza Hut", "Dunkin'", "Costa Coffee", "Tim Hortons", "7-Eleven", "\u017babka", "Shell", "BP", "Chevron", "TotalEnergies", "Aral", "Q8", "Petronas", "Caltex", "Esso", "Tesla Supercharger", "Ionity", "Walmart", "Carrefour", "Tesco", "Lidl", "Aldi", "Costco", "Auchan", "IKEA", "H&M", "Zara", "Uniqlo", "Nike", "Adidas", "Decathlon", "REI", "The North Face", "Apple Store", "Samsung", "Media Markt", "Best Buy", "Barnes & Noble", "WHSmith", "Waterstones", "Marriott", "Hilton", "Holiday Inn", "Ibis", "Best Western", "Radisson", "Planet Fitness", "Anytime Fitness", "Gold's Gym", "24 Hour Fitness", "Snap Fitness", "Walgreens", "CVS Pharmacy", "Boots", "Watsons", "Hertz", "Avis", "Sixt", "Enterprise", "Europcar", "Mountain Warehouse", "Intersport", "Hudson News");
    private static final char SPECIAL_CHAR = '\uffff';

    public IndexPoiCreator(IndexCreatorSettings settings, MapRenderingTypesEncoder renderingTypes) {
        this.settings = settings;
        this.renderingTypes = renderingTypes;
        this.poiTypes = MapPoiTypes.getDefault();
    }

    public void storeCities(CityDataStorage cityDataStorage) {
        if (cityDataStorage != null) {
            this.cityQuadTree = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 8, 0.55f);
            this.cityTagsGroup = new HashMap<Multipolygon, List<PoiCreatorTagGroup>>();
            int id = 1;
            HashSet<String> allLanguages = new HashSet<String>(Arrays.asList(MapRenderingTypes.langs));
            for (Map.Entry<City, Boundary> entry : cityDataStorage.cityBoundaries.entrySet()) {
                String enName;
                Boundary b = entry.getValue();
                City city = entry.getKey();
                if (city.getType() == null || !city.getType().storedAsSeparateAdminEntity()) continue;
                ArrayList<String> tags = new ArrayList<String>();
                String name = city.getName();
                if (!Algorithms.isEmpty((CharSequence)name)) {
                    tags.add("name");
                    tags.add(name);
                }
                if (!Algorithms.isEmpty((CharSequence)(enName = city.getEnName(false)))) {
                    tags.add("name:en");
                    tags.add(enName);
                }
                Map otherNames = city.getNamesMap(true);
                for (Map.Entry nameEntry : otherNames.entrySet()) {
                    if (!allLanguages.contains(nameEntry.getKey())) continue;
                    tags.add("name:" + (String)nameEntry.getKey());
                    tags.add((String)nameEntry.getValue());
                }
                tags.add("place");
                tags.add(city.getType().name().toLowerCase());
                if (tags.isEmpty()) continue;
                PoiCreatorTagGroup poiCreatorTagGroup = new PoiCreatorTagGroup(id, tags);
                List tagGroups = this.cityTagsGroup.computeIfAbsent(b.getMultipolygon(), s -> new ArrayList());
                tagGroups.add(poiCreatorTagGroup);
                ++id;
                Multipolygon m = b.getMultipolygon();
                QuadRect bboxLatLon = m.getLatLonBbox();
                int left = MapUtils.get31TileNumberX((double)bboxLatLon.left);
                int right = MapUtils.get31TileNumberX((double)bboxLatLon.right);
                int top = MapUtils.get31TileNumberY((double)bboxLatLon.top);
                int bottom = MapUtils.get31TileNumberY((double)bboxLatLon.bottom);
                QuadRect bbox = new QuadRect((double)left, (double)top, (double)right, (double)bottom);
                this.cityQuadTree.insert((Object)m, bbox);
            }
        }
    }

    public void setPoiTypes(MapPoiTypes poiTypes) {
        this.poiTypes = poiTypes;
    }

    public void iterateEntity(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if (e instanceof Relation && this.excludedRelations.contains(e.getId())) {
            return;
        }
        if (!this.settings.keepOnlyRouteRelationObjects) {
            this.iterateEntityInternal(e, ctx, icc);
        }
    }

    void iterateEntityInternal(Entity e, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        this.tempAmenityList.clear();
        Map<String, String> tags = this.tagsTransform.addPropogatedTags(this.renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.POI, e, e.getTags());
        tags = this.renderingTypes.transformTags(tags, Entity.EntityType.valueOf((Entity)e), MapRenderingTypesEncoder.EntityConvertApplyType.POI);
        IndexRouteRelationCreator routeRelationCreator = icc.getIndexRouteRelationCreator();
        if (routeRelationCreator != null) {
            tags = routeRelationCreator.addClickableWayTags(icc, e, tags, true);
        }
        this.tempAmenityList = EntityParser.parseAmenities((MapPoiTypes)this.poiTypes, (Entity)e, tags, this.tempAmenityList);
        if (!this.tempAmenityList.isEmpty() && this.poiPreparedStatement != null) {
            if ((e instanceof Node || e instanceof Way) && icc.bboxFilter.shouldFilterPoiEntity(e)) {
                icc.bboxFilter.logEntityWithAmenity(e, this.tempAmenityList.get(0));
                return;
            }
            List<Object> relationCenters = Collections.singletonList(null);
            StringBuilder memberIds = new StringBuilder();
            relationCenters = this.collectRelationCenters(e, ctx, tags, relationCenters, memberIds);
            long id = e.getId();
            if (icc.basemap && id < 0L) {
                id = GENERATE_OBJ_ID--;
            } else if (id > 0L) {
                id = ObfConstants.createMapObjectIdFromOsmAndEntity((Entity)e);
                if (e instanceof Relation) {
                    while (this.generatedIds.contains(id)) {
                        id += 2L;
                    }
                    this.generatedIds.add(id);
                }
            }
            for (Amenity a : this.tempAmenityList) {
                PoiType st;
                if (icc.basemap && ((st = a.getType().getPoiTypeByKeyName(a.getSubType())) == null || !a.getType().containsBasemapPoi(st))) continue;
                for (int i = 0; i < relationCenters.size(); ++i) {
                    LatLon cen = relationCenters.get(i);
                    if (cen != null) {
                        a.setLocation(cen);
                    }
                    if (a.getLocation() == null) continue;
                    EntityParser.parseMapObject((MapObject)a, (Entity)e, tags);
                    if (relationCenters.size() > 1) {
                        a.setAdditionalInfo("route_id", "R" + e.getId());
                        long cenId = id + (long)i * 2L;
                        a.setId(Long.valueOf(cenId));
                        this.generatedIds.add(cenId);
                    } else {
                        a.setId(Long.valueOf(id));
                        this.generatedIds.add(id);
                    }
                    if (!memberIds.isEmpty()) {
                        a.setAdditionalInfo("route_members_ids", memberIds.toString());
                    }
                    if (icc.bboxFilter.shouldFilterPoiAmenity(a)) {
                        icc.bboxFilter.logEntityWithAmenity(e, a);
                        continue;
                    }
                    try {
                        this.insertAmenityIntoPoi(a);
                        continue;
                    }
                    catch (Exception excpt) {
                        System.out.println("TODO FIX " + a.getId() + " " + String.valueOf(excpt));
                        excpt.printStackTrace();
                    }
                }
            }
        }
    }

    private List<LatLon> collectRelationCenters(Entity e, OsmDbAccessorContext ctx, Map<String, String> tags, List<LatLon> centers, StringBuilder memberIds) throws SQLException {
        block9: {
            Relation relation;
            block11: {
                boolean isAdministrative;
                block10: {
                    if (!(e instanceof Relation)) break block9;
                    relation = (Relation)e;
                    ctx.loadEntityRelation(relation);
                    isAdministrative = tags.get(OSMSettings.OSMTagKey.ADMIN_LEVEL.getValue()) != null;
                    List adminCenters = relation.getMemberEntities("admin_centre");
                    if (adminCenters.size() != 1) break block10;
                    centers = Collections.singletonList(((Entity)adminCenters.get(0)).getLatLon());
                    break block9;
                }
                if (!OsmMapUtils.isMultipolygon(tags) || isAdministrative) break block11;
                MultipolygonBuilder original = new MultipolygonBuilder();
                original.setId(relation.getId());
                if (MultipolygonBuilder.isClimbingMultipolygon((Entity)relation)) {
                    Map<Long, Node> allNodes = ctx.retrieveAllRelationNodes((Relation)e);
                    original.createClimbingOuterWay(e, new ArrayList<Node>(allNodes.values()));
                } else {
                    original.createInnerAndOuterWays((Entity)relation);
                }
                List multipolygons = original.splitPerOuterRing(log);
                centers = new ArrayList<LatLon>();
                for (Multipolygon m : multipolygons) {
                    Ring out;
                    assert (m.getOuterRings().size() == 1);
                    if (!m.areRingsComplete()) {
                        log.warn((Object)("In multipolygon (POI) " + relation.getId() + " there are incompleted ways"));
                    }
                    if ((out = (Ring)m.getOuterRings().get(0)).getBorder().size() == 0) {
                        log.warn((Object)("Multipolygon (POI) has an outer ring that can't be formed: " + relation.getId()));
                        continue;
                    }
                    ArrayList<List> innerWays = new ArrayList<List>();
                    for (Ring r : m.getInnerRings()) {
                        innerWays.add(r.getBorder());
                    }
                    LatLon l = OsmMapUtils.getComplexPolyCenter((Collection)out.getBorder(), innerWays);
                    centers.add(l);
                }
                break block9;
            }
            if (!OsmMapUtils.isSuperRoute(tags)) break block9;
            for (Relation.RelationMember members : relation.getMembers()) {
                if (members.getEntityId().getType() != Entity.EntityType.RELATION) continue;
                if (memberIds.length() > 0) {
                    memberIds.append(" ");
                }
                memberIds.append("O" + members.getEntityId().getId());
                if (centers.get(0) != null) continue;
                Relation memberRel = (Relation)members.getEntity();
                ctx.loadEntityRelation(memberRel);
                centers = Collections.singletonList(OsmMapUtils.getCenter((Entity)memberRel, (boolean)true));
            }
        }
        return centers;
    }

    public void iterateRelation(Relation e, OsmDbAccessorContext ctx) throws SQLException {
        this.tagsTransform.handleRelationPropogatedTags(e, this.renderingTypes, ctx, MapRenderingTypesEncoder.EntityConvertApplyType.POI);
    }

    public void commitAndClosePoiFile(Long lastModifiedDate) throws SQLException {
        this.closeAllPreparedStatements();
        if (this.poiConnection != null) {
            this.poiConnection.commit();
            this.poiConnection.close();
            this.poiConnection = null;
            if (lastModifiedDate != null) {
                this.poiIndexFile.setLastModified(lastModifiedDate);
            }
        }
    }

    public void removePoiFile() {
        Algorithms.removeAllFiles((File)this.poiIndexFile);
    }

    public void insertAmenityIntoPoi(Amenity amenity) throws SQLException {
        assert ("poi" != null) : "use constants here to show table usage ";
        this.poiPreparedStatement.setLong(1, amenity.getId());
        this.poiPreparedStatement.setInt(2, MapUtils.get31TileNumberX((double)amenity.getLocation().getLongitude()));
        this.poiPreparedStatement.setInt(3, MapUtils.get31TileNumberY((double)amenity.getLocation().getLatitude()));
        this.poiPreparedStatement.setString(4, amenity.getType().getKeyName());
        this.poiPreparedStatement.setString(5, amenity.getSubType());
        this.poiPreparedStatement.setString(6, this.encodeAdditionalInfo(amenity, amenity.getName()));
        this.poiPreparedStatement.setInt(7, amenity.getOrder());
        String tagGroups = this.insertMergedTaggroups(amenity);
        this.poiPreparedStatement.setString(8, tagGroups);
        int topIndex = 9;
        for (Map.Entry entry : this.poiTypes.topIndexPoiAdditional.entrySet()) {
            String val = amenity.getAdditionalInfo(((String)entry.getKey()).replace("top_index_", ""));
            this.poiPreparedStatement.setString(topIndex, val);
            ++topIndex;
        }
        this.addBatch(this.poiPreparedStatement);
    }

    private PoiAdditionalType getOrCreate(String tag, String value, boolean text) {
        String ks = PoiAdditionalType.getKey(tag, value, text);
        if (this.additionalTypesByTag.containsKey(ks)) {
            return this.additionalTypesByTag.get(ks);
        }
        int sz = this.additionalTypesId.size();
        PoiAdditionalType tp = new PoiAdditionalType(sz, tag, value, text);
        this.additionalTypesId.add(tp);
        this.additionalTypesByTag.put(ks, tp);
        return tp;
    }

    private String encodeAdditionalInfo(Amenity amenity, String name) {
        LinkedHashMap<Object, String> tempNames = new LinkedHashMap<Object, String>();
        if (!Algorithms.isEmpty((CharSequence)name)) {
            tempNames.put("name", name);
        }
        for (Map.Entry entry : amenity.getNamesMap(true).entrySet()) {
            tempNames.put("name:" + (String)entry.getKey(), (String)entry.getValue());
        }
        for (String e : amenity.getAdditionalInfoKeys()) {
            tempNames.put(e, amenity.getAdditionalInfo(e));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry e : tempNames.entrySet()) {
            String topIndexKey;
            boolean text = this.poiTypes.isTextAdditionalInfo((String)e.getKey(), (String)e.getValue());
            PoiAdditionalType rulType = this.getOrCreate((String)e.getKey(), (String)e.getValue(), text);
            if (!rulType.isText() || !Algorithms.isEmpty((CharSequence)((CharSequence)e.getValue()))) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\uffff');
                }
                if (!rulType.isText() && rulType.getValue() == null) {
                    throw new IllegalStateException("Additional rule type '" + rulType.getTag() + "' should be encoded with value '" + (String)e.getValue() + "'");
                }
                stringBuilder.append((char)(rulType.getId() + 1)).append((String)e.getValue());
            }
            if (!this.poiTypes.topIndexPoiAdditional.containsKey(topIndexKey = "top_index_" + (String)e.getKey())) continue;
            this.topIndexKeys.add(topIndexKey);
            rulType = this.getOrCreate(topIndexKey, (String)e.getValue(), false);
            if (rulType.getValue() == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\uffff');
            }
            stringBuilder.append((char)(rulType.getId() + 1)).append((String)e.getValue());
        }
        return stringBuilder.toString();
    }

    private Map<PoiAdditionalType, String> decodeAdditionalInfo(String name, Map<PoiAdditionalType, String> tempNames) {
        tempNames.clear();
        if (name.length() == 0) {
            return tempNames;
        }
        int p = 0;
        while (true) {
            Set<String> collection;
            int i;
            String t = (i = name.indexOf(65535, p)) == -1 ? name.substring(p) : name.substring(p, i);
            PoiAdditionalType rulType = this.additionalTypesId.get(t.charAt(0) - '\u0001');
            if (this.topIndexAdditional != null && this.topIndexAdditional.containsKey(rulType.getTag()) && !(collection = this.topIndexAdditional.get(rulType.getTag())).contains(rulType.getValue())) {
                if (i == -1) break;
                p = i + 1;
                continue;
            }
            tempNames.put(rulType, t.substring(1));
            if (!rulType.isText() && rulType.getValue() == null) {
                throw new IllegalStateException("Additional rule type '" + rulType.getTag() + "' should be encoded with value '" + t.substring(1) + "'");
            }
            if (i == -1) break;
            p = i + 1;
        }
        return tempNames;
    }

    public void createDatabaseStructure(File poiIndexFile) throws SQLException {
        this.poiIndexFile = poiIndexFile;
        File parentFile = poiIndexFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        if (poiIndexFile.exists()) {
            Algorithms.removeAllFiles((File)poiIndexFile);
        }
        this.poiConnection = DBDialect.SQLITE.getDatabaseConnection(poiIndexFile.getAbsolutePath(), log);
        Statement stat = this.poiConnection.createStatement();
        stat.executeUpdate("create table poi (id bigint, x int, y int,type varchar(1024), subtype varchar(1024), additionalTags varchar(8096), priority int, taggroups varchar(1024), " + this.getCreateColumnsTopIndexAdditionals() + "primary key(id, type, subtype))");
        stat.executeUpdate("create table taggroups (id int, tagvalues varchar(8096), primary key(id))");
        stat.executeUpdate("create index poi_loc on poi (x, y, type, subtype)");
        stat.executeUpdate("create index poi_id on poi (id, type, subtype)");
        stat.execute("PRAGMA user_version = 2");
        stat.close();
        this.poiPreparedStatement = this.poiConnection.prepareStatement("INSERT INTO poi(id, x, y, type, subtype, additionalTags, priority, taggroups" + this.getInsertColumnsTopIndexAdditionals() + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?" + this.getInsertValuesTopIndexAdditionals() + ")");
        this.tagGroupsPreparedStatement = this.poiConnection.prepareStatement("INSERT INTO taggroups (id, tagvalues) VALUES (?, ?)");
        this.pStatements.put(this.poiPreparedStatement, 0);
        this.pStatements.put(this.tagGroupsPreparedStatement, 0);
        this.poiConnection.setAutoCommit(false);
    }

    public void excludeFromMainIteration(long id) {
        this.excludedRelations.add(id);
    }

    public void writeBinaryPoiIndex(File poiGeocoding, BinaryMapIndexWriter writer, String regionName, IProgress progress) throws SQLException, IOException {
        int level;
        if (this.poiPreparedStatement != null) {
            this.closePreparedStatements(this.poiPreparedStatement);
        }
        if (this.tagGroupsPreparedStatement != null) {
            this.closePreparedStatements(this.tagGroupsPreparedStatement);
        }
        this.poiConnection.commit();
        TreeMap<String, Set<PoiTileBox>> namesIndex = new TreeMap<String, Set<PoiTileBox>>();
        int zoomToStart = 6;
        IntBbox bbox = new IntBbox();
        Tree<PoiTileBox> rootZoomsTree = new Tree<PoiTileBox>();
        this.collectTopIndexMap();
        this.collectTagGroups();
        this.processPOIIntoTree(poiGeocoding, namesIndex, zoomToStart, bbox, rootZoomsTree);
        long startFpPoiIndex = writer.startWritePoiIndex(regionName, bbox.minX, bbox.maxX, bbox.maxY, bbox.minY);
        PoiCreatorCategories globalCategories = ((PoiTileBox)rootZoomsTree.node).categories;
        writer.writePoiCategoriesTable(globalCategories);
        writer.writePoiSubtypesTable(globalCategories, this.topIndexAdditional);
        Map<PoiTileBox, List<BinaryFileReference>> fpToWriteSeeks = writer.writePoiNameIndex(namesIndex, startFpPoiIndex);
        log.info((Object)"Poi box processing finished");
        for (level = 0; level < 16 - zoomToStart; ++level) {
            int subtrees = rootZoomsTree.getSubTreesOnLevel(level);
            if (subtrees <= 8) continue;
            --level;
            break;
        }
        if (level > 0) {
            rootZoomsTree.extractChildrenFromLevel(level);
            zoomToStart += level;
        }
        for (Tree<PoiTileBox> subs : rootZoomsTree.getSubtrees()) {
            this.writePoiBoxes(writer, subs, startFpPoiIndex, fpToWriteSeeks, globalCategories);
        }
        PreparedStatement prepareStatement = this.poiConnection.prepareStatement("SELECT id, x, y, type, subtype, additionalTags, taggroups from poi where x >= ? AND x < ? AND y >= ? AND y < ? order by priority ");
        for (Map.Entry<PoiTileBox, List<BinaryFileReference>> entry : fpToWriteSeeks.entrySet()) {
            int z = entry.getKey().zoom;
            int x = entry.getKey().x;
            int y = entry.getKey().y;
            writer.startWritePoiData(z, x, y, entry.getValue());
            if (this.useInMemoryCreator) {
                List<PoiData> poiData = entry.getKey().poiData;
                Collections.sort(poiData, new Comparator<PoiData>(){

                    @Override
                    public int compare(PoiData o1, PoiData o2) {
                        return -Integer.compare(o1.getRating(), o2.getRating());
                    }
                });
                for (PoiData poi : poiData) {
                    int x31 = poi.x;
                    int y31 = poi.y;
                    String type = poi.type;
                    String subtype = poi.subtype;
                    int x24shift = (x31 >> 7) - (x << 24 - z);
                    int y24shift = (y31 >> 7) - (y << 24 - z);
                    int precisionXY = MapUtils.calculateFromBaseZoomPrecisionXY((int)24, (int)27, (int)(x31 >> 4), (int)(y31 >> 4));
                    if (poi.id > 0x2000000000000L) continue;
                    writer.writePoiDataAtom(poi.id, x24shift, y24shift, type, subtype, poi.additionalTags, globalCategories, this.settings.poiZipLongStrings ? this.settings.poiZipStringLimit : -1, precisionXY, poi.tagGroups);
                }
            } else {
                prepareStatement.setInt(1, x << 31 - z);
                prepareStatement.setInt(2, x + 1 << 31 - z);
                prepareStatement.setInt(3, y << 31 - z);
                prepareStatement.setInt(4, y + 1 << 31 - z);
                ResultSet rset = prepareStatement.executeQuery();
                HashMap<PoiAdditionalType, String> mp = new HashMap<PoiAdditionalType, String>();
                while (rset.next()) {
                    long id = rset.getLong(1);
                    int x31 = rset.getInt(2);
                    int y31 = rset.getInt(3);
                    int x24shift = (x31 >> 7) - (x << 24 - z);
                    int y24shift = (y31 >> 7) - (y << 24 - z);
                    int precisionXY = MapUtils.calculateFromBaseZoomPrecisionXY((int)24, (int)27, (int)(x31 >> 4), (int)(y31 >> 4));
                    String type = rset.getString(4);
                    String subtype = rset.getString(5);
                    List<Integer> tagGroupIds = this.poiTagGroups.get(id);
                    if (Algorithms.isEmpty(tagGroupIds)) {
                        tagGroupIds = this.parseTaggroups(rset.getString(6));
                    }
                    if (id > 0x2000000000000L) continue;
                    writer.writePoiDataAtom(id, x24shift, y24shift, type, subtype, this.decodeAdditionalInfo(rset.getString(6), mp), globalCategories, this.settings.poiZipLongStrings ? this.settings.poiZipStringLimit : -1, precisionXY, tagGroupIds);
                }
                rset.close();
            }
            writer.endWritePoiData();
        }
        prepareStatement.close();
        writer.endWritePoiIndex();
    }

    private void collectTopIndexMap() throws SQLException, IOException {
        if (this.topIndexAdditional != null) {
            return;
        }
        LinkedHashMap<String, TreeSet<String>> providedTopIndexes = null;
        if (this.settings.poiTopIndexUrl != null || !Algorithms.isEmpty((CharSequence)System.getenv(ENV_POI_TOP_INDEXES_URL))) {
            String url = this.settings.poiTopIndexUrl != null ? this.settings.poiTopIndexUrl : System.getenv(ENV_POI_TOP_INDEXES_URL);
            log.info((Object)("Using global list of poi additionals - " + url));
            providedTopIndexes = new LinkedHashMap<String, TreeSet<String>>();
            InputStream is = new URL(url).openStream();
            StringBuilder sb = Algorithms.readFromInputStream((InputStream)is);
            for (String s : sb.toString().split("\n")) {
                String tag = s.substring(0, s.indexOf(44));
                String value = s.substring(s.indexOf(44) + 1);
                TreeSet<String> set = (TreeSet<String>)providedTopIndexes.get(tag);
                if (set == null) {
                    set = new TreeSet<String>();
                    providedTopIndexes.put(tag, set);
                }
                set.add(value);
            }
        } else {
            log.info((Object)"Not using global list of poi indexes");
        }
        this.topIndexAdditional = new LinkedHashMap<String, Set<String>>();
        boolean isBrand = false;
        for (Map.Entry entry : this.poiTypes.topIndexPoiAdditional.entrySet()) {
            String column;
            if (!this.topIndexKeys.contains(entry.getKey()) || (column = (String)entry.getKey()).contains(":")) continue;
            if (((String)entry.getKey()).equals("top_index_brand")) {
                isBrand = true;
            }
            int minCount = ((PoiType)entry.getValue()).getMinCount();
            int maxPerMap = ((PoiType)entry.getValue()).getMaxPerMap();
            minCount = minCount > 0 ? minCount : 3;
            int n = maxPerMap = maxPerMap > 0 ? maxPerMap : 100;
            if (providedTopIndexes != null) {
                minCount = 0;
                maxPerMap = 1000;
            }
            ResultSet rs = this.poiConnection.createStatement().executeQuery("select count(*) as cnt, \"" + column + "\", * from poi where \"" + column + "\" is not NULL group by \"" + column + "\" having cnt > " + minCount + " order by cnt desc");
            HashSet<String> set = new HashSet<String>();
            while (rs.next()) {
                String originalValue = rs.getString(2);
                if (Algorithms.isEmpty((CharSequence)originalValue)) continue;
                if (providedTopIndexes != null) {
                    String normalizedValue = TopTagValuesAnalyzer.normalizeTagValue(originalValue);
                    String key = ((String)entry.getKey()).substring("top_index_".length());
                    if (!providedTopIndexes.containsKey(key) || !((Set)providedTopIndexes.get(key)).contains(normalizedValue) || maxPerMap-- <= 0) continue;
                    set.add(originalValue);
                    this.addTopIndexWithLang(rs, column, originalValue);
                    continue;
                }
                if (maxPerMap-- > 0) {
                    set.add(originalValue);
                    this.addTopIndexWithLang(rs, column, originalValue);
                    continue;
                }
                if (!isBrand || !this.WORLD_BRANDS.contains(originalValue)) continue;
                set.add(originalValue);
                this.addTopIndexWithLang(rs, column, originalValue);
            }
            this.topIndexAdditional.put(column, set);
        }
    }

    private void addTopIndexWithLang(ResultSet rs, String topIndexKey, String topIndexVal) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<String> savedValues = new ArrayList<String>();
        for (int i = 3; i < columnCount; ++i) {
            String columnName;
            String value = rs.getString(i);
            if (Algorithms.isEmpty((CharSequence)value) || (columnName = metaData.getColumnName(i)).equals(topIndexKey) || !columnName.startsWith(topIndexKey) || value.equals(topIndexVal) || savedValues.contains(value)) continue;
            this.topIndexAdditional.computeIfAbsent(columnName, k -> new HashSet()).add(value);
            savedValues.add(value);
        }
    }

    private void processPOIIntoTree(File poiGeocoding, Map<String, Set<PoiTileBox>> namesIndex, int zoomToStart, IntBbox bbox, Tree<PoiTileBox> rootZoomsTree) throws SQLException, IOException {
        ResultSet rs = this.poiConnection.createStatement().executeQuery("SELECT x,y,type,subtype,id,additionalTags,taggroups from poi ORDER BY id, priority");
        rootZoomsTree.setNode(new PoiTileBox());
        long geocodingTime = 0L;
        long geocodingCnt = 0L;
        long geocodingSuccess = 0L;
        long geoCitySuccess = 0L;
        long geoCityCnt = 0L;
        long geoCityTime = 0L;
        RoutingContext geocodingCtx = null;
        GeocodingUtilities geocodingUtilities = new GeocodingUtilities();
        BinaryMapIndexReader geoReader = null;
        if (poiGeocoding != null && this.settings.poiGeocodingEnable) {
            geoReader = new BinaryMapIndexReader(new RandomAccessFile(poiGeocoding, "r"), poiGeocoding, false);
            geoReader.init(false);
            if (geoReader.containsAddressData() && geoReader.containsRouteData()) {
                geocodingCtx = GeocodingUtilities.buildDefaultContextForPOI((BinaryMapIndexReader)geoReader);
            }
        }
        if (geocodingCtx == null) {
            log.info((Object)"Geocoding for POI is disabled");
        } else {
            log.info((Object)"Geocoding for POI is enabled");
        }
        int count = 0;
        ConsoleProgressImplementation console = new ConsoleProgressImplementation();
        console.startWork(1000000);
        LinkedHashMap<PoiAdditionalType, String> additionalTags = new LinkedHashMap<PoiAdditionalType, String>();
        PoiAdditionalType nameRuleType = this.getOrCreate("name", null, true);
        PoiAdditionalType nameEnRuleType = this.getOrCreate("name:en", null, true);
        PoiAdditionalType streetRuleType = this.getOrCreate("addr_street", null, true);
        PoiAdditionalType hnoRuleType = this.getOrCreate("addr_housenumber", null, true);
        PoiAdditionalType wikidataType = this.getOrCreate("wikidata", null, true);
        HashSet<String> duplicateWikiWids = new HashSet<String>();
        while (rs.next()) {
            boolean added;
            String wikidata;
            int x = rs.getInt(1);
            int y = rs.getInt(2);
            LatLon latLon = new LatLon(MapUtils.get31LatitudeY((int)y), MapUtils.get31LongitudeX((int)x));
            bbox.minX = Math.min(x, bbox.minX);
            bbox.maxX = Math.max(x, bbox.maxX);
            bbox.minY = Math.min(y, bbox.minY);
            bbox.maxY = Math.max(y, bbox.maxY);
            if (count++ > 10000) {
                count = 0;
                console.progress(10000);
            }
            String type = rs.getString(3);
            String subtype = rs.getString(4);
            this.decodeAdditionalInfo(rs.getString(6), additionalTags);
            if (type.equals("osmwiki") && additionalTags.containsKey(wikidataType) && (wikidata = (String)additionalTags.get(wikidataType)) != null && wikidata.length() > 0 && !(added = duplicateWikiWids.add(wikidata))) continue;
            if (geocodingCtx != null && Algorithms.isEmpty((CharSequence)((CharSequence)additionalTags.get(streetRuleType))) && !Algorithms.isEmpty((CharSequence)((CharSequence)additionalTags.get(nameRuleType)))) {
                long tm = System.currentTimeMillis();
                List res = geocodingUtilities.reverseGeocodingSearch(geocodingCtx, latLon.getLatitude(), latLon.getLongitude(), false);
                if (this.settings.poiGeocodingPrecise) {
                    res = geocodingUtilities.sortGeocodingResults(Collections.singletonList(geoReader), res);
                }
                ++geocodingCnt;
                if (res.size() > 0 && ((GeocodingUtilities.GeocodingResult)res.get(0)).getDistance() < 150.0) {
                    GeocodingUtilities.GeocodingResult geoRes = (GeocodingUtilities.GeocodingResult)res.get(0);
                    if (geoRes.streetName != null) {
                        additionalTags.put(streetRuleType, geoRes.streetName);
                        if (geoRes.getBuildingString() != null) {
                            additionalTags.put(hnoRuleType, geoRes.getBuildingString());
                        }
                        ++geocodingSuccess;
                    }
                }
                geocodingTime += System.currentTimeMillis() - tm;
            }
            List<Integer> tagGroupIds = this.parseTaggroups(rs.getString(7));
            ArrayList<PoiCreatorTagGroup> tagGroups = new ArrayList<PoiCreatorTagGroup>();
            if (this.cityQuadTree != null) {
                ++geoCityCnt;
                long tm = System.currentTimeMillis();
                ArrayList result = new ArrayList();
                this.cityQuadTree.queryInBox(new QuadRect((double)x, (double)y, (double)x, (double)y), result);
                boolean ok = false;
                if (result.size() > 0) {
                    for (Multipolygon multipolygon : result) {
                        if (!multipolygon.containsPoint(latLon)) continue;
                        if (!this.cityTagsGroup.containsKey(multipolygon)) {
                            log.error((Object)("Multipolygon for POI is not found!!! " + type + " " + subtype + " " + latLon.toString()));
                            continue;
                        }
                        ok = true;
                        List<PoiCreatorTagGroup> list = this.cityTagsGroup.get(multipolygon);
                        tagGroups.addAll(list);
                    }
                }
                if (ok) {
                    ++geoCitySuccess;
                }
                geoCityTime += System.currentTimeMillis() - tm;
            } else if (this.tagGroupsFromDB != null && tagGroupIds.size() > 0) {
                for (int id : tagGroupIds) {
                    if (!this.tagGroupsFromDB.containsKey(id)) continue;
                    tagGroups.add(this.tagGroupsFromDB.get(id));
                }
            }
            Tree<PoiTileBox> prevTree = rootZoomsTree;
            rootZoomsTree.getNode().categories.addCategory(type, subtype, additionalTags);
            if (tagGroups.size() > 0) {
                rootZoomsTree.getNode().tagGroups.addTagGroup(tagGroups);
            }
            for (int i = zoomToStart; i <= 16; ++i) {
                Multipolygon multipolygon;
                int xs = x >> 31 - i;
                int ys = y >> 31 - i;
                Tree subtree = null;
                multipolygon = prevTree.getSubtrees().iterator();
                while (multipolygon.hasNext()) {
                    Tree sub = (Tree)multipolygon.next();
                    if (((PoiTileBox)sub.getNode()).x != xs || ((PoiTileBox)sub.getNode()).y != ys || ((PoiTileBox)sub.getNode()).zoom != i) continue;
                    subtree = sub;
                    break;
                }
                if (subtree == null) {
                    subtree = new Tree();
                    PoiTileBox poiBox = new PoiTileBox();
                    subtree.setNode(poiBox);
                    poiBox.x = xs;
                    poiBox.y = ys;
                    poiBox.zoom = i;
                    prevTree.addSubTree(subtree);
                }
                ((PoiTileBox)subtree.getNode()).categories.addCategory(type, subtype, additionalTags);
                ((PoiTileBox)subtree.getNode()).tagGroups.addTagGroup(tagGroups);
                prevTree = subtree;
            }
            TreeSet<String> otherNames = null;
            TreeSet<String> idNames = null;
            for (Map.Entry e : additionalTags.entrySet()) {
                String tag = ((PoiAdditionalType)e.getKey()).getTag();
                if (ObfConstants.isTagIndexedForSearchAsName((String)tag) && !"name:en".equals(tag)) {
                    if (otherNames == null) {
                        otherNames = new TreeSet<String>();
                    }
                    otherNames.add((String)e.getValue());
                }
                if (this.settings.charsToBuildPoiIdNameIndex > 0 && ObfConstants.isTagIndexedForSearchAsId((String)tag)) {
                    if (idNames == null) {
                        idNames = new TreeSet<String>();
                    }
                    idNames.add((String)e.getValue());
                }
                if (this.settings.charsToBuildPoiIdNameIndex <= 0 || !tag.equals("route_members_ids")) continue;
                if (idNames == null) {
                    idNames = new TreeSet();
                }
                for (String id : ((String)e.getValue()).split(" ")) {
                    idNames.add(id);
                }
            }
            this.addNamePrefix((String)additionalTags.get(nameRuleType), (String)additionalTags.get(nameEnRuleType), prevTree.getNode(), namesIndex, otherNames, idNames);
            if (tagGroupIds.size() == 0) {
                Map.Entry e;
                e = tagGroups.iterator();
                while (e.hasNext()) {
                    PoiCreatorTagGroup p = (PoiCreatorTagGroup)e.next();
                    tagGroupIds.add(p.id);
                }
            }
            if (this.useInMemoryCreator) {
                if (prevTree.getNode().poiData == null) {
                    prevTree.getNode().poiData = new ArrayList<PoiData>();
                }
                PoiData poiData = new PoiData();
                poiData.x = x;
                poiData.y = y;
                poiData.type = type;
                poiData.subtype = subtype;
                poiData.id = rs.getLong(5);
                poiData.additionalTags.putAll(additionalTags);
                poiData.tagGroups.addAll(tagGroupIds);
                prevTree.getNode().poiData.add(poiData);
                continue;
            }
            this.poiTagGroups.put(rs.getLong(5), tagGroupIds);
        }
        log.info((Object)String.format("POI geocoding full address (%d of %d for %.2f sec), city (%d of %d for %.2f sec)", geocodingSuccess, geocodingCnt, (double)geocodingTime / 1000.0, geoCitySuccess, geoCityCnt, (double)geoCityTime / 1000.0));
        log.info((Object)"Poi processing finished");
    }

    private void addNamePrefix(String name, String nameEn, PoiTileBox data, Map<String, Set<PoiTileBox>> poiData, Set<String> names, Set<String> idNames) {
        if (name != null) {
            this.parsePrefix(name, data, poiData, this.settings.charsToBuildPoiNameIndex);
            if (Algorithms.isEmpty((CharSequence)nameEn)) {
                nameEn = Junidecode.unidecode((String)name);
            }
        }
        if (!Algorithms.objectEquals((Object)nameEn, (Object)name) && !Algorithms.isEmpty((CharSequence)nameEn)) {
            this.parsePrefix(nameEn, data, poiData, this.settings.charsToBuildPoiNameIndex);
        }
        if (names != null) {
            for (String nk : names) {
                if (Algorithms.objectEquals((Object)nk, (Object)name) || Algorithms.isEmpty((CharSequence)nk)) continue;
                this.parsePrefix(nk, data, poiData, this.settings.charsToBuildPoiNameIndex);
            }
        }
        if (idNames != null) {
            for (String nk : idNames) {
                if (Algorithms.isEmpty((CharSequence)nk)) continue;
                this.parsePrefix(nk, data, poiData, this.settings.charsToBuildPoiIdNameIndex);
            }
        }
    }

    private void parsePrefix(String name, PoiTileBox data, Map<String, Set<PoiTileBox>> poiData, int ind) {
        String arabic;
        name = Algorithms.normalizeSearchText((String)name);
        HashSet splitName = new HashSet(Algorithms.splitByWordsLowercase((String)name));
        if (ArabicNormalizer.isSpecialArabic((String)name) && (arabic = ArabicNormalizer.normalize((String)name)) != null && !arabic.equals(name)) {
            splitName.addAll(Algorithms.splitByWordsLowercase((String)arabic));
        }
        for (String str : splitName) {
            if (str.length() > ind) {
                str = str.substring(0, ind);
            }
            if (!poiData.containsKey(str)) {
                poiData.put(str, new LinkedHashSet());
            }
            poiData.get(str).add(data);
        }
    }

    private void writePoiBoxes(BinaryMapIndexWriter writer, Tree<PoiTileBox> tree, long startFpPoiIndex, Map<PoiTileBox, List<BinaryFileReference>> fpToWriteSeeks, PoiCreatorCategories globalCategories) throws IOException, SQLException {
        int zoom;
        int x = tree.getNode().x;
        int y = tree.getNode().y;
        boolean end = (zoom = tree.getNode().zoom) == 16;
        BinaryFileReference fileRef = writer.startWritePoiBox(zoom, x, y, startFpPoiIndex, end);
        if (fileRef != null) {
            if (!fpToWriteSeeks.containsKey(tree.getNode())) {
                fpToWriteSeeks.put(tree.getNode(), new ArrayList());
            }
            fpToWriteSeeks.get(tree.getNode()).add(fileRef);
        }
        if (zoom >= 12 && zoom <= 16) {
            PoiCreatorCategories boxCats = tree.getNode().categories;
            boxCats.buildCategoriesToWrite(globalCategories);
            writer.writePoiCategories(boxCats);
        }
        PoiCreatorTagGroups tagGroups = tree.getNode().tagGroups;
        writer.writePoiTagGroups(tagGroups);
        if (!end) {
            for (Tree<PoiTileBox> subTree : tree.getSubtrees()) {
                this.writePoiBoxes(writer, subTree, startFpPoiIndex, fpToWriteSeeks, globalCategories);
            }
        }
        writer.endWritePoiBox();
    }

    private String getCreateColumnsTopIndexAdditionals() {
        if (this.poiTypes != null && this.poiTypes.topIndexPoiAdditional.size() > 0) {
            Object sql = "";
            for (Map.Entry entry : this.poiTypes.topIndexPoiAdditional.entrySet()) {
                sql = (String)sql + "\"" + (String)entry.getKey() + "\" varchar(2048), ";
            }
            return sql;
        }
        return "";
    }

    private String getInsertColumnsTopIndexAdditionals() {
        if (this.poiTypes != null && this.poiTypes.topIndexPoiAdditional.size() > 0) {
            Object sql = "";
            for (Map.Entry entry : this.poiTypes.topIndexPoiAdditional.entrySet()) {
                sql = (String)sql + " ,\"" + (String)entry.getKey() + "\"";
            }
            return sql;
        }
        return "";
    }

    private String getInsertValuesTopIndexAdditionals() {
        if (this.poiTypes != null && this.poiTypes.topIndexPoiAdditional.size() > 0) {
            Object sql = "";
            for (Map.Entry entry : this.poiTypes.topIndexPoiAdditional.entrySet()) {
                sql = (String)sql + ", ?";
            }
            return sql;
        }
        return "";
    }

    private String insertMergedTaggroups(Amenity amenity) throws SQLException {
        Map tg = amenity.getTagGroups();
        if (tg == null || tg.isEmpty()) {
            return "";
        }
        Object result = "";
        String region = amenity.getRegionName();
        Map replaceIDMap = this.tagGroupIdsByRegion.computeIfAbsent(region, s -> new HashMap());
        for (Map.Entry entry : tg.entrySet()) {
            int mergedId;
            int id = (Integer)entry.getKey();
            if (!replaceIDMap.containsKey(id)) {
                mergedId = this.maxTagGroupId + 1;
                Object allPairs = "";
                for (BinaryMapIndexReader.TagValuePair p : (List)entry.getValue()) {
                    if (!((String)allPairs).isEmpty()) {
                        allPairs = (String)allPairs + ",";
                    }
                    allPairs = (String)allPairs + p.tag + "," + p.value;
                }
                this.tagGroupsPreparedStatement.setInt(1, mergedId);
                this.tagGroupsPreparedStatement.setString(2, (String)allPairs);
                this.addBatch(this.tagGroupsPreparedStatement);
                replaceIDMap.put(id, mergedId);
                this.maxTagGroupId = mergedId;
            } else {
                mergedId = (Integer)replaceIDMap.get(id);
            }
            if (!((String)result).isEmpty()) {
                result = (String)result + ",";
            }
            result = (String)result + String.valueOf(mergedId);
        }
        return result;
    }

    private void collectTagGroups() throws SQLException {
        ResultSet rs = this.poiConnection.createStatement().executeQuery("select id, tagvalues from taggroups");
        while (rs.next()) {
            if (this.tagGroupsFromDB == null) {
                this.tagGroupsFromDB = new HashMap<Integer, PoiCreatorTagGroup>();
            }
            int id = rs.getInt(1);
            String tg = rs.getString(2);
            String[] strArray = tg.split(",");
            List<String> tagValues = Arrays.asList(strArray);
            PoiCreatorTagGroup poiCreatorTagGroup = new PoiCreatorTagGroup(id, tagValues);
            this.tagGroupsFromDB.put(id, poiCreatorTagGroup);
        }
    }

    private List<Integer> parseTaggroups(String taggroupsColumn) {
        ArrayList<Integer> tagGroupIds = new ArrayList<Integer>();
        String[] strArray = taggroupsColumn.split(",");
        for (int i = 0; i < strArray.length; ++i) {
            if (Algorithms.isEmpty((CharSequence)strArray[i])) continue;
            Integer tg = Integer.parseInt(strArray[i]);
            tagGroupIds.add(tg);
        }
        return tagGroupIds;
    }

    public void resetOrder(Amenity amenity) {
        String subtype;
        PoiCategory pc = amenity.getType();
        PoiType pt = pc.getPoiTypeByKeyName(subtype = amenity.getSubType());
        if (pt != null) {
            amenity.setOrder(pt.getOrder());
        }
    }

    public static class PoiCreatorTagGroup {
        int id;
        List<String> tagValues;

        PoiCreatorTagGroup(int id, List<String> tagValues) {
            this.id = id;
            this.tagValues = tagValues;
        }
    }

    public static class PoiAdditionalType {
        private String tag;
        private String value;
        private boolean text;
        private int usage;
        private int targetId;
        private int id;

        public PoiAdditionalType(int id, String tag, String value, boolean text) {
            this.id = id;
            this.tag = tag;
            this.text = text;
            this.value = text ? null : value;
        }

        public int getId() {
            return this.id;
        }

        public boolean isText() {
            return this.text;
        }

        public void increment() {
            ++this.usage;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public int getUsage() {
            return this.usage;
        }

        public String getTag() {
            return this.tag;
        }

        public String getValue() {
            return this.value;
        }

        public static String getKey(String tag, String value, boolean text) {
            return text ? tag : tag + "/" + value;
        }

        public void setTargetPoiId(int catId, int valueId) {
            if (catId <= 31) {
                this.targetId = valueId << 6 | catId << 1;
            } else {
                if (catId > 32768) {
                    throw new IllegalArgumentException("Refer source code");
                }
                this.targetId = valueId << 16 | catId << 1 | 1;
            }
        }
    }

    private class IntBbox {
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;

        private IntBbox() {
        }
    }

    private static class Tree<T> {
        private T node;
        private List<Tree<T>> subtrees = null;

        private Tree() {
        }

        public List<Tree<T>> getSubtrees() {
            if (this.subtrees == null) {
                this.subtrees = new ArrayList<Tree<T>>();
            }
            return this.subtrees;
        }

        public void addSubTree(Tree<T> t) {
            this.getSubtrees().add(t);
        }

        public T getNode() {
            return this.node;
        }

        public void setNode(T node) {
            this.node = node;
        }

        public void extractChildrenFromLevel(int level) {
            ArrayList<Tree<T>> list = new ArrayList<Tree<T>>();
            this.collectChildrenFromLevel(list, level);
            this.subtrees = list;
        }

        public void collectChildrenFromLevel(List<Tree<T>> list, int level) {
            if (level == 0) {
                if (this.subtrees != null) {
                    list.addAll(this.subtrees);
                }
            } else if (this.subtrees != null) {
                for (Tree<T> sub : this.subtrees) {
                    sub.collectChildrenFromLevel(list, level - 1);
                }
            }
        }

        public int getSubTreesOnLevel(int level) {
            if (level == 0) {
                if (this.subtrees == null) {
                    return 0;
                }
                return this.subtrees.size();
            }
            int sum = 0;
            if (this.subtrees != null) {
                for (Tree<T> t : this.subtrees) {
                    sum += t.getSubTreesOnLevel(level - 1);
                }
            }
            return sum;
        }
    }

    public static class PoiTileBox {
        int x;
        int y;
        int zoom;
        PoiCreatorCategories categories = new PoiCreatorCategories();
        List<PoiData> poiData = null;
        PoiCreatorTagGroups tagGroups = new PoiCreatorTagGroups();

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZoom() {
            return this.zoom;
        }
    }

    public static class PoiCreatorCategories {
        Map<String, Set<String>> categories = new LinkedHashMap<String, Set<String>>();
        Set<PoiAdditionalType> additionalAttributes = new LinkedHashSet<PoiAdditionalType>();
        Map<String, Integer> catIndexes;
        Map<String, Integer> subcatIndexes;
        TIntArrayList cachedCategoriesIds;
        TIntArrayList cachedAdditionalIds;
        TIntArrayList singleThreadVarTypes = new TIntArrayList();

        private String[] split(String subCat) {
            return subCat.split(",|;");
        }

        private boolean toSplit(String subCat) {
            return subCat.contains(";") || subCat.contains(",");
        }

        public void addCategory(String cat, String subCat, Map<PoiAdditionalType, String> additionalTags) {
            for (PoiAdditionalType rt : additionalTags.keySet()) {
                if (!rt.isText() && rt.getValue() == null) {
                    throw new NullPointerException("Null value for additional tag =" + rt.getTag());
                }
                this.additionalAttributes.add(rt);
            }
            if (!this.categories.containsKey(cat)) {
                this.categories.put(cat, new TreeSet());
            }
            if (this.toSplit(subCat)) {
                String[] split;
                for (String sub : split = this.split(subCat)) {
                    this.categories.get(cat).add(sub.trim());
                }
            } else {
                this.categories.get(cat).add(subCat.trim());
            }
        }

        public TIntArrayList buildTypeIds(String category, String subcategory) {
            this.singleThreadVarTypes.clear();
            TIntArrayList types = this.singleThreadVarTypes;
            this.internalBuildType(category, subcategory, types);
            return types;
        }

        private void internalBuildType(String category, String subcategory, TIntArrayList types) {
            int catInd = this.catIndexes.get(category);
            if (this.toSplit(subcategory)) {
                for (String sub : this.split(subcategory)) {
                    Integer subcatInd = this.subcatIndexes.get(category + "\uffff" + sub.trim());
                    if (subcatInd == null) {
                        throw new IllegalArgumentException("Unknown subcategory " + sub + " category " + category);
                    }
                    types.add(subcatInd << 7 | catInd);
                }
            } else {
                Integer subcatInd = this.subcatIndexes.get(category + "\uffff" + subcategory.trim());
                if (subcatInd == null) {
                    throw new IllegalArgumentException("Unknown subcategory " + subcategory + " category " + category);
                }
                types.add(subcatInd << 7 | catInd);
            }
        }

        public void buildCategoriesToWrite(PoiCreatorCategories globalCategories) {
            this.cachedCategoriesIds = new TIntArrayList();
            this.cachedAdditionalIds = new TIntArrayList();
            for (Map.Entry<String, Set<String>> cats : this.categories.entrySet()) {
                for (String subcat : cats.getValue()) {
                    String cat = cats.getKey();
                    globalCategories.internalBuildType(cat, subcat, this.cachedCategoriesIds);
                }
            }
            for (PoiAdditionalType rt : this.additionalAttributes) {
                if (rt.getTargetId() == -1) {
                    throw new IllegalStateException("Map rule type is not registered for poi : " + String.valueOf(rt));
                }
                this.cachedAdditionalIds.add(rt.getTargetId());
            }
        }

        public void setSubcategoryIndex(String cat, String sub, int j) {
            if (this.subcatIndexes == null) {
                this.subcatIndexes = new HashMap<String, Integer>();
            }
            this.subcatIndexes.put(cat + "\uffff" + sub, j);
        }

        public void setCategoryIndex(String cat, int i) {
            if (this.catIndexes == null) {
                this.catIndexes = new HashMap<String, Integer>();
            }
            this.catIndexes.put(cat, i);
        }
    }

    private static class PoiData {
        int x;
        int y;
        String type;
        String subtype;
        long id;
        Map<PoiAdditionalType, String> additionalTags = new HashMap<PoiAdditionalType, String>();
        List<Integer> tagGroups = new ArrayList<Integer>();

        private PoiData() {
        }

        public int getRating() {
            int rt = 0;
            for (PoiAdditionalType t : this.additionalTags.keySet()) {
                if (!t.getTag().equals("travel_elo")) continue;
                try {
                    rt = Integer.parseInt(this.additionalTags.get(t));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                break;
            }
            if (rt > 0) {
                return rt;
            }
            return this.additionalTags.size();
        }
    }

    public static class PoiCreatorTagGroups {
        HashSet<Integer> ids;
        HashSet<PoiCreatorTagGroup> tagGroups;

        public void addTagGroup(List<PoiCreatorTagGroup> poiCreatorTagGroups) {
            for (PoiCreatorTagGroup poiCreatorTagGroup : poiCreatorTagGroups) {
                if (this.ids == null) {
                    this.ids = new HashSet();
                    this.tagGroups = new HashSet();
                }
                if (this.ids.contains(poiCreatorTagGroup.id)) continue;
                this.ids.add(poiCreatorTagGroup.id);
                this.tagGroups.add(poiCreatorTagGroup);
            }
        }
    }
}

