/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.data.Boundary;
import net.osmand.data.City;
import net.osmand.data.DataTileManager;
import net.osmand.data.QuadRect;
import net.osmand.osm.edit.Entity;
import net.osmand.util.MapUtils;

public class CityDataStorage {
    public Map<City, Boundary> cityBoundaries = new HashMap<City, Boundary>();
    public Map<Boundary, List<City>> boundaryToContainingCities = new HashMap<Boundary, List<City>>();
    private static final double CITY_VILLAGE_DIST = 30000.0;
    private DataTileManager<City> cityVillageManager = new DataTileManager(13);
    private static final double CITY_DIST = 70000.0;
    private DataTileManager<City> cityManager = new DataTileManager(10);
    private Map<Entity.EntityId, City> cities = new LinkedHashMap<Entity.EntityId, City>();
    private List<Boundary> notAssignedBoundaries = new ArrayList<Boundary>();

    public List<City> getClosestObjects(double latitude, double longitude) {
        ArrayList<City> result = new ArrayList();
        result = this.cityManager.getClosestObjects(latitude, longitude, 70000.0);
        for (City c : this.cityVillageManager.getClosestObjects(latitude, longitude, 30000.0)) {
            result.add(c);
        }
        return result;
    }

    public void registerObject(double latitude, double longitude, City city, Entity e) {
        if (city.getType() == City.CityType.CITY || city.getType() == City.CityType.TOWN) {
            this.cityManager.registerObject(latitude, longitude, (Object)city);
        } else {
            this.cityVillageManager.registerObject(latitude, longitude, (Object)city);
        }
        this.cities.put(Entity.EntityId.valueOf((Entity)e), city);
    }

    public City getRegisteredCity(Entity e) {
        return this.cities.get(Entity.EntityId.valueOf((Entity)e));
    }

    public Boundary getBoundaryByCity(City c) {
        return this.cityBoundaries.get(c);
    }

    public void setCityBoundary(City c, Boundary b) {
        this.cityBoundaries.put(c, b);
    }

    public boolean isCityHasBoundary(City c) {
        return this.cityBoundaries.containsKey(c);
    }

    public List<City> getCityListByBoundary(Boundary b) {
        if (this.boundaryToContainingCities.containsKey(b)) {
            return this.boundaryToContainingCities.get(b);
        }
        return null;
    }

    public void attachAllCitiesToBoundary(Boundary boundary) {
        ArrayList<City> list = new ArrayList<City>(1);
        for (City c : this.cities.values()) {
            if (!boundary.containsPoint(c.getLocation())) continue;
            list.add(c);
        }
        if (list.size() > 0) {
            this.boundaryToContainingCities.put(boundary, list);
        }
    }

    public List<Boundary> getNotAssignedBoundaries() {
        return this.notAssignedBoundaries;
    }

    public void addNotAssignedBoundary(Boundary boundary) {
        this.notAssignedBoundaries.add(boundary);
    }

    public void removeNotAssignedBoundary(Boundary boundary) {
        this.notAssignedBoundaries.remove(boundary);
    }

    public Collection<City> getAllCities() {
        return this.cities.values();
    }

    public int citiesSize() {
        return this.cities.size();
    }

    public void assignBbox(City c) {
        Boundary b = this.cityBoundaries.get(c);
        if (c.getBbox31() == null && b != null) {
            this.assignBbox(c, b);
        }
    }

    public void assignBbox(City c, Boundary b) {
        QuadRect bbox = b.getMultipolygon().getLatLonBbox();
        c.setBbox31(new int[]{MapUtils.get31TileNumberX((double)bbox.left), MapUtils.get31TileNumberY((double)bbox.top), MapUtils.get31TileNumberX((double)bbox.right), MapUtils.get31TileNumberY((double)bbox.bottom)});
    }
}

