/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import net.osmand.shared.data.StringIntPair;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.FilterChangedListener;
import net.osmand.shared.gpx.filters.ListTrackFilter$;
import net.osmand.shared.gpx.filters.SingleFieldTrackFilterParams;
import net.osmand.shared.gpx.filters.TrackFilterType;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.SerialNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 X2\u00020\u0001:\u0002WXB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007Bm\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f\u0012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0006\u0010\u0016J\u0016\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'J\b\u0010)\u001a\u00020\u0013H\u0016J/\u00107\u001a\u00020%2\"\u00108\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0011j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t`1\u00a2\u0006\u0002\u00105J\u0014\u00107\u001a\u00020%2\f\u00108\u001a\b\u0012\u0004\u0012\u00020=0'J\u0014\u0010-\u001a\u00020%2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0'J\u0016\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u0013J\u000e\u0010A\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u000bJ\u0010\u0010B\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u0001H\u0016J\u0014\u0010C\u001a\u00020\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0'J\u0010\u0010D\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u000bH\u0016J\u000e\u0010F\u001a\u00020\t2\u0006\u0010E\u001a\u00020\u000bJ\b\u0010G\u001a\u00020\u0013H\u0016J\u0014\u0010H\u001a\u00020%2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0'J\u0006\u0010I\u001a\u00020%J\u0010\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020(H\u0016J\u0010\u0010L\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020(H\u0004J\u0013\u0010M\u001a\u00020\u00132\b\u0010N\u001a\u0004\u0018\u00010OH\u0096\u0002J\b\u0010P\u001a\u00020\tH\u0016J \u0010Q\u001a\u00020%2\u0006\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0007R$\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR(\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R8\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8\u0006@DX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b*\u0010\u001a\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R8\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0011j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t`1X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b2\u00103\"\u0004\b4\u00105R,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b9\u0010\u001a\u001a\u0004\b\u0012\u0010:\"\u0004\b;\u0010<\u00a8\u0006Y\u0080\u00e5\b\u0002\u0080\u00e5\b\n\u0080\u00e5\b\f\u0080\u00e5\b\u000e\u0080\u00e5\b\u0010\u0080\u00e5\b\u0012"}, d2={"Lnet/osmand/shared/gpx/filters/ListTrackFilter;", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "trackFilterType", "Lnet/osmand/shared/gpx/filters/TrackFilterType;", "filterChangedListener", "Lnet/osmand/shared/gpx/filters/FilterChangedListener;", "<init>", "(Lnet/osmand/shared/gpx/filters/TrackFilterType;Lnet/osmand/shared/gpx/filters/FilterChangedListener;)V", "seen0", "", "firstItem", "", "selectedItems", "Ljava/util/ArrayList;", "allItems", "", "allItemsCollection", "Ljava/util/HashMap;", "isSelectAllItemsSelected", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILnet/osmand/shared/gpx/filters/TrackFilterType;Ljava/lang/String;Ljava/util/ArrayList;Ljava/util/List;Ljava/util/HashMap;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "collectionFilterParams", "Lnet/osmand/shared/gpx/filters/SingleFieldTrackFilterParams;", "getCollectionFilterParams$annotations", "()V", "getCollectionFilterParams", "()Lnet/osmand/shared/gpx/filters/SingleFieldTrackFilterParams;", "setCollectionFilterParams", "(Lnet/osmand/shared/gpx/filters/SingleFieldTrackFilterParams;)V", "value", "getFirstItem", "()Ljava/lang/String;", "setFirstItem", "(Ljava/lang/String;)V", "updateFullCollection", "", "items", "", "Lnet/osmand/shared/gpx/TrackItem;", "isEnabled", "getSelectedItems$annotations", "getSelectedItems", "()Ljava/util/ArrayList;", "setSelectedItems", "(Ljava/util/ArrayList;)V", "getAllItems", "()Ljava/util/List;", "Lkotlin/collections/HashMap;", "getAllItemsCollection", "()Ljava/util/HashMap;", "setAllItemsCollection", "(Ljava/util/HashMap;)V", "Ljava/util/HashMap;", "setFullItemsCollection", "collection", "isSelectAllItemsSelected$annotations", "()Z", "setSelectAllItemsSelected", "(Z)V", "Lnet/osmand/shared/data/StringIntPair;", "setItemSelected", "item", "selected", "isItemSelected", "initWithValue", "areAllItemsSelected", "getItemText", "itemName", "getTracksCountForItem", "hasSelectAllVariant", "addSelectedItems", "clearSelectedItems", "isTrackAccepted", "trackItem", "getTrackPropertyValue", "equals", "other", "", "hashCode", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "OsmAnd-shared"})
public class ListTrackFilter
extends BaseTrackFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public SingleFieldTrackFilterParams collectionFilterParams;
    @Nullable
    private String firstItem;
    @NotNull
    private ArrayList<String> selectedItems;
    @NotNull
    private List<String> allItems;
    @NotNull
    private HashMap<String, Integer> allItemsCollection;
    private boolean isSelectAllItemsSelected;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public ListTrackFilter(@NotNull TrackFilterType trackFilterType, @Nullable FilterChangedListener filterChangedListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackFilterType), (String)"trackFilterType");
        super(trackFilterType, filterChangedListener, null);
        Object additionalData = this.getTrackFilterType().getAdditionalData();
        if (additionalData == null || !(additionalData instanceof SingleFieldTrackFilterParams)) {
            throw new IllegalArgumentException("additionalData in " + this.getTrackFilterType() + " filter should be valid instance of CollectionTrackFilterParams");
        }
        this.setCollectionFilterParams((SingleFieldTrackFilterParams)additionalData);
        this.selectedItems = new ArrayList();
        this.allItems = new ArrayList();
        this.allItemsCollection = new HashMap();
    }

    @NotNull
    public final SingleFieldTrackFilterParams getCollectionFilterParams() {
        SingleFieldTrackFilterParams singleFieldTrackFilterParams = this.collectionFilterParams;
        if (singleFieldTrackFilterParams != null) {
            return singleFieldTrackFilterParams;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"collectionFilterParams");
        return null;
    }

    public final void setCollectionFilterParams(@NotNull SingleFieldTrackFilterParams singleFieldTrackFilterParams) {
        Intrinsics.checkNotNullParameter((Object)singleFieldTrackFilterParams, (String)"<set-?>");
        this.collectionFilterParams = singleFieldTrackFilterParams;
    }

    @Transient
    public static /* synthetic */ void getCollectionFilterParams$annotations() {
    }

    @Nullable
    public final String getFirstItem() {
        return this.firstItem;
    }

    public final void setFirstItem(@Nullable String value) {
        block0: {
            this.firstItem = value;
            String string = value;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Object[] objectArray = new String[]{it};
            this.setSelectedItems(CollectionsKt.arrayListOf((Object[])objectArray));
        }
    }

    public final void updateFullCollection(@Nullable List<TrackItem> items) {
        if (KAlgorithms.INSTANCE.isEmpty((Collection)items)) {
            this.allItemsCollection = new HashMap();
        } else {
            HashMap newCollection = new HashMap();
            List<TrackItem> list = items;
            Intrinsics.checkNotNull(list);
            for (TrackItem item : list) {
                Object object = item.getDataItem();
                if (object == null || (object = (String)((DataItem)object).getParameter(GpxParameter.FILE_DIR)) == null) {
                    object = "";
                }
                Object folderName = object;
                Integer n = (Integer)newCollection.get(folderName);
                int count = n != null ? n : 0;
                ((Map)newCollection).put(folderName, count + 1);
            }
            this.allItemsCollection = newCollection;
        }
    }

    @Override
    public boolean isEnabled() {
        return !KAlgorithms.INSTANCE.isEmpty((Collection)this.selectedItems);
    }

    @NotNull
    public final ArrayList<String> getSelectedItems() {
        return this.selectedItems;
    }

    protected final void setSelectedItems(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.selectedItems = arrayList;
    }

    @SerialNames(names={"selectedItems", "selectedFolders", "selectedCities", "selectedColors", "selectedWidths"})
    public static /* synthetic */ void getSelectedItems$annotations() {
    }

    @NotNull
    public final List<String> getAllItems() {
        return this.allItems;
    }

    @NotNull
    public final HashMap<String, Integer> getAllItemsCollection() {
        return this.allItemsCollection;
    }

    public final void setAllItemsCollection(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.allItemsCollection = hashMap;
    }

    public final void setFullItemsCollection(@NotNull HashMap<String, Integer> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.allItems = new ArrayList(collection.keySet());
        this.allItemsCollection = collection;
    }

    public final boolean isSelectAllItemsSelected() {
        return this.isSelectAllItemsSelected;
    }

    public final void setSelectAllItemsSelected(boolean value) {
        block0: {
            this.isSelectAllItemsSelected = value;
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener == null) break block0;
            filterChangedListener.onFilterChanged();
        }
    }

    @Serializable
    public static /* synthetic */ void isSelectAllItemsSelected$annotations() {
    }

    public final void setFullItemsCollection(@NotNull List<StringIntPair> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        ArrayList<String> tmpAllItems = new ArrayList<String>();
        HashMap tmpAllItemsCollection = new HashMap();
        for (StringIntPair pair : collection) {
            if (pair.getString() == null || pair.getInteger() == null) continue;
            tmpAllItems.add(pair.getString());
            ((Map)tmpAllItemsCollection).put(pair.getString(), pair.getInteger());
        }
        this.allItems = tmpAllItems;
        this.allItemsCollection = tmpAllItemsCollection;
    }

    public final void setSelectedItems(@NotNull List<String> selectedItems) {
        block0: {
            Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
            this.selectedItems = new ArrayList(selectedItems);
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener == null) break block0;
            filterChangedListener.onFilterChanged();
        }
    }

    public final void setItemSelected(@NotNull String item, boolean selected) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            boolean bl = selected ? this.selectedItems.add(item) : this.selectedItems.remove(item);
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener == null) break block0;
            filterChangedListener.onFilterChanged();
        }
    }

    public final boolean isItemSelected(@NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.selectedItems.contains(item);
    }

    @Override
    public void initWithValue(@NotNull BaseTrackFilter value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof ListTrackFilter) {
            this.setSelectedItems(new ArrayList(((ListTrackFilter)value).selectedItems));
            Iterator<String> iterator = this.selectedItems.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String item;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (this.allItems.contains(item)) continue;
                this.allItems.add(item);
                ((Map)this.allItemsCollection).put(item, 0);
            }
            super.initWithValue(value);
        }
    }

    public final boolean areAllItemsSelected(@NotNull List<String> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        for (String item : items) {
            if (this.isItemSelected(item)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String getItemText(@NotNull String itemName) {
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        return itemName;
    }

    public final int getTracksCountForItem(@NotNull String itemName) {
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        Integer n = this.allItemsCollection.get(itemName);
        return n != null ? n : 0;
    }

    public boolean hasSelectAllVariant() {
        return false;
    }

    public final void addSelectedItems(@NotNull List<String> selectedItems) {
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        this.selectedItems.addAll((Collection<String>)selectedItems);
    }

    public final void clearSelectedItems() {
        this.selectedItems = new ArrayList();
    }

    @Override
    public boolean isTrackAccepted(@NotNull TrackItem trackItem) {
        Intrinsics.checkNotNullParameter((Object)trackItem, (String)"trackItem");
        String trackItemPropertyValue = this.getTrackPropertyValue(trackItem);
        Iterator<String> iterator = this.selectedItems.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String item;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!KAlgorithms.INSTANCE.stringsEqual(trackItemPropertyValue, item)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected final String getTrackPropertyValue(@NotNull TrackItem trackItem) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)trackItem, (String)"trackItem");
        Object value = null;
        GpxDataItem gpxDataItem = trackItem.getDataItem();
        if (gpxDataItem != null) {
            GpxParameter gpxParameter = this.getTrackFilterType().getProperty();
            Intrinsics.checkNotNull((Object)((Object)gpxParameter));
            object2 = gpxDataItem.getParameter(gpxParameter);
        } else {
            object2 = null;
        }
        Object object3 = value = object2;
        if (object3 != null) {
            Object it = object3;
            boolean bl = false;
            value = this.getCollectionFilterParams().trackParamToString(it);
        }
        if ((object = value) == null || (object = object.toString()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return super.equals(other) && other instanceof ListTrackFilter && ((ListTrackFilter)other).selectedItems.size() == this.selectedItems.size() && this.areAllItemsSelected((List<String>)((ListTrackFilter)other).selectedItems);
    }

    @Override
    public int hashCode() {
        int result = this.selectedItems.hashCode();
        result = 31 * result + ((Object)this.allItems).hashCode();
        result = 31 * result + Boolean.hashCode(this.isSelectAllItemsSelected);
        return result;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(ListTrackFilter self, CompositeEncoder output, SerialDescriptor serialDesc) {
        BaseTrackFilter.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.firstItem != null) {
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.firstItem);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual(self.selectedItems, new ArrayList())) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], self.selectedItems);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual(self.allItems, new ArrayList())) {
            output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)kSerializerArray[3], self.allItems);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual(self.allItemsCollection, new HashMap())) {
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)kSerializerArray[4], self.allItemsCollection);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.isSelectAllItemsSelected) {
            output.encodeBooleanElement(serialDesc, 5, self.isSelectAllItemsSelected);
        }
    }

    public /* synthetic */ ListTrackFilter(int seen0, TrackFilterType trackFilterType, String firstItem, ArrayList selectedItems, List allItems, HashMap allItemsCollection, boolean isSelectAllItemsSelected, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, trackFilterType, serializationConstructorMarker);
        Object additionalData = this.getTrackFilterType().getAdditionalData();
        if (additionalData == null || !(additionalData instanceof SingleFieldTrackFilterParams)) {
            throw new IllegalArgumentException("additionalData in " + this.getTrackFilterType() + " filter should be valid instance of CollectionTrackFilterParams");
        }
        this.setCollectionFilterParams((SingleFieldTrackFilterParams)additionalData);
        this.firstItem = (seen0 & 2) == 0 ? null : firstItem;
        this.selectedItems = (seen0 & 4) == 0 ? new ArrayList() : selectedItems;
        this.allItems = (seen0 & 8) == 0 ? (List)new ArrayList() : allItems;
        this.allItemsCollection = (seen0 & 0x10) == 0 ? new HashMap() : allItemsCollection;
        this.isSelectAllItemsSelected = (seen0 & 0x20) == 0 ? false : isSelectAllItemsSelected;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{TrackFilterType.Companion.serializer(), null, new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), new HashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)IntSerializer.INSTANCE), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/osmand/shared/gpx/filters/ListTrackFilter$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/gpx/filters/ListTrackFilter;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ListTrackFilter> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

