/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.travel;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXUtilities;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.util.Algorithms;
import net.osmand.util.SqlInsertValuesReader;
import net.osmand.wiki.CustomWikiModel;
import net.osmand.wiki.PoiFieldCategory;
import net.osmand.wiki.WikiDatabasePreparation;
import net.osmand.wiki.WikiImageUrlStorage;
import net.osmand.wiki.WikivoyageOSMTags;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParserException;

public class WikivoyageLangPreparation {
    private static final Log log = PlatformUtil.getLog(WikivoyageLangPreparation.class);
    private static boolean uncompressed;
    private static final Map<Long, Long> KNOWN_WIKIVOYAGE_MAIN;
    private static final long WID_TRAVEL_TOPICS = 14199938L;
    public static final long WID_DESTINATIONS = 1200957L;
    private static final long WID_ITINERARIES = 1322323L;
    private static final long WID_PHRASEBOOKS = 1599788L;
    private static final long WID_CULTURAL_ATTRACTIONS = 11042L;
    private static final long WID_WORLD_HERITAGE_SITE = 9259L;
    private static final long WID_OTHER_DESTINATIONS = 14201351L;
    private static final boolean DEBUG = false;
    private static final String SUFFIX_EN_REDIRECT = "en:";
    public static final String EMAIL = "Email";
    public static final String DIRECTIONS = "Directions";
    public static final String WORKING_HOURS = "Working hours";
    public static final String PRICE = "Price";
    public static final String PHONE = "Phone";

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, SQLException, XmlPullParserException, InterruptedException {
        String lang = "";
        String wikivoyageFolderName = "";
        String wikidataSqliteName = "";
        boolean help = false;
        for (String arg : args) {
            String val = arg.substring(arg.indexOf("=") + 1);
            if (arg.startsWith("--lang=")) {
                lang = val;
                continue;
            }
            if (arg.startsWith("--wikivoyageDir=")) {
                wikivoyageFolderName = val;
                continue;
            }
            if (arg.startsWith("--compress=")) {
                uncompressed = "no".equals(val) || "false".equals(val);
                continue;
            }
            if (arg.startsWith("--wikidataDB=")) {
                wikidataSqliteName = val;
                continue;
            }
            if (!arg.equals("--h")) continue;
            help = true;
        }
        if (args.length == 0 || help || wikivoyageFolderName.isEmpty() || wikidataSqliteName.isEmpty()) {
            WikivoyageLangPreparation.printHelp();
            return;
        }
        File wikiArticles = new File(wikivoyageFolderName, lang + "wikivoyage-latest-pages-articles.xml.bz2");
        File wikiProps = new File(wikivoyageFolderName, lang + "wikivoyage-latest-page_props.sql.gz");
        File wikiTitles = new File(wikivoyageFolderName, lang + "wikivoyage-latest-all-titles.gz");
        if (!wikiArticles.exists()) {
            System.out.println("Wikivoyage dump for " + lang + " doesn't exist" + wikiArticles.getName());
            return;
        }
        if (!wikiProps.exists()) {
            System.out.println("Wikivoyage page props for " + lang + " doesn't exist" + wikiProps.getName());
            return;
        }
        File wikivoyageSqlite = new File(wikivoyageFolderName, (uncompressed ? "full_" : "") + "wikivoyage.sqlite");
        File wikidataDB = new File(wikidataSqliteName);
        WikivoyageLangPreparation.processWikivoyage(wikiArticles, wikiProps, wikiTitles, lang, wikivoyageSqlite, wikidataDB);
        System.out.println("Successfully generated.");
    }

    private static void printHelp() {
        System.out.printf("Usage: --lang=<lang> --wikivoyageDir=<wikivoyage folder> --compress=<true|false> --wikidataDB=<wikidata sqlite>%n--h - print this help%n<lang> - language of wikivoyage%n<wikivoyage folder> - work folder%n<compress> - with the \"false\" or \"no\" argument, uncompressed content and gpx fields are added in the full_wikivoyage.sqlite,%n\t\tby default only gziped fields are present in the wikivoyage.sqlite%n<wikidata sqlite> - database file with data from wikidatawiki-latest-pages-articles and commonswiki-latest-pages-articles.xml.gz%n\t\tThe file is in the folder which has osm_wiki_*.gz files. This files with osm elements with wikidata=*, wikipedia=* tags,%n\t\talso folder has wikidatawiki-latest-pages-articles.xml.gz file ", new Object[0]);
    }

    protected static void processWikivoyage(File wikiArticles, File wikiProps, File wikiTitles, String lang, File wikivoyageSqlite, File wikidataSqlite) throws ParserConfigurationException, SAXException, IOException, SQLException {
        PageInfos pageInfos = WikivoyageLangPreparation.readPageInfos(wikiProps, wikiTitles);
        SAXParser sx = SAXParserFactory.newInstance().newSAXParser();
        BufferedInputStream articlesStream = new BufferedInputStream(new FileInputStream(wikiArticles), 32768);
        BZip2CompressorInputStream zis = new BZip2CompressorInputStream((InputStream)articlesStream);
        InputStreamReader reader = new InputStreamReader((InputStream)zis, "UTF-8");
        InputSource articlesSource = new InputSource(reader);
        articlesSource.setEncoding("UTF-8");
        Connection wikidataConn = DBDialect.SQLITE.getDatabaseConnection(wikidataSqlite.getAbsolutePath(), log);
        final PreparedStatement selectCoordsByID = wikidataConn.prepareStatement("SELECT lat, lon FROM wiki_coords where id = ?");
        final PreparedStatement selectTitle = wikidataConn.prepareStatement("select title from wiki_mapping where id = ? and lang = ?");
        final PreparedStatement selectWid = wikidataConn.prepareStatement("select id from wiki_mapping where title = ? and lang = ?");
        WikiDatabasePreparation.WikiDBBrowser browser = new WikiDatabasePreparation.WikiDBBrowser(){

            @Override
            public String getWikipediaTitleByWid(String lang, long wikidataId) throws SQLException {
                if (wikidataId > 0L) {
                    selectTitle.setLong(1, wikidataId);
                    selectTitle.setString(2, lang);
                    ResultSet rs = selectTitle.executeQuery();
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                }
                return null;
            }

            @Override
            public LatLon getLocation(String lang, String wikiLink, long wikidataId) throws SQLException {
                LatLon r = this.getLocationWid(wikidataId);
                if (r != null) {
                    return r;
                }
                if (!Algorithms.isEmpty((CharSequence)wikiLink)) {
                    long wid;
                    selectWid.setString(1, wikiLink);
                    selectWid.setString(2, lang);
                    ResultSet rs = selectWid.executeQuery();
                    if (rs.next() && (wid = rs.getLong(1)) > 0L) {
                        return this.getLocationWid(wid);
                    }
                }
                return null;
            }

            private LatLon getLocationWid(long wikidataId) throws SQLException {
                if (wikidataId > 0L) {
                    LatLon l;
                    selectCoordsByID.setLong(1, wikidataId);
                    ResultSet rs = selectCoordsByID.executeQuery();
                    if (rs.next() && ((l = new LatLon(rs.getDouble(1), rs.getDouble(2))).getLatitude() != 0.0 || l.getLongitude() != 0.0)) {
                        return l;
                    }
                }
                return null;
            }
        };
        WikivoyageHandler handler = new WikivoyageHandler(sx, articlesStream, lang, wikivoyageSqlite, pageInfos, browser);
        sx.parse(articlesSource, (DefaultHandler)handler);
        handler.finish();
        wikidataConn.close();
    }

    private static PageInfos readPageInfos(File wikiProps, File wikiTitles) throws IOException {
        final PageInfos pageInfos = new PageInfos();
        InputStream fis = new FileInputStream(wikiTitles);
        if (wikiTitles.getName().endsWith("gz")) {
            fis = new GZIPInputStream(fis);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(fis));
        String s = null;
        while ((s = r.readLine()) != null) {
            int i = s.indexOf(9);
            if (i <= 0 || !s.substring(0, i).trim().equals("0")) continue;
            String title = s.substring(i + 1).trim().replace('_', ' ');
            pageInfos.titlesLc.put(title.toLowerCase(), title);
        }
        System.out.printf("Read %d page info titles\n", pageInfos.titlesLc.size());
        fis.close();
        SqlInsertValuesReader.readInsertValuesFile(wikiProps.getAbsolutePath(), new SqlInsertValuesReader.InsertValueProcessor(){

            @Override
            public void process(List<String> vs) {
                long pageId = Long.parseLong(vs.get(0));
                String property = vs.get(1);
                String value = vs.get(2);
                PageInfo pi = this.getPageInfo(pageId);
                if (property.equals("wpb_banner")) {
                    pi.banner = value;
                } else if (property.equals("wikibase_item")) {
                    pi.wikidataId = Long.parseLong(value.substring(1));
                    pageInfos.byWikidataId.put(pi.wikidataId, pi);
                } else if (property.equals("page_image_free")) {
                    pi.image = value;
                }
            }

            private PageInfo getPageInfo(long pageId) {
                PageInfo p = pageInfos.byId.get(pageId);
                if (p == null) {
                    p = new PageInfo();
                    p.id = pageId;
                    pageInfos.byId.put(pageId, p);
                }
                return p;
            }
        });
        return pageInfos;
    }

    public static void createInitialDbStructure(Connection conn, String lang, boolean uncompressed) throws SQLException {
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS travel_articles(title text, content_gz blob" + (uncompressed ? ", content text" : "") + ", is_part_of text, is_part_of_wid bigint, lat double, lon double, image_title text, banner_title text, src_banner_title text,  gpx_gz blob" + (uncompressed ? ", gpx text" : "") + ", trip_id bigint, original_id bigint, lang text, contents_json text)");
        conn.createStatement().execute("CREATE INDEX IF NOT EXISTS index_title ON travel_articles(title);");
        conn.createStatement().execute("CREATE INDEX IF NOT EXISTS index_id ON travel_articles(trip_id);");
        conn.createStatement().execute("CREATE INDEX IF NOT EXISTS index_local_id ON travel_articles(lang, original_id);");
        conn.createStatement().execute("CREATE INDEX IF NOT EXISTS index_part_of ON travel_articles(is_part_of);");
        StringBuilder b = new StringBuilder("CREATE TABLE IF NOT EXISTS travel_points(");
        boolean f = true;
        for (INS_POI_COLUMN col : INS_POI_COLUMN.values()) {
            if (!f) {
                b.append(", ");
            }
            b.append(col.name().toLowerCase());
            if (col == INS_POI_COLUMN.TRIP_ID || col == INS_POI_COLUMN.ORIGINAL_ID || col == INS_POI_COLUMN.WIKIDATA_ID) {
                b.append(" bigint");
            } else if (col == INS_POI_COLUMN.LAT || col == INS_POI_COLUMN.LON) {
                b.append(" double");
            } else {
                b.append(" text");
            }
            f = false;
        }
        b.append(");");
        conn.createStatement().execute(b.toString());
        conn.createStatement().execute("CREATE INDEX IF NOT EXISTS indexp_trip_id ON travel_points(trip_id);");
        conn.createStatement().execute("DELETE FROM travel_articles WHERE lang = '" + lang + "';");
        conn.createStatement().execute("DELETE FROM travel_points WHERE lang = '" + lang + "';");
    }

    public static PreparedStatement generateInsertPrep(Connection conn, boolean uncompressed) throws SQLException {
        return conn.prepareStatement("INSERT INTO travel_articles(title, content_gz" + (uncompressed ? ", content" : "") + ", is_part_of, lat, lon, image_title, banner_title, gpx_gz" + (uncompressed ? ", gpx" : "") + ", trip_id , original_id , lang, contents_json) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?" + (uncompressed ? ", ?, ?" : "") + ")");
    }

    private static String trim(String s) {
        return s.trim().replaceAll("[\\p{Cf}]", "");
    }

    static {
        KNOWN_WIKIVOYAGE_MAIN = new HashMap<Long, Long>();
        KNOWN_WIKIVOYAGE_MAIN.put(14199938L, 0L);
        KNOWN_WIKIVOYAGE_MAIN.put(1599788L, 14199938L);
        KNOWN_WIKIVOYAGE_MAIN.put(14208553L, 14199938L);
        KNOWN_WIKIVOYAGE_MAIN.put(1322323L, 14199938L);
        KNOWN_WIKIVOYAGE_MAIN.put(5056668L, 14199938L);
        KNOWN_WIKIVOYAGE_MAIN.put(1200957L, 0L);
        KNOWN_WIKIVOYAGE_MAIN.put(15L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(51L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(48L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(49L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(55643L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(18L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(46L, 1200957L);
        KNOWN_WIKIVOYAGE_MAIN.put(14201351L, 1200957L);
    }

    private static class PageInfos {
        private Map<Long, PageInfo> byId = new HashMap<Long, PageInfo>();
        private Map<Long, PageInfo> byWikidataId = new HashMap<Long, PageInfo>();
        private Map<String, PageInfo> byTitle = new HashMap<String, PageInfo>();
        private Map<String, String> titlesLc = new HashMap<String, String>();
        public Set<String> missingParentsInfo = new HashSet<String>();

        private PageInfos() {
        }

        public String getCorrectTitle(String titleRef) {
            String lc = titleRef.toLowerCase();
            if (this.titlesLc.containsKey(lc)) {
                return this.titlesLc.get(lc);
            }
            if (this.titlesLc.containsKey(lc = lc.replace('_', ' '))) {
                return this.titlesLc.get(lc);
            }
            if (this.titlesLc.containsKey(lc.replace("__", "_"))) {
                return this.titlesLc.get(lc);
            }
            if (lc.contains("%")) {
                try {
                    lc = URLDecoder.decode(lc, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.titlesLc.containsKey(lc)) {
                return this.titlesLc.get(lc);
            }
            return null;
        }
    }

    public static class WikivoyageHandler
    extends DefaultHandler {
        long id = 1L;
        private final SAXParser saxParser;
        private boolean page = false;
        private boolean revision = false;
        private StringBuilder ctext = null;
        private String title;
        private long cid;
        private long cns;
        private PageInfo cInfo;
        private final InputStream progIS;
        private ConsoleProgressImplementation progress = new ConsoleProgressImplementation();
        private DBDialect dialect = DBDialect.SQLITE;
        private Connection wikiVoyageConn;
        private final WikiImageUrlStorage imageUrlStorage;
        private WikiDatabasePreparation.WikiDBBrowser dbBrowser;
        private PreparedStatement prepInsert;
        private PreparedStatement prepInsertPOI;
        private int batch = 0;
        private static final int BATCH_SIZE = 500;
        final ByteArrayOutputStream bous = new ByteArrayOutputStream(64000);
        private String lang;
        private PageInfos pageInfos;
        private PageInfos enPageInfos;
        private Map<String, String> redirects = new HashMap<String, String>();
        private int skippedArticle;

        WikivoyageHandler(SAXParser saxParser, InputStream progIS, String lang, File wikivoyageSqlite, PageInfos pageInfos, WikiDatabasePreparation.WikiDBBrowser dbBrowser) throws IOException, SQLException {
            this.lang = lang;
            this.saxParser = saxParser;
            this.progIS = progIS;
            this.pageInfos = pageInfos;
            this.dbBrowser = dbBrowser;
            this.progress.startTask("Parse wikivoyage xml", progIS.available());
            this.wikiVoyageConn = this.dialect.getDatabaseConnection(wikivoyageSqlite.getAbsolutePath(), log);
            this.imageUrlStorage = new WikiImageUrlStorage(this.wikiVoyageConn, wikivoyageSqlite.getParent(), lang);
            WikivoyageLangPreparation.createInitialDbStructure(this.wikiVoyageConn, lang, uncompressed);
            this.prepInsert = WikivoyageLangPreparation.generateInsertPrep(this.wikiVoyageConn, uncompressed);
            this.enPageInfos = this.readEnPageInfo(this.wikiVoyageConn);
            this.redirects.put("Q14199938", "");
            this.redirects.put("Q1322323", "");
            this.redirects.put("Q1200957", "");
            this.redirects.put("Q11042", "");
            this.redirects.put("Q9259", "");
            this.prepInsertPOI = this.prepareInsertPoi();
        }

        private PreparedStatement prepareInsertPoi() throws SQLException {
            StringBuilder b = new StringBuilder("INSERT INTO travel_points(");
            boolean f = true;
            for (INS_POI_COLUMN col : INS_POI_COLUMN.values()) {
                if (!f) {
                    b.append(", ");
                }
                b.append(col.name().toLowerCase());
                f = false;
            }
            b.append(") VALUES (");
            f = true;
            for (int i = 0; i < INS_POI_COLUMN.values().length; ++i) {
                if (!f) {
                    b.append(", ");
                }
                b.append("?");
                f = false;
            }
            b.append(")");
            return this.wikiVoyageConn.prepareStatement(b.toString());
        }

        private PageInfos readEnPageInfo(Connection c) throws SQLException {
            Statement s = c.createStatement();
            PageInfos en = new PageInfos();
            ResultSet rs = s.executeQuery("select lang, title, trip_id, original_id, is_part_of, image_title, banner_title, lat, lon from travel_articles where lang='en' ");
            while (rs.next()) {
                PageInfo pi = new PageInfo();
                pi.id = rs.getLong(4);
                pi.wikidataId = rs.getLong(3);
                pi.title = rs.getString(2);
                pi.partOf = rs.getString(5);
                pi.image = rs.getString(6);
                pi.banner = rs.getString(7);
                pi.lat = rs.getDouble(8);
                pi.lon = rs.getDouble(9);
                en.byWikidataId.put(pi.wikidataId, pi);
                en.byTitle.put(pi.title, pi);
                en.byId.put(pi.id, pi);
            }
            return en;
        }

        public void addBatch() throws SQLException {
            this.prepInsert.addBatch();
            if (this.batch++ > 500) {
                this.prepInsert.executeBatch();
                this.prepInsertPOI.executeBatch();
                this.batch = 0;
            }
        }

        public void finish() throws SQLException {
            this.prepInsertPOI.executeBatch();
            this.prepInsert.executeBatch();
            if (!this.wikiVoyageConn.getAutoCommit()) {
                this.wikiVoyageConn.commit();
            }
            this.prepInsert.close();
            this.assignDefaultPartOfAndValidate();
            this.wikiVoyageConn.close();
            final Map<String, Integer> mp = WikiDatabasePreparation.POI_OTHER_TYPES;
            ArrayList<String> keys = new ArrayList<String>(mp.keySet());
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return -Integer.compare((Integer)mp.get(o1), (Integer)mp.get(o2));
                }
            });
            System.out.println("-----------------");
            System.out.println("Other category types (top 15) could be assigned to default categories:");
            for (int i = 0; i < 15 && i < keys.size(); ++i) {
                System.out.printf("Key: %s - %d\n", keys.get(i), mp.get(keys.get(i)));
            }
            mp.clear();
        }

        private void assignDefaultPartOfAndValidate() throws SQLException {
            PreparedStatement upd = this.wikiVoyageConn.prepareStatement("UPDATE travel_articles SET is_part_of = ?, is_part_of_wid = ? WHERE original_id =  ? and lang = ?");
            PreparedStatement del = this.wikiVoyageConn.prepareStatement("DELETE FROM travel_articles WHERE original_id =  ? and lang = ?");
            int batch = 0;
            int articles = 0;
            int articlesParentWid = 0;
            PageInfo otherDest = this.pageInfos.byWikidataId.get(14201351L);
            PageInfo enOtherDest = this.enPageInfos.byWikidataId.get(14201351L);
            Object otherDestTitle = otherDest == null ? WikivoyageLangPreparation.SUFFIX_EN_REDIRECT + enOtherDest.title : otherDest.title;
            for (PageInfo p : this.pageInfos.byId.values()) {
                PageInfo enPage;
                Object partOf = p.partOf;
                long partOfWid = 0L;
                if (partOf == null) continue;
                boolean delete = false;
                if (this.redirects.containsKey(partOf)) {
                    String target = this.redirects.get(partOf);
                    if (((String)partOf).startsWith("Q") && target.isEmpty()) {
                        long wid = Long.parseLong(((String)partOf).substring(1));
                        PageInfo pageRedirect = this.pageInfos.byWikidataId.get(wid);
                        PageInfo enPage2 = this.enPageInfos.byWikidataId.get(wid);
                        if (pageRedirect != null && pageRedirect.title != null) {
                            partOf = pageRedirect.title;
                        } else if (enPage2 != null && enPage2.title != null) {
                            System.out.printf("Warning redirect to 'en' from '%s' (not exist) '%s'  -> '%s'\n", this.lang, partOf, WikivoyageLangPreparation.SUFFIX_EN_REDIRECT + enPage2.title);
                            partOf = WikivoyageLangPreparation.SUFFIX_EN_REDIRECT + enPage2.title;
                        } else {
                            this.skipArticle(this.lang, pageRedirect.title, "n", "parent no redirect to " + (String)partOf);
                            delete = true;
                        }
                    } else {
                        partOf = target;
                    }
                }
                if (!(Algorithms.isEmpty((CharSequence)partOf) || this.pageInfos.byTitle.containsKey(partOf) || ((String)partOf).startsWith(WikivoyageLangPreparation.SUFFIX_EN_REDIRECT) || p.wikidataId <= 0L || (enPage = this.enPageInfos.byWikidataId.get(p.wikidataId)) == null || this.enPageInfos.byTitle.get(enPage.partOf) == null)) {
                    PageInfo enParent = this.enPageInfos.byTitle.get(enPage.partOf);
                    PageInfo locParent = this.pageInfos.byWikidataId.get(enParent.wikidataId);
                    if (locParent != null) {
                        System.out.printf("Info correct parent %s '%s': '%s' -> '%s' \n", this.lang, p.title, partOf, locParent.title);
                        partOf = locParent.title;
                    } else {
                        String enPartOf = WikivoyageLangPreparation.SUFFIX_EN_REDIRECT + enParent.title;
                        System.out.printf("Warning redirect parent %s '%s': '%s' -> '%s' \n", this.lang, p.title, partOf, enPartOf);
                        partOf = enPartOf;
                    }
                }
                if (((String)partOf).equalsIgnoreCase(this.title)) {
                    this.skipArticle(this.lang, this.title, "l", String.format("Loop reference is detected!", new Object[0]));
                    delete = true;
                } else if (((String)partOf).startsWith(WikivoyageLangPreparation.SUFFIX_EN_REDIRECT)) {
                    PageInfo parentEnPage = this.enPageInfos.byTitle.get(((String)partOf).substring(WikivoyageLangPreparation.SUFFIX_EN_REDIRECT.length()));
                    if (parentEnPage != null) {
                        partOfWid = parentEnPage.wikidataId;
                    } else {
                        this.skipArticle(this.lang, p.title, "e", "en parent doesn't exist " + (String)partOf);
                        delete = true;
                    }
                } else if (!Algorithms.isEmpty((CharSequence)partOf)) {
                    PageInfo parentPage = this.pageInfos.byTitle.get(partOf);
                    if (parentPage != null) {
                        partOfWid = parentPage.wikidataId;
                    } else {
                        this.skipArticle(this.lang, p.title, "p", "parent doesn't exist " + (String)partOf);
                        delete = true;
                    }
                } else if (p.wikidataId != 1200957L && p.wikidataId != 14199938L) {
                    this.skipArticle(this.lang, p.title, "r", "no parent");
                    delete = true;
                }
                if (delete) {
                    del.setLong(1, p.id);
                    del.setString(2, this.lang);
                    del.addBatch();
                    continue;
                }
                if (partOfWid == 1200957L && !KNOWN_WIKIVOYAGE_MAIN.containsKey(p.wikidataId)) {
                    partOfWid = 14201351L;
                    partOf = otherDestTitle;
                }
                ++articles;
                if (partOfWid > 0L) {
                    ++articlesParentWid;
                } else {
                    System.out.printf("Warning parent no wid %s '%s' -> '%s' \n", this.lang, p.title, partOf);
                }
                upd.setString(1, (String)partOf);
                upd.setLong(2, partOfWid);
                upd.setLong(3, p.id);
                upd.setString(4, this.lang);
                upd.addBatch();
                if (++batch % 500 != 0) continue;
                System.out.println("Update parent wikidata id batch: " + batch);
                upd.executeBatch();
            }
            upd.executeBatch();
            del.executeBatch();
            System.out.printf("Total %s: %d articles (%d - parent wikidata, %d - skipped)\n", this.lang, articles, articlesParentWid, this.skippedArticle);
        }

        public String getStandardPartOf(Map<WikivoyageTemplates, List<String>> macroBlocks, PageInfo enPage) {
            long wid = 0L;
            if (macroBlocks.containsKey((Object)WikivoyageTemplates.PHRASEBOOK)) {
                wid = 1599788L;
            }
            if (KNOWN_WIKIVOYAGE_MAIN.containsKey(this.cInfo.wikidataId)) {
                wid = KNOWN_WIKIVOYAGE_MAIN.get(this.cInfo.wikidataId);
            } else if (enPage != null && this.enPageInfos.byTitle.containsKey(enPage.partOf)) {
                PageInfo enParent = this.enPageInfos.byTitle.get(enPage.partOf);
                wid = enParent.wikidataId;
            }
            PageInfo p = this.pageInfos.byWikidataId.get(wid);
            if (wid > 0L) {
                if (p != null && p.title != null) {
                    return p.title;
                }
                String parent = "Q" + wid;
                this.redirects.put(parent, "");
                return parent;
            }
            return "";
        }

        public int getCount() {
            return (int)(this.id - 1L);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (!this.page) {
                this.page = name.equals("page");
                if (this.page) {
                    this.cid = 0L;
                    this.cns = -1L;
                    this.cInfo = null;
                    this.title = null;
                }
            } else if (name.equals("title")) {
                this.ctext = new StringBuilder();
            } else if (name.equals("text")) {
                this.ctext = null;
                if (this.cid > 0L && (this.cns == 0L || this.cInfo != null && KNOWN_WIKIVOYAGE_MAIN.containsKey(this.cInfo.wikidataId))) {
                    this.ctext = new StringBuilder();
                }
            } else if (name.equals("revision")) {
                this.revision = true;
            } else if (name.equals("id") && !this.revision) {
                this.ctext = new StringBuilder();
            } else if (name.equals("ns")) {
                this.ctext = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.page && this.ctext != null) {
                this.ctext.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String name = this.saxParser.isNamespaceAware() ? localName : qName;
            try {
                if (this.page) {
                    if (name.equals("page")) {
                        this.page = false;
                        this.progress.remaining(this.progIS.available());
                    } else if (name.equals("title")) {
                        this.title = WikivoyageLangPreparation.trim(this.ctext.toString());
                        this.ctext = null;
                    } else if (name.equals("revision")) {
                        this.revision = false;
                    } else if (name.equals("ns")) {
                        this.cns = Long.parseLong(this.ctext.toString());
                        this.ctext = null;
                    } else if (name.equals("id") && !this.revision) {
                        this.cid = Long.parseLong(this.ctext.toString());
                        this.cInfo = this.pageInfos.byId.get(this.cid);
                        this.ctext = null;
                    } else if (name.equals("text")) {
                        if (this.ctext != null) {
                            String red = WikiDatabasePreparation.getRedirect(this.ctext);
                            if (red != null) {
                                this.redirects.put(this.title, WikivoyageLangPreparation.trim(red));
                            } else if (this.cInfo == null) {
                                System.err.printf("Error page %d %s - empty info\n", this.cid, this.title);
                            } else {
                                this.parseText(this.ctext);
                            }
                        }
                        this.ctext = null;
                    }
                }
            }
            catch (IOException | SQLException e) {
                throw new SAXException(e);
            }
        }

        private void parseText(StringBuilder cont) throws IOException, SQLException, SAXException {
            HashMap<WikivoyageTemplates, List<String>> macroBlocks = new HashMap<WikivoyageTemplates, List<String>>();
            ArrayList<Map<WikiDatabasePreparation.PoiFieldType, Object>> pois = new ArrayList<Map<WikiDatabasePreparation.PoiFieldType, Object>>();
            this.cInfo.title = this.title;
            String wikiText = WikiDatabasePreparation.removeMacroBlocks(cont, null, macroBlocks, pois, this.lang, this.title, this.dbBrowser, null);
            if (macroBlocks.containsKey((Object)WikivoyageTemplates.DISAMB) || macroBlocks.containsKey((Object)WikivoyageTemplates.MONUMENT_TITLE)) {
                return;
            }
            PageInfo enPage = null;
            if (this.cInfo.wikidataId > 0L) {
                enPage = this.enPageInfos.byWikidataId.get(this.cInfo.wikidataId);
            }
            try {
                boolean accepted;
                LatLon ll = this.dbBrowser.getLocation(this.lang, null, this.cInfo.wikidataId);
                if (ll == null) {
                    ll = enPage != null && enPage.lat != 0.0 ? new LatLon(enPage.lat, enPage.lon) : WikiDatabasePreparation.getLatLonFromGeoBlock((List)macroBlocks.get((Object)WikivoyageTemplates.LOCATION), this.lang, this.title);
                }
                if (accepted = true) {
                    String corrPartOf;
                    String parent;
                    List<String> possiblePartOf;
                    int column = 1;
                    String filename = this.getFileName((List)macroBlocks.get((Object)WikivoyageTemplates.BANNER));
                    if (this.id++ % 500L == 0L) {
                        log.debug((Object)String.format("Article accepted %d %s %s free: %s\n", this.cid, this.title, ll, Runtime.getRuntime().freeMemory() / 0x100000L));
                    }
                    CustomWikiModel wikiModel = new CustomWikiModel("https://upload.wikimedia.org/wikipedia/commons/${image}", "https://" + this.lang + ".wikivoyage.org/wiki/${title}", this.imageUrlStorage, false);
                    String plainStr = WikiDatabasePreparation.generateHtmlArticle(wikiText, wikiModel);
                    String contentsJson = wikiModel.getContentsJson();
                    String shortDescr = WikiDatabasePreparation.getShortDescr(wikiText, wikiModel);
                    String partOf = WikivoyageHandler.parsePartOf((List)macroBlocks.get((Object)WikivoyageTemplates.PART_OF), this.title, this.lang);
                    if ("Voyages culturels".equals(partOf)) {
                        partOf = "Q11042";
                    }
                    if (partOf == null) {
                        return;
                    }
                    if (partOf.length() == 0) {
                        partOf = this.getStandardPartOf(macroBlocks, enPage).trim();
                    }
                    if (partOf.length() == 0 && (possiblePartOf = WikivoyageHandler.parsePartOfFromQuickFooter((List)macroBlocks.get((Object)WikivoyageTemplates.QUICK_FOOTER), this.title, this.lang)) != null) {
                        for (String s : possiblePartOf) {
                            if (s.startsWith("WIKIDATAQ")) {
                                partOf = s.substring("WIKIDATA".length());
                                break;
                            }
                            if (this.pageInfos.getCorrectTitle(s) != null) {
                                partOf = this.pageInfos.getCorrectTitle(s);
                                break;
                            }
                            if (!this.pageInfos.missingParentsInfo.add(s)) continue;
                            System.out.printf("Info missing parent '%s' in %s '%s' \n", s, this.lang, this.title);
                        }
                    }
                    if (partOf.length() == 0 && this.title.contains("/") && (parent = this.pageInfos.getCorrectTitle(this.title.substring(0, this.title.lastIndexOf(47)))) != null) {
                        partOf = parent;
                    }
                    if (!partOf.equals(corrPartOf = this.pageInfos.getCorrectTitle(partOf)) && corrPartOf != null) {
                        System.out.printf("Info correct parent %s '%s': '%s' -> '%s' \n", this.lang, this.title, partOf, corrPartOf);
                        partOf = corrPartOf;
                    }
                    if (KNOWN_WIKIVOYAGE_MAIN.containsKey(this.cInfo.wikidataId)) {
                        partOf = this.getStandardPartOf(macroBlocks, enPage).trim();
                    }
                    if (Algorithms.isEmpty((CharSequence)(partOf = WikivoyageLangPreparation.trim(partOf)))) {
                        long wid;
                        long l = wid = this.cInfo == null ? 0L : this.cInfo.wikidataId;
                        if (wid != 1200957L && wid != 14199938L) {
                            this.skipArticle(this.lang, this.title, "s", String.format("wid=%s no parent attached", "Q" + wid));
                            return;
                        }
                    }
                    if (partOf.equalsIgnoreCase(this.title)) {
                        this.skipArticle(this.lang, this.title, "l", String.format("Loop reference is detected!", new Object[0]));
                        return;
                    }
                    this.prepInsert.setString(column++, this.title.toString());
                    this.prepInsert.setBytes(column++, this.stringToCompressedByteArray(this.bous, plainStr));
                    if (uncompressed) {
                        this.prepInsert.setString(column++, plainStr);
                    }
                    this.prepInsert.setString(column++, partOf);
                    this.cInfo.partOf = partOf;
                    this.pageInfos.byTitle.put(this.title, this.cInfo);
                    if (ll == null) {
                        this.prepInsert.setNull(column++, 8);
                        this.prepInsert.setNull(column++, 8);
                    } else {
                        this.prepInsert.setDouble(column++, ll.getLatitude());
                        this.prepInsert.setDouble(column++, ll.getLongitude());
                    }
                    if (this.cInfo.image == null && enPage != null) {
                        this.cInfo.image = enPage.image;
                    }
                    if (this.cInfo.image != null) {
                        this.prepInsert.setString(column++, this.cInfo.image);
                    } else {
                        ++column;
                    }
                    if (this.cInfo.banner == null && enPage != null) {
                        this.cInfo.banner = enPage.banner;
                    }
                    if (this.cInfo.banner != null) {
                        this.prepInsert.setString(column++, this.cInfo.banner);
                    } else if (this.cInfo.image != null) {
                        this.prepInsert.setString(column++, this.cInfo.image);
                    } else {
                        this.prepInsert.setString(column++, filename);
                    }
                    String gpx = this.generateGpx(pois, this.title.toString(), this.lang, shortDescr, this.cInfo.wikidataId, this.cid, ll);
                    this.prepInsert.setBytes(column++, this.stringToCompressedByteArray(this.bous, gpx));
                    if (uncompressed) {
                        this.prepInsert.setString(column++, gpx);
                    }
                    this.prepInsert.setLong(column++, this.cInfo.wikidataId);
                    this.prepInsert.setLong(column++, this.cid);
                    this.prepInsert.setString(column++, this.lang);
                    this.prepInsert.setString(column++, contentsJson);
                    this.addBatch();
                }
            }
            catch (SQLException e) {
                throw new SAXException(e);
            }
        }

        private void skipArticle(String lang, String title, String sh, String msg) {
            ++this.skippedArticle;
            String titleUrl = title.replace(" ", "%20");
            System.out.printf("Skip article -%s- %s https://%s.wikivoyage.org/wiki/%s: %s \n", sh, lang, lang, titleUrl, msg);
        }

        public static String capitalizeFirstLetterAndLowercase(String s) {
            if (s != null && s.length() > 1) {
                return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
            }
            return s;
        }

        private String generateGpx(List<Map<WikiDatabasePreparation.PoiFieldType, Object>> list, String title, String lang, String descr, long tripId, long id, LatLon ll) throws SQLException {
            GPXFile f = new GPXFile(title, lang, descr);
            ArrayList<GPXUtilities.WptPt> points = new ArrayList<GPXUtilities.WptPt>();
            TreeMap<INS_POI_COLUMN, Object> insParams = new TreeMap<INS_POI_COLUMN, Object>();
            for (Map<WikiDatabasePreparation.PoiFieldType, Object> s : list) {
                insParams.clear();
                GPXUtilities.WptPt point = new GPXUtilities.WptPt();
                Iterator<Map.Entry<WikiDatabasePreparation.PoiFieldType, Object>> tags = s.entrySet().iterator();
                LinkedHashMap<String, String> extraValues = new LinkedHashMap<String, String>();
                insParams.put(INS_POI_COLUMN.TITLE, title);
                insParams.put(INS_POI_COLUMN.LANG, lang);
                insParams.put(INS_POI_COLUMN.ORIGINAL_ID, id);
                insParams.put(INS_POI_COLUMN.TRIP_ID, tripId);
                while (tags.hasNext()) {
                    Map.Entry<WikiDatabasePreparation.PoiFieldType, Object> e = tags.next();
                    WikiDatabasePreparation.PoiFieldType fieldType = e.getKey();
                    String value = String.valueOf(e.getValue());
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.CATEGORY) {
                        PoiFieldCategory cat = (PoiFieldCategory)((Object)e.getValue());
                        point.category = cat.name().toLowerCase();
                        point.setColor(cat.color);
                        if (!Algorithms.isEmpty((CharSequence)cat.icon)) {
                            point.setIconName(cat.icon);
                        }
                        insParams.put(INS_POI_COLUMN.CATEGORY, cat.name().toLowerCase());
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.PHONE) {
                        extraValues.put(WikivoyageLangPreparation.PHONE, value);
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_PHONE.tag(), value);
                        insParams.put(INS_POI_COLUMN.PHONE, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.WORK_HOURS) {
                        extraValues.put(WikivoyageLangPreparation.WORKING_HOURS, value);
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_OPENING_HOURS.tag(), value);
                        insParams.put(INS_POI_COLUMN.OPENING_HOURS, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.PRICE) {
                        extraValues.put(WikivoyageLangPreparation.PRICE, value);
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_PRICE.tag(), value);
                        insParams.put(INS_POI_COLUMN.PRICE, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.DIRECTIONS) {
                        extraValues.put(WikivoyageLangPreparation.DIRECTIONS, value);
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_DIRECTIONS.tag(), value);
                        insParams.put(INS_POI_COLUMN.DIRECTIONS, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.ADDRESS) {
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_ADDRESS.tag(), value);
                        insParams.put(INS_POI_COLUMN.ADDRESS, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.WIKIDATA) {
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_WIKIDATA.tag(), value);
                        if (value.length() <= 1) continue;
                        try {
                            insParams.put(INS_POI_COLUMN.WIKIDATA_ID, Long.parseLong(value.substring(1)));
                        }
                        catch (NumberFormatException e1) {
                            System.out.println("Parsing wikidata long: '" + value + "'");
                        }
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.WIKIPEDIA) {
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_WIKIPEDIA.tag(), value);
                        insParams.put(INS_POI_COLUMN.WIKIPEDIA, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.EMAIL) {
                        extraValues.put(WikivoyageLangPreparation.EMAIL, value);
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_EMAIL.tag(), value);
                        insParams.put(INS_POI_COLUMN.EMAIL, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.FAX) {
                        extraValues.put("Fax", value);
                        point.getExtensionsToWrite().put(WikivoyageOSMTags.TAG_FAX.tag(), value);
                        insParams.put(INS_POI_COLUMN.FAX, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.NAME) {
                        point.name = value;
                        insParams.put(INS_POI_COLUMN.NAME, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.WEBSITE) {
                        point.link = value;
                        insParams.put(INS_POI_COLUMN.WEBSITE, value);
                        continue;
                    }
                    if (fieldType == WikiDatabasePreparation.PoiFieldType.DESCRIPTION) {
                        point.desc = value;
                        continue;
                    }
                    if (fieldType != WikiDatabasePreparation.PoiFieldType.LATLON) continue;
                    point.lat = ((LatLon)e.getValue()).getLatitude();
                    point.lon = ((LatLon)e.getValue()).getLongitude();
                    insParams.put(INS_POI_COLUMN.LAT, point.lat);
                    insParams.put(INS_POI_COLUMN.LON, point.lon);
                }
                for (String key : extraValues.keySet()) {
                    point.desc = point.desc == null ? "" : point.desc + "\n ";
                    point.desc = point.desc + key + ": " + (String)extraValues.get(key);
                }
                insParams.put(INS_POI_COLUMN.DESCRIPTION, point.desc);
                if (!point.hasLocation() || Algorithms.isEmpty((CharSequence)point.name)) continue;
                for (INS_POI_COLUMN i : INS_POI_COLUMN.values()) {
                    Object obj = insParams.get((Object)i);
                    if (obj instanceof Long) {
                        this.prepInsertPOI.setLong(i.ordinal() + 1, (Long)obj);
                        continue;
                    }
                    if (obj instanceof Double) {
                        this.prepInsertPOI.setDouble(i.ordinal() + 1, (Double)obj);
                        continue;
                    }
                    if (obj != null) {
                        this.prepInsertPOI.setString(i.ordinal() + 1, String.valueOf(obj));
                        continue;
                    }
                    this.prepInsertPOI.setObject(i.ordinal() + 1, null);
                }
                this.prepInsertPOI.addBatch();
                points.add(point);
            }
            if (!points.isEmpty()) {
                f.addPoints(points);
                return GPXUtilities.asString((GPXFile)f);
            }
            return "";
        }

        private byte[] stringToCompressedByteArray(ByteArrayOutputStream baos, String toCompress) {
            baos.reset();
            try {
                GZIPOutputStream gzout = new GZIPOutputStream(baos);
                gzout.write(toCompress.getBytes("UTF-8"));
                gzout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }

        private String getFileName(List<String> list) {
            if (list != null && !list.isEmpty()) {
                String[] infoSplit;
                String bannerInfo = list.get(0);
                for (String s : infoSplit = bannerInfo.split("\\|")) {
                    int index;
                    String toCompare = s.toLowerCase();
                    if (!toCompare.contains(".jpg") && !toCompare.contains(".jpeg") && !toCompare.contains(".png") && !toCompare.contains(".gif")) continue;
                    s = s.replace("https:", "");
                    int equalInd = s.indexOf("=");
                    int columnInd = s.indexOf(":");
                    int n = equalInd == -1 && columnInd == -1 ? -1 : (index = columnInd > equalInd ? columnInd : equalInd);
                    if (index != -1) {
                        return s.substring(index + 1, s.length()).trim();
                    }
                    return s.trim();
                }
            }
            return "";
        }

        public static String parsePartOf(List<String> list, String lang, String title) {
            if (list != null && !list.isEmpty()) {
                String partOf = list.get(0);
                String lowerCasePartOf = partOf.toLowerCase();
                if (lowerCasePartOf.startsWith("navigation")) {
                    String[] splitPartOf = partOf.split(" ");
                    if (splitPartOf.length > 1) {
                        return splitPartOf[1];
                    }
                    System.out.printf("Error structure the partof: %s (%s %s)", partOf, lang, title);
                    return "";
                }
                if (lowerCasePartOf.startsWith("footer|")) {
                    String[] splitPartOf;
                    String part = "";
                    String type = "";
                    for (String s : splitPartOf = partOf.split("\\|")) {
                        String[] vls = s.split("=");
                        String key = vls[0].trim().toLowerCase();
                        if (vls.length > 1 && key.equals("ispartof")) {
                            part = vls[1].trim();
                            break;
                        }
                        if (vls.length <= 1 || !key.equals("type")) continue;
                        type = vls[1].trim();
                    }
                    if (part.length() == 0) {
                        if (type.equalsIgnoreCase("\u043c\u0430\u0440\u0448\u0440\u0443\u0442")) {
                            return "Q1322323";
                        }
                        if (type.equalsIgnoreCase("\u043a\u043e\u043d\u0442\u0438\u043d\u0435\u043d\u0442")) {
                            return "Q1200957";
                        }
                        if (type.equalsIgnoreCase("\u0441\u0432\u043e\u0434\u043d\u0430\u044f") || type.equalsIgnoreCase("\u043f\u0440\u0438\u0440\u043e\u0434\u0430") || type.equalsIgnoreCase("\u043d\u0430\u0441\u043b\u0435\u0434\u0438\u0435")) {
                            return null;
                        }
                        System.out.printf("Error structure the partof: %s (%s) in the article: %s %s\n", partOf, type, lang, title);
                    }
                    return WikivoyageLangPreparation.trim(part).replaceAll("_", " ");
                }
                if (lowerCasePartOf.contains("\u05e7\u05d8\u05d2\u05d5\u05e8\u05d9\u05d4")) {
                    return partOf.substring(partOf.indexOf(":") + 1).trim().replaceAll("[_\\|\\*]", "");
                }
                String[] splitPartOf = partOf.split("\\|");
                if (splitPartOf.length > 1) {
                    return WikivoyageLangPreparation.trim(splitPartOf[1]).replaceAll("_", " ");
                }
                System.out.printf("Error structure the partof: %s in the article: %s %s\n", partOf, lang, title);
                return "";
            }
            return "";
        }

        public static List<String> parsePartOfFromQuickFooter(List<String> list, String lang, String title) {
            ArrayList<String> l = null;
            if (list != null && !list.isEmpty()) {
                String[] info;
                String partOf = list.get(0);
                for (String s : info = partOf.split("\\|")) {
                    String value = null;
                    int i = s.indexOf("=");
                    if (i > 0) {
                        String key = s.substring(0, i).trim().toLowerCase();
                        String v = s.substring(i + 1).trim();
                        if (!(key.equals("livello") || key.equals("w") || key.equals("commons") || v.length() <= 0)) {
                            value = v;
                        }
                    } else if (s.trim().toUpperCase().equals("UNESCO")) {
                        value = "WIKIDATAQ9259";
                    }
                    if (value == null) continue;
                    if (l == null) {
                        l = new ArrayList<String>();
                    }
                    l.add(0, value);
                }
            }
            return l;
        }
    }

    private static enum INS_POI_COLUMN {
        TRIP_ID,
        ORIGINAL_ID,
        LANG,
        TITLE,
        LAT,
        LON,
        CATEGORY,
        NAME,
        WIKIPEDIA,
        WIKIDATA_ID,
        DESCRIPTION,
        EMAIL,
        FAX,
        WEBSITE,
        PRICE,
        OPENING_HOURS,
        ADDRESS,
        PHONE,
        DIRECTIONS;

    }

    protected static class PageInfo {
        public long id;
        public String banner;
        public String image;
        public long wikidataId;
        public String title;
        public String partOf;
        public double lat;
        public double lon;

        protected PageInfo() {
        }
    }

    public static enum WikivoyageTemplates {
        LOCATION("geo"),
        POI("poi"),
        PART_OF("part_of"),
        QUICK_FOOTER("quickfooter"),
        BANNER("pagebanner"),
        REGION_LIST("regionlist"),
        WARNING("warningbox"),
        CITATION("citation"),
        TWO_PART("two"),
        STATION("station"),
        METRIC_DATA("metric"),
        TRANSLATION("translation"),
        PHRASEBOOK("phrasebook"),
        MONUMENT_TITLE("monument-title"),
        DISAMB("disamb");

        private final String type;

        private WikivoyageTemplates(String s) {
            this.type = s;
        }

        public String getType() {
            return this.type;
        }
    }
}

