/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.Link;
import info.bliki.api.PageInfo;
import info.bliki.api.Revision;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class Page
extends PageInfo {
    private List<Link> links = new ArrayList<Link>();
    private List<PageInfo> categories = new ArrayList<PageInfo>();
    private String editToken;
    private String imageUrl;
    private String imageThumbUrl;
    private boolean missing;
    private boolean invalid;
    private Revision revision;
    private static final int BLOCK_SIZE = 8192;

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getImageThumbUrl() {
        return this.imageThumbUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setImageThumbUrl(String imageThumbUrl) {
        this.imageThumbUrl = imageThumbUrl;
    }

    @Override
    public String toString() {
        return "Page{ns=" + this.ns + ", title=" + this.title + ", id=" + this.pageid + ", links=" + this.links + ", categories=" + this.categories + ", editToken='" + this.editToken + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", imageThumbUrl='" + this.imageThumbUrl + '\'' + ", missing=" + this.missing + ", invalid=" + this.invalid + ", revision=" + this.revision + '}';
    }

    public boolean addCategory(PageInfo arg0) {
        return this.categories.add(arg0);
    }

    public boolean containsCategory(PageInfo o) {
        return this.categories.contains(o);
    }

    public PageInfo getCategory(int index) {
        return this.categories.get(index);
    }

    public int sizeOfCategoryList() {
        return this.categories.size();
    }

    public boolean addLink(Link arg0) {
        return this.links.add(arg0);
    }

    public boolean containsLink(Link o) {
        return this.links.contains(o);
    }

    public Link getLink(int index) {
        return this.links.get(index);
    }

    public String getEditToken() {
        return this.editToken;
    }

    public void setEditToken(String editToken) {
        this.editToken = editToken;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public void downloadImageUrl(OutputStream outputStream) {
        this.downloadImageUrl(outputStream, this.imageUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImageUrl(OutputStream outputStream, String url) {
        if (url != null && url.length() > 3) {
            BufferedInputStream bis = null;
            HttpGet request = null;
            try {
                String extension2;
                CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(30000).setRedirectsEnabled(false).build()).build();
                String extension = "jpg";
                int index = url.lastIndexOf(46);
                if (index > 0 && ((extension2 = url.substring(index + 1).toLowerCase()).equals("svg") || extension2.equals("gif") || extension2.equals("png") || extension2.equals("jpg") || extension2.equals("jpeg"))) {
                    extension = extension2;
                }
                request = new HttpGet(url);
                request.setHeader("accept", "image/" + extension);
                request.setHeader("User-Agent", "JavaWikipediaAPI/3.1-SNAPSHOT https://bitbucket.org/axelclk/info.bliki.wiki/");
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    InputStream is = response.getEntity().getContent();
                    bis = new BufferedInputStream(is);
                    byte[] b = new byte[8192];
                    int count = bis.read(b);
                    while (count != -1 && count <= 8192) {
                        outputStream.write(b, 0, count);
                        count = bis.read(b);
                    }
                    if (count != -1) {
                        outputStream.write(b, 0, count);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (request != null) {
                    request.reset();
                }
            }
        }
    }

    public int sizeOfLinksList() {
        return this.links.size();
    }

    public Revision getCurrentRevision() {
        return this.revision;
    }

    public void setCurrentRevision(Revision revision) {
        this.revision = revision;
    }

    public String getCurrentContent() {
        if (this.revision != null) {
            return this.revision.getContent();
        }
        return null;
    }
}

