/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.oauth;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.httpclient.jdk.JDKHttpFuture;
import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import com.github.scribejava.core.httpclient.multipart.MultipartUtils;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.osmand.util.Algorithms;

public class OsmAndJDKHttpClient
implements HttpClient {
    private static final String BOUNDARY = "CowMooCowMooCowCowCow";
    private final JDKHttpClientConfig config;

    public OsmAndJDKHttpClient() {
        this(JDKHttpClientConfig.defaultConfig());
    }

    public OsmAndJDKHttpClient(JDKHttpClientConfig clientConfig) {
        this.config = clientConfig;
    }

    public void close() {
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.BYTE_ARRAY, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.MULTIPART, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.STRING, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.STREAM, bodyContents, callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodyType bodyType, Object bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        try {
            Response t;
            Response response = this.doExecute(userAgent, headers, httpVerb, completeUrl, bodyType, bodyContents);
            Object object = t = converter == null ? response : converter.convert(response);
            if (callback != null) {
                callback.onCompleted((Object)t);
            }
            return new JDKHttpFuture((Object)t);
        }
        catch (IOException | RuntimeException e) {
            if (callback != null) {
                callback.onThrowable((Throwable)e);
            }
            return new JDKHttpFuture(e);
        }
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.BYTE_ARRAY, bodyContents);
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload multipartPayloads) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.MULTIPART, multipartPayloads);
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.STRING, bodyContents);
    }

    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.STREAM, bodyContents);
    }

    private Response doExecute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodyType bodyType, Object bodyContents) throws IOException {
        URL url = new URL(completeUrl);
        HttpURLConnection connection = this.config.getProxy() == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.config.getProxy());
        connection.setInstanceFollowRedirects(this.config.isFollowRedirects());
        connection.setRequestMethod(httpVerb.name());
        if (this.config.getConnectTimeout() != null) {
            connection.setConnectTimeout(this.config.getConnectTimeout());
        }
        if (this.config.getReadTimeout() != null) {
            connection.setReadTimeout(this.config.getReadTimeout());
        }
        OsmAndJDKHttpClient.addHeaders(connection, headers, userAgent);
        if (httpVerb.isPermitBody()) {
            bodyType.setBody(connection, bodyContents, httpVerb.isRequiresBody());
        }
        try {
            connection.connect();
            int responseCode = connection.getResponseCode();
            return new Response(responseCode, connection.getResponseMessage(), OsmAndJDKHttpClient.parseHeaders(connection), responseCode >= 200 && responseCode < 400 ? connection.getInputStream() : connection.getErrorStream(), new Closeable[0]);
        }
        catch (UnknownHostException e) {
            throw new OAuthException("The IP address of a host could not be determined.", (Exception)e);
        }
    }

    private static Map<String, String> parseHeaders(HttpURLConnection conn) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> headerField : conn.getHeaderFields().entrySet()) {
            String key = headerField.getKey();
            String value = headerField.getValue().get(0);
            if ("Content-Encoding".equalsIgnoreCase(key)) {
                headers.put("Content-Encoding", value);
                continue;
            }
            headers.put(key, value);
        }
        return headers;
    }

    private static void addHeaders(HttpURLConnection connection, Map<String, String> headers, String userAgent) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private static void addBody(HttpURLConnection connection, File file, boolean requiresBody) throws IOException {
        if (requiresBody) {
            String filename = file.getName();
            String formName = "file";
            FileInputStream stream = new FileInputStream(file);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=CowMooCowMooCowCowCow");
            connection.setRequestProperty("User-Agent", "OsmAnd");
            OutputStream ous = connection.getOutputStream();
            ous.write("--CowMooCowMooCowCowCow\r\n".getBytes());
            ous.write(("content-disposition: form-data; name=\"" + formName + "\"; filename=\"" + filename + "\"\r\n").getBytes());
            ous.write("Content-Type: application/octet-stream\r\n\r\n".getBytes());
            BufferedInputStream bis = new BufferedInputStream(stream, 20480);
            ous.flush();
            Algorithms.streamCopy(bis, ous);
            ous.write("\r\n--CowMooCowMooCowCowCow--\r\n".getBytes());
            ous.flush();
            Algorithms.closeStream(bis);
        }
    }

    private static void addBody(HttpURLConnection connection, byte[] content, boolean requiresBody) throws IOException {
        int contentLength = content.length;
        if (requiresBody || contentLength > 0) {
            connection.setDoOutput(true);
            OutputStream outputStream = OsmAndJDKHttpClient.prepareConnectionForBodyAndGetOutputStream(connection, contentLength);
            if (contentLength > 0) {
                outputStream.write(content);
            }
        }
    }

    private static void addBody(HttpURLConnection connection, MultipartPayload multipartPayload, boolean requiresBody) throws IOException {
        for (Map.Entry header : multipartPayload.getHeaders().entrySet()) {
            connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
        }
        if (requiresBody) {
            ByteArrayOutputStream os = MultipartUtils.getPayload((MultipartPayload)multipartPayload);
            int contentLength = os.size();
            connection.setDoOutput(true);
            OutputStream outputStream = OsmAndJDKHttpClient.prepareConnectionForBodyAndGetOutputStream(connection, contentLength);
            if (contentLength > 0) {
                os.writeTo(outputStream);
            }
        }
    }

    private static OutputStream prepareConnectionForBodyAndGetOutputStream(HttpURLConnection connection, int contentLength) throws IOException {
        connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
        if (connection.getRequestProperty("Content-Type") == null) {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        return connection.getOutputStream();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum BodyType {
        BYTE_ARRAY{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                OsmAndJDKHttpClient.addBody(connection, (byte[])bodyContents, requiresBody);
            }
        }
        ,
        STREAM{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                OsmAndJDKHttpClient.addBody(connection, (File)bodyContents, requiresBody);
            }
        }
        ,
        MULTIPART{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                OsmAndJDKHttpClient.addBody(connection, (MultipartPayload)bodyContents, requiresBody);
            }
        }
        ,
        STRING{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                OsmAndJDKHttpClient.addBody(connection, ((String)bodyContents).getBytes(), requiresBody);
            }
        };


        abstract void setBody(HttpURLConnection var1, Object var2, boolean var3) throws IOException;
    }
}

