/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;

public class ImageBlock
extends AbstractBlock {
    private ResourceReference reference;
    private boolean freeStandingURI;

    public ImageBlock(ResourceReference reference, boolean isFreeStandingURI) {
        this(reference, isFreeStandingURI, Collections.emptyMap());
    }

    public ImageBlock(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        super(parameters);
        this.reference = reference;
        this.freeStandingURI = isFreeStandingURI;
    }

    public ResourceReference getReference() {
        return this.reference;
    }

    public boolean isFreeStandingURI() {
        return this.freeStandingURI;
    }

    @Override
    public void traverse(Listener listener) {
        listener.onImage(this.getReference(), this.isFreeStandingURI(), this.getParameters());
    }

    @Override
    public ImageBlock clone(BlockFilter blockFilter) {
        ImageBlock clone = (ImageBlock)super.clone(blockFilter);
        clone.reference = this.getReference().clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImageBlock && super.equals(obj)) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getReference(), (Object)((ImageBlock)obj).getReference());
            builder.append(this.isFreeStandingURI(), ((ImageBlock)obj).isFreeStandingURI());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.getReference());
        builder.append(this.isFreeStandingURI());
        return builder.toHashCode();
    }
}

