/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.maskband.DefaultDatasetLayoutImpl;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import java.io.File;
import java.io.IOException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TiffDatasetLayoutImpl
extends DefaultDatasetLayoutImpl
implements DatasetLayout {
    private File externalMasks;
    private File externalOverviews;
    private File externalMaskOverviews;
    private int numInternalOverviews = -1;
    private int numInternalMasks = -1;
    private int numExternalMasks = -1;
    private int numExternalOverviews = -1;
    private int numExternalMaskOverviews = -1;

    public int getNumInternalOverviews() {
        return this.numInternalOverviews;
    }

    public int getNumInternalMasks() {
        return this.numInternalMasks;
    }

    public int getNumExternalMasks() {
        return this.numExternalMasks;
    }

    public int getInternalOverviewImageIndex(int overviewIndex) {
        if (overviewIndex == 0) {
            return overviewIndex;
        }
        if (this.numInternalOverviews < 0 || overviewIndex > this.numInternalOverviews) {
            return -1;
        }
        int index = 0;
        if (this.numInternalMasks > 0) {
            ++index;
        }
        return index + overviewIndex;
    }

    public int getInternalMaskImageIndex(int maskIndex) {
        if (this.numInternalMasks <= 0 || maskIndex >= this.numInternalMasks) {
            return -1;
        }
        if (maskIndex == 0) {
            return 1;
        }
        return this.numInternalOverviews + 2 + maskIndex;
    }

    public int getNumExternalOverviews() {
        return this.numExternalOverviews;
    }

    public int getNumExternalMaskOverviews() {
        return this.numExternalMaskOverviews;
    }

    public File getExternalMaskOverviews() {
        return this.externalMaskOverviews;
    }

    public File getExternalMasks() {
        return this.externalMasks;
    }

    public File getExternalOverviews() {
        return this.externalOverviews;
    }

    public void setNumInternalOverviews(int numOverviews) {
        this.numInternalOverviews = numOverviews;
    }

    public void setNumInternalMasks(int numInternalMasks) {
        this.numInternalMasks = numInternalMasks;
    }

    public void setExternalMasks(File externalMasks) {
        this.externalMasks = externalMasks;
    }

    public void setNumExternalMasks(int numExternalMasks) {
        this.numExternalMasks = numExternalMasks;
    }

    public void setExternalOverviews(File externalOverviews) {
        this.externalOverviews = externalOverviews;
    }

    public void setExternalMaskOverviews(File externalMaskOverviews) {
        this.externalMaskOverviews = externalMaskOverviews;
    }

    public void setNumExternalOverviews(int numExternalOverviews) {
        this.numExternalOverviews = numExternalOverviews;
    }

    public void setNumExternalMaskOverviews(int numExternalMaskOverviews) {
        this.numExternalMaskOverviews = numExternalMaskOverviews;
    }

    public static DatasetLayout parseLayout(IIOMetadata metadata) throws IOException {
        TiffDatasetLayoutImpl layout = null;
        Node tree = metadata.getAsTree("com_sun_media_imageio_plugins_tiff_stream_1.0");
        if (tree == null) {
            return layout;
        }
        layout = new TiffDatasetLayoutImpl();
        NodeList list = tree.getChildNodes();
        int len = list.getLength();
        block10: for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (node == null) continue;
            String nodeName = node.getNodeName();
            String value = node.getAttributes().item(0).getNodeValue();
            TIFFStreamMetadata.MetadataNode mnode = TIFFStreamMetadata.MetadataNode.getFromName(nodeName);
            switch (mnode) {
                case N_INT_MASK: {
                    layout.setNumInternalMasks(Integer.parseInt(value));
                    continue block10;
                }
                case N_EXT_MASK: {
                    layout.setNumExternalMasks(Integer.parseInt(value));
                    continue block10;
                }
                case N_INT_OVR: {
                    layout.setNumInternalOverviews(Integer.parseInt(value));
                    continue block10;
                }
                case N_EXT_OVR: {
                    layout.setNumExternalOverviews(Integer.parseInt(value));
                    continue block10;
                }
                case N_EXT_OVR_MASK: {
                    layout.setNumExternalMaskOverviews(Integer.parseInt(value));
                    continue block10;
                }
                case EXT_MASK_FILE: {
                    layout.setExternalMasks(value != null && !value.isEmpty() ? new File(value) : null);
                    continue block10;
                }
                case EXT_OVR_FILE: {
                    layout.setExternalOverviews(value != null && !value.isEmpty() ? new File(value) : null);
                    continue block10;
                }
                case EXT_OVR_MASK_FILE: {
                    layout.setExternalMaskOverviews(value != null && !value.isEmpty() ? new File(value) : null);
                    continue block10;
                }
            }
        }
        return layout;
    }
}

