/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.osmand.NativeJavaRendering;
import net.osmand.swing.NativeSwingRendering;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;

public class OsmAndImageRendering {
    private static String[] setupDefaultAttrs(String[] args) {
        if (args.length < 1) {
            args = new String[]{"-native=/home/victor/projects/osmand/repo/core/binaries/linux/amd64/", "-obfFiles=/home/victor/projects/osmand/osm-gen", "-gpxFile=/home/victor/projects/osmand/repo/rendering-tests/VictorTest.gpx", "-output=/home/victor/projects/osmand/repo/rendering-tests/Victor/", "-eyepiece=/home/victor/projects/osmand/temp/eyepiece-linux-clang-amd64-release", "-stylesPath=/home/victor/projects/osmand/repo/resources/rendering_styles/"};
        }
        return args;
    }

    public static void main(String[] args) throws IOException, XmlPullParserException, SAXException, ParserConfigurationException, TransformerException {
        String nativeLib = null;
        String eyepiece = null;
        String dirWithObf = null;
        String websiteUrl = "";
        String gpxFile = null;
        String outputFiles = null;
        String stylesPath = null;
        for (String a : args = OsmAndImageRendering.setupDefaultAttrs(args)) {
            if (a.startsWith("-native=")) {
                nativeLib = a.substring("-native=".length());
                continue;
            }
            if (a.startsWith("-websiteUrl=")) {
                websiteUrl = a.substring("-websiteUrl=".length());
                continue;
            }
            if (a.startsWith("-obfFiles=")) {
                dirWithObf = a.substring("-obfFiles=".length());
                continue;
            }
            if (a.startsWith("-gpxFile=")) {
                gpxFile = a.substring("-gpxFile=".length());
                continue;
            }
            if (a.startsWith("-output=")) {
                outputFiles = a.substring("-output=".length());
                continue;
            }
            if (a.startsWith("-eyepiece=")) {
                eyepiece = a.substring("-eyepiece=".length());
                continue;
            }
            if (!a.startsWith("-stylesPath=")) continue;
            stylesPath = a.substring("-stylesPath=".length());
        }
        String backup = null;
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(new File(gpxFile));
        Element de = doc.getDocumentElement();
        String defZoom = OsmAndImageRendering.getAttribute(de, "zoom", "11");
        String defMapDensity = OsmAndImageRendering.getAttribute(de, "mapDensity", "1");
        String defRenderingName = OsmAndImageRendering.getAttribute(de, "renderingName", "default");
        String defRenderingProps = OsmAndImageRendering.getAttribute(de, "renderingProperties", "");
        String defWidth = OsmAndImageRendering.getAttribute(de, "width", "1366");
        String defHeight = OsmAndImageRendering.getAttribute(de, "height", "768");
        NodeList nl = doc.getElementsByTagName("wpt");
        NodeList gen = doc.getElementsByTagName("html");
        File gpx = new File(gpxFile);
        HTMLContent html = null;
        if (gen.getLength() > 0) {
            String gpxName;
            String outputFName = gpxName = gpx.getName().substring(0, gpx.getName().length() - 4);
            if (eyepiece != null) {
                // empty if block
            }
            html = new HTMLContent(new File(gpx.getParentFile(), outputFName + ".html"), websiteUrl + gpxName);
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(gen.item(0)), new StreamResult(sw));
            html.setContent(sw.toString());
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            double lat = Double.parseDouble(e.getAttribute("lat"));
            double lon = Double.parseDouble(e.getAttribute("lon"));
            int imageHeight = Integer.parseInt(OsmAndImageRendering.getSubAttr(e, "height", defHeight));
            int imageWidth = Integer.parseInt(OsmAndImageRendering.getSubAttr(e, "width", defWidth));
            String name = OsmAndImageRendering.getSubAttr(e, "name", (lat + "!" + lon).replace('.', '_'));
            String maps = OsmAndImageRendering.getSubAttr(e, "maps", "");
            String mapDensities = OsmAndImageRendering.getSubAttr(e, "mapDensity", defMapDensity);
            String zooms = OsmAndImageRendering.getSubAttr(e, "zoom", defZoom);
            String renderingNames = OsmAndImageRendering.getSubAttr(e, "renderingName", defRenderingName);
            String renderingProperties = OsmAndImageRendering.getSubAttr(e, "renderingProperties", defRenderingProps);
            if (maps.isEmpty()) {
                throw new UnsupportedOperationException("No maps element found for wpt " + name);
            }
            NativeJavaRendering nsr = nativeLib != null ? NativeJavaRendering.getDefault((String)nativeLib, null, (String)NativeSwingRendering.findFontFolder()) : null;
            ArrayList<File> obfFiles = new ArrayList<File>();
            OsmAndImageRendering.initMaps(dirWithObf, backup, gpxFile, maps, nsr, obfFiles);
            List<ImageCombination> ls = OsmAndImageRendering.getCombinations(name, zooms, mapDensities, renderingNames, renderingProperties);
            if (html != null) {
                html.newRow(OsmAndImageRendering.getSubAttr(e, "desc", ""));
            }
            for (ImageCombination ic : ls) {
                System.out.println("Generate " + ic.generateName + " style " + ic.renderingStyle);
                if (eyepiece != null) {
                    try {
                        String[] listProps;
                        Object line = eyepiece;
                        double dx = ic.mapDensity;
                        line = (String)line + " -latLon=" + lat + ";" + lon;
                        line = (String)line + " -stylesPath=\"" + stylesPath + "\"";
                        String styleName = ic.renderingStyle;
                        if (styleName.endsWith(".render.xml")) {
                            styleName = styleName.substring(0, styleName.length() - ".render.xml".length());
                        }
                        line = (String)line + " -styleName=" + styleName;
                        for (File file : obfFiles) {
                            line = (String)line + " -obfFile=\"" + file.getAbsolutePath() + "\"";
                        }
                        for (String p : listProps = ic.renderingProperties.split(",")) {
                            if (p.trim().length() <= 0) continue;
                            line = (String)line + " -styleSetting:" + p;
                        }
                        line = (String)line + " -outputImageWidth=" + imageWidth;
                        line = (String)line + " -outputImageHeight=" + imageHeight;
                        String string = ic.generateName + ".png";
                        line = (String)line + " -outputImageFilename=\"" + outputFiles + "/" + string + "\"";
                        line = (String)line + " -referenceTileSize=" + (int)(dx * 256.0);
                        line = (String)line + " -displayDensityFactor=" + dx;
                        line = (String)line + " -zoom=" + ic.zoom;
                        line = (String)line + " -outputImageFormat=png";
                        line = (String)line + " -verbose";
                        System.out.println((String)line);
                        Process p = Runtime.getRuntime().exec((String)line);
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((line = input.readLine()) != null) {
                            System.out.println((String)line);
                        }
                        input.close();
                        if (html != null) {
                            html.addFile(string);
                        }
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                if (nativeLib == null) continue;
                String fileName = ic.generateName + ".png";
                System.out.println("Generate to " + fileName);
                nsr.loadRuleStorage(ic.renderingStyle, ic.renderingProperties);
                NativeJavaRendering.RenderingImageResult generationResult = nsr.renderImage(new NativeJavaRendering.RenderingImageContext(lat, lon, imageWidth, imageHeight, ic.zoom, ic.mapDensity));
                BufferedImage mg = generationResult.getImage();
                ImageWriter writer = ImageIO.getImageWritersBySuffix("png").next();
                if (html != null) {
                    html.addFile(fileName);
                }
                writer.setOutput(new FileImageOutputStream(new File(outputFiles, fileName)));
                writer.write(mg);
            }
        }
        if (html != null) {
            html.write();
        }
    }

    private static List<ImageCombination> getCombinations(String name, String zooms, String mapDensities, String renderingNames, String renderingProperties) {
        String[] zoomsStr = zooms.split(",");
        String[] mapDenses = mapDensities.split(",");
        String[] renderingNamesStr = renderingNames.split(",");
        String[] renderingPropertiesStr = renderingProperties.split(";");
        ArrayList<ImageCombination> list = new ArrayList<ImageCombination>();
        for (int i1 = 0; i1 < zoomsStr.length; ++i1) {
            String name1 = OsmAndImageRendering.append(name, "z", zoomsStr, i1);
            for (int i2 = 0; i2 < mapDenses.length; ++i2) {
                String name2 = OsmAndImageRendering.append(name1, "mapDens", mapDenses, i2);
                for (int i3 = 0; i3 < renderingNamesStr.length; ++i3) {
                    String name3 = OsmAndImageRendering.append(name2, "", renderingNamesStr, i3);
                    for (int i4 = 0; i4 < renderingPropertiesStr.length; ++i4) {
                        String name4 = OsmAndImageRendering.append(name3, "", renderingPropertiesStr, i4);
                        Object rst = renderingPropertiesStr[i4];
                        if (!((String)rst).contains("noPolygons")) {
                            if (((String)rst).trim().length() > 0) {
                                rst = (String)rst + ",";
                            }
                            rst = (String)rst + "noPolygons=false";
                        }
                        list.add(new ImageCombination(name4, zoomsStr[i1], mapDenses[i2], renderingNamesStr[i3] + ".render.xml", (String)rst));
                    }
                }
            }
        }
        return list;
    }

    private static String append(String name, String key, String[] ar, int ind) {
        if (ar.length == 1) {
            return name;
        }
        String vl = ar[ind];
        Object r = "";
        if (key.length() > 0) {
            r = (String)r + key + "_";
        }
        if (((String)(r = (String)r + vl.replace('=', '_').replace(',', '-'))).length() > 0) {
            return name + "-" + (String)r;
        }
        return name;
    }

    private static void initMaps(String dirWithObf, String backup, String gpxFile, String maps, NativeJavaRendering nsr, List<File> initFiles) throws IOException {
        for (String map : maps.split(",")) {
            map = map.trim();
            File targetFile = new File(new File(gpxFile).getParentFile(), map + ".obf");
            File sourceFile = new File(dirWithObf + "/" + map + ".obf");
            File sourceZip = new File(dirWithObf + "/" + map + ".obf.zip");
            if (backup != null) {
                if (!sourceZip.exists() && !sourceFile.exists()) {
                    sourceZip = new File(backup + "/" + map + ".obf.zip");
                }
                if (!sourceFile.exists()) {
                    sourceFile = new File(backup + "/" + map + ".obf");
                }
            }
            if (sourceFile.exists()) {
                targetFile = sourceFile;
            } else {
                if (!(sourceFile.exists() || sourceZip.exists() || targetFile.exists())) {
                    throw new IllegalStateException("File " + sourceFile.getAbsolutePath() + " is not found");
                }
                if (sourceZip.exists() && (!targetFile.exists() || targetFile.lastModified() != sourceZip.lastModified())) {
                    ZipInputStream zipIn = new ZipInputStream(new FileInputStream(sourceZip));
                    ZipEntry entry = null;
                    while ((entry = zipIn.getNextEntry()) != null) {
                        byte[] bs = new byte[1024];
                        if (!entry.getName().endsWith(".obf")) continue;
                        FileOutputStream fout = new FileOutputStream(targetFile);
                        int l = 0;
                        while ((l = zipIn.read(bs)) >= 0) {
                            fout.write(bs, 0, l);
                        }
                        fout.close();
                        break;
                    }
                    zipIn.close();
                    targetFile.setLastModified(sourceZip.lastModified());
                }
            }
            if (nsr != null) {
                nsr.initMapFile(targetFile.getAbsolutePath(), true);
            }
            initFiles.add(targetFile);
        }
    }

    private static String getSubAttr(Element e, String attrName, String def) {
        String tt;
        NodeList ns = e.getElementsByTagName(attrName);
        if (ns.getLength() > 0 && (tt = ns.item(0).getTextContent()) != null && tt.length() > 0) {
            return tt;
        }
        return def;
    }

    private static String getAttribute(Element e, String attrName, String def) {
        String vl = e.getAttribute(attrName);
        if (vl != null && vl.length() > 0) {
            return vl;
        }
        return def;
    }

    public static class HTMLContent {
        private File file;
        private List<String> descriptions = new ArrayList<String>();
        private List<List<String>> files = new ArrayList<List<String>>();
        private String header;
        private String footer;
        private String rowheader;
        private String rowfooter;
        private String rowContent;
        private String webSiteUrl;

        public HTMLContent(File file, String webSite) {
            this.file = file;
            this.webSiteUrl = webSite;
        }

        public void addFile(String file) {
            this.files.get(this.files.size() - 1).add(file);
        }

        public void newRow(String description) {
            this.descriptions.add(description);
            this.files.add(new ArrayList());
        }

        public void write() throws IOException {
            BufferedWriter w = new BufferedWriter(new FileWriter(this.file));
            w.write(this.header);
            for (int i = 0; i < this.descriptions.size(); ++i) {
                String desc = this.descriptions.get(i);
                List<String> fs = this.files.get(i);
                w.write(this.rowheader.replace("$DESCRIPTION", desc));
                for (String f : fs) {
                    w.write(this.rowContent.replace("$FILENAME", f).replace("$PWD", this.webSiteUrl));
                }
                w.write(this.rowfooter.replace("$DESCRIPTION", desc));
            }
            w.write(this.footer);
            w.close();
        }

        public void setContent(String textContent) {
            System.out.println("Generate html page " + textContent);
            int rw = textContent.indexOf("<ROW>");
            int erw = textContent.indexOf("</ROW>");
            this.header = textContent.substring(0, rw);
            String row = textContent.substring(rw + "<ROW>".length(), erw);
            this.footer = textContent.substring(erw + "</ROW>".length());
            int crw = row.indexOf("<ROW_ELEMENT>");
            int cerw = row.indexOf("</ROW_ELEMENT>");
            this.rowheader = row.substring(0, crw);
            this.rowContent = row.substring(crw + "<ROW_ELEMENT>".length(), cerw);
            this.rowfooter = row.substring(cerw + "</ROW_ELEMENT>".length());
        }
    }

    static class ImageCombination {
        int zoom;
        double mapDensity;
        String renderingStyle;
        String renderingProperties;
        String generateName;

        public ImageCombination(String nm, String zoom, String mapDensity, String rendering, String props) {
            this.generateName = nm;
            this.renderingStyle = rendering;
            this.renderingProperties = props;
            this.zoom = Integer.parseInt(zoom);
            this.mapDensity = Double.parseDouble(mapDensity);
        }
    }
}

