/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import net.osmand.data.QuadPointDouble;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GpxRouteApproximation;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.util.MapUtils;

public class GpxMultiSegmentsApproximation {
    private static final int MAX_DEPTH_ROLLBACK = 500;
    private static final double MIN_BRANCHING_DIST = 10.0;
    private static boolean EAGER_ALGORITHM = false;
    private static boolean PRIORITY_ALGORITHM = !EAGER_ALGORITHM;
    private final boolean TEST_SHIFT_GPX_POINTS = false;
    private static boolean DEBUG = false;
    private static final int ROUTE_POINTS = 12;
    private static final int GPX_MAX = 30;
    final Comparator<RouteSegmentAppr> METRICS_COMPARATOR = new Comparator<RouteSegmentAppr>(){

        @Override
        public int compare(RouteSegmentAppr o1, RouteSegmentAppr o2) {
            return Double.compare(o1.metric(), o2.metric());
        }
    };
    private final RoutePlannerFrontEnd frontEnd;
    private final GpxRouteApproximation gctx;
    private final List<RoutePlannerFrontEnd.GpxPoint> gpxPoints;
    private final float minPointApproximation;
    private final float initDist;
    PriorityQueue<RouteSegmentAppr> queue = new PriorityQueue<RouteSegmentAppr>(this.METRICS_COMPARATOR);
    TLongHashSet visited = new TLongHashSet();

    public GpxMultiSegmentsApproximation(RoutePlannerFrontEnd frontEnd, GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) {
        this.frontEnd = frontEnd;
        this.gctx = gctx;
        this.gpxPoints = gpxPoints;
        this.minPointApproximation = gctx.ctx.config.minPointApproximation;
        this.initDist = this.minPointApproximation / 2.0f;
    }

    public void loadConnections(RouteSegmentAppr last, List<RouteSegmentAppr> connected) {
        block3: {
            block2: {
                connected.clear();
                if (last.parent != null) break block2;
                BinaryRoutePlanner.RouteSegmentPoint pnt = (BinaryRoutePlanner.RouteSegmentPoint)last.segment;
                this.addSegmentInternal(last, pnt, connected);
                if (pnt.others == null) break block3;
                for (BinaryRoutePlanner.RouteSegmentPoint o : pnt.others) {
                    this.addSegmentInternal(last, o, connected);
                }
                break block3;
            }
            for (BinaryRoutePlanner.RouteSegment sg = this.gctx.ctx.loadRouteSegment(last.segment.getEndPointX(), last.segment.getEndPointY(), this.gctx.ctx.config.memoryLimitation); sg != null; sg = sg.getNext()) {
                this.addSegment(last, sg.initRouteSegment(!sg.isPositive()), connected);
                this.addSegment(last, sg, connected);
            }
        }
    }

    private void addSegmentInternal(RouteSegmentAppr last, BinaryRoutePlanner.RouteSegment sg, List<RouteSegmentAppr> connected) {
        boolean accept = this.approximateSegment(last, sg, connected);
        if (DEBUG && !accept) {
            System.out.println("** " + String.valueOf(sg) + " - not accepted");
        }
    }

    private void addSegment(RouteSegmentAppr last, BinaryRoutePlanner.RouteSegment sg, List<RouteSegmentAppr> connected) {
        if (sg == null) {
            return;
        }
        int oneway = this.gctx.ctx.getRouter().isOneWay(sg.getRoad());
        if (sg.isPositive() && oneway < 0 || !sg.isPositive() && oneway > 0) {
            return;
        }
        if (sg.getRoad().getId() != last.segment.road.getId() || sg.getSegmentStart() != last.segment.getSegmentStart()) {
            this.addSegmentInternal(last, sg, connected);
        }
    }

    public void visit(RouteSegmentAppr r) {
        this.visited.add(GpxMultiSegmentsApproximation.calculateRoutePointId(r));
    }

    public boolean isVisited(RouteSegmentAppr r) {
        return this.visited.contains(GpxMultiSegmentsApproximation.calculateRoutePointId(r));
    }

    public GpxRouteApproximation gpxApproximation() throws IOException {
        long timeToCalculate = System.nanoTime();
        this.initGpxPointsXY31(this.gpxPoints);
        RoutePlannerFrontEnd.GpxPoint currentPoint = this.findNextRoutablePoint(0);
        if (currentPoint == null) {
            return this.gctx;
        }
        RouteSegmentAppr last = new RouteSegmentAppr(0, currentPoint.pnt);
        ArrayList<RouteSegmentAppr> connected = new ArrayList<RouteSegmentAppr>();
        RouteSegmentAppr bestRoute = null;
        while (!(last.gpxNext() >= this.gpxPoints.size() || this.gctx.ctx.calculationProgress != null && this.gctx.ctx.calculationProgress.isCancelled)) {
            RouteSegmentAppr bestNext = null;
            if (!this.isVisited(last)) {
                this.visit(last);
                this.loadConnections(last, connected);
                if (connected.size() > 0) {
                    if (EAGER_ALGORITHM) {
                        Collections.sort(connected, this.METRICS_COMPARATOR);
                        bestNext = (RouteSegmentAppr)connected.get(0);
                        this.queue.addAll(connected.subList(1, connected.size()));
                    } else if (PRIORITY_ALGORITHM) {
                        this.queue.addAll(connected);
                    }
                }
            }
            if ((bestNext = this.peakMinFromQueue(bestRoute, bestNext)) != null) {
                if (DEBUG) {
                    System.out.println(String.valueOf(bestNext) + " " + String.valueOf(this.gpxPoints.get((int)(bestNext.gpxStart + bestNext.gpxLen)).loc));
                }
                if (bestRoute == null || bestRoute.gpxNext() < last.gpxNext()) {
                    bestRoute = last;
                }
                last = bestNext;
                continue;
            }
            if (bestRoute != null) {
                this.wrapupRoute(this.gpxPoints, bestRoute);
            }
            RoutePlannerFrontEnd.GpxPoint pnt = this.findNextRoutablePoint(bestRoute != null ? bestRoute.gpxNext() : last.gpxNext());
            this.visited = new TLongHashSet();
            if (pnt == null) {
                this.debugln("------------------");
                break;
            }
            this.debugln("\n!!! " + pnt.ind + " " + String.valueOf(pnt.loc) + " " + String.valueOf(pnt.pnt));
            last = new RouteSegmentAppr(pnt.ind, pnt.pnt);
            bestRoute = null;
        }
        if (this.gctx.ctx.calculationProgress != null) {
            this.gctx.ctx.calculationProgress.timeToCalculate = System.nanoTime() - timeToCalculate;
            if (this.gctx.ctx.calculationProgress.isCancelled) {
                System.out.println("Approximation cancelled");
                return this.gctx;
            }
        }
        if (bestRoute == null || bestRoute.gpxNext() < last.gpxNext()) {
            bestRoute = last;
        }
        if (bestRoute != null) {
            this.wrapupRoute(this.gpxPoints, bestRoute);
        }
        System.out.printf("Approximation took %.2f seconds (%d route points searched)\n", (double)(System.nanoTime() - timeToCalculate) / 1.0E9, this.gctx.routePointsSearched);
        return this.gctx;
    }

    private RouteSegmentAppr peakMinFromQueue(RouteSegmentAppr bestRoute, RouteSegmentAppr bestNext) {
        while (!this.queue.isEmpty() && bestNext == null) {
            bestNext = (RouteSegmentAppr)this.queue.remove();
            if (bestRoute == null || !(this.gpxDist(bestRoute.gpxNext(), bestNext.gpxNext()) > 500.0)) continue;
            bestNext = null;
        }
        return bestNext;
    }

    private void debugln(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    private double gpxDist(int gpxL1, int gpxL2) {
        return this.gpxPoints.get((int)Math.min((int)gpxL1, (int)(this.gpxPoints.size() - 1))).cumDist - this.gpxPoints.get((int)Math.min((int)gpxL2, (int)(this.gpxPoints.size() - 1))).cumDist;
    }

    private boolean approximateSegment(RouteSegmentAppr parent, BinaryRoutePlanner.RouteSegment sg, List<RouteSegmentAppr> connected) {
        RouteSegmentAppr c = new RouteSegmentAppr(parent, sg);
        boolean added = false;
        for (int pointInd = c.gpxStart + 1; pointInd < this.gpxPoints.size(); ++pointInd) {
            boolean farEnd;
            RoutePlannerFrontEnd.GpxPoint p = this.gpxPoints.get(pointInd);
            if (p.x31 == c.segment.getEndPointX() && p.y31 == c.segment.getEndPointY()) {
                ++c.gpxLen;
                continue;
            }
            QuadPointDouble pp = MapUtils.getProjectionPoint31(p.x31, p.y31, c.segment.getStartPointX(), c.segment.getStartPointY(), c.segment.getEndPointX(), c.segment.getEndPointY());
            boolean beforeStart = pp.x == (double)c.segment.getStartPointX() && pp.y == (double)c.segment.getStartPointY();
            boolean bl = farEnd = pp.x == (double)c.segment.getEndPointX() && pp.y == (double)c.segment.getEndPointY();
            if (farEnd) break;
            double dist = BinaryRoutePlanner.squareRootDist((int)pp.x, (int)pp.y, p.x31, p.y31);
            if (dist > (double)this.minPointApproximation) {
                if (beforeStart || c.gpxLen > 0) break;
                return added;
            }
            if (dist > 10.0 && dist > c.maxDistToGpx && c.gpxLen > 0) {
                RouteSegmentAppr altShortBranch = new RouteSegmentAppr(parent, sg);
                altShortBranch.maxDistToGpx = c.maxDistToGpx;
                altShortBranch.gpxLen = c.gpxLen;
                added |= this.addConnected(parent, altShortBranch, connected);
            }
            c.maxDistToGpx = Math.max(c.maxDistToGpx, dist);
            ++c.gpxLen;
        }
        return added |= this.addConnected(parent, c, connected);
    }

    private boolean addConnected(RouteSegmentAppr parent, RouteSegmentAppr c, List<RouteSegmentAppr> connected) {
        if (this.isVisited(c)) {
            return false;
        }
        int pointInd = c.gpxNext();
        if (pointInd < this.gpxPoints.size()) {
            QuadPointDouble pp = MapUtils.getProjectionPoint31(c.segment.getEndPointX(), c.segment.getEndPointY(), this.gpxPoints.get((int)(pointInd - 1)).x31, this.gpxPoints.get((int)(pointInd - 1)).y31, this.gpxPoints.get((int)pointInd).x31, this.gpxPoints.get((int)pointInd).y31);
            double dist = BinaryRoutePlanner.squareRootDist((int)pp.x, (int)pp.y, c.segment.getEndPointX(), c.segment.getEndPointY());
            c.maxDistToGpx = Math.max(c.maxDistToGpx, dist);
            if (dist > (double)this.minPointApproximation) {
                if (DEBUG) {
                    System.out.println("** " + String.valueOf(c) + " - ignore " + dist);
                }
                return false;
            }
        }
        connected.add(c);
        if (DEBUG) {
            System.out.println("** " + String.valueOf(c) + " - accept");
        }
        return true;
    }

    public RoutePlannerFrontEnd.GpxPoint findNextRoutablePoint(int searchStart) throws IOException {
        for (int i = searchStart; i < this.gpxPoints.size(); ++i) {
            if (!this.initRoutingPoint(this.gpxPoints.get(i), this.initDist)) continue;
            return this.gpxPoints.get(i);
        }
        return null;
    }

    private boolean initRoutingPoint(RoutePlannerFrontEnd.GpxPoint start, double distThreshold) throws IOException {
        if (start != null && start.pnt == null) {
            ++this.gctx.routePointsSearched;
            double gpxDir = start.object.directionRoute(start.ind, true);
            BinaryRoutePlanner.RouteSegmentPoint rsp = this.frontEnd.findRouteSegment(start.loc.getLatitude(), start.loc.getLongitude(), this.gctx.ctx, null, false);
            if (rsp == null || MapUtils.getDistance(rsp.getPreciseLatLon(), start.loc) > distThreshold) {
                return false;
            }
            start.pnt = this.initStartPoint(start, gpxDir, rsp);
            if (rsp.others != null) {
                start.pnt.others = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
                for (BinaryRoutePlanner.RouteSegmentPoint o : rsp.others) {
                    if (!(MapUtils.getDistance(o.getPreciseLatLon(), start.loc) < distThreshold)) continue;
                    start.pnt.others.add(this.initStartPoint(start, gpxDir, o));
                }
            }
            return true;
        }
        return false;
    }

    private BinaryRoutePlanner.RouteSegmentPoint initStartPoint(RoutePlannerFrontEnd.GpxPoint start, double gpxDir, BinaryRoutePlanner.RouteSegmentPoint rsp) {
        double dirc = rsp.road.directionRoute(rsp.getSegmentStart(), rsp.isPositive());
        boolean direct = Math.abs(MapUtils.alignAngleDifference(gpxDir - dirc)) < 1.5707963267948966;
        return new BinaryRoutePlanner.RouteSegmentPoint(rsp.getRoad(), direct ? rsp.getSegmentStart() : rsp.getSegmentEnd(), direct ? rsp.getSegmentEnd() : rsp.getSegmentStart(), rsp.distToProj);
    }

    private void initGpxPointsXY31(List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) {
        for (RoutePlannerFrontEnd.GpxPoint p : gpxPoints) {
            p.x31 = MapUtils.get31TileNumberX(p.loc.getLongitude());
            p.y31 = MapUtils.get31TileNumberY(p.loc.getLatitude());
        }
    }

    private void wrapupRoute(List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, RouteSegmentAppr bestRoute) {
        if (bestRoute.parent == null) {
            return;
        }
        ArrayList<RouteSegmentResult> res = new ArrayList<RouteSegmentResult>();
        int startInd = 0;
        int last = Math.min(bestRoute.gpxNext(), gpxPoints.size() - 1);
        RouteSegmentResult lastRes = null;
        while (bestRoute != null && bestRoute.parent != null) {
            startInd = bestRoute.gpxStart;
            int end = bestRoute.segment.getSegmentEnd();
            if (lastRes != null && bestRoute.segment.getRoad().getId() == lastRes.getObject().getId() && lastRes.getStartPointIndex() == bestRoute.segment.getSegmentEnd() && lastRes.isForwardDirection() == bestRoute.segment.isPositive()) {
                end = lastRes.getEndPointIndex();
                res.remove(res.size() - 1);
            }
            RouteSegmentResult routeRes = new RouteSegmentResult(bestRoute.segment.road, bestRoute.segment.getSegmentStart(), end);
            res.add(routeRes);
            bestRoute = bestRoute.parent;
            lastRes = routeRes;
        }
        Collections.reverse(res);
        if (DEBUG) {
            System.out.printf("ROUTE %d -> %d :\n", startInd, last);
            for (RouteSegmentResult r : res) {
                System.out.println(" " + String.valueOf(r));
            }
        }
        for (RouteSegmentResult r : res) {
            r.setGpxPointIndex(startInd);
        }
        gpxPoints.get((int)startInd).routeToTarget = res;
        gpxPoints.get((int)startInd).targetInd = last;
    }

    private static long calculateRoutePointId(RouteSegmentAppr segm) {
        long segId = 0L;
        if (segm.parent != null) {
            boolean positive = segm.segment.isPositive();
            segId = (segm.segment.getRoad().getId() << 12) + (long)(segm.segment.getSegmentStart() << 1) + (long)(positive ? 1 : 0);
        }
        return (segId << 30) + (long)(segm.gpxStart + segm.gpxLen);
    }

    private static class RouteSegmentAppr {
        private final BinaryRoutePlanner.RouteSegment segment;
        private final RouteSegmentAppr parent;
        private final int gpxStart;
        private int gpxLen = 0;
        private double maxDistToGpx = 0.0;

        private int gpxNext() {
            return this.gpxStart + this.gpxLen + 1;
        }

        private RouteSegmentAppr(int start, BinaryRoutePlanner.RouteSegmentPoint pnt) {
            this.parent = null;
            this.segment = pnt;
            this.gpxStart = start;
        }

        private RouteSegmentAppr(RouteSegmentAppr parent, BinaryRoutePlanner.RouteSegment segment) {
            this.parent = parent;
            this.segment = segment;
            this.gpxStart = parent.gpxStart + parent.gpxLen;
        }

        private double metric() {
            return this.maxDistToGpx / Math.sqrt(this.gpxLen + 1);
        }

        public String toString() {
            return String.format("%d -> %d  ( %s ) %.2f", this.gpxStart, this.gpxNext(), this.segment, this.maxDistToGpx);
        }
    }
}

