/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.swing.Messages;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;

public class SelectPointDialog
extends JDialog {
    private static final long serialVersionUID = -4862884032977071296L;
    private static final Log log = PlatformUtil.getLog(SelectPointDialog.class);
    private JButton okButton;
    private JButton cancelButton;
    private JTextField latPosition;
    private JTextField lonPosition;
    private LatLon result;

    public SelectPointDialog(Component parent, LatLon position) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.setTitle("Select point");
        this.initDialog(position);
    }

    public LatLon getResult() {
        return this.result;
    }

    public void showDialog() {
        this.setSize(800, 200);
        double x = this.getParent().getBounds().getCenterX();
        double y = this.getParent().getBounds().getCenterY();
        this.setLocation((int)x - this.getWidth() / 2, (int)y - this.getHeight() / 2);
        this.setVisible(true);
    }

    private void initDialog(LatLon position) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.add(pane);
        this.createInputSourceSection(pane, position);
        pane.add(Box.createVerticalGlue());
        FlowLayout l = new FlowLayout(2);
        JPanel buttonsPane = new JPanel(l);
        this.okButton = new JButton("OK");
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(Messages.getString("NewTileSourceDialog.CANCEL"));
        buttonsPane.add(this.cancelButton);
        buttonsPane.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)l.preferredLayoutSize(buttonsPane).getHeight()));
        pane.add(buttonsPane);
        this.addListeners();
    }

    private void createInputSourceSection(JPanel root, LatLon position) {
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewTileSourceDialog.INPUT.SOURCE")));
        root.add(panel);
        JLabel label = new JLabel("Latitude :");
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.anchor = 17;
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 0;
        l.setConstraints(label, constr);
        this.latPosition = new JTextField();
        this.latPosition.setText(String.valueOf((float)position.getLatitude()));
        panel.add(this.latPosition);
        constr = new GridBagConstraints();
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 0;
        l.setConstraints(this.latPosition, constr);
        label = new JLabel("Longitude :");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.ipady = 10;
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.lonPosition = new JTextField();
        this.lonPosition.setText(String.valueOf((float)position.getLongitude()));
        panel.add(this.lonPosition);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 1;
        l.setConstraints(this.lonPosition, constr);
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, panel.getPreferredSize().height));
    }

    private void addListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectPointDialog.this.okPressed()) {
                    SelectPointDialog.this.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPointDialog.this.setVisible(false);
            }
        });
    }

    private double parseDouble(String s) {
        if (Algorithms.isEmpty((CharSequence)s)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public boolean okPressed() {
        if (Double.isNaN(this.parseDouble(this.latPosition.getText()))) {
            JOptionPane.showMessageDialog(this, "Lat coordinate is not a number", "Wrong position", 0);
            return false;
        }
        if (Double.isNaN(this.parseDouble(this.lonPosition.getText()))) {
            JOptionPane.showMessageDialog(this, "Lon coordinate is not a number", "Wrong position", 0);
            return false;
        }
        this.result = new LatLon(this.parseDouble(this.latPosition.getText()), this.parseDouble(this.lonPosition.getText()));
        return true;
    }
}

