/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.template;

import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaEngine;
import info.bliki.wiki.filter.ParsedPageName;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class Frame {
    private final ParsedPageName page;
    private final Map<String, String> templateParameters;
    private final Frame parent;
    private boolean isSubst;

    public Frame(ParsedPageName page, Map<String, String> templateParameters, Frame parent, boolean isSubst) {
        this.templateParameters = templateParameters;
        this.page = page;
        this.parent = parent;
        this.isSubst = isSubst;
    }

    public Frame newChild(ParsedPageName pageName, Map<String, String> templateParameters, boolean isSubst) {
        return new Frame(pageName, templateParameters, this, isSubst);
    }

    public LuaValue getArgument(String name) {
        String value;
        String string = value = this.templateParameters != null ? this.templateParameters.get(name) : null;
        if (value != null) {
            return ScribuntoLuaEngine.toLuaString(value);
        }
        return LuaValue.NIL;
    }

    public Map<String, String> getTemplateParameters() {
        return new HashMap<String, String>(this.templateParameters);
    }

    public LuaValue getAllArguments() {
        LuaTable table = new LuaTable();
        for (Map.Entry<String, String> entry : this.templateParameters.entrySet()) {
            try {
                int numberedParam = Integer.parseInt(entry.getKey());
                table.set((LuaValue)LuaValue.valueOf((int)numberedParam), (LuaValue)ScribuntoLuaEngine.toLuaString(entry.getValue()));
            }
            catch (NumberFormatException e) {
                table.set((LuaValue)ScribuntoLuaEngine.toLuaString(entry.getKey()), (LuaValue)ScribuntoLuaEngine.toLuaString(entry.getValue()));
            }
        }
        return table;
    }

    public Frame getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.page.pagename;
    }

    public boolean isSubsting() {
        return this.isSubst;
    }
}

