/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.MapZooms;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.Ring;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import rtree.RTree;

public class CombineSRTMIntoFile {
    private static final Log log = PlatformUtil.getLog(CombineSRTMIntoFile.class);
    private static final int NUMBER_OF_FILES_TO_PROCESS_ON_DISK = 50;
    private static final long SIZE_GB_TO_COMBINE_INRAM = 0x200000000L;

    public static void main(String[] args) throws IOException {
        File directoryWithSRTMFiles = new File(args[0]);
        File directoryWithTargetFiles = new File(args[1]);
        boolean dryRun = false;
        boolean feet = false;
        HashSet<String> filters = new HashSet<String>();
        int limit = 1000;
        for (int i = 2; i < args.length; ++i) {
            if ("--dry-run".equals(args[i])) {
                dryRun = true;
                continue;
            }
            if ("--feet".equals(args[i])) {
                feet = true;
                continue;
            }
            if (args[i].startsWith("--filter=")) {
                String[] fs;
                String f = args[i].substring("--filter=".length());
                if (f.length() <= 0) continue;
                for (String ff : fs = f.split(",")) {
                    filters.add(ff.trim());
                }
                continue;
            }
            if (!args[i].startsWith("--limit=")) continue;
            limit = Integer.parseInt(args[i].substring("--limit=".length()));
        }
        System.out.println("CURRENT PID PROCESS: " + ProcessHandle.current().pid());
        OsmandRegions or = new OsmandRegions();
        BinaryMapIndexReader fl = or.prepareFile();
        Map allCountries = or.cacheAllCountries();
        BinaryMapIndexReader.MapIndex mapIndex = (BinaryMapIndexReader.MapIndex)fl.getMapIndexes().get(0);
        int srtm = mapIndex.getRule("region_srtm", "yes");
        int downloadName = mapIndex.getRule("download_name", null);
        int boundary = mapIndex.getRule("osmand_region", "boundary");
        int cnt = 1;
        HashSet<String> failedCountries = new HashSet<String>();
        for (String fullName : allCountries.keySet()) {
            LinkedList lst = (LinkedList)allCountries.get(fullName);
            if (fullName == null) continue;
            if (!filters.isEmpty()) {
                boolean matches = false;
                for (String filt : filters) {
                    if (!fullName.contains(filt)) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
            }
            BinaryMapDataObject rc = null;
            for (BinaryMapDataObject r : lst) {
                if (r.containsType(boundary)) continue;
                rc = r;
                break;
            }
            System.out.println(fullName);
            if (rc == null || !rc.containsAdditionalType(srtm)) continue;
            String dw = rc.getNameByType(downloadName);
            System.out.println("Region " + fullName + " " + cnt++ + " out of " + allCountries.size());
            try {
                CombineSRTMIntoFile.process(rc, lst, dw, directoryWithSRTMFiles, directoryWithTargetFiles, dryRun, limit, feet);
            }
            catch (Exception e) {
                failedCountries.add(fullName);
                e.printStackTrace();
            }
        }
        if (!failedCountries.isEmpty()) {
            throw new IllegalStateException("Failed countries " + String.valueOf(failedCountries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(BinaryMapDataObject country, List<BinaryMapDataObject> boundaries, String downloadName, File directoryWithSRTMFiles, File directoryWithTargetFiles, boolean dryRun, int limit, boolean feet) throws Exception {
        String suffix = "_2" + (feet ? ".srtmf.obf" : ".srtm.obf");
        String name = country.getName();
        String dwName = Algorithms.capitalizeFirstLetterAndLowercase((String)(downloadName + suffix));
        File targetFile = new File(directoryWithTargetFiles, dwName);
        if (targetFile.exists()) {
            System.out.println("Already processed " + name);
            return;
        }
        TreeSet<String> srtmFileNames = new TreeSet<String>();
        Multipolygon polygon = CombineSRTMIntoFile.collectFiles(country, boundaries, name, srtmFileNames);
        if (dryRun) {
            return;
        }
        if (srtmFileNames.size() > limit) {
            System.out.println("\n\n!!!!!!!! WARNING BECAUSE LIMIT OF FILES EXCEEDED !!!!!!!!!\n\n");
            return;
        }
        File procFile = new File(directoryWithTargetFiles, dwName + ".proc");
        boolean ok = CombineSRTMIntoFile.lockFile(procFile);
        if (!ok) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String file : srtmFileNames) {
            File fl = new File(directoryWithSRTMFiles, file + ".osm.bz2");
            if (!fl.exists()) {
                System.err.println("!! Missing " + name + " because " + file + " doesn't exist");
                continue;
            }
            files.add(fl);
        }
        try {
            if (files.isEmpty()) {
                System.err.println("!!! WARNING " + name + " because no files are present to index !!!");
                return;
            }
            File genFile = new File(".", targetFile.getName()).getAbsoluteFile();
            IndexCreatorSettings settings = new IndexCreatorSettings();
            settings.indexMap = true;
            settings.zoomWaySmoothness = 2;
            settings.boundary = polygon;
            IndexCreator ic = new IndexCreator(genFile.getParentFile(), settings);
            ic.setDialects(DBDialect.SQLITE, DBDialect.SQLITE_IN_MEMORY);
            ic.setRegionName(name + " contour lines");
            ic.setMapFileName(genFile.getName());
            File nodesDB = new File(genFile.getParentFile(), dwName + ".nodes.tmp.odb");
            ic.setNodesDBFile(nodesDB);
            ic.generateIndexes(files.toArray(new File[files.size()]), new ConsoleProgressImplementation(1.0), null, MapZooms.parseZooms((String)"11-12;13-"), new MapRenderingTypesEncoder(genFile.getName()), log, true);
            nodesDB.delete();
            RTree.clearCache();
            Algorithms.fileCopy((File)genFile, (File)targetFile);
        }
        finally {
            procFile.delete();
        }
    }

    private static boolean lockFile(File procFile) throws IOException {
        boolean created = procFile.createNewFile();
        if (!created) {
            long existingPid = CombineSRTMIntoFile.readPidFromFile(procFile);
            if (existingPid != -1L && CombineSRTMIntoFile.isProcessAlive(existingPid)) {
                System.out.println("\n\n!!!!!!!! WARNING FILE IS BEING PROCESSED !!!!!!!!!\n\n");
                return false;
            }
            if (!procFile.delete()) {
                System.out.println("Failed to delete stale lock file.");
                return false;
            }
            created = procFile.createNewFile();
            if (!created) {
                System.out.println("\n\n!!!!!!!! WARNING FILE IS BEING PROCESSED !!!!!!!!!\n\n");
                return false;
            }
        }
        CombineSRTMIntoFile.writePidToFile(procFile);
        return true;
    }

    private static Multipolygon collectFiles(BinaryMapDataObject country, List<BinaryMapDataObject> boundaries, String name, Set<String> srtmFileNames) {
        QuadRect qr = new QuadRect(180.0, -90.0, -180.0, 90.0);
        MultipolygonBuilder bld = new MultipolygonBuilder();
        if (boundaries != null) {
            for (BinaryMapDataObject o : boundaries) {
                bld.addOuterWay(CombineSRTMIntoFile.convertToWay(o));
                CombineSRTMIntoFile.updateBbox(o, qr);
            }
        } else {
            bld.addOuterWay(CombineSRTMIntoFile.convertToWay(country));
            CombineSRTMIntoFile.updateBbox(country, qr);
        }
        Multipolygon polygon = bld.build();
        int rightLon = (int)Math.floor(qr.right);
        int leftLon = (int)Math.floor(qr.left);
        int bottomLat = (int)Math.floor(qr.bottom);
        int topLat = (int)Math.floor(qr.top);
        boolean onetile = leftLon == rightLon && bottomLat == topLat;
        for (int lon = leftLon; lon <= rightLon; ++lon) {
            for (int lat = bottomLat; lat <= topLat; ++lat) {
                boolean isOut;
                boolean bl = isOut = !polygon.containsPoint((double)lat + 0.5, (double)lon + 0.5) && !onetile;
                if (isOut) {
                    LatLon bl2 = new LatLon((double)lat, (double)lon);
                    LatLon br = new LatLon((double)lat, (double)(lon + 1));
                    LatLon tr = new LatLon((double)(lat + 1), (double)(lon + 1));
                    LatLon tl = new LatLon((double)(lat + 1), (double)lon);
                    for (Ring r : polygon.getOuterRings()) {
                        List border = r.getBorder();
                        Node prev = (Node)border.get(border.size() - 1);
                        for (int i = 0; i < border.size() && isOut; ++i) {
                            Node n = (Node)border.get(i);
                            if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)tr, (LatLon)tl)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)tr, (LatLon)br)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)bl2, (LatLon)tl)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)br, (LatLon)bl2)) {
                                isOut = false;
                            }
                            prev = n;
                        }
                        if (isOut) continue;
                        break;
                    }
                }
                if (isOut) {
                    boolean anyPointInTile = false;
                    for (Ring r : polygon.getOuterRings()) {
                        for (Node n : r.getBorder()) {
                            double nLat = n.getLatitude();
                            double nLon = n.getLongitude();
                            if (!(nLat >= (double)lat) || !(nLat < (double)(lat + 1)) || !(nLon >= (double)lon) || !(nLon < (double)(lon + 1))) continue;
                            anyPointInTile = true;
                            break;
                        }
                        if (!anyPointInTile) continue;
                        break;
                    }
                    if (anyPointInTile) {
                        isOut = false;
                    }
                }
                if (isOut) continue;
                String filename = CombineSRTMIntoFile.getFileName(lon, lat);
                srtmFileNames.add(filename);
            }
        }
        System.out.println();
        System.out.println("-----------------------------");
        System.out.println("PROCESSING " + name + " lon [" + leftLon + " - " + rightLon + "] lat [" + bottomLat + " - " + topLat + "] TOTAL " + srtmFileNames.size() + " files " + String.valueOf(srtmFileNames));
        return polygon;
    }

    private static long readPidFromFile(File procFile) {
        long l;
        BufferedReader reader = new BufferedReader(new FileReader(procFile));
        try {
            String line = reader.readLine();
            l = line != null ? Long.parseLong(line.trim()) : -1L;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NumberFormatException e) {
                return -1L;
            }
        }
        reader.close();
        return l;
    }

    private static boolean isProcessAlive(long pid) {
        Optional<ProcessHandle> handle = ProcessHandle.of(pid);
        return handle.map(ProcessHandle::isAlive).orElse(false);
    }

    private static void writePidToFile(File procFile) throws IOException {
        try (FileWriter writer = new FileWriter(procFile);){
            long pid = ProcessHandle.current().pid();
            writer.write(Long.toString(pid));
        }
    }

    private static Way convertToWay(BinaryMapDataObject o) {
        Way w = new Way(-1L);
        for (int i = 0; i < o.getPointsLength(); ++i) {
            double lat = MapUtils.get31LatitudeY((int)o.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)o.getPoint31XTile(i));
            w.addNode(new Node(lat, lon, -1L));
        }
        return w;
    }

    private static void updateBbox(BinaryMapDataObject country, QuadRect qr) {
        for (int i = 0; i < country.getPointsLength(); ++i) {
            double lat = MapUtils.get31LatitudeY((int)country.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)country.getPoint31XTile(i));
            qr.left = Math.min(lon, qr.left);
            qr.right = Math.max(lon, qr.right);
            qr.top = Math.max(lat, qr.top);
            qr.bottom = Math.min(lat, qr.bottom);
        }
    }

    private static String getFileName(int lon, int lat) {
        Object fn;
        Object object = fn = lat >= 0 ? "N" : "S";
        if (Math.abs(lat) < 10) {
            fn = (String)fn + "0";
        }
        fn = (String)fn + Math.abs(lat);
        fn = (String)fn + (lon >= 0 ? "E" : "W");
        if (Math.abs(lon) < 10) {
            fn = (String)fn + "00";
        } else if (Math.abs(lon) < 100) {
            fn = (String)fn + "0";
        }
        fn = (String)fn + Math.abs(lon);
        return fn;
    }
}

