/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.Street;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiType;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.tester.RandomRouteTester;
import net.osmand.util.MapUtils;

public class ObfChecker {
    private static final int LIMIT_HH_POINTS_NEEDED = 150000;
    private static final int MAX_BUILDING_DISTANCE = 100;
    private static final int MAX_MAP_RULES = 13800;
    private static final int MAX_ROUTE_RULES = 17500;
    private static final int MAX_POI_TYPES = 6400;
    private static final double MAX_BBOX_AREAS_MIN_MAX_RATIO = 0.0;
    private static final QuadRect bboxPoi = new QuadRect();
    private static final QuadRect bboxMap = new QuadRect();
    private static final QuadRect bboxRoute = new QuadRect();
    private static double bboxPoiAreaMax = 0.0;
    private static double bboxMapAreaMax = 0.0;
    private static double bboxRouteAreaMax = 0.0;

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--test")) {
            args = new String[]{System.getProperty("maps.dir") + "Us_california_northamerica_2.road.obf"};
        }
        LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>();
        ArrayList<String> files = new ArrayList<String>();
        for (String a : args) {
            if (a.startsWith("--")) {
                String[] k = a.substring(2).split("=");
                argMap.put(k[0], k.length == 1 ? "" : k[1]);
                continue;
            }
            files.add(a);
        }
        int failed = 0;
        try {
            for (String file : files) {
                boolean ok = ObfChecker.check(file, argMap);
                if (ok) continue;
                ++failed;
            }
            if (failed == 0) {
                System.out.println("OK");
            }
            System.exit(failed);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean check(String file, Map<String, String> argMap) throws Exception {
        File oFile = new File(file);
        RandomAccessFile r = new RandomAccessFile(oFile.getAbsolutePath(), "r");
        boolean ok = true;
        if (oFile.length() > Integer.MAX_VALUE) {
            ok = false;
            System.err.println("File exceeds max integer value that causes issue with C++ protobuf");
        }
        BinaryMapIndexReader index = new BinaryMapIndexReader(r, oFile);
        BinaryMapIndexReader.MapIndex mi = null;
        BinaryHHRouteReaderAdapter.HHRouteRegion car = null;
        BinaryHHRouteReaderAdapter.HHRouteRegion bicycle = null;
        BinaryMapPoiReaderAdapter.PoiRegion poi = null;
        BinaryMapRouteReaderAdapter.RouteRegion routeRegion = null;
        long routeSectionSize = 0L;
        BinaryMapAddressReaderAdapter.AddressRegion address = null;
        boolean world = oFile.getName().toLowerCase().startsWith("world");
        for (BinaryIndexPart p : index.getIndexes()) {
            BinaryMapRouteReaderAdapter.RouteRegion that;
            if (p instanceof BinaryMapIndexReader.MapIndex) {
                BinaryMapIndexReader.MapIndex that2;
                mi = that2 = (BinaryMapIndexReader.MapIndex)p;
                ObfChecker.calcMaxMapBboxArea(that2);
                int mapRulesSize = ObfChecker.calcMapIndexRulesSize(index, that2);
                ok &= ObfChecker.checkSizeLimit(that2.getName(), "map rules", mapRulesSize, 13800);
                continue;
            }
            if (p instanceof BinaryHHRouteReaderAdapter.HHRouteRegion) {
                BinaryHHRouteReaderAdapter.HHRouteRegion hr = (BinaryHHRouteReaderAdapter.HHRouteRegion)p;
                if (hr.profile.equals("car")) {
                    car = hr;
                } else if (hr.profile.equals("bicycle")) {
                    bicycle = hr;
                }
                ok &= ObfChecker.checkHHRegion(index, hr);
                continue;
            }
            if (p instanceof BinaryMapPoiReaderAdapter.PoiRegion) {
                BinaryMapPoiReaderAdapter.PoiRegion that3;
                poi = that3 = (BinaryMapPoiReaderAdapter.PoiRegion)p;
                ObfChecker.calcMaxPoiBboxArea(that3);
                int poiTypesSize = ObfChecker.calcPoiIndexTypesSize(index, that3);
                ok &= ObfChecker.checkSizeLimit(that3.getName(), "poi types", poiTypesSize, 6400);
                continue;
            }
            if (p instanceof BinaryMapAddressReaderAdapter.AddressRegion) {
                address = (BinaryMapAddressReaderAdapter.AddressRegion)p;
                continue;
            }
            if (!(p instanceof BinaryMapRouteReaderAdapter.RouteRegion)) continue;
            routeRegion = that = (BinaryMapRouteReaderAdapter.RouteRegion)p;
            ObfChecker.calcMaxRouteBboxArea(that);
            routeSectionSize = p.getLength();
            ok &= ObfChecker.checkSizeLimit(that.getName(), "route rules", that.quickGetEncodingRulesSize(), 17500);
        }
        if (routeSectionSize > 300000L && !world) {
            int cnt = 0;
            BinaryMapIndexReader.SearchRequest sr = BinaryMapIndexReader.buildSearchRouteRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, null);
            List regions = index.searchRouteIndexTree(sr, routeRegion.getSubregions());
            for (BinaryMapRouteReaderAdapter.RouteSubregion rs : regions) {
                if (cnt > 150000) break;
                List ls = index.loadRouteIndexData(rs);
                for (RouteDataObject rdo : ls) {
                    if (rdo == null || rdo.getHighway() == null) continue;
                    cnt += rdo.getPointsLength();
                }
            }
            if (cnt > 150000) {
                ok &= ObfChecker.runRandomRouteTester(oFile);
                ok &= ObfChecker.checkNull(oFile, car, "Missing HH route section for car - route section bytes: " + routeSectionSize);
                ok &= ObfChecker.checkNull(oFile, bicycle, "Missing HH route section for bicycle - route section bytes: " + routeSectionSize);
            }
        }
        ok &= ObfChecker.checkNull(oFile, mi, "Missing Map section");
        if (!world) {
            ok &= ObfChecker.checkNull(oFile, poi, "Missing Poi section");
            ok &= ObfChecker.checkNull(oFile, address, "Missing address section");
            ok &= ObfChecker.checkNull(oFile, routeRegion, "Missing routing section");
            ok &= ObfChecker.checkSimpleAddress(index, address, true);
        }
        index.close();
        return ok;
    }

    private static boolean checkSimpleAddress(BinaryMapIndexReader index, BinaryMapAddressReaderAdapter.AddressRegion address, boolean checkDuplicateBuildings) throws IOException {
        StringBuilder errors = new StringBuilder();
        int cityInd = 0;
        int streetInd = 0;
        int errInd = 0;
        long time = System.currentTimeMillis();
        for (BinaryMapAddressReaderAdapter.CityBlocks cityType : EnumSet.of(BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE, BinaryMapAddressReaderAdapter.CityBlocks.POSTCODES_TYPE, BinaryMapAddressReaderAdapter.CityBlocks.VILLAGES_TYPE)) {
            List cities = index.getCities(null, cityType, address, null);
            for (City c : cities) {
                ++cityInd;
                index.preloadStreets(c, null, true, null);
                TreeSet<String> set = new TreeSet<String>();
                for (Street s : c.getStreets()) {
                    if (s.getName().startsWith("<")) continue;
                    ++streetInd;
                    if (set.contains(s.getName())) {
                        String err = String.format(" %d. duplicate street '%s' in '%s'", errInd++, s.getName(), c.getName());
                        ObfChecker.addErr(errors, errInd, err);
                    }
                    set.add(s.getName());
                    if (!checkDuplicateBuildings) continue;
                    TreeMap<String, Building> map = new TreeMap<String, Building>();
                    for (Building b : s.getBuildings()) {
                        Building bld = (Building)map.get(b.getName());
                        if (bld == null) {
                            map.put(b.getName(), b);
                            continue;
                        }
                        double dist = MapUtils.getDistance((LatLon)b.getLocation(), (LatLon)bld.getLocation());
                        if (!(dist > 100.0)) continue;
                        String err = String.format(" %d. Buildings '%s' ('%s' in '%s') too far %.2f km (%.5f, %.5f - %.5f, %.5f) ", errInd++, b.getName(), s.getName(), c.getName(), dist / 1000.0, b.getLocation().getLatitude(), b.getLocation().getLongitude(), bld.getLocation().getLatitude(), bld.getLocation().getLongitude());
                        ObfChecker.addErr(errors, errInd, err);
                    }
                }
                c.getStreets().clear();
            }
        }
        if (!errors.isEmpty()) {
            System.err.printf("Checked %d cities, %d streets (%.1f s) - found %d errors in address section\n", cityInd, streetInd, Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f), errInd);
        }
        return true;
    }

    private static void addErr(StringBuilder errors, int errInd, String err) {
        if (errInd % 5 == 0) {
            errors.append("\n");
        } else if (errors.length() < 1000000) {
            errors.append(err);
        }
    }

    private static boolean checkHHRegion(BinaryMapIndexReader index, BinaryHHRouteReaderAdapter.HHRouteRegion hr) throws IOException {
        boolean ok = true;
        TLongObjectHashMap pnts = index.initHHPoints(hr, (short)0, HHRouteDataStructure.NetworkDBPoint.class);
        for (HHRouteDataStructure.NetworkDBPoint pnt : pnts.valueCollection()) {
            if (pnt.dualPoint != null) continue;
            System.err.printf("Error in map %s - %s missing dual point \n", index.getFile().getName(), pnt);
            ok = false;
        }
        return ok;
    }

    private static boolean checkNull(File f, Object o, String string) {
        if (o == null) {
            System.err.println("[" + f.getName() + "] " + string);
            return false;
        }
        return true;
    }

    private static boolean runRandomRouteTester(File oFile) throws Exception {
        String directory = oFile.getAbsoluteFile().getParent();
        String filename = oFile.getName();
        String[] args = new String[]{"--maps-dir=" + directory, "--obf-prefix=" + filename, "--no-native-library", "--no-html-report", "--avoid-brp-java", "--avoid-brp-cpp", "--avoid-hh-cpp", "--use-hh-points", "--max-shift=1000", "--profile=car", "--iterations=10", "--min-dist=5", "--max-dist=100", "--stop-at-first-route"};
        return RandomRouteTester.run(args) == 0;
    }

    private static boolean checkSizeLimit(String map, String section, int test, int max) {
        if (test > max) {
            System.err.printf("[%s] %s size %d exceeded limit %s\n", map, section, test, max);
            return false;
        }
        return true;
    }

    private static int calcMapIndexRulesSize(BinaryMapIndexReader index, BinaryMapIndexReader.MapIndex mapIndex) throws IOException {
        BinaryMapIndexReader.SearchRequest req = BinaryMapIndexReader.buildSearchRequest((int)0, (int)0, (int)0, (int)0, (int)0, null);
        index.searchMapIndex(req, mapIndex);
        return mapIndex.decodingRules.size();
    }

    private static int calcPoiIndexTypesSize(BinaryMapIndexReader index, BinaryMapPoiReaderAdapter.PoiRegion p) throws IOException {
        int total = 0;
        index.initCategories(p);
        List cs = p.getCategories();
        List subcategories = p.getSubcategories();
        for (int i = 0; i < cs.size(); ++i) {
            total += ((List)subcategories.get(i)).size();
        }
        int singleVals = 0;
        TreeSet<String> text = new TreeSet<String>();
        TreeSet<String> refs = new TreeSet<String>();
        MapPoiTypes poiTypes = MapPoiTypes.getDefault();
        for (BinaryMapPoiReaderAdapter.PoiSubType st : p.getSubTypes()) {
            if (st.text) {
                PoiType ref = poiTypes.getPoiTypeByKey(st.name);
                if (ref != null && !ref.isAdditional()) {
                    refs.add(st.name);
                    continue;
                }
                text.add(st.name);
                continue;
            }
            if (st.possibleValues.size() == 1) {
                ++singleVals;
                continue;
            }
            total += st.possibleValues.size();
        }
        total += refs.size();
        total += text.size();
        return total += singleVals;
    }

    private static double getQuadRectArea(QuadRect qr) {
        double x = MapUtils.squareRootDist31((int)((int)qr.left), (int)((int)qr.top), (int)((int)qr.right), (int)((int)qr.top));
        double y = MapUtils.squareRootDist31((int)((int)qr.left), (int)((int)qr.top), (int)((int)qr.left), (int)((int)qr.bottom));
        return x * y;
    }

    private static void calcMaxMapBboxArea(BinaryMapIndexReader.MapIndex mapIndex) {
        for (BinaryMapIndexReader.MapRoot r : mapIndex.getRoots()) {
            bboxMap.expand((double)r.getLeft(), (double)r.getTop(), (double)r.getRight(), (double)r.getBottom());
        }
        bboxMapAreaMax = Math.max(ObfChecker.getQuadRectArea(bboxMap), bboxMapAreaMax);
    }

    private static void calcMaxRouteBboxArea(BinaryMapRouteReaderAdapter.RouteRegion routeRegion) {
        ArrayList regions = new ArrayList();
        regions.addAll(routeRegion.getBaseSubregions());
        regions.addAll(routeRegion.getSubregions());
        for (BinaryMapRouteReaderAdapter.RouteSubregion r : regions) {
            bboxRoute.expand((double)r.left, (double)r.top, (double)r.right, (double)r.bottom);
        }
        bboxRouteAreaMax = Math.max(ObfChecker.getQuadRectArea(bboxRoute), bboxRouteAreaMax);
    }

    private static void calcMaxPoiBboxArea(BinaryMapPoiReaderAdapter.PoiRegion p) {
        bboxPoi.expand((double)p.getLeft31(), (double)p.getTop31(), (double)p.getRight31(), (double)p.getBottom31());
        bboxPoiAreaMax = Math.max(ObfChecker.getQuadRectArea(bboxRoute), bboxPoiAreaMax);
    }

    private static boolean checkBboxAreasMinMaxRatio(String map) {
        if (bboxPoiAreaMax > 0.0 && bboxMapAreaMax > 0.0 && bboxRouteAreaMax > 0.0) {
            double min = Math.min(Math.min(bboxPoiAreaMax, bboxMapAreaMax), bboxRouteAreaMax);
            double max = Math.max(Math.max(bboxPoiAreaMax, bboxMapAreaMax), bboxRouteAreaMax);
            double ratio = max / min;
            if (ratio > 0.0) {
                System.err.printf("[%s] bbox area ratio %.2f exceeded limit %.2f poi(%.0f) map(%.0f) route(%.0f)\n", map, ratio, 0.0, bboxPoiAreaMax / 1000000.0, bboxMapAreaMax / 1000000.0, bboxRouteAreaMax / 1000000.0);
                return false;
            }
        }
        return true;
    }
}

