/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.block;

import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;

@Component
@Singleton
public class BlockMatcherConverter
extends AbstractConverter<BlockMatcher> {
    protected BlockMatcher convertToType(Type targetType, Object value) {
        if (value == null) {
            return null;
        }
        String matcherName = value.toString().trim();
        ClassBlockMatcher matcher = null;
        if (matcherName.startsWith("class:")) {
            String blockClassName = matcherName.substring(6);
            if (blockClassName.indexOf(46) == -1) {
                blockClassName = "org.xwiki.rendering.block." + blockClassName;
            }
            try {
                Class<?> blockClass = Class.forName(blockClassName);
                if (Block.class.isAssignableFrom(blockClass)) {
                    matcher = new ClassBlockMatcher(blockClass);
                }
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
        }
        if (matcher == null) {
            throw new ConversionException(String.format("Unknown BlockMatcher [%s]", matcherName));
        }
        return matcher;
    }

    protected String convertToString(BlockMatcher value) {
        throw new ConversionException("not implemented yet");
    }
}

