/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.organization.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.OrganizedTracksGroup;
import net.osmand.shared.gpx.data.TracksGroup;
import net.osmand.shared.gpx.enums.TracksSortScope;
import net.osmand.shared.gpx.organization.OrganizeByParams;
import net.osmand.shared.gpx.organization.enums.OrganizeByType;
import net.osmand.shared.gpx.organization.strategy.OrganizeByStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/osmand/shared/gpx/organization/strategy/OrganizeByListStrategy;", "Lnet/osmand/shared/gpx/organization/strategy/OrganizeByStrategy;", "<init>", "()V", "apply", "", "Lnet/osmand/shared/gpx/data/OrganizedTracksGroup;", "originalGroup", "Lnet/osmand/shared/gpx/data/TracksGroup;", "params", "Lnet/osmand/shared/gpx/organization/OrganizeByParams;", "getTrackSortScope", "Lnet/osmand/shared/gpx/enums/TracksSortScope;", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOrganizeByListStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrganizeByListStrategy.kt\nnet/osmand/shared/gpx/organization/strategy/OrganizeByListStrategy\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n381#2,7:45\n1#3:52\n*S KotlinDebug\n*F\n+ 1 OrganizeByListStrategy.kt\nnet/osmand/shared/gpx/organization/strategy/OrganizeByListStrategy\n*L\n22#1:45,7\n*E\n"})
public final class OrganizeByListStrategy
implements OrganizeByStrategy {
    @NotNull
    public static final OrganizeByListStrategy INSTANCE = new OrganizeByListStrategy();

    private OrganizeByListStrategy() {
    }

    @Override
    @NotNull
    public List<OrganizedTracksGroup> apply(@NotNull TracksGroup originalGroup, @NotNull OrganizeByParams params) {
        Object key;
        Intrinsics.checkNotNullParameter((Object)originalGroup, (String)"originalGroup");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        OrganizeByType type = params.getType();
        GpxParameter gpxParameter = type.getGpxParameter();
        if (gpxParameter == null) {
            return CollectionsKt.emptyList();
        }
        GpxParameter property = gpxParameter;
        HashMap groupedTracks = new HashMap();
        List<TrackItem> trackItems = originalGroup.getTrackItems();
        boolean bl = false;
        for (TrackItem trackItem : trackItems) {
            Object object;
            Object object2 = trackItem.getDataItem();
            if (object2 == null || (object2 = (String)((DataItem)object2).getParameter(property)) == null) {
                object2 = "";
            }
            key = object2;
            Map $this$getOrPut$iv = groupedTracks;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(trackItem);
        }
        List result = new ArrayList();
        Iterator iterator = groupedTracks.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            key = (CharSequence)entry.getKey();
            if (key.length() == 0) {
                boolean bl3 = false;
                object = "None";
            } else {
                object = key;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ifEmpty(...)");
            String value = (String)object;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            List trackItems2 = (List)v;
            String id = OrganizedTracksGroup.Companion.createId(originalGroup, type, value);
            result.add(new OrganizedTracksGroup(id, this.getName(type, value), this.getIconName(type, value), type, 0.0, trackItems2, originalGroup, 16, null));
        }
        return result;
    }

    @Override
    @NotNull
    public TracksSortScope getTrackSortScope() {
        return TracksSortScope.ORGANIZED_BY_NAME;
    }
}

