/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.util.KMapUtils;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0016\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010 \u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010!\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lnet/osmand/shared/gpx/GpxElevationTransfer;", "", "readOnlySourceGpxFile", "Lnet/osmand/shared/gpx/GpxFile;", "mutableTargetGpxFile", "<init>", "(Lnet/osmand/shared/gpx/GpxFile;Lnet/osmand/shared/gpx/GpxFile;)V", "nTargetPoints", "", "nOriginalPoints", "nInterpolatedPoints", "originalLatLonPrecision", "", "src", "target", "targetMutablePoints", "", "Lnet/osmand/shared/gpx/primitives/WptPt;", "elevationPoints", "", "", "log", "Lnet/osmand/shared/util/Logger;", "transfer", "", "calcSourceElevationPoints", "", "mutateTargetPoints", "ensureTargetSegments", "interpolateTargetGaps", "ensureSegmentStartEndPoints", "points", "interpolatePointsWithExistingStartEnd", "nResolvedPoints", "calcPointId", "wpt", "precision", "OsmAnd-shared"})
public final class GpxElevationTransfer {
    private int nTargetPoints;
    private int nOriginalPoints;
    private int nInterpolatedPoints;
    private final double originalLatLonPrecision;
    @NotNull
    private final GpxFile src;
    @NotNull
    private final GpxFile target;
    @NotNull
    private List<WptPt> targetMutablePoints;
    @NotNull
    private final Map<Long, Double> elevationPoints;
    @NotNull
    private final Logger log;

    public GpxElevationTransfer(@NotNull GpxFile readOnlySourceGpxFile, @NotNull GpxFile mutableTargetGpxFile) {
        Intrinsics.checkNotNullParameter((Object)readOnlySourceGpxFile, (String)"readOnlySourceGpxFile");
        Intrinsics.checkNotNullParameter((Object)mutableTargetGpxFile, (String)"mutableTargetGpxFile");
        this.originalLatLonPrecision = 1.0E-4;
        this.src = readOnlySourceGpxFile;
        this.target = mutableTargetGpxFile;
        this.targetMutablePoints = new ArrayList();
        this.elevationPoints = new HashMap();
        this.log = LoggerFactory.INSTANCE.getLogger("GpxElevationTransfer");
    }

    public final boolean transfer() {
        this.nTargetPoints = 0;
        this.nOriginalPoints = 0;
        this.nInterpolatedPoints = 0;
        this.elevationPoints.clear();
        this.calcSourceElevationPoints();
        this.targetMutablePoints = this.target.getAllSegmentsPoints();
        this.mutateTargetPoints();
        this.ensureTargetSegments();
        this.interpolateTargetGaps();
        this.log.info("GpxElevationTransfer: original=" + this.nOriginalPoints + " interpolated=" + this.nInterpolatedPoints);
        return this.nResolvedPoints() > 0;
    }

    private final void calcSourceElevationPoints() {
        for (WptPt wpt : this.src.getAllSegmentsPoints()) {
            if (Double.isNaN(wpt.getEle()) || !wpt.hasLocation()) continue;
            this.elevationPoints.put(this.calcPointId(wpt, this.originalLatLonPrecision), wpt.getEle());
        }
    }

    private final void mutateTargetPoints() {
        if (this.elevationPoints.isEmpty()) {
            return;
        }
        for (WptPt wpt : this.targetMutablePoints) {
            if (!wpt.hasLocation()) continue;
            int n = this.nTargetPoints;
            this.nTargetPoints = n + 1;
            Double originalElevation = this.elevationPoints.get(this.calcPointId(wpt, this.originalLatLonPrecision));
            if (originalElevation == null) continue;
            wpt.setEle(originalElevation);
            int n2 = this.nOriginalPoints;
            this.nOriginalPoints = n2 + 1;
        }
    }

    private final void ensureTargetSegments() {
        if (this.elevationPoints.isEmpty() || this.nResolvedPoints() >= this.nTargetPoints) {
            return;
        }
        for (Track track : this.target.getTracks()) {
            if (track.getGeneralTrack()) continue;
            for (TrkSegment segment : track.getSegments()) {
                if (segment.getGeneralSegment()) continue;
                this.ensureSegmentStartEndPoints(segment.getPoints());
            }
        }
    }

    private final void interpolateTargetGaps() {
        if (this.elevationPoints.isEmpty() || this.nResolvedPoints() >= this.nTargetPoints) {
            return;
        }
        this.interpolatePointsWithExistingStartEnd(this.targetMutablePoints);
    }

    private final boolean ensureSegmentStartEndPoints(List<WptPt> points) {
        int i;
        if (points.isEmpty()) {
            return true;
        }
        if (Double.isNaN(((WptPt)CollectionsKt.first(points)).getEle())) {
            int n = points.size();
            for (i = 1; i < n; ++i) {
                double ele = points.get(i).getEle();
                if (Double.isNaN(ele)) continue;
                ((WptPt)CollectionsKt.first(points)).setEle(ele);
                int n2 = this.nInterpolatedPoints;
                this.nInterpolatedPoints = n2 + 1;
                break;
            }
        }
        if (Double.isNaN(((WptPt)CollectionsKt.last(points)).getEle())) {
            for (i = points.size() - 2; -1 < i; --i) {
                double ele = points.get(i).getEle();
                if (Double.isNaN(ele)) continue;
                ((WptPt)CollectionsKt.last(points)).setEle(ele);
                int n = this.nInterpolatedPoints;
                this.nInterpolatedPoints = n + 1;
                break;
            }
        }
        return !Double.isNaN(((WptPt)CollectionsKt.first(points)).getEle()) && !Double.isNaN(((WptPt)CollectionsKt.last(points)).getEle());
    }

    private final void interpolatePointsWithExistingStartEnd(List<WptPt> points) {
        if (!this.ensureSegmentStartEndPoints(points)) {
            return;
        }
        int i = 1;
        while (i < points.size() - 1) {
            int afterGapIndex;
            if (!Double.isNaN(points.get(i).getEle())) {
                ++i;
                continue;
            }
            int beforeGapIndex = i - 1;
            for (afterGapIndex = i + 1; afterGapIndex < points.size() && Double.isNaN(points.get(afterGapIndex).getEle()); ++afterGapIndex) {
            }
            if (afterGapIndex >= points.size()) {
                return;
            }
            double firstEle = points.get(beforeGapIndex).getEle();
            double lastEle = points.get(afterGapIndex).getEle();
            if (Double.isNaN(firstEle) || Double.isNaN(lastEle)) {
                return;
            }
            int steps = afterGapIndex - beforeGapIndex;
            double step = (lastEle - firstEle) / (double)steps;
            int n = afterGapIndex;
            for (int j = beforeGapIndex + 1; j < n; ++j) {
                int n2 = this.nInterpolatedPoints;
                this.nInterpolatedPoints = n2 + 1;
                double thisEle = firstEle + step * (double)(j - beforeGapIndex);
                points.get(j).setEle(Math.rint(thisEle * 1000.0) / 1000.0);
            }
            i = afterGapIndex + 1;
        }
    }

    private final int nResolvedPoints() {
        return this.nOriginalPoints + this.nInterpolatedPoints;
    }

    private final long calcPointId(WptPt wpt, double precision) {
        double roundLat = Math.rint(wpt.getLat() / precision) * precision;
        double roundLon = Math.rint(wpt.getLon() / precision) * precision;
        int y31 = KMapUtils.INSTANCE.get31TileNumberY(roundLat);
        int x31 = KMapUtils.INSTANCE.get31TileNumberX(roundLon);
        return (long)y31 | (long)x31 << 31;
    }
}

