/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.BidiRun;
import java.io.UnsupportedEncodingException;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class Reshaper {
    private static final Log LOG = PlatformUtil.getLog(Reshaper.class);

    public static String reshape(byte[] bytes) {
        try {
            return Reshaper.reshape(new String(bytes, "UTF-8"), false);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String reshape(String s) {
        return Reshaper.reshape(s, true);
    }

    public static String reshape(String s, boolean reshape) {
        if (reshape) {
            ArabicShaping as = new ArabicShaping(8);
            try {
                s = as.shape(s);
            }
            catch (ArabicShapingException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        s = Reshaper.bidiShape(s, reshape);
        return s;
    }

    public static String bidiShape(String s, boolean mirror) {
        String originalS = s;
        try {
            Bidi line = new Bidi(s.length(), s.length());
            line.setPara(s, (byte)126, null);
            byte direction = line.getDirection();
            if (direction != 2) {
                if (line.isLeftToRight() || !mirror) {
                    return s;
                }
                char[] chs = new char[s.length()];
                for (int i = 0; i < chs.length; ++i) {
                    chs[i] = Reshaper.mirror(s.charAt(chs.length - i - 1));
                }
                return new String(chs);
            }
            int count = line.countRuns();
            StringBuilder res = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                StringBuilder runs = new StringBuilder();
                BidiRun run = line.getVisualRun(i);
                boolean ltr = run.getDirection() == 0;
                int start = run.getStart();
                int limit = run.getLimit();
                int begin = ltr ? start : limit - 1;
                int end = ltr ? limit : start - 1;
                int ind = begin;
                while (ind != end) {
                    char ch = s.charAt(ind);
                    if (!ltr && mirror) {
                        ch = Reshaper.mirror(ch);
                    }
                    res.append(ch);
                    runs.append(ch);
                    if (ltr) {
                        ++ind;
                        continue;
                    }
                    --ind;
                }
            }
            if (!mirror) {
                res.reverse();
            }
            return res.toString();
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return s;
        }
    }

    private static char mirror(char ch) {
        switch (ch) {
            case '(': {
                ch = (char)41;
                break;
            }
            case ')': {
                ch = (char)40;
                break;
            }
            case '[': {
                ch = (char)93;
                break;
            }
            case ']': {
                ch = (char)91;
            }
        }
        return ch;
    }

    public static void main(String[] args) {
        Reshaper.test2();
        Reshaper.test3();
        Reshaper.test4();
        Reshaper.test5();
    }

    public static void test3() {
        String s = "\u05de\u05e8\u05db\u05d6 \u05de\u05e1\u05d7\u05e8\u05d9/\u05d4\u05e9\u05dc\u05d5\u05dd (40050)";
        String reshape = Reshaper.reshape(s);
        String expected = "(40050) \u05dd\u05d5\u05dc\u05e9\u05d4/\u05d9\u05e8\u05d7\u05e1\u05de \u05d6\u05db\u05e8\u05de";
        Reshaper.check(s, reshape, expected);
    }

    public static void test5() {
        String s = "\u05de\u05e8\u05db\u05d6 \u05de\u05e1\u05d7\u05e8\u05d9/\u05d4\u05e9\u05dc\u05d5\u05dd (\u05de\u05e8\u05d6)";
        String reshape = Reshaper.reshape(s);
        String expected = "(\u05d6\u05e8\u05de) \u05dd\u05d5\u05dc\u05e9\u05d4/\u05d9\u05e8\u05d7\u05e1\u05de \u05d6\u05db\u05e8\u05de";
        Reshaper.check(s, reshape, expected);
    }

    public static void check(String source, String reshape, String expected) {
        Reshaper.printSplit("Source  ", source);
        Reshaper.printSplit("Expected", expected);
        Reshaper.printSplit("Reshaped", reshape);
        System.out.println(reshape);
        if (!reshape.equals(expected)) {
            throw new IllegalArgumentException(String.format("Bug: expected '%s', reshaped '%s'", expected, reshape));
        }
    }

    static void printSplit(String p, String source) {
        Reshaper.printSplit(p, source, true);
        Reshaper.printSplit(p, source, false);
    }

    static void printSplit(String p, String source, boolean f) {
        System.out.print(p);
        System.out.print(": \u2066");
        for (int i = 0; i < source.length(); ++i) {
            if (f) {
                System.out.print(source.charAt(i));
                System.out.print(" \u200e");
                continue;
            }
            System.out.print(String.format("%04x ", source.charAt(i)));
        }
        System.out.println();
        System.out.flush();
    }

    public static void test2() {
        String s = "\u06af\u0686 \u067e\u0698 \u0646\u0645\u06a9\u06cc \u0628\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0639\u0631\u0628\u064a";
        String reshape = Reshaper.reshape(s);
        String expected1 = "\ufef2\ufe91\ufeae\ufecc\ufedf\ufe8d \ufe94\ufed0\ufee0\ufedf\ufe8e\ufe91 \ufbfd\ufb91\ufee4\ufee7 \ufb8b\ufb58 \ufb7b\ufb94";
        String expected2 = "\ufef2\ufe91\ufeae\ufecc\ufedf\ufe8d \ufe94\ufed0\ufee0\ufedf\ufe8e\ufe91 \u06cc\u06a9\ufee4\ufee7 \u0698\u067e \u0686\u06af";
        Reshaper.check(s, reshape, expected1);
    }

    public static void test4() {
        String s = "Abc (123)";
        Reshaper.check(s, Reshaper.reshape(s), s);
    }
}

