/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.data;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lnet/osmand/shared/data/Limits;", "", "min", "", "max", "<init>", "(Ljava/lang/Number;Ljava/lang/Number;)V", "getMin", "()Ljava/lang/Number;", "getMax", "getMidpoint", "", "clamp", "value", "toString", "", "equals", "", "other", "hashCode", "", "OsmAnd-shared"})
public final class Limits {
    @NotNull
    private final Number min;
    @NotNull
    private final Number max;

    public Limits(@NotNull Number min, @NotNull Number max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = min;
        this.max = max;
    }

    @NotNull
    public final Number getMin() {
        return this.min;
    }

    @NotNull
    public final Number getMax() {
        return this.max;
    }

    public final double getMidpoint() {
        return (this.min.doubleValue() + this.max.doubleValue()) / 2.0;
    }

    public final double clamp(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return RangesKt.coerceIn((double)value.doubleValue(), (double)this.min.doubleValue(), (double)this.max.doubleValue());
    }

    @NotNull
    public String toString() {
        return "Limits=[" + this.min + ";" + this.max + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Limits cfr_ignored_0 = (Limits)other;
        if (!Intrinsics.areEqual((Object)this.min, (Object)((Limits)other).min)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.max, (Object)((Limits)other).max);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }
}

