/*
 * Decompiled with CFR 0.152.
 */
package com.jwetherell.openmap.common;

import com.jwetherell.openmap.common.Ellipsoid;
import com.jwetherell.openmap.common.LatLonPoint;
import com.jwetherell.openmap.common.ZonedUTMPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class MGRSPoint
extends ZonedUTMPoint {
    private static final int NUM_100K_SETS = 6;
    private static final int[] SET_ORIGIN_COLUMN_LETTERS = new int[]{65, 74, 83, 65, 74, 83};
    private static final int[] SET_ORIGIN_ROW_LETTERS = new int[]{65, 70, 65, 70, 65, 70};
    public static final int ACCURACY_1_METER = 5;
    public static final int ACCURACY_10_METER = 4;
    public static final int ACCURACY_100_METER = 3;
    public static final int ACCURACY_1000_METER = 2;
    public static final int ACCURACY_10000_METER = 1;
    private int[] originColumnLetters = SET_ORIGIN_COLUMN_LETTERS;
    private int[] originRowLetters = SET_ORIGIN_ROW_LETTERS;
    private static final int A = 65;
    private static final int I = 73;
    private static final int O = 79;
    private static final int V = 86;
    private static final int Z = 90;
    private String mgrs = null;
    private int accuracy = 5;

    public MGRSPoint() {
    }

    public MGRSPoint(LatLonPoint llpoint) {
        this(llpoint, Ellipsoid.WGS_84);
    }

    public MGRSPoint(LatLonPoint llpoint, Ellipsoid ellip) {
        this();
        MGRSPoint.LLtoMGRS(llpoint, ellip, this);
    }

    public MGRSPoint(String mgrsString) throws NumberFormatException {
        this();
        this.setMGRS(mgrsString);
    }

    public MGRSPoint(double northing, double easting, int zoneNumber, char zoneLetter) {
        super(northing, easting, zoneNumber, zoneLetter);
    }

    public void setMGRS(String mgrsString) throws NumberFormatException {
        try {
            this.mgrs = mgrsString.toUpperCase();
            this.decode(this.mgrs);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new NumberFormatException("MGRSPoint has bad string: " + mgrsString);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void decode(String mgrsString) throws NumberFormatException {
        float north100k;
        char testChar;
        if (mgrsString.contains(" ")) {
            String[] parts = mgrsString.split(" ");
            StringBuilder s = new StringBuilder();
            for (String i : parts) {
                s.append(i);
            }
            mgrsString = s.toString();
        }
        if (mgrsString == null || mgrsString.length() == 0) {
            throw new NumberFormatException("MGRSPoint coverting from nothing");
        }
        mgrsString = mgrsString.toUpperCase();
        int length = mgrsString.length();
        String hunK = null;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (!Character.isLetter(testChar = mgrsString.charAt(i))) {
            if (i >= 2) {
                throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString + ", first two characters need to be a number between 1-60.");
            }
            sb.append(testChar);
            ++i;
        }
        this.zone_number = Integer.parseInt(sb.toString());
        if (this.zone_number < 1 || this.zone_number > 60) {
            throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString + ", first two characters need to be a number between 1-60.");
        }
        if (i == 0 || i + 3 > length) {
            throw new NumberFormatException("MGRSPoint bad conversion from: " + mgrsString + ", MGRS string must be at least 4-5 digits long");
        }
        this.zone_letter = mgrsString.charAt(i++);
        if (this.zone_letter <= 'A' || this.zone_letter == 'B' || this.zone_letter == 'Y' || this.zone_letter >= 'Z' || this.zone_letter == 'I' || this.zone_letter == 'O') {
            throw new NumberFormatException("MGRSPoint zone letter " + this.zone_letter + " not handled: " + mgrsString);
        }
        hunK = mgrsString.substring(i, i += 2);
        char char1 = hunK.charAt(0);
        char char2 = hunK.charAt(1);
        if (char1 < 'A' || char2 < 'A' || char1 > 'Z' || char2 > 'Z' || char1 == 'I' || char2 == 'I' || char1 == 'O' || char2 == 'O') {
            throw new NumberFormatException("MGRSPoint bad conversion from " + mgrsString + ", invalid 100k designator");
        }
        int set = this.get100kSetForZone(this.zone_number);
        float east100k = this.getEastingFromChar(char1, set);
        for (north100k = this.getNorthingFromChar(char2, set); north100k < this.getMinNorthing(this.zone_letter); north100k += 2000000.0f) {
        }
        int remainder = length - i;
        if (remainder % 2 != 0) {
            throw new NumberFormatException("MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters" + mgrsString);
        }
        int sep = remainder / 2;
        float sepEasting = 0.0f;
        float sepNorthing = 0.0f;
        if (sep > 0) {
            float accuracyBonus = 100000.0f / (float)Math.pow(10.0, sep);
            String sepEastingString = mgrsString.substring(i, i + sep);
            sepEasting = Float.parseFloat(sepEastingString) * accuracyBonus;
            String sepNorthingString = mgrsString.substring(i + sep);
            sepNorthing = Float.parseFloat(sepNorthingString) * accuracyBonus;
        }
        this.easting = sepEasting + east100k;
        this.northing = sepNorthing + north100k;
    }

    protected float getEastingFromChar(char e, int set) {
        int[] baseCol = this.getOriginColumnLetters();
        int curCol = baseCol[set - 1];
        float eastingValue = 100000.0f;
        boolean rewindMarker = false;
        while (curCol != e) {
            if (++curCol == 73) {
                ++curCol;
            }
            if (curCol == 79) {
                ++curCol;
            }
            if (curCol > 90) {
                if (rewindMarker) {
                    throw new NumberFormatException("Bad character: " + e);
                }
                curCol = 65;
                rewindMarker = true;
            }
            eastingValue += 100000.0f;
        }
        return eastingValue;
    }

    protected float getNorthingFromChar(char n, int set) {
        if (n > 'V') {
            throw new NumberFormatException("MGRSPoint given invalid Northing " + n);
        }
        int[] baseRow = this.getOriginRowLetters();
        int curRow = baseRow[set - 1];
        float northingValue = 0.0f;
        boolean rewindMarker = false;
        while (curRow != n) {
            if (++curRow == 73) {
                ++curRow;
            }
            if (curRow == 79) {
                ++curRow;
            }
            if (curRow > 86) {
                if (rewindMarker) {
                    throw new NumberFormatException("Bad character: " + n);
                }
                curRow = 65;
                rewindMarker = true;
            }
            northingValue += 100000.0f;
        }
        return northingValue;
    }

    protected float getMinNorthing(char zoneLetter) throws NumberFormatException {
        float northing = switch (zoneLetter) {
            case 'C' -> 1100000.0f;
            case 'D' -> 2000000.0f;
            case 'E' -> 2800000.0f;
            case 'F' -> 3700000.0f;
            case 'G' -> 4600000.0f;
            case 'H' -> 5500000.0f;
            case 'J' -> 6400000.0f;
            case 'K' -> 7300000.0f;
            case 'L' -> 8200000.0f;
            case 'M' -> 9100000.0f;
            case 'N' -> 0.0f;
            case 'P' -> 800000.0f;
            case 'Q' -> 1700000.0f;
            case 'R' -> 2600000.0f;
            case 'S' -> 3500000.0f;
            case 'T' -> 4400000.0f;
            case 'U' -> 5300000.0f;
            case 'V' -> 6200000.0f;
            case 'W' -> 7000000.0f;
            case 'X' -> 7900000.0f;
            default -> -1.0f;
        };
        if ((double)northing >= 0.0) {
            return northing;
        }
        throw new NumberFormatException("Invalid zone letter: " + this.zone_letter);
    }

    @Override
    public LatLonPoint toLatLonPoint() {
        return this.toLatLonPoint(Ellipsoid.WGS_84, new LatLonPoint());
    }

    @Override
    public LatLonPoint toLatLonPoint(Ellipsoid ellip) {
        return this.toLatLonPoint(ellip, new LatLonPoint());
    }

    @Override
    public LatLonPoint toLatLonPoint(Ellipsoid ellip, LatLonPoint llpoint) {
        return MGRSPoint.MGRStoLL(this, ellip, llpoint);
    }

    public static LatLonPoint MGRStoLL(MGRSPoint mgrsp, Ellipsoid ellip, LatLonPoint llp) {
        return MGRSPoint.UTMtoLL(ellip, mgrsp.northing, mgrsp.easting, mgrsp.zone_number, MGRSPoint.MGRSZoneToUTMZone(mgrsp.zone_letter), llp);
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llpoint) {
        return MGRSPoint.LLtoMGRS(llpoint, Ellipsoid.WGS_84, new MGRSPoint());
    }

    public static MGRSPoint LLtoMGRS(LatLonPoint llp, Ellipsoid ellip, MGRSPoint mgrsp) {
        if (mgrsp == null) {
            mgrsp = new MGRSPoint();
        }
        mgrsp = (MGRSPoint)MGRSPoint.LLtoUTM(llp, ellip, mgrsp);
        mgrsp.zone_letter = mgrsp.getLetterDesignator(llp.getLatitude());
        mgrsp.resolve();
        return mgrsp;
    }

    public static char MGRSZoneToUTMZone(char mgrsZone) throws NumberFormatException {
        char zone = MGRSPoint.checkZone(mgrsZone);
        return Character.toUpperCase(zone) >= 'N' ? (char)'N' : 'S';
    }

    public static char checkZone(char zone) throws NumberFormatException {
        if ((zone = Character.toUpperCase(zone)) <= 'A' || zone == 'B' || zone == 'Y' || zone >= 'Z' || zone == 'I' || zone == 'O') {
            throw new NumberFormatException("Invalid MGRSPoint zone letter: " + zone);
        }
        return zone;
    }

    public void setAccuracy(int value) {
        this.accuracy = value;
        this.mgrs = null;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void resolve(int digitAccuracy) {
        this.setAccuracy(digitAccuracy);
        this.resolve();
    }

    public void resolve() {
        if (this.zone_letter == 'Z') {
            this.mgrs = "Latitude limit exceeded";
        } else {
            StringBuffer sb = new StringBuffer(Integer.toString(this.zone_number)).append(this.zone_letter).append(this.get100kID(this.easting, this.northing, this.zone_number));
            StringBuffer seasting = new StringBuffer(Integer.toString((int)this.easting));
            StringBuffer snorthing = new StringBuffer(Integer.toString((int)this.northing));
            while (this.accuracy + 1 > seasting.length()) {
                seasting.insert(0, '0');
            }
            while (this.accuracy + 1 > snorthing.length()) {
                snorthing.insert(0, '0');
            }
            while (snorthing.length() > 6) {
                snorthing.deleteCharAt(0);
            }
            try {
                sb.append(seasting.substring(1, this.accuracy + 1)).append(snorthing.substring(1, this.accuracy + 1));
                this.mgrs = sb.toString();
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.mgrs = null;
            }
        }
    }

    private int get100kSetForZone(int i) {
        int set = i % 6;
        if (set == 0) {
            set = 6;
        }
        return set;
    }

    private int[] getOriginColumnLetters() {
        return this.originColumnLetters;
    }

    private int[] getOriginRowLetters() {
        return this.originRowLetters;
    }

    private String get100kID(double easting, double northing, int zone_number) {
        int set = this.get100kSetForZone(zone_number);
        int setColumn = (int)easting / 100000;
        int setRow = (int)northing / 100000 % 20;
        return this.get100kID(setColumn, setRow, set);
    }

    private String get100kID(int setColumn, int setRow, int set) {
        int[] baseCol = this.getOriginColumnLetters();
        int[] baseRow = this.getOriginRowLetters();
        int colOrigin = baseCol[set - 1];
        int rowOrigin = baseRow[set - 1];
        int colInt = colOrigin + setColumn - 1;
        int rowInt = rowOrigin + setRow;
        boolean rollover = false;
        if (colInt > 90) {
            colInt = colInt - 90 + 65 - 1;
            rollover = true;
        }
        if (colInt == 73 || colOrigin < 73 && colInt > 73 || (colInt > 73 || colOrigin < 73) && rollover) {
            ++colInt;
        }
        if ((colInt == 79 || colOrigin < 79 && colInt > 79 || (colInt > 79 || colOrigin < 79) && rollover) && ++colInt == 73) {
            ++colInt;
        }
        if (colInt > 90) {
            colInt = colInt - 90 + 65 - 1;
        }
        if (rowInt > 86) {
            rowInt = rowInt - 86 + 65 - 1;
            rollover = true;
        } else {
            rollover = false;
        }
        if (rowInt == 73 || rowOrigin < 73 && rowInt > 73 || (rowInt > 73 || rowOrigin < 73) && rollover) {
            ++rowInt;
        }
        if ((rowInt == 79 || rowOrigin < 79 && rowInt > 79 || (rowInt > 79 || rowOrigin < 79) && rollover) && ++rowInt == 73) {
            ++rowInt;
        }
        if (rowInt > 86) {
            rowInt = rowInt - 86 + 65 - 1;
        }
        String twoLetter = "" + (char)colInt + (char)rowInt;
        return twoLetter;
    }

    public String toFlavoredString() {
        try {
            ArrayList<String> all = new ArrayList<String>();
            for (int i = 0; i <= this.mgrs.length(); ++i) {
                if (!Character.isAlphabetic(this.mgrs.charAt(i))) continue;
                all.add(this.mgrs.substring(0, i + 1));
                all.add(this.mgrs.substring(i + 1, i + 3));
                String remains = this.mgrs.substring(i + 3);
                all.add(remains.substring(0, remains.length() / 2));
                all.add(remains.substring(remains.length() / 2));
                break;
            }
            StringBuilder os = new StringBuilder();
            for (String part : all) {
                if (os.length() > 0) {
                    os.append(" ");
                }
                os.append(part);
            }
            return os.toString();
        }
        catch (Exception e) {
            return this.mgrs;
        }
    }

    public String toFlavoredString(int accuracy) {
        try {
            ArrayList<String> all = new ArrayList<String>();
            for (int i = 0; i <= this.mgrs.length(); ++i) {
                if (!Character.isAlphabetic(this.mgrs.charAt(i))) continue;
                all.add(this.mgrs.substring(0, i + 1));
                all.add(this.mgrs.substring(i + 1, i + 3));
                String remains = this.mgrs.substring(i + 3);
                int easting = Integer.parseInt(remains.substring(0, remains.length() / 2));
                int northing = Integer.parseInt(remains.substring(remains.length() / 2));
                double resolution = Math.pow(10.0, this.getAccuracy() - accuracy);
                long roundedEasting = Math.round((double)easting / resolution);
                long roundedNorthing = Math.round((double)northing / resolution);
                int eastShift = 0;
                int northShift = 0;
                if ((double)roundedEasting == resolution * 10.0) {
                    roundedEasting = 0L;
                    eastShift = 1;
                }
                if ((double)roundedNorthing == resolution * 10.0) {
                    roundedNorthing = 0L;
                    northShift = 1;
                }
                if (eastShift != 0 || northShift != 0) {
                    all.set(1, MGRSPoint.shiftChar((String)all.get(1), eastShift, northShift));
                    String string = "";
                }
                all.add(String.format(Locale.US, "%0" + accuracy + "d", roundedEasting));
                all.add(String.format(Locale.US, "%0" + accuracy + "d", roundedNorthing));
                break;
            }
            StringBuilder os = new StringBuilder();
            for (String part : all) {
                if (os.length() > 0) {
                    os.append(" ");
                }
                os.append(part);
            }
            return os.toString();
        }
        catch (Exception e) {
            return this.toFlavoredString();
        }
    }

    private static String shiftChar(String chars, int east, int north) {
        int idx;
        ArrayList<Character> keys = new ArrayList<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')));
        StringBuilder s = new StringBuilder();
        if (east != 0) {
            idx = keys.indexOf(Character.valueOf(chars.charAt(0)));
            if ((idx += east) >= keys.size()) {
                idx -= keys.size();
            }
            if (idx < 0) {
                idx += keys.size();
            }
            s.append(keys.get(idx));
        } else {
            s.append(chars.charAt(0));
        }
        if (north != 0) {
            idx = keys.indexOf(Character.valueOf(chars.charAt(1)));
            if ((idx += north) >= keys.size()) {
                idx -= keys.size();
            }
            if (idx < 0) {
                idx += keys.size();
            }
            s.append(keys.get(idx));
        } else {
            s.append(chars.charAt(1));
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return this.mgrs;
    }
}

