/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.util.List;

public class Switch
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Switch();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) {
        if (list.size() < 2) {
            return null;
        }
        String defaultResult = null;
        String conditionString = isSubst ? list.get(0) : Switch.parseTrim(list.get(0), model);
        boolean valueFound = false;
        for (int i = 1; i < list.size(); ++i) {
            String parsedLHS;
            boolean hasRHS;
            List<String> splitByEq = WikipediaScanner.splitByChar('=', list.get(i), null, 2);
            String leftHandSide = splitByEq.get(0);
            boolean bl = hasRHS = splitByEq.size() == 2;
            if (hasRHS && valueFound) {
                return Switch.parseTrim(splitByEq.get(1), model);
            }
            String string = parsedLHS = isSubst ? leftHandSide : Switch.parseTrim(leftHandSide, model);
            if (hasRHS && "#default".equals(parsedLHS)) {
                defaultResult = splitByEq.get(1);
                continue;
            }
            if (!hasRHS && i == list.size() - 1) {
                return parsedLHS;
            }
            if (!this.equalsTypes(conditionString, parsedLHS, Switch.checkNumerically(conditionString))) continue;
            if (hasRHS) {
                return Switch.parseTrim(splitByEq.get(1), model);
            }
            valueFound = true;
        }
        return Switch.parseTrim(defaultResult, model);
    }

    private boolean equalsTypes(String first, String second, boolean checkNumerically) {
        if (first.length() == 0) {
            return second.length() == 0;
        }
        if (second.length() == 0) {
            return first.length() == 0;
        }
        if (first.charAt(0) == '+') {
            first = first.substring(1);
        }
        if (second.charAt(0) == '+') {
            second = second.substring(1);
        }
        if (checkNumerically) {
            try {
                double d1 = Double.parseDouble(first);
                double d2 = Double.parseDouble(second);
                if (d1 == d2) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return first.equals(second);
    }

    private static boolean checkNumerically(String condition) {
        if (condition.length() > 0) {
            if (Switch.isNumeric0(condition.charAt(0))) {
                return true;
            }
            for (int i = 0; i < condition.length(); ++i) {
                if (!Switch.isNumeric1(condition.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isNumeric0(char c) {
        return c == '+' || c == '-' || c == '0' || c == '.' || c == ',' || c == 'e' || c == 'E';
    }

    private static boolean isNumeric1(char c) {
        return c == '+' || c == '-' || c == '.' || c == ',' || c == 'e' || c == 'E';
    }
}

