/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel;

import java.io.Reader;
import java.io.StringReader;
import org.xwiki.rendering.listener.InlineFilterListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.util.ParserUtils;

public class WikiModelParserUtils
extends ParserUtils {
    public void parseInline(StreamParser parser, String content, Listener listener) throws ParseException {
        this.parseInline(parser, content, listener, false);
    }

    public void parseInline(StreamParser parser, String content, Listener listener, boolean prefix) throws ParseException {
        if (prefix) {
            InlineFilterListener inlineFilterListener = new InlineFilterListener(){
                private boolean foundWord = false;
                private boolean foundSpace = false;

                public void onWord(String word) {
                    if (this.foundWord) {
                        super.onWord(word);
                    } else {
                        this.foundWord = true;
                    }
                }

                public void onSpace() {
                    if (this.foundSpace) {
                        super.onSpace();
                    } else {
                        this.foundSpace = true;
                    }
                }
            };
            inlineFilterListener.setWrappedListener(listener);
            parser.parse((Reader)new StringReader("wikimarker " + content), (Listener)inlineFilterListener);
        } else {
            InlineFilterListener inlineFilterListener = new InlineFilterListener();
            inlineFilterListener.setWrappedListener(listener);
            parser.parse((Reader)new StringReader(content), (Listener)inlineFilterListener);
        }
    }
}

