/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class XPath {
    private static final int ASSERTION = 0;
    private Stack steps_ = new Stack();
    private boolean absolute_;
    private String string_;
    private static Hashtable cache_ = new Hashtable();

    private XPath(boolean isAbsolute, Step[] steps) {
        for (int i = 0; i < steps.length; ++i) {
            this.steps_.addElement(steps[i]);
        }
        this.absolute_ = isAbsolute;
        this.string_ = null;
    }

    private XPath(String s) throws XPathException {
        this(s, new InputStreamReader(new ByteArrayInputStream(s.getBytes())));
    }

    private XPath(String s, Reader reader) throws XPathException {
        try {
            boolean multiLevel;
            this.string_ = s;
            SimpleStreamTokenizer toks = new SimpleStreamTokenizer(reader);
            toks.ordinaryChar('/');
            toks.ordinaryChar('.');
            toks.wordChars(':', ':');
            toks.wordChars('_', '_');
            if (toks.nextToken() == 47) {
                this.absolute_ = true;
                if (toks.nextToken() == 47) {
                    multiLevel = true;
                    toks.nextToken();
                } else {
                    multiLevel = false;
                }
            } else {
                this.absolute_ = false;
                multiLevel = false;
            }
            this.steps_.push(new Step(this, multiLevel, toks));
            while (toks.ttype == 47) {
                if (toks.nextToken() == 47) {
                    multiLevel = true;
                    toks.nextToken();
                } else {
                    multiLevel = false;
                }
                this.steps_.push(new Step(this, multiLevel, toks));
            }
            if (toks.ttype != -1) {
                throw new XPathException(this, "at end of XPATH expression", toks, "end of expression");
            }
        }
        catch (IOException e) {
            throw new XPathException(this, e);
        }
    }

    public String toString() {
        if (this.string_ == null) {
            this.string_ = this.generateString();
        }
        return this.string_;
    }

    private String generateString() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Enumeration i = this.steps_.elements();
        while (i.hasMoreElements()) {
            Step step = (Step)i.nextElement();
            if (!first || this.absolute_) {
                result.append('/');
                if (step.isMultiLevel()) {
                    result.append('/');
                }
            }
            result.append(step.toString());
            first = false;
        }
        return result.toString();
    }

    public boolean isAbsolute() {
        return this.absolute_;
    }

    public boolean isStringValue() {
        Step lastStep = (Step)this.steps_.peek();
        return lastStep.isStringValue();
    }

    public Enumeration getSteps() {
        return this.steps_.elements();
    }

    public String getIndexingAttrName() throws XPathException {
        Step step = (Step)this.steps_.peek();
        BooleanExpr predicate = step.getPredicate();
        if (!(predicate instanceof AttrExistsExpr)) {
            throw new XPathException(this, "has no indexing attribute name (must end with predicate of the form [@attrName]");
        }
        return ((AttrExistsExpr)predicate).getAttrName();
    }

    public String getIndexingAttrNameOfEquals() throws XPathException {
        Step step = (Step)this.steps_.peek();
        BooleanExpr predicate = step.getPredicate();
        if (predicate instanceof AttrEqualsExpr) {
            return ((AttrEqualsExpr)predicate).getAttrName();
        }
        return null;
    }

    public Object clone() {
        Step[] steps = new Step[this.steps_.size()];
        Enumeration step = this.steps_.elements();
        for (int i = 0; i < steps.length; ++i) {
            steps[i] = (Step)step.nextElement();
        }
        return new XPath(this.absolute_, steps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XPath get(String xpathString) throws XPathException {
        Hashtable hashtable = cache_;
        synchronized (hashtable) {
            XPath result = (XPath)cache_.get(xpathString);
            if (result == null) {
                result = new XPath(xpathString);
                cache_.put(xpathString, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XPath get(boolean isAbsolute, Step[] steps) {
        XPath created = new XPath(isAbsolute, steps);
        String xpathString = created.toString();
        Hashtable hashtable = cache_;
        synchronized (hashtable) {
            XPath inCache = (XPath)cache_.get(xpathString);
            if (inCache == null) {
                cache_.put(xpathString, created);
                return created;
            }
            return inCache;
        }
    }

    public static boolean isStringValue(String xpathString) throws XPathException, IOException {
        return XPath.get(xpathString).isStringValue();
    }
}

