/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

public class SpecialEntity {
    private final String key;
    private final int intCode;
    private final String htmlString;
    private boolean htmlSpecialEntity;
    private final String escapedXmlString;

    public SpecialEntity(String key, int intCode, String htmlString, boolean htmlSpecialEntity) {
        this.key = key;
        this.intCode = intCode;
        String str = "&" + key + ";";
        this.htmlString = htmlString != null ? htmlString : str;
        this.escapedXmlString = htmlSpecialEntity ? String.valueOf((char)this.intCode) : str;
        this.htmlSpecialEntity = htmlSpecialEntity;
    }

    public String getKey() {
        return this.key;
    }

    public int intValue() {
        return this.intCode;
    }

    public String getHtmlString() {
        return this.htmlString;
    }

    public String getEscapedXmlString() {
        return this.escapedXmlString;
    }

    public String getEscaped(boolean htmlEscaped) {
        return htmlEscaped ? this.getHtmlString() : this.getEscapedXmlString();
    }

    public boolean isHtmlSpecialEntity() {
        return this.htmlSpecialEntity;
    }

    public char charValue() {
        return (char)this.intValue();
    }

    public String getDecimalNCR() {
        return "&#" + this.intCode + ";";
    }

    public String getHexNCR() {
        return "&#x" + Integer.toHexString(this.intCode) + ";";
    }

    public String getEscapedValue() {
        return "&" + this.key + ";";
    }
}

