/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import gnu.trove.iterator.TIntObjectIterator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import net.osmand.render.RenderingRule;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRulesStorage;
import org.xmlpull.v1.XmlPullParserException;

public class RenderingRulesStoragePrinter {
    public static void main(String[] args) throws XmlPullParserException, IOException {
        String defaultFile = "/Users/victorshcherb/osmand/repos/resources/rendering_styles/default.render.xml";
        if (args.length > 0) {
            defaultFile = args[0];
        }
        String outputPath = ".";
        if (args.length > 1) {
            outputPath = args[1];
        }
        String name = "Style";
        RenderingRulesStorage storage = RenderingRulesStorage.getTestStorageForStyle((String)defaultFile);
        new RenderingRulesStoragePrinter().printJavaFile(outputPath, name, storage);
    }

    protected void printJavaFile(String path, String name, RenderingRulesStorage storage) throws IOException {
        String defindent;
        PrintStream out = System.out;
        out = new PrintStream(new File(path, name + "RenderingRulesStorage.java"));
        out.println("\n\npackage net.osmand.render;\n\npublic class " + name + "RenderingRulesStorage {");
        String indent = defindent = "\t";
        out.println(indent + defindent + "RenderingRulesStorage storage;");
        out.println("\tprivate java.util.Map<String, String> createMap(int... attrs) {\n\t\tjava.util.Map<String, String> mp = new java.util.HashMap<String, String>();\n\t\t\tfor(int i = 0; i< attrs.length; i+=2) {\n\t\t\t\tmp.put(storage.getStringValue(attrs[i]), storage.getStringValue(attrs[i+1]));\n\t\t\t}\n\t\treturn mp;\n\t}");
        out.println("\tprivate java.util.Map<String, String> createMap(String... attrs) {\n\t\tjava.util.Map<String, String> mp = new java.util.HashMap<String, String>();\n\t\t\tfor(int i = 0; i< attrs.length; i+=2) {\n\t\t\t\tmp.put(attrs[i], attrs[i+1]);\n\t\t\t}\n\t\treturn mp;\n\t}");
        out.println("\n" + indent + "public void createStyle(RenderingRulesStorage storage) {");
        out.println(indent + defindent + "this.storage=storage;");
        out.println(indent + defindent + "storage.renderingName=" + this.javaString(storage.renderingName) + ";");
        out.println(indent + defindent + "storage.internalRenderingName=" + this.javaString(storage.internalRenderingName) + ";");
        out.println(indent + defindent + "initDictionary();");
        out.println(indent + defindent + "initProperties();");
        out.println(indent + defindent + "initConstants();");
        out.println(indent + defindent + "initAttributes();");
        out.println(indent + defindent + "initRules();");
        out.println(indent + "}");
        this.printJavaInitConstants(storage, out, indent, defindent);
        this.printJavaInitProperties(storage, out, indent, defindent);
        this.printJavaInitRules(storage, out, indent, defindent);
        this.printJavaInitAttributes(storage, out, indent, defindent);
        this.printJavaInitDictionary(storage, out, indent, defindent);
        out.println("\n\n}");
    }

    private String javaString(String s) {
        return "\"" + s + "\"";
    }

    private void printJavaInitDictionary(RenderingRulesStorage storage, PrintStream out, String indent, String ti) {
        out.println("\n" + indent + "public void initDictionary() {");
        int i = 0;
        for (String s : storage.dictionary) {
            out.println(indent + ti + "storage.getDictionaryValue(" + this.javaString(s) + ");  // " + i++);
        }
        out.println(indent + "}");
    }

    private void printJavaInitProperties(RenderingRulesStorage storage, PrintStream out, String indent, String ti) {
        out.println("\n" + indent + "public void initProperties() {");
        out.println(indent + ti + "RenderingRuleProperty prop = null;");
        for (RenderingRuleProperty p : storage.PROPS.getCustomRules()) {
            out.println(indent + ti + "prop = new RenderingRuleProperty(" + this.javaString(p.attrName) + "," + p.type + ", " + p.input + ");");
            out.println(indent + ti + "prop.setDescription(" + this.javaString(p.description) + ");");
            out.println(indent + ti + "prop.setCategory(" + this.javaString(p.category) + ");");
            out.println(indent + ti + "prop.setName(" + this.javaString(p.name) + ");");
            if (p.possibleValues != null && !p.isBoolean()) {
                Object mp = "";
                for (String s : p.possibleValues) {
                    if (((String)mp).length() > 0) {
                        mp = (String)mp + ", ";
                    }
                    mp = (String)mp + this.javaString(s);
                }
                out.println(indent + ti + "prop.setPossibleValues(new String[]{" + (String)mp + "});");
            }
            out.println(indent + ti + "storage.PROPS.registerRule(prop);");
        }
        out.println(indent + "}");
    }

    private void printJavaInitAttributes(RenderingRulesStorage storage, PrintStream out, String indent, String ti) {
        out.println("\n" + indent + "public void initAttributes() {");
        for (int i = 0; i < 15; ++i) {
            out.println(indent + ti + "RenderingRule rule" + i + " = null;");
        }
        for (Map.Entry entry : storage.renderingAttributes.entrySet()) {
            this.generateRenderingRule(storage, out, indent + ti, "rule", 0, (RenderingRule)entry.getValue());
            out.println(indent + ti + "storage.renderingAttributes.put(" + this.javaString((String)entry.getKey()) + ", rule0);");
        }
        out.println(indent + "}");
    }

    private void printJavaInitRules(RenderingRulesStorage storage, PrintStream out, String indent, String ti) {
        int javaFunctions = 0;
        boolean initNewSection = true;
        for (int rulesSection = 0; rulesSection < 6; ++rulesSection) {
            initNewSection = true;
            if (storage.tagValueGlobalRules[rulesSection] == null) continue;
            TIntObjectIterator iterator = storage.tagValueGlobalRules[rulesSection].iterator();
            int rulesInSection = 0;
            while (iterator.hasNext()) {
                iterator.advance();
                if (initNewSection) {
                    if (javaFunctions > 0) {
                        out.println(indent + "}\n");
                    }
                    out.println("\n" + indent + "public void initRules" + javaFunctions + "() {");
                    for (int k = 0; k < 15; ++k) {
                        out.println(indent + ti + "RenderingRule rule" + k + " = null;");
                    }
                    initNewSection = false;
                    ++javaFunctions;
                }
                if (rulesInSection > 50) {
                    rulesInSection = 0;
                    initNewSection = true;
                }
                rulesInSection += this.generateRenderingRule(storage, out, indent + ti, "rule", 0, (RenderingRule)iterator.value());
                out.println(indent + ti + "storage.tagValueGlobalRules[" + rulesSection + "].put(" + iterator.key() + ", rule0);");
            }
        }
        if (javaFunctions > 0) {
            out.println(indent + "}\n");
        }
        out.println("\n" + indent + "public void initRules() {");
        for (int k = 0; k < 6; ++k) {
            if (storage.tagValueGlobalRules[k] == null) continue;
            out.println(indent + ti + "storage.tagValueGlobalRules[" + k + "] = new gnu.trove.map.hash.TIntObjectHashMap();");
        }
        for (int i = 0; i < javaFunctions; ++i) {
            out.println(indent + ti + "initRules" + i + "();");
        }
        out.println(indent + "}");
    }

    private int generateRenderingRule(RenderingRulesStorage storage, PrintStream out, String indent, String name, int ind, RenderingRule key) {
        int cnt = 1;
        Object mp = "";
        Iterator it = key.getAttributes().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            int kk = storage.getDictionaryValue((String)e.getKey());
            int vv = storage.getDictionaryValue((String)e.getValue());
            mp = (String)mp + kk + ", " + vv;
            if (!it.hasNext()) continue;
            mp = (String)mp + ", ";
        }
        mp = ((String)mp).isEmpty() ? "java.util.Collections.EMPTY_MAP" : "createMap(" + (String)mp + ")";
        out.println(indent + name + ind + " = new RenderingRule(" + (String)mp + ", " + key.isGroup() + ",  storage);");
        for (RenderingRule k : key.getIfChildren()) {
            this.generateRenderingRule(storage, out, indent + "\t", name, ind + 1, k);
            out.println(indent + name + ind + ".addIfChildren(" + name + (ind + 1) + ");");
            ++cnt;
        }
        for (RenderingRule k : key.getIfElseChildren()) {
            this.generateRenderingRule(storage, out, indent + "\t", name, ind + 1, k);
            out.println(indent + name + ind + ".addIfElseChildren(" + name + (ind + 1) + ");");
            ++cnt;
        }
        return cnt;
    }

    private void printJavaInitConstants(RenderingRulesStorage storage, PrintStream out, String indent, String ti) {
        out.println("\n" + indent + "public void initConstants() {");
        for (Map.Entry entry : storage.renderingConstants.entrySet()) {
            out.println(indent + ti + "storage.renderingConstants.put(" + this.javaString((String)entry.getKey()) + ", " + this.javaString((String)entry.getValue()) + ");");
        }
        out.println(indent + "}");
    }
}

