/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.io.IOsmStorageFilter;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.Algorithms;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class FilterOsmByTags {
    private static final Log LOG = PlatformUtil.getLog(FilterOsmByTags.class);

    public static void main(String[] args) throws IOException, XmlPullParserException, XMLStreamException {
        if (args.length < 3) {
            System.out.println("Synopsis: <input_osm_file> <output_osm_file> <json_filter>");
            System.exit(1);
            return;
        }
        File input = new File(args[0]);
        File output = new File(args[1]);
        Gson gson = new Gson();
        List arrayConditions = (List)gson.fromJson(args[2], List.class);
        FilterOsmByTags.process(input, output, arrayConditions);
    }

    private static void process(File inputFile, File targetFile, final List<Map<String, Object>> arrayConditions) throws IOException, XmlPullParserException, XMLStreamException {
        FileInputStream original = new FileInputStream(inputFile);
        InputStream fis = original;
        if (inputFile.getName().endsWith(".gz")) {
            fis = new GZIPInputStream(fis);
        } else if (inputFile.getName().endsWith(".bz2")) {
            fis = new BZip2CompressorInputStream(fis);
        }
        OsmBaseStorage bs = new OsmBaseStorage();
        bs.getFilters().add(new IOsmStorageFilter(){

            public boolean acceptEntityToLoad(OsmBaseStorage storage, Entity.EntityId entityId, Entity entity) {
                for (Map orCondition : arrayConditions) {
                    boolean test = FilterOsmByTags.testCondition(orCondition, entityId, entity);
                    if (!test) continue;
                    return true;
                }
                return false;
            }
        });
        bs.parseOSM(fis, (IProgress)new ConsoleProgressImplementation(), (InputStream)original, true);
        LOG.info((Object)"File was read");
        OsmStorageWriter w = new OsmStorageWriter();
        OutputStream outputStream = new FileOutputStream(targetFile);
        if (targetFile.getName().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        } else if (targetFile.getName().endsWith(".bz2")) {
            outputStream = new BZip2CompressorOutputStream(outputStream);
        }
        LOG.info((Object)"Entities processed. Saving file.");
        w.saveStorage(outputStream, bs, null, true);
        outputStream.close();
        fis.close();
        LOG.info((Object)"Completed.");
    }

    protected static boolean testCondition(Map<String, Object> orCondition, Entity.EntityId entityId, Entity entity) {
        boolean allMet = true;
        for (String tag : orCondition.keySet()) {
            boolean t = false;
            Object o = orCondition.get(tag);
            String value = entity.getTag(tag);
            if (o instanceof List) {
                Object obj;
                Iterator iterator = ((List)o).iterator();
                while (iterator.hasNext() && !(t = Algorithms.objectEquals((Object)value, obj = iterator.next()))) {
                }
            } else {
                t = Algorithms.objectEquals((Object)value, (Object)o);
            }
            allMet = allMet && t;
        }
        return allMet;
    }
}

