/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.util.Algorithms;
import org.json.JSONArray;
import org.json.JSONObject;

public class City
extends MapObject {
    private CityType type = null;
    private List<Street> listOfStreets = new ArrayList<Street>();
    private String postcode = null;
    private City closestCity = null;
    private int[] bbox31 = null;
    private static long POSTCODE_INTERNAL_ID = -1000L;
    private Set<String> isin = null;

    public static City createPostcode(String postcode) {
        return new City(postcode, POSTCODE_INTERNAL_ID--);
    }

    public City(CityType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public City(String postcode, long id) {
        this.type = CityType.POSTCODE;
        this.name = this.enName = postcode;
        this.id = id;
    }

    public boolean isInCityByName(String name) {
        if (this.isin == null) {
            return false;
        }
        return this.isin.contains(name.toLowerCase());
    }

    public int[] getBbox31() {
        return this.bbox31;
    }

    public void setBbox31(int[] bbox31) {
        this.bbox31 = bbox31;
    }

    public boolean isPostcode() {
        return this.type == CityType.POSTCODE;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public City getClosestCity() {
        return this.closestCity;
    }

    public void setClosestCity(City closestCity) {
        this.closestCity = closestCity;
    }

    public void registerStreet(Street street) {
        this.listOfStreets.add(street);
    }

    public void unregisterStreet(Street candidate) {
        this.listOfStreets.remove(candidate);
    }

    public CityType getType() {
        return this.type;
    }

    public List<Street> getStreets() {
        return this.listOfStreets;
    }

    @Override
    public String toString() {
        if (this.isPostcode()) {
            return "Postcode : " + this.getName() + " " + String.valueOf(this.getLocation());
        }
        return "City [" + String.valueOf((Object)this.type) + "] " + this.getName() + " " + String.valueOf(this.getLocation());
    }

    public Street getStreetByName(String name) {
        for (Street s : this.listOfStreets) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public Set<String> getIsin() {
        return this.isin;
    }

    public void setIsin(String val) {
        String[] vls;
        this.isin = new TreeSet<String>();
        for (String v1 : vls = val.toLowerCase().split(",")) {
            String[] v2s;
            for (String v2 : v2s = v1.trim().split(";")) {
                if (Algorithms.isEmpty(v2 = v2.trim())) continue;
                this.isin.add(v2);
            }
        }
    }

    public Map<Street, Street> mergeWith(City city) {
        LinkedHashMap<Street, Street> m = new LinkedHashMap<Street, Street>();
        for (Street street : city.listOfStreets) {
            if (this.listOfStreets.contains(street)) {
                this.listOfStreets.get(this.listOfStreets.indexOf(street)).mergeWith(street);
                continue;
            }
            Street s = new Street(this);
            s.copyNames(street);
            s.setLocation(street.getLocation().getLatitude(), street.getLocation().getLongitude());
            s.setId(street.getId());
            s.buildings.addAll(street.getBuildings());
            m.put(street, s);
            this.listOfStreets.add(s);
        }
        this.copyNames(city);
        return m;
    }

    @Override
    public JSONObject toJSON() {
        return this.toJSON(true);
    }

    public JSONObject toJSON(boolean includingBuildings) {
        JSONObject json = super.toJSON();
        if (this.type != null) {
            json.put("type", (Object)this.type.name());
        }
        if (this.postcode != null) {
            json.put("postcode", (Object)this.postcode);
        }
        if (this.bbox31 != null) {
            json.put("bbox31", (Object)Arrays.toString(this.bbox31));
        }
        JSONArray listOfStreetsArr = new JSONArray();
        for (Street s : this.listOfStreets) {
            listOfStreetsArr.put((Object)s.toJSON(includingBuildings));
        }
        json.put("listOfStreets", (Object)listOfStreetsArr);
        return json;
    }

    public static City parseJSON(JSONObject json) throws IllegalArgumentException {
        if (!json.has("type")) {
            throw new IllegalArgumentException();
        }
        CityType type = CityType.valueOf(json.getString("type"));
        City c = new City(type);
        MapObject.parseJSON(json, c);
        if (json.has("postcode")) {
            c.postcode = json.getString("postcode");
        }
        if (json.has("bbox31")) {
            String bboxString;
            Object bboxValue = json.get("bbox31");
            int[] parsedBbox = null;
            if (bboxValue instanceof JSONArray) {
                JSONArray bboxArray = (JSONArray)bboxValue;
                if (bboxArray.length() >= 4) {
                    int[] buffer = new int[4];
                    boolean valid = true;
                    for (int i = 0; i < buffer.length; ++i) {
                        Object value = bboxArray.get(i);
                        if (!(value instanceof Number)) {
                            valid = false;
                            break;
                        }
                        buffer[i] = ((Number)value).intValue();
                    }
                    if (valid) {
                        parsedBbox = buffer;
                    }
                }
            } else if (bboxValue instanceof String && !(bboxString = ((String)bboxValue).trim()).isEmpty()) {
                String[] parts;
                String normalized = bboxString;
                if (normalized.startsWith("[")) {
                    normalized = normalized.substring(1);
                }
                if (normalized.endsWith("]")) {
                    normalized = normalized.substring(0, normalized.length() - 1);
                }
                if ((parts = normalized.split(",")).length >= 4) {
                    int[] buffer = new int[4];
                    boolean valid = true;
                    for (int i = 0; i < buffer.length; ++i) {
                        String part = parts[i].trim();
                        if (Algorithms.isEmpty(part)) {
                            valid = false;
                            break;
                        }
                        try {
                            buffer[i] = Integer.parseInt(part);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            valid = false;
                            break;
                        }
                    }
                    if (valid) {
                        parsedBbox = buffer;
                    }
                }
            }
            if (parsedBbox != null) {
                c.bbox31 = parsedBbox;
            }
        }
        if (json.has("listOfStreets")) {
            JSONArray streetsArr = json.getJSONArray("listOfStreets");
            c.listOfStreets = new ArrayList<Street>();
            for (int i = 0; i < streetsArr.length(); ++i) {
                JSONObject streetObj = streetsArr.getJSONObject(i);
                Street street = Street.parseJSON(c, streetObj);
                if (street == null) continue;
                c.listOfStreets.add(street);
            }
        }
        return c;
    }

    public static enum CityType {
        CITY(10000.0, 100000),
        TOWN(4000.0, 20000),
        VILLAGE(1300.0, 1000),
        HAMLET(1000.0, 100),
        SUBURB(1500.0, 5000),
        BOUNDARY(0.0, 0),
        POSTCODE(500.0, 1000),
        BOROUGH(2000.0, 2500),
        DISTRICT(1000.0, 10000),
        NEIGHBOURHOOD(500.0, 500),
        CENSUS(2000.0, 2500);

        private final double radius;
        private final int population;

        private CityType(double radius, int population) {
            this.radius = radius;
            this.population = population;
        }

        public double getRadius() {
            return this.radius;
        }

        public int getPopulation() {
            return this.population;
        }

        public boolean storedAsSeparateAdminEntity() {
            return this == CITY || this == TOWN || this == VILLAGE || this == HAMLET || this == SUBURB;
        }

        public static String valueToString(CityType t) {
            return t.toString().toLowerCase();
        }

        public static CityType valueFromEntity(Entity e) {
            String place = e.getTag(OSMSettings.OSMTagKey.PLACE);
            if ("locality".equals(place) && "townland".equals(e.getTag(OSMSettings.OSMTagKey.LOCALITY))) {
                return SUBURB;
            }
            return CityType.valueFromString(place);
        }

        public static CityType valueFromString(String place) {
            if (place == null) {
                return null;
            }
            if ("township".equals(place)) {
                return TOWN;
            }
            for (CityType t : CityType.values()) {
                if (!t.name().equalsIgnoreCase(place) || t == BOUNDARY || t == POSTCODE) continue;
                return t;
            }
            return null;
        }
    }
}

