/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.filters.BaseTrackFilter;
import net.osmand.shared.gpx.filters.FilterChangedListener;
import net.osmand.shared.gpx.filters.RangeTrackFilterSerializer;
import net.osmand.shared.gpx.filters.TrackFilterType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=RangeTrackFilterSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u0000 =*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001=B+\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u00002\b\b\u0002\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010 \u001a\u00020!J\u0018\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020$2\b\b\u0002\u0010 \u001a\u00020!J\u001f\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00028\u00002\b\b\u0002\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010%\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u001b\u0010*\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020$J\u0013\u0010,\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010-\u001a\u00020!2\b\u0010.\u001a\u0004\u0018\u00010/H\u0096\u0002J\u0015\u00100\u001a\u00020$2\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020$J\u0006\u00103\u001a\u00020$J\u0006\u00104\u001a\u00020$J\u0015\u00105\u001a\u00020$2\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00101J\b\u00106\u001a\u000207H\u0002J\u0015\u00108\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020!H\u0016R&\u0010\u0004\u001a\u00028\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0016\n\u0002\u0010\u0012\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00008\u0006@BX\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u000fR&\u0010\u0016\u001a\u00028\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0016\n\u0002\u0010\u0012\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R&\u0010\u001a\u001a\u00028\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0016\n\u0002\u0010\u0012\u0012\u0004\b\u001b\u0010\r\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011\u00a8\u0006>"}, d2={"Lnet/osmand/shared/gpx/filters/RangeTrackFilter;", "T", "", "Lnet/osmand/shared/gpx/filters/BaseTrackFilter;", "minValue", "maxValue", "trackFilterType", "Lnet/osmand/shared/gpx/filters/TrackFilterType;", "filterChangedListener", "Lnet/osmand/shared/gpx/filters/FilterChangedListener;", "<init>", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Lnet/osmand/shared/gpx/filters/TrackFilterType;Lnet/osmand/shared/gpx/filters/FilterChangedListener;)V", "getMinValue$annotations", "()V", "getMinValue", "()Ljava/lang/Comparable;", "setMinValue", "(Ljava/lang/Comparable;)V", "Ljava/lang/Comparable;", "value", "getMaxValue$annotations", "getMaxValue", "valueFrom", "getValueFrom$annotations", "getValueFrom", "setValueFrom", "valueTo", "getValueTo$annotations", "getValueTo", "setValueTo", "", "from", "updateListeners", "", "(Ljava/lang/Comparable;Z)V", "to", "", "isEnabled", "isTrackAccepted", "trackItem", "Lnet/osmand/shared/gpx/TrackItem;", "initWithValue", "check", "(Ljava/lang/Comparable;)Ljava/lang/Comparable;", "setMaxValue", "equals", "other", "", "flor", "(Ljava/lang/Comparable;)Ljava/lang/String;", "ceilMaxValue", "ceilValueTo", "ceilMinValue", "ceil", "getProperty", "Lnet/osmand/shared/gpx/GpxParameter;", "getComparableValue", "(Ljava/lang/Object;)Ljava/lang/Comparable;", "hashCode", "", "isValid", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nRangeTrackFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeTrackFilter.kt\nnet/osmand/shared/gpx/filters/RangeTrackFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public class RangeTrackFilter<T extends Comparable<? super T>>
extends BaseTrackFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T minValue;
    @NotNull
    private T maxValue;
    @NotNull
    private T valueFrom;
    @NotNull
    private T valueTo;

    public RangeTrackFilter(@NotNull T minValue, @NotNull T maxValue, @NotNull TrackFilterType trackFilterType, @Nullable FilterChangedListener filterChangedListener) {
        Intrinsics.checkNotNullParameter(minValue, (String)"minValue");
        Intrinsics.checkNotNullParameter(maxValue, (String)"maxValue");
        Intrinsics.checkNotNullParameter((Object)((Object)trackFilterType), (String)"trackFilterType");
        super(trackFilterType, filterChangedListener, null);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueFrom = minValue;
        this.valueTo = maxValue;
    }

    @NotNull
    public final T getMinValue() {
        return this.minValue;
    }

    public final void setMinValue(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.minValue = t;
    }

    @Serializable
    public static /* synthetic */ void getMinValue$annotations() {
    }

    @NotNull
    public final T getMaxValue() {
        return this.maxValue;
    }

    @Serializable
    public static /* synthetic */ void getMaxValue$annotations() {
    }

    @NotNull
    public final T getValueFrom() {
        return this.valueFrom;
    }

    public final void setValueFrom(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.valueFrom = t;
    }

    @Serializable
    public static /* synthetic */ void getValueFrom$annotations() {
    }

    @NotNull
    public final T getValueTo() {
        return this.valueTo;
    }

    public final void setValueTo(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.valueTo = t;
    }

    @Serializable
    public static /* synthetic */ void getValueTo$annotations() {
    }

    public void setValueFrom(@NotNull T from, boolean updateListeners) {
        block1: {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            this.valueFrom = ComparisonsKt.maxOf(this.minValue, from);
            this.valueFrom = ComparisonsKt.minOf(this.valueFrom, this.valueTo);
            if (!updateListeners) break block1;
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener != null) {
                filterChangedListener.onFilterChanged();
            }
        }
    }

    public static /* synthetic */ void setValueFrom$default(RangeTrackFilter rangeTrackFilter, Comparable comparable, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setValueFrom");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        rangeTrackFilter.setValueFrom(comparable, bl);
    }

    public final void setValueTo(@NotNull String to, boolean updateListeners) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        T baseValue = this.getComparableValue(this.getTrackFilterType().getMeasureUnitType().getBaseValueFromFormatted(to));
        this.setValueTo(baseValue, updateListeners);
    }

    public static /* synthetic */ void setValueTo$default(RangeTrackFilter rangeTrackFilter, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setValueTo");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        rangeTrackFilter.setValueTo(string, bl);
    }

    public final void setValueFrom(@NotNull String from, boolean updateListeners) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        GpxParameter property = this.getProperty();
        double value = this.getTrackFilterType().getMeasureUnitType().getBaseValueFromFormatted(from);
        String baseValue = this.getComparableValue(value).toString();
        Object t = property.getValueFromString(baseValue);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type T of net.osmand.shared.gpx.filters.RangeTrackFilter");
        this.setValueFrom((Comparable)t, updateListeners);
    }

    public static /* synthetic */ void setValueFrom$default(RangeTrackFilter rangeTrackFilter, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setValueFrom");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        rangeTrackFilter.setValueFrom(string, bl);
    }

    private final void setValueTo(T to, boolean updateListeners) {
        block2: {
            this.valueTo = to;
            if (this.valueTo.compareTo(this.maxValue) > 0) {
                this.maxValue = this.valueTo;
            }
            this.valueTo = ComparisonsKt.maxOf(this.valueFrom, this.valueTo);
            if (!updateListeners) break block2;
            FilterChangedListener filterChangedListener = this.getFilterChangedListener();
            if (filterChangedListener != null) {
                filterChangedListener.onFilterChanged();
            }
        }
    }

    static /* synthetic */ void setValueTo$default(RangeTrackFilter rangeTrackFilter, Comparable comparable, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setValueTo");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        rangeTrackFilter.setValueTo(comparable, bl);
    }

    @Override
    public boolean isEnabled() {
        return this.valueFrom.compareTo(this.minValue) > 0 || this.valueTo.compareTo(this.maxValue) < 0;
    }

    @Override
    public boolean isTrackAccepted(@NotNull TrackItem trackItem) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)trackItem, (String)"trackItem");
                object = trackItem.getDataItem();
                if (object == null) break block3;
                GpxParameter gpxParameter = this.getTrackFilterType().getProperty();
                Intrinsics.checkNotNull((Object)((Object)gpxParameter));
                if ((object = (Comparable)((DataItem)object).getParameter(gpxParameter)) != null) break block4;
            }
            return false;
        }
        Object value = object;
        T comparableValue = this.getComparableValue(value);
        T t = this.valueFrom;
        return (comparableValue.compareTo(this.valueTo) <= 0 ? 0 <= comparableValue.compareTo(t) : false) || comparableValue.compareTo(this.minValue) < 0 && Intrinsics.areEqual(this.valueFrom, this.minValue) || comparableValue.compareTo(this.maxValue) > 0 && Intrinsics.areEqual(this.valueTo, this.maxValue);
    }

    @Override
    public void initWithValue(@NotNull BaseTrackFilter value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof RangeTrackFilter) {
            T it;
            T t = this.check((Comparable<?>)((RangeTrackFilter)value).minValue);
            if (t != null) {
                it = t;
                boolean bl = false;
                this.minValue = it;
            }
            T t2 = this.check((Comparable<?>)((RangeTrackFilter)value).maxValue);
            if (t2 != null) {
                it = t2;
                boolean bl = false;
                this.maxValue = it;
            }
            T t3 = this.check((Comparable<?>)((RangeTrackFilter)value).valueFrom);
            if (t3 != null) {
                it = t3;
                boolean bl = false;
                this.valueFrom = it;
            }
            T t4 = this.check((Comparable<?>)((RangeTrackFilter)value).valueTo);
            if (t4 != null) {
                it = t4;
                boolean bl = false;
                this.valueTo = it;
            }
            super.initWithValue(value);
        }
    }

    private final T check(Comparable<?> value) {
        return (T)((Comparable)this.getProperty().check(value));
    }

    public final void setMaxValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setMaxValue(this.getComparableValue(value));
    }

    public final void setMaxValue(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.maxValue = this.getComparableValue(value);
        this.valueTo = this.getComparableValue(value);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return super.equals(other) && other instanceof RangeTrackFilter && Intrinsics.areEqual(((RangeTrackFilter)other).minValue, this.minValue) && Intrinsics.areEqual(((RangeTrackFilter)other).maxValue, this.maxValue) && Intrinsics.areEqual(((RangeTrackFilter)other).valueFrom, this.valueFrom) && Intrinsics.areEqual(((RangeTrackFilter)other).valueTo, this.valueTo);
    }

    private final String flor(T value) {
        String string;
        T t = value;
        if (t instanceof Float) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Float");
            string = String.valueOf((float)Math.floor(((Float)value).floatValue()));
        } else if (t instanceof Double) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Double");
            string = String.valueOf(Math.floor((Double)value));
        } else {
            string = value.toString();
        }
        return string;
    }

    @NotNull
    public final String ceilMaxValue() {
        return this.ceil(this.maxValue);
    }

    @NotNull
    public final String ceilValueTo() {
        return this.ceil(this.valueTo);
    }

    @NotNull
    public final String ceilMinValue() {
        return this.ceil(this.minValue);
    }

    private final String ceil(T value) {
        String string;
        T t = value;
        if (t instanceof Float) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Float");
            string = String.valueOf((float)Math.ceil(((Float)value).floatValue()));
        } else if (t instanceof Double) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Double");
            string = String.valueOf(Math.ceil((Double)value));
        } else {
            string = value.toString();
        }
        return string;
    }

    private final GpxParameter getProperty() {
        GpxParameter gpxParameter = this.getTrackFilterType().getProperty();
        Intrinsics.checkNotNull((Object)((Object)gpxParameter));
        return gpxParameter;
    }

    private final T getComparableValue(Object value) {
        return this.getProperty().getComparableValue(value);
    }

    @Override
    public int hashCode() {
        int result = this.minValue.hashCode();
        result = 31 * result + this.maxValue.hashCode();
        result = 31 * result + this.valueFrom.hashCode();
        result = 31 * result + this.valueTo.hashCode();
        return result;
    }

    @Override
    public boolean isValid() {
        return this.maxValue.compareTo(this.minValue) > 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0001\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\u00a8\u0006\t"}, d2={"Lnet/osmand/shared/gpx/filters/RangeTrackFilter$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/osmand/shared/gpx/filters/RangeTrackFilter;", "T", "typeSerial0", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> KSerializer<RangeTrackFilter<T>> serializer(@NotNull KSerializer<T> typeSerial0) {
            Intrinsics.checkNotNullParameter(typeSerial0, (String)"typeSerial0");
            return RangeTrackFilterSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

